/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.server.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.jfapchannel.AcceptListener;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationMetaData;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.JFapConnectionBrokenException;
import com.ibm.ws.sib.jfapchannel.framework.FrameworkException;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnection;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnectionContext;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.impl.JFapUtils;
import com.ibm.ws.sib.utils.ras.SibTr;

public class InboundConnection
extends Connection {
    private static final TraceComponent tc = SibTr.register(InboundConnection.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    public static final String $sccsid = "@(#) 1.42 SIB/ws/code/sib.jfapchannel.server.impl/src/com/ibm/ws/sib/jfapchannel/impl/InboundConnection.java, SIB.comms, WASX.SIB, aa1225.01 10/02/15 03:11:45 [7/2/12 05:59:07]";
    private AcceptListener acceptListener = null;
    private final String eyeCatcher;

    public InboundConnection(NetworkConnectionContext channel, NetworkConnection vc, AcceptListener al, int heartbeatInterval, int heartbeatTimeout) throws FrameworkException {
        super(channel, vc, heartbeatInterval, heartbeatTimeout);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"<init>", (Object)new Object[]{channel, vc, al, "" + heartbeatInterval, "" + heartbeatTimeout});
        }
        this.acceptListener = al;
        this.description = "IN " + this.tcpCtx.getLocalAddress().getHostAddress() + ":" + this.tcpCtx.getLocalPort() + "<-" + this.tcpCtx.getRemoteAddress().getHostAddress() + ":" + this.tcpCtx.getRemotePort();
        this.eyeCatcher = this.tcpCtx.getRemoteAddress().getHostAddress() + ":" + this.tcpCtx.getRemotePort() + ":" + this.tcpCtx.getLocalAddress().getHostAddress() + ":" + this.tcpCtx.getLocalPort();
        this.remoteHostAddress = this.tcpCtx.getRemoteAddress().getHostAddress();
        this.chainName = this.getMetaData().getChainName();
        if (TraceComponent.isAnyTracingEnabled()) {
            JFapUtils.debugSummaryMessage((TraceComponent)tc, (Connection)this, null, (String)"New inbound connection established");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"<init>");
        }
    }

    protected ConversationImpl startNewConversation(ConversationImpl c) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"startNewConversation", (Object)c);
        }
        ConversationImpl retValue = this.startNewConversationGeneric(c, false, this.acceptListener);
        this.first = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"startNewConversation", (Object)retValue);
        }
        return retValue;
    }

    public void closeNotification(Conversation c) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"closeNotification", (Object)c);
        }
        if (this.conversationTable.contains(c.getId())) {
            this.conversationTable.remove(c.getId());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"closeNotification");
        }
    }

    public void invalidateImpl(boolean notifyPeer, Throwable throwable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"invalidateImpl", (Object)new Object[]{"" + notifyPeer, throwable});
        }
        if (throwable != null && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            SibTr.exception((TraceComponent)tc, (Throwable)throwable);
        }
        JFapConnectionBrokenException exception = new JFapConnectionBrokenException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"INBOUNDCONV_INVALIDATE_SICJ0051", (Object[])new Object[]{this.remoteHostAddress, this.chainName}, null));
        if (throwable != null) {
            exception.initCause(throwable);
        }
        this.wakeupAllConversationsWithException((SIException)exception, true);
        this.physicalCloseFromInvalidateImpl(notifyPeer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"invalidateImpl");
        }
    }

    protected void connectionClosedByPeer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"connectionClosedByPeer");
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"connectionClosedByPeer");
        }
    }

    protected void handshakeComplete() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"handshakeComplete invoked on inbound connection");
        }
    }

    protected void handshakeFailed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"handshakeFailed invoked on inbound connection");
        }
    }

    protected Conversation cloneConversation(ConversationReceiveListener receiveListener) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"cloneConnection", (Object)receiveListener);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"attempt to clone inbound conversation!");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"cloneConnection");
        }
        throw new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"INBOUNDCONV_INTERNAL_SICJ0052", null, (String)"INBOUNDCONV_INTERNAL_SICJ0052"));
    }

    protected ConversationMetaData getMetaData() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getMetaData");
        }
        ConversationMetaData retValue = this.connChannel.getMetaData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getMetaData", (Object)retValue);
        }
        return retValue;
    }

    protected boolean isInbound() {
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("InboundConnection@").append(Integer.toHexString(System.identityHashCode((Object)this)));
        buf.append(": {");
        buf.append("Remote Address: ");
        buf.append(this.remoteHostAddress);
        buf.append(", Chain: ");
        buf.append(this.chainName);
        buf.append(", Heartbeat Timeout: ");
        buf.append(this.getHeartbeatTimeoutForToString());
        buf.append(", Heartbeat Interval: ");
        buf.append(this.getHeartbeatIntervalForToString());
        buf.append("}\nEvents follow:\n");
        buf.append(this.getDiagnostics(false));
        return buf.toString();
    }

    public String getEyeCatcher() {
        return this.eyeCatcher;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source Info: @(#) 1.42 SIB/ws/code/sib.jfapchannel.server.impl/src/com/ibm/ws/sib/jfapchannel/impl/InboundConnection.java, SIB.comms, WASX.SIB, aa1225.01 10/02/15 03:11:45 [7/2/12 05:59:07]");
        }
    }
}

