/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jfap.inbound.channel;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.channelfw.osgi.ChannelFactoryProvider;
import com.ibm.websphere.event.EventEngine;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jfap.inbound.channel.CommsInboundChain;
import com.ibm.ws.jfap.inbound.channel.JFAPServerInboundChannelFactory;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsEngineComponent;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.common.service.CommonServiceFacade;
import com.ibm.ws.sib.comms.server.AcceptListenerFactoryImpl;
import com.ibm.ws.sib.jfapchannel.server.ServerConnectionManager;
import com.ibm.ws.sib.mfp.trm.TrmMessageFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.channelfw.ChannelConfiguration;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class CommsServerServiceFacade {
    private static final TraceComponent tc = Tr.register(CommsServerServiceFacade.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final String Inbound_ConfigAlias = "wasJmsEndpoint";
    private String endpointName = null;
    private final CommsInboundChain inboundChain = new CommsInboundChain(this, false);
    private final CommsInboundChain inboundSecureChain = new CommsInboundChain(this, true);
    private int wasJmsPort;
    private String host = null;
    private int wasJmsSSLPort;
    private boolean iswasJmsEndpointEnabled = true;
    private static CHFWBundle _chfw_bunlde;
    private static final AtomicServiceReference<CHFWBundle> _chfwRef;
    private static final AtomicServiceReference<ChannelConfiguration> _tcpOptionsRef;
    private static final AtomicServiceReference<ChannelFactoryProvider> _sslFactoryProviderRef;
    private static final AtomicServiceReference<ChannelConfiguration> _sslOptionsRef;
    private static final AtomicServiceReference<ChannelConfiguration> _commsClientServiceRef;
    private static final AtomicServiceReference<CommonServiceFacade> _commonServiceFacadeRef;
    private static final AtomicServiceReference<EventEngine> _eventSvcRef;
    private volatile Map<String, Object> Config = null;
    private final Object actionLock = new Object();
    private final Runnable stopBasicChainAction = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            Object object = CommsServerServiceFacade.this.actionLock;
            synchronized (object) {
                block6: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"CommsServerServiceFacade: stoppin basic chain ", (Object)CommsServerServiceFacade.this.inboundChain);
                    }
                    try {
                        CommsServerServiceFacade.this.inboundChain.stop();
                    }
                    catch (Exception e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                        SibTr.debug((TraceComponent)tc, (String)"Exception in stopping Basic chain", (Object)e);
                    }
                }
            }
        }
    };
    private final Runnable stopSSLChainAction = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            Object object = CommsServerServiceFacade.this.actionLock;
            synchronized (object) {
                block6: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"CommsServerServiceFacade: stopping secure chain ", (Object)CommsServerServiceFacade.this.inboundSecureChain);
                    }
                    try {
                        CommsServerServiceFacade.this.inboundSecureChain.stop();
                    }
                    catch (Exception e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                        SibTr.debug((TraceComponent)tc, (String)"Exception in secure chain stopping", (Object)e);
                    }
                }
            }
        }
    };
    private final Runnable updateSSLChainAction = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            Object object = CommsServerServiceFacade.this.actionLock;
            synchronized (object) {
                block7: {
                    if (CommsServerServiceFacade.this.Config != null && CommsServerServiceFacade.this.iswasJmsEndpointEnabled) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"CommsServerServiceFacade: updating secure chain ", (Object)CommsServerServiceFacade.this.inboundSecureChain);
                        }
                        try {
                            CommsServerServiceFacade.this.inboundSecureChain.update();
                        }
                        catch (Exception e) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                            SibTr.debug((TraceComponent)tc, (String)"Exception in updating secure  chain", (Object)e);
                        }
                    }
                }
            }
        }
    };
    private final Runnable updateBasicChainAction = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            Object object = CommsServerServiceFacade.this.actionLock;
            synchronized (object) {
                block7: {
                    if (CommsServerServiceFacade.this.Config != null && CommsServerServiceFacade.this.iswasJmsEndpointEnabled) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"CommsServerServiceFacade: updating basic chain ", (Object)CommsServerServiceFacade.this.inboundChain);
                        }
                        try {
                            CommsServerServiceFacade.this.inboundChain.update();
                        }
                        catch (Exception e) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                            SibTr.debug((TraceComponent)tc, (String)"Exception in updating badic  chain", (Object)e);
                        }
                    }
                }
            }
        }
    };

    public void activate(Map<String, Object> properties, ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"Activate ", properties);
        }
        this.Config = properties;
        Object cid = this.Config.get("component.id");
        this.endpointName = (String)properties.get("id");
        if (this.endpointName == null) {
            this.endpointName = Inbound_ConfigAlias + cid;
        }
        _chfwRef.activate(context);
        _tcpOptionsRef.activate(context);
        _sslOptionsRef.activate(context);
        _sslFactoryProviderRef.activate(context);
        _commonServiceFacadeRef.activate(context);
        _commsClientServiceRef.activate(context);
        _eventSvcRef.activate(context);
        _chfw_bunlde = this.getCHFWBundle();
        ServerConnectionManager.initialise(new AcceptListenerFactoryImpl());
        _chfw_bunlde.getFramework().registerFactory("JFAPChannel", JFAPServerInboundChannelFactory.class);
        this.inboundChain.init(this.endpointName, this.getCHFWBundle());
        this.inboundSecureChain.init(this.endpointName + "-ssl", this.getCHFWBundle());
        this.modified(context, properties);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"Activate");
        }
    }

    protected void deactivate(ComponentContext ctx, int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("CommsServerServiceFacade deactivated, reason=" + reason), (Object[])new Object[0]);
        }
        this.Config = null;
        this.performAction(this.stopBasicChainAction);
        this.performAction(this.stopSSLChainAction);
        _chfwRef.deactivate(ctx);
        _tcpOptionsRef.deactivate(ctx);
        _sslOptionsRef.deactivate(ctx);
        _sslFactoryProviderRef.deactivate(ctx);
        _commonServiceFacadeRef.deactivate(ctx);
        _commsClientServiceRef.deactivate(ctx);
        _eventSvcRef.deactivate(ctx);
    }

    protected void modified(ComponentContext context, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"modified ", properties);
        }
        this.iswasJmsEndpointEnabled = MetatypeUtils.parseBoolean((Object)Inbound_ConfigAlias, (String)"enabled", (Object)properties.get("enabled"), (boolean)true);
        this.host = (String)this.Config.get("host");
        this.wasJmsPort = MetatypeUtils.parseInteger((Object)Inbound_ConfigAlias, (String)"wasJmsPort", (Object)properties.get("wasJmsPort"), (int)-1);
        this.wasJmsSSLPort = MetatypeUtils.parseInteger((Object)Inbound_ConfigAlias, (String)"wasJmsSSLPort", (Object)properties.get("wasJmsSSLPort"), (int)-1);
        this.Config = properties;
        if (this.wasJmsPort >= 0) {
            this.inboundChain.enable(true);
        }
        if (this.wasJmsSSLPort >= 0 && _sslFactoryProviderRef.getService() != null) {
            this.inboundSecureChain.enable(true);
        }
        if (this.iswasJmsEndpointEnabled) {
            this.performAction(this.updateBasicChainAction);
            this.performAction(this.updateSSLChainAction);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"wasjmsEndpoint disabled: .. stopping chains");
            }
            this.performAction(this.stopBasicChainAction);
            this.performAction(this.stopSSLChainAction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"modified ");
        }
    }

    private void performAction(Runnable action) {
        action.run();
    }

    void closeViaCommsMPConnections(int mode) {
        JsEngineComponent _mp;
        JsMessagingEngine local_ME;
        JsAdminService admnService;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"CommsServerServiceFacade closeViaCommsMPConnections", (Object[])new Object[]{mode});
        }
        if (null != (admnService = CommsServerServiceFacade.getJsAdminService()) && null != (local_ME = admnService.getMessagingEngine("defaultBus", "defaultME")) && null != (_mp = local_ME.getMessageProcessor())) {
            _mp.stop(mode);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeViaCommsMPConnections");
        }
    }

    protected void setCommsClientService(ServiceReference<ChannelConfiguration> service) {
        _commsClientServiceRef.setReference(service);
    }

    protected void unsetCommsClientService(ServiceReference<ChannelConfiguration> service) {
        _commsClientServiceRef.unsetReference(service);
    }

    protected void setChfwBundle(ServiceReference<CHFWBundle> ref) {
        _chfwRef.setReference(ref);
    }

    protected void unsetChfwBundle(ServiceReference<CHFWBundle> ref) {
        _chfwRef.unsetReference(ref);
    }

    private CHFWBundle getCHFWBundle() {
        return (CHFWBundle)_chfwRef.getService();
    }

    @Trivial
    protected void setSslSupport(ServiceReference<ChannelFactoryProvider> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("enable ssl support " + ref.getProperty("type")), (Object[])new Object[]{this});
        }
        _sslFactoryProviderRef.setReference(ref);
        if (this.Config != null && this.wasJmsSSLPort >= 0) {
            this.inboundSecureChain.enable(true);
        }
        this.performAction(this.updateSSLChainAction);
    }

    @Trivial
    public void unsetSslSupport(ServiceReference<ChannelFactoryProvider> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("disable ssl support " + ref.getProperty("type")), (Object[])new Object[]{this});
        }
        if (_sslFactoryProviderRef.unsetReference(ref)) {
            this.inboundSecureChain.enable(false);
        }
    }

    public static WsByteBufferPoolManager getBufferPoolManager() {
        return _chfw_bunlde.getBufferManager();
    }

    @Trivial
    protected void setTcpOptions(ServiceReference<ChannelConfiguration> service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("set tcp options " + service.getProperty("id")), (Object[])new Object[]{this});
        }
        _tcpOptionsRef.setReference(service);
    }

    @Trivial
    protected void updatedTcpOptions(ServiceReference<ChannelConfiguration> service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("update tcp options " + service.getProperty("id")), (Object[])new Object[]{this});
        }
        this.performAction(this.updateBasicChainAction);
        this.performAction(this.updateSSLChainAction);
    }

    protected void unsetTcpOptions(ServiceReference<ChannelConfiguration> service) {
    }

    Map<String, Object> getTcpOptions() {
        ChannelConfiguration chanCnfgService = (ChannelConfiguration)_tcpOptionsRef.getService();
        return chanCnfgService.getConfiguration();
    }

    @Trivial
    protected void setSslOptions(ServiceReference<ChannelConfiguration> service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("set tcp options " + service.getProperty("id")), (Object[])new Object[0]);
        }
        _sslOptionsRef.setReference(service);
        this.performAction(this.updateSSLChainAction);
    }

    @Trivial
    protected void updatedSslOptions(ServiceReference<ChannelConfiguration> service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("update ssl options " + service.getProperty("id")), (Object[])new Object[0]);
        }
        this.performAction(this.updateSSLChainAction);
    }

    @Trivial
    protected void unsetSslOptions(ServiceReference<ChannelConfiguration> service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("unset ssl options " + service.getProperty("id")), (Object[])new Object[0]);
        }
        if (_sslOptionsRef.unsetReference(service)) {
            this.performAction(this.stopSSLChainAction);
        }
    }

    Map<String, Object> getSslOptions() {
        ChannelConfiguration chanCnfgService = (ChannelConfiguration)_sslOptionsRef.getService();
        if (null != chanCnfgService) {
            return chanCnfgService.getConfiguration();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"getSslOptions() returning NULL as _sslOptionsRef.getHighestRankedService() returned NUll _sslOptionsRef: ", _sslOptionsRef);
        }
        return null;
    }

    protected void setCommonServiceFacade(ServiceReference<CommonServiceFacade> ref) {
        _commonServiceFacadeRef.setReference(ref);
    }

    protected void unsetCommonServiceFacade(ServiceReference<CommonServiceFacade> ref) {
        _commonServiceFacadeRef.unsetReference(ref);
    }

    protected void setEventService(ServiceReference<EventEngine> ref) {
        _eventSvcRef.setReference(ref);
    }

    protected void unsetEventService(ServiceReference<EventEngine> ref) {
        _eventSvcRef.unsetReference(ref);
    }

    public static TrmMessageFactory getTrmMessageFactory() {
        CommonServiceFacade cfr_ignored_0 = (CommonServiceFacade)_commonServiceFacadeRef.getService();
        return CommonServiceFacade.getTrmMessageFactory();
    }

    public static JsAdminService getJsAdminService() {
        CommonServiceFacade cfr_ignored_0 = (CommonServiceFacade)_commonServiceFacadeRef.getService();
        return CommonServiceFacade.getJsAdminService();
    }

    public static EventEngine getEventEngine() {
        return (EventEngine)_eventSvcRef.getService();
    }

    int getConfigured_wasJmsPort() {
        return this.wasJmsPort;
    }

    int getConfigured_wasJmsSSLPort() {
        return this.wasJmsSSLPort;
    }

    String getConfigured_Host() {
        return this.host;
    }

    static {
        _chfwRef = new AtomicServiceReference("chfwBundle");
        _tcpOptionsRef = new AtomicServiceReference("tcpOptions");
        _sslFactoryProviderRef = new AtomicServiceReference("sslSupport");
        _sslOptionsRef = new AtomicServiceReference("sslOptions");
        _commsClientServiceRef = new AtomicServiceReference("commsClientService");
        _commonServiceFacadeRef = new AtomicServiceReference("commonServiceFacade");
        _eventSvcRef = new AtomicServiceReference("eventService");
    }
}

