/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jfap.inbound.channel;

import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.EndPointMgr;
import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.event.Event;
import com.ibm.websphere.event.EventEngine;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jfap.inbound.channel.CommsServerServiceFacade;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channelfw.ChainEventListener;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.exception.ChainException;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class CommsInboundChain
implements ChainEventListener {
    private static final TraceComponent tc = Tr.register(CommsInboundChain.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private boolean _isSecureChain = false;
    private boolean _isEnabled = false;
    private String _chainName;
    private final CommsServerServiceFacade _commsServerFacade;
    private String _endpointName;
    private ChannelFramework _cfw;
    private EndPointMgr _endpointMgr;
    private String _tcpName;
    private String _sslName;
    private String _jfapName;
    private volatile boolean _isChainStarted = false;
    private ChainConfiguration _currentConfig;
    private final StopWait stopWait = new StopWait();
    private final AtomicInteger chainState;

    CommsInboundChain(CommsServerServiceFacade commsServer, boolean isSecureChain) {
        this.chainState = new AtomicInteger(ChainState.UNINITIALIZED.val);
        this._commsServerFacade = commsServer;
        this._isSecureChain = isSecureChain;
    }

    public void init(String endpointName, CHFWBundle cfBundle) {
        this._cfw = cfBundle.getFramework();
        this._endpointMgr = cfBundle.getEndpointManager();
        this._endpointName = endpointName;
        if (this._isSecureChain) {
            this._chainName = "InboundSecureMessaging";
            this._tcpName = this._endpointName;
            this._sslName = "SSL-" + this._endpointName;
            this._jfapName = "JFAP-" + this._endpointName;
        } else {
            this._chainName = "InboundBasicMessaging";
            this._tcpName = this._endpointName;
            this._jfapName = "JFAP-" + this._endpointName;
        }
    }

    public void enable(boolean enbaled) {
        this._isEnabled = enbaled;
    }

    public void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"CommsInboundChain Stop");
        }
        try {
            ChainData cd = this._cfw.getChain(this._chainName);
            if (cd != null) {
                this._cfw.stopChain(cd, this._cfw.getDefaultChainQuiesceTimeout());
                this.stopWait.waitForStop(this._cfw.getDefaultChainQuiesceTimeout());
                this._cfw.destroyChain(cd);
                this._cfw.removeChain(cd);
            }
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Failed in successfully cleaning(i.e stopping/destorying/removing) chain: ", (Object)e);
            }
        }
        finally {
            this._isChainStarted = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"CommsServerServiceFacade JfapChainStop");
        }
    }

    public void update() {
        block22: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"CommsInboundChain update");
            }
            if (!this._isEnabled || FrameworkState.isStopping()) {
                return;
            }
            ChainConfiguration oldConfig = this._currentConfig;
            boolean validOldConfig = oldConfig == null ? false : oldConfig.isValidConfig;
            Map<String, Object> tcpOptions = this._commsServerFacade.getTcpOptions();
            Map<String, Object> sslOptions = this._isSecureChain ? this._commsServerFacade.getSslOptions() : null;
            ChainConfiguration newConfig = new ChainConfiguration(this._isSecureChain ? this._commsServerFacade.getConfigured_wasJmsSSLPort() : this._commsServerFacade.getConfigured_wasJmsPort(), this._commsServerFacade.getConfigured_Host(), tcpOptions, sslOptions);
            if (newConfig.configPort < 0 || !newConfig.complete()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Stopping chain due to configuration " + newConfig));
                }
                this._currentConfig = newConfig;
                this.stop();
                return;
            }
            if (validOldConfig && newConfig.unchanged(oldConfig)) {
                if (newConfig.getActivePort() == oldConfig.getActivePort() && newConfig.getActivePort() != -1) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Chain is already started " + oldConfig));
                    }
                    return;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Existing config must be started " + newConfig));
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("New/changed chain configuration " + newConfig));
            }
            try {
                ChannelData jfapChannel;
                ChannelData sslChannel;
                if (validOldConfig) {
                    this.stop();
                }
                if (newConfig.tcpChanged(oldConfig)) {
                    this.removeChannel(this._tcpName);
                }
                if (newConfig.sslChanged(oldConfig)) {
                    this.removeChannel(this._sslName);
                }
                this._currentConfig = newConfig;
                this._endpointMgr.defineEndPoint(this._endpointName, newConfig.configHost, newConfig.configPort);
                ChannelData tcpChannel = this._cfw.getChannel(this._tcpName);
                if (tcpChannel == null) {
                    String typeName = (String)tcpOptions.get("type");
                    HashMap<String, Object> chanProps = new HashMap<String, Object>(tcpOptions);
                    chanProps.put("endPointName", this._endpointName);
                    chanProps.put("hostname", newConfig.configHost);
                    chanProps.put("port", String.valueOf(newConfig.configPort));
                    tcpChannel = this._cfw.addChannel(this._tcpName, this._cfw.lookupFactory(typeName), chanProps);
                }
                if (this._isSecureChain && (sslChannel = this._cfw.getChannel(this._sslName)) == null) {
                    sslChannel = this._cfw.addChannel(this._sslName, this._cfw.lookupFactory("SSLChannel"), new HashMap<String, Object>(sslOptions));
                }
                if ((jfapChannel = this._cfw.getChannel(this._jfapName)) == null) {
                    jfapChannel = this._cfw.addChannel(this._jfapName, this._cfw.lookupFactory("JFAPChannel"), null);
                }
                String[] chanList = this._isSecureChain ? new String[]{this._tcpName, this._sslName, this._jfapName} : new String[]{this._tcpName, this._jfapName};
                ChainData cd = this._cfw.addChain(this._chainName, FlowType.INBOUND, chanList);
                cd.setEnabled(true);
                this._cfw.addChainEventListener((ChainEventListener)this, this._chainName);
                this._cfw.startChain(cd);
                int jmsActivePort = -1;
                try {
                    jmsActivePort = this._cfw.getListeningPort(this._chainName);
                }
                catch (ChainException e) {
                    this._isChainStarted = false;
                    jmsActivePort = -1;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"JFAP chain InboundBasicMessaging failed in obtaining Listening port from ChannelFrameWork", (Object)((Object)e));
                    }
                    return;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"JFAP chain InboundBasicMessaging successfully started and bound to port: ", (Object)jmsActivePort);
                }
                this._isChainStarted = true;
                newConfig.isValidConfig = true;
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block22;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Problem in starting the chain  " + newConfig));
            }
        }
    }

    private void removeChannel(String name) {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"CommsInboundChain removeChnanel", (Object)name);
            }
            try {
                this._cfw.removeChannel(name);
            }
            catch (ChannelException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Error removing channel " + name), (Object)((Object)e));
                }
            }
            catch (ChainException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Error removing channel " + name), (Object)((Object)e));
            }
        }
    }

    public void chainInitialized(ChainData chainData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"chainInitialized", (Object)chainData);
        }
        this.chainState.set(ChainState.INITIALIZED.val);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"chainInitialized");
        }
    }

    public void chainStarted(ChainData chainData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"chainStarted", (Object)chainData);
        }
        this.chainState.set(ChainState.STARTED.val);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"chainStarted");
        }
    }

    public void chainStopped(ChainData chainData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"chainStopped", (Object)chainData);
        }
        this.chainState.set(ChainState.STOPPED.val);
        this.stopWait.notifyStopped();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"chainStopped");
        }
    }

    public void chainQuiesced(ChainData chainData) {
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"chainQuiesced", (Object)chainData);
            }
            this.chainState.set(ChainState.QUIESCED.val);
            try {
                if (this._isSecureChain) {
                    this._commsServerFacade.closeViaCommsMPConnections(3);
                } else {
                    this._commsServerFacade.closeViaCommsMPConnections(2);
                }
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                SibTr.debug((TraceComponent)tc, (String)"Failed in stopping MP connections which are establised through COMMS: ", (Object)e);
            }
        }
        this.signalNoConnections();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"chainQuiesced");
        }
    }

    private void signalNoConnections() {
        CommsInboundChain commsInboundChain = this;
        EventEngine events = commsInboundChain._commsServerFacade.getEventEngine();
        if (null == events) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Unable to send event, missing service");
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            SibTr.event((TraceComponent)tc, (String)"No active connections, sending stop chain event");
        }
        Event event = events.createEvent(ChannelFramework.EVENT_STOPCHAIN);
        event.setProperty("ChannelName", (Object)this._cfw.getChannel(this._jfapName).getExternalName());
        events.postEvent(event);
    }

    public void chainDestroyed(ChainData chainData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"chainDestroyed", (Object)chainData);
        }
        this.chainState.getAndSet(ChainState.DESTROYED.val);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"chainDestroyed");
        }
    }

    public void chainUpdated(ChainData chainData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"chainUpdated", (Object)chainData);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"chainUpdated");
        }
    }

    private class StopWait {
        private StopWait() {
        }

        synchronized void waitForStop(long timeout) {
            long start;
            long interval = timeout + 2345L;
            for (long waited = 0L; CommsInboundChain.this.chainState.get() > ChainState.STOPPED.val && waited < interval; waited += System.nanoTime() - start) {
                start = System.nanoTime();
                try {
                    this.wait(interval - waited);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        synchronized void notifyStopped() {
            this.notifyAll();
        }
    }

    private final class ChainConfiguration {
        final int configPort;
        final String configHost;
        final Map<String, Object> tcpOptions;
        final Map<String, Object> sslOptions;
        volatile int activePort = -1;
        boolean isValidConfig = false;

        ChainConfiguration(int port, String host, Map<String, Object> tcp, Map<String, Object> ssl) {
            this.tcpOptions = tcp;
            this.sslOptions = ssl;
            this.configPort = port;
            this.configHost = host;
        }

        public int getActivePort() {
            if (this.configPort < 0) {
                return -1;
            }
            if (this.activePort == -1) {
                try {
                    this.activePort = CommsInboundChain.this._cfw.getListeningPort(CommsInboundChain.this._chainName);
                }
                catch (ChainException ce) {
                    this.activePort = -1;
                }
            }
            return this.activePort;
        }

        @Trivial
        public boolean complete() {
            if (this.tcpOptions == null) {
                return false;
            }
            return !CommsInboundChain.this._isSecureChain || this.sslOptions != null;
        }

        protected boolean unchanged(ChainConfiguration other) {
            if (other == null) {
                return false;
            }
            if (CommsInboundChain.this._isSecureChain) {
                return this.configHost.equals(other.configHost) && this.configPort == other.configPort && this.tcpOptions == other.tcpOptions && this.sslOptions == other.sslOptions;
            }
            return this.configHost.equals(other.configHost) && this.configPort == other.configPort && this.tcpOptions == other.tcpOptions;
        }

        protected boolean tcpChanged(ChainConfiguration other) {
            if (other == null) {
                return false;
            }
            return !this.configHost.equals(other.configHost) || this.configPort != other.configPort || this.tcpOptions != other.tcpOptions;
        }

        protected boolean sslChanged(ChainConfiguration other) {
            if (other == null) {
                return false;
            }
            return this.sslOptions != other.sslOptions;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[host=" + this.configHost + ",port=" + this.configPort + ",listening=" + this.activePort + ",complete=" + this.complete() + "]";
        }
    }

    static enum ChainState {
        UNINITIALIZED(0, "UNINITIALIZED"),
        DESTROYED(1, "DESTROYED"),
        INITIALIZED(2, "INITIALIZED"),
        STOPPED(3, "STOPPED"),
        QUIESCED(4, "QUIESCED"),
        STARTED(5, "STARTED");

        final int val;
        final String name;

        @Trivial
        private ChainState(int val, String name) {
            this.val = val;
            this.name = "name";
        }

        @Trivial
        public static final String printState(int state) {
            switch (state) {
                case 0: {
                    return "UNINITIALIZED";
                }
                case 1: {
                    return "DESTROYED";
                }
                case 2: {
                    return "INITIALIZED";
                }
                case 3: {
                    return "STOPPED";
                }
                case 4: {
                    return "QUIESCED";
                }
                case 5: {
                    return "STARTED";
                }
            }
            return "UNKNOWN";
        }
    }
}

