/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.util.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.anno.service.internal.AnnotationServiceImpl_Logging;
import com.ibm.ws.anno.util.internal.UtilImpl_Factory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.util.Util_InternMap;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class UtilImpl_InternMap
implements Util_InternMap {
    private static final TraceComponent tc = Tr.register(UtilImpl_InternMap.class);
    public static final String CLASS_NAME = UtilImpl_InternMap.class.getName();
    protected final String hashText;
    public static final int DEFAULT_LOG_THRESHHOLD = 4096;
    protected final int logThreshHold;
    protected final UtilImpl_Factory factory;
    protected final Util_InternMap.ValueType valueType;
    protected boolean checkValues;
    protected final String name;
    protected final Map<String, String> internMap;
    protected int lastReportedLength;
    protected int totalLength;
    static final long serialVersionUID = -5461277679491511795L;

    @Override
    @Trivial
    public String getHashText() {
        return this.hashText;
    }

    @Override
    @Trivial
    public int getLogThreshHold() {
        return this.logThreshHold;
    }

    @Trivial
    public static String doValidate(String value, Util_InternMap.ValueType valueType) {
        String vMsg = null;
        switch (valueType) {
            case VT_CLASS_RESOURCE: {
                if (value.contains("\\")) {
                    vMsg = "ANNO_UTIL_UNEXPECTED_BACKSLASH";
                    break;
                }
                if (value.endsWith(".class")) break;
                vMsg = "ANNO_UTIL_EXPECTED_CLASS";
                break;
            }
            case VT_CLASS_REFERENCE: {
                if (value.contains("\\")) {
                    vMsg = "ANNO_UTIL_UNEXPECTED_BACKSLASH";
                    break;
                }
                if (!value.endsWith(".class")) break;
                vMsg = "ANNO_UTIL_UNEXPECTED_CLASS";
                break;
            }
            case VT_CLASS_NAME: {
                if (value.contains("\\")) {
                    vMsg = "ANNO_UTIL_UNEXPECTED_BACKSLASH";
                    break;
                }
                if (value.contains("/")) {
                    vMsg = "ANNO_UTIL_UNEXPECTED_FORWARD_SLASH";
                    break;
                }
                if (!value.endsWith(".class")) break;
                vMsg = "ANNO_UTIL_UNEXPECTED_CLASS";
                break;
            }
            case VT_FIELD_NAME: {
                if (value.contains("\\")) {
                    vMsg = "ANNO_UTIL_UNEXPECTED_BACKSLASH";
                    break;
                }
                if (value.contains("/")) {
                    vMsg = "ANNO_UTIL_UNEXPECTED_FORWARD_SLASH";
                    break;
                }
                if (!value.endsWith(".class")) break;
                vMsg = "ANNO_UTIL_UNEXPECTED_CLASS";
                break;
            }
            case VT_METHOD_NAME: {
                if (value.contains("\\")) {
                    vMsg = "ANNO_UTIL_UNEXPECTED_BACKSLASH";
                    break;
                }
                if (value.contains("/")) {
                    vMsg = "ANNO_UTIL_UNEXPECTED_FORWARD_SLASH";
                    break;
                }
                if (!value.endsWith(".class")) break;
                vMsg = "ANNO_UTIL_UNEXPECTED_CLASS";
                break;
            }
            case VT_OTHER: {
                break;
            }
            default: {
                vMsg = "ANNO_UTIL_UNRECOGNIZED_TYPE";
            }
        }
        return vMsg;
    }

    @Override
    @Trivial
    public String validate(String value, Util_InternMap.ValueType valueType) {
        return UtilImpl_InternMap.doValidate(value, valueType);
    }

    @Trivial
    public UtilImpl_InternMap(UtilImpl_Factory factory, Util_InternMap.ValueType valueType, String name) {
        this(factory, valueType, 4096, name);
    }

    @Trivial
    public UtilImpl_InternMap(UtilImpl_Factory factory, Util_InternMap.ValueType valueType, int logThreshHold, String name) {
        this.factory = factory;
        this.logThreshHold = logThreshHold;
        this.name = name;
        this.hashText = AnnotationServiceImpl_Logging.getBaseHash(this) + "(" + this.name + ")";
        this.valueType = valueType;
        this.checkValues = tc.isDebugEnabled();
        this.internMap = new HashMap<String, String>();
        this.lastReportedLength = 0;
        this.totalLength = 0;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Value type [ {1} ] Log threshhold [ {2} ]", new Object[]{this.hashText, this.valueType, this.logThreshHold}), (Object[])new Object[0]);
        }
    }

    @Override
    @Trivial
    public UtilImpl_Factory getFactory() {
        return this.factory;
    }

    @Override
    @Trivial
    public Util_InternMap.ValueType getValueType() {
        return this.valueType;
    }

    @Trivial
    public boolean getCheckValues() {
        return this.checkValues;
    }

    @Override
    @Trivial
    public String getName() {
        return this.name;
    }

    @Trivial
    protected Map<String, String> getInternMap() {
        return this.internMap;
    }

    @Trivial
    protected int getLastReportedLength() {
        return this.lastReportedLength;
    }

    @Override
    @Trivial
    public Collection<String> getValues() {
        return this.getInternMap().values();
    }

    @Override
    @Trivial
    public int getSize() {
        return this.getInternMap().size();
    }

    @Override
    @Trivial
    public int getTotalLength() {
        return this.totalLength;
    }

    @Override
    @Trivial
    public String intern(String value) {
        return this.intern(value, true);
    }

    @Override
    public String intern(String value, boolean doForce) {
        String priorIntern;
        String vMsgId;
        if (value == null) {
            return value;
        }
        if (this.checkValues && (vMsgId = this.validate(value, this.valueType)) != null) {
            Tr.warning((TraceComponent)tc, (String)vMsgId, (Object[])new Object[]{this.getHashText(), value, this.valueType});
        }
        if ((priorIntern = this.internMap.get(value)) != null || !doForce) {
            return priorIntern;
        }
        priorIntern = value;
        this.internMap.put(value, value);
        this.totalLength += value.length();
        if (this.totalLength - this.lastReportedLength > this.logThreshHold) {
            this.lastReportedLength = this.totalLength;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Total [ {1} ]", this.hashText, this.totalLength), (Object[])new Object[0]);
            }
        }
        return priorIntern;
    }

    @Override
    @Trivial
    public boolean contains(String value) {
        return this.internMap.containsKey(value);
    }

    @Override
    @Trivial
    public void logState() {
        if (AnnotationServiceImpl_Logging.stateLogger.isDebugEnabled()) {
            this.log(AnnotationServiceImpl_Logging.stateLogger);
        }
    }

    @Override
    @Trivial
    public void log(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("BEGIN Intern Map [ {0} ]:", this.getHashText()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Log threshhold[ {0} ]", this.getLogThreshHold()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Size [ {0} ]", this.getSize()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Total Length [ {0} ]", this.getTotalLength()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)logger, (String)"END Intern Map", (Object[])new Object[0]);
    }
}

