/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.ltc.embeddable.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.tx.jta.embeddable.EmbeddableTransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCallback;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import java.util.ArrayList;

public final class LTCCallbacks {
    private static LTCCallbacks _instance = new LTCCallbacks();
    private ArrayList<UOWCallback> _callbacks = new ArrayList();
    private static final UOWCurrent _uowCurrent = EmbeddableTransactionManagerFactory.getUOWCurrent();
    private static final TraceComponent tc = Tr.register(LTCCallbacks.class, (String)"Transaction", (String)"com.ibm.ws.LocalTransaction.resources.LocalTranMsgs");

    private LTCCallbacks() {
    }

    public static LTCCallbacks instance() {
        return _instance;
    }

    public void registerCallback(UOWCallback callback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerCallback", (Object)callback);
        }
        if (!this._callbacks.contains(callback)) {
            this._callbacks.add(callback);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Number of registered Callbacks: " + this._callbacks.size()));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerCallback");
        }
    }

    public void contextChange(int typeOfChange) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String type = "UNKNOWN";
            switch (typeOfChange) {
                case 0: {
                    type = "PRE_BEGIN";
                    break;
                }
                case 1: {
                    type = "POST_BEGIN";
                    break;
                }
                case 2: {
                    type = "PRE_END";
                    break;
                }
                case 3: {
                    type = "POST_END";
                }
            }
            Tr.entry((TraceComponent)tc, (String)"contextChange", (Object)type);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"UOWCurrent", (Object)_uowCurrent);
        }
        UOWCoordinator coord = null;
        if (typeOfChange == 1 || typeOfChange == 2) {
            coord = _uowCurrent.getUOWCoord();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Coordinator=" + coord));
        }
        IllegalStateException ex = null;
        for (int i = 0; i < this._callbacks.size(); ++i) {
            UOWCallback callback = this._callbacks.get(i);
            try {
                callback.contextChange(typeOfChange, coord);
                continue;
            }
            catch (IllegalStateException ise) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception caught during UOW callback at context change", (Object)ise);
                }
                ex = ise;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"contextChange");
        }
        if (ex != null) {
            throw ex;
        }
    }
}

