/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.embeddable.impl;

import com.ibm.ejs.util.Util;
import com.ibm.tx.jta.embeddable.impl.EmbeddableTransactionImpl;
import com.ibm.tx.jta.embeddable.impl.JTAAsyncResourceBase;
import com.ibm.tx.jta.embeddable.impl.WSATParticipantWrapper;
import com.ibm.tx.jta.impl.JTAXAResourceImpl;
import com.ibm.tx.jta.impl.RecoveryManager;
import com.ibm.tx.jta.impl.RegisteredResources;
import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.tx.remote.TransactionWrapper;
import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.HeuristicHazardException;
import com.ibm.ws.Transaction.JTA.JTAResource;
import com.ibm.ws.Transaction.JTA.ResourceSupportsOnePhaseCommit;
import com.ibm.ws.Transaction.JTA.XAReturnCodeHelper;
import com.ibm.ws.Transaction.test.XAFlowCallbackControl;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import java.util.ArrayList;
import javax.transaction.HeuristicMixedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;

public class EmbeddableRegisteredResources
extends RegisteredResources {
    private static final TraceComponent tc = Tr.register(EmbeddableRegisteredResources.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    public static final int WSAT_PREPARE_ORDER_CONCURRENT = 0;
    public static final int WSAT_PREPARE_ORDER_BEFORE = 1;
    public static final int WSAT_PREPARE_ORDER_AFTER = 2;
    private final int _wsatPrepareOrder = 0;
    private RecoverableUnitSection _wsatAsyncSection;
    private ArrayList<JTAAsyncResourceBase> _asyncResourceObjects;

    public EmbeddableRegisteredResources(TransactionImpl tran, boolean disableTwoPhase) {
        super(tran, disableTwoPhase);
    }

    public void addAsyncResource(JTAAsyncResourceBase resource) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addAsyncResource", (Object[])new Object[]{this, resource});
        }
        if (this._asyncResourceObjects == null) {
            this._asyncResourceObjects = new ArrayList();
        } else {
            for (JTAAsyncResourceBase asyncRes : this._asyncResourceObjects) {
                if (!resource.getKey().equals(asyncRes.getKey())) continue;
                SystemException se = new SystemException("Cannot register two asynchronous resources with the same keys: " + asyncRes.getKey());
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"addAsyncResource", (Object)se);
                }
                throw se;
            }
        }
        resource.setResourceStatus(1);
        this._asyncResourceObjects.add(resource);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("(SPI) SERVER registered with Transaction. TX: " + this._transaction.getLocalTID() + ", Resource: " + (Object)((Object)resource)), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addAsyncResource");
        }
    }

    protected boolean gotAsyncResources() {
        return this._asyncResourceObjects != null && this._asyncResourceObjects.size() != 0;
    }

    protected void prePrepareGetAsyncPrepareResults(long startTime) throws HeuristicHazardException, RollbackException, SystemException, HeuristicMixedException {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prePrepareGetAsyncPrepareResults", (Object[])new Object[]{this});
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prePrepareGetAsyncPrepareResults", (Object)((Object)this));
        }
    }

    protected void postPreparePrepareAsyncResources() throws SystemException, RollbackException {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"postPreparePrepareAsyncResources", (Object[])new Object[]{this});
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"postPreparePrepareAsyncResources", (Object)((Object)this));
        }
    }

    protected void postPrepareGetAsyncPrepareResults(long startTime) throws HeuristicHazardException, RollbackException, SystemException, HeuristicMixedException {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"postPrepareGetAsyncPrepareResults", (Object[])new Object[]{this});
        }
        this.getAsyncPrepareResults(startTime);
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"postPrepareGetAsyncPrepareResults", (Object)((Object)this));
        }
    }

    protected void prePreparePrepareAsyncResources() throws SystemException, RollbackException {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prePreparePrepareAsyncResources", (Object[])new Object[]{this});
        }
        this.prepareAsyncResources();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prePreparePrepareAsyncResources", (Object)((Object)this));
        }
    }

    void rollbackResources() {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rollbackResources", (Object[])new Object[]{this});
        }
        this.distributeEnd(0x20000000);
        this._outcome = false;
        this._retryRequired = this.distributeOutcome();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"rollbackResources", (Object)this._retryRequired);
        }
    }

    protected void getAsyncPrepareResults(long startTime) throws HeuristicHazardException, RollbackException, SystemException, HeuristicMixedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAsyncPrepareResults", (Object[])new Object[]{startTime, this});
        }
        this.awaitAsyncResponses(startTime);
        for (JTAAsyncResourceBase currResource : this._asyncResourceObjects) {
            int currResult = this.prepareResource(currResource);
            if (currResult == 0) {
                currResource.setResourceStatus(2);
                if (this._prepareResult == 3) {
                    this._prepareResult = 0;
                }
                ++this._okVoteCount;
                continue;
            }
            currResource.setResourceStatus(4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAsyncPrepareResults");
        }
    }

    private void awaitAsyncResponses(long startTime) {
    }

    protected void prepareAsyncResources() throws SystemException, RollbackException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepareAsyncResources", (Object[])new Object[]{this});
        }
        for (JTAAsyncResourceBase currResource : this._asyncResourceObjects) {
            try {
                currResource.sendAsyncPrepare();
            }
            catch (XAException xae) {
                FFDCFilter.processException((Throwable)xae, (String)"com.ibm.ws.tx.jta.RegisteredResources.prepareAsyncResources", (String)"761", (Object)((Object)this));
                this._errorCode = xae.errorCode;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("XAException: error code " + XAReturnCodeHelper.convertXACode((int)this._errorCode)), (Object[])new Object[]{xae});
                }
                if (xaFlowCallbackEnabled) {
                    XAFlowCallbackControl.afterXAFlow((int)1, (int)51);
                }
                this.logRmfailOnPreparing(xae);
                currResource.setResourceStatus(2);
                if (this._errorCode == -7) {
                    Throwable toThrow = new RollbackException().initCause((Throwable)xae);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"prepareAsyncResources", (Object)toThrow);
                    }
                    throw (RollbackException)toThrow;
                }
                Throwable toThrow = new SystemException().initCause((Throwable)xae);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"prepareAsyncResources", (Object)toThrow);
                }
                throw (SystemException)toThrow;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepareAsyncResources");
        }
    }

    protected boolean completeAsyncResources() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"completeAsyncResources", (Object[])new Object[]{this});
        }
        boolean retryRequired = false;
        for (JTAAsyncResourceBase currResource : this._asyncResourceObjects) {
            boolean informResource = true;
            int flowType = -1;
            try {
                switch (currResource.getResourceStatus()) {
                    case 2: {
                        currResource.setResourceStatus(3);
                    }
                    case 3: {
                        if (this._outcome) {
                            if (xaFlowCallbackEnabled) {
                                informResource = XAFlowCallbackControl.beforeXAFlow((int)2, (int)30);
                                flowType = 2;
                            }
                            if (!informResource) break;
                            currResource.sendAsyncCommit();
                            break;
                        }
                        if (xaFlowCallbackEnabled) {
                            informResource = XAFlowCallbackControl.beforeXAFlow((int)3, (int)40);
                            flowType = 3;
                        }
                        if (!informResource) break;
                        currResource.sendAsyncRollback();
                        break;
                    }
                    case 1: {
                        if (this._outcome) break;
                        currResource.setResourceStatus(3);
                        if (xaFlowCallbackEnabled) {
                            informResource = XAFlowCallbackControl.beforeXAFlow((int)3, (int)40);
                            flowType = 3;
                        }
                        if (!informResource) break;
                        currResource.sendAsyncRollback();
                        break;
                    }
                }
            }
            catch (XAException xae) {
                this._errorCode = xae.errorCode;
                FFDCFilter.processException((Throwable)xae, (String)"com.ibm.ws.tx.jta.RegisteredResources.distributeOutcome", (String)"1929", (Object)((Object)this));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("XAException: error code " + XAReturnCodeHelper.convertXACode((int)this._errorCode)), (Object[])new Object[]{xae});
                }
                if (xaFlowCallbackEnabled) {
                    XAFlowCallbackControl.afterXAFlow((int)flowType, (int)51);
                }
                if (this._errorCode == -3) {
                    this.updateHeuristicOutcome(9);
                    currResource.setResourceStatus(6);
                    currResource.destroy();
                    if (!this._outcome) continue;
                    this._diagnosticsRequired = true;
                    Tr.error((TraceComponent)tc, (String)"WTRN0047_XAER_RMERR_ON_COMMIT", (Object[])new Object[]{currResource});
                    continue;
                }
                if (this._errorCode == -7) {
                    this.logRmfailOnCompleting(currResource, xae);
                    currResource.setState(3);
                    this.updateHeuristicOutcome(11);
                    this.addToFailedResources(currResource);
                    retryRequired = true;
                    continue;
                }
                currResource.setResourceStatus(4);
                currResource.destroy();
                this._diagnosticsRequired = true;
                if (this._outcome) {
                    Tr.error((TraceComponent)tc, (String)"WTRN0050_UNEXPECTED_XA_ERROR_ON_COMMIT", (Object[])new Object[]{XAReturnCodeHelper.convertXACode((int)this._errorCode)});
                } else {
                    Tr.error((TraceComponent)tc, (String)"WTRN0051_UNEXPECTED_XA_ERROR_ON_ROLLBACK", (Object[])new Object[]{XAReturnCodeHelper.convertXACode((int)this._errorCode)});
                }
                this._systemException = xae;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"completeAsyncResources", (Object)retryRequired);
        }
        return retryRequired;
    }

    protected boolean getAsyncCompletionResults(long startTime, boolean retryRequired) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAsyncCompletionResults", (Object[])new Object[]{startTime, retryRequired, this});
        }
        for (JTAAsyncResourceBase currResource : this._asyncResourceObjects) {
            if (!this.deliverOutcome(currResource)) continue;
            retryRequired = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAsyncCompletionResults", (Object)retryRequired);
        }
        return retryRequired;
    }

    protected void logResources() throws SystemException {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logResources", (Object[])new Object[]{this._resourcesLogged});
        }
        if (!this._resourcesLogged) {
            if (this._asyncResourceObjects != null) {
                for (JTAAsyncResourceBase resource : this._asyncResourceObjects) {
                    if (resource.getResourceStatus() != 2) continue;
                    this.recordLog(resource);
                }
            }
            super.logResources();
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logResources");
        }
    }

    public boolean isOnlyAgent() {
        boolean result;
        boolean bl = result = this._resourceObjects.size() == 1 && this._resourceObjects.get(0) instanceof ResourceSupportsOnePhaseCommit && (this._asyncResourceObjects == null || this._asyncResourceObjects.size() == 0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isOnlyAgent", (Object[])new Object[]{result});
        }
        return result;
    }

    protected RecoverableUnitSection recordOtherResourceTypes(JTAResource resource) throws SystemException {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recordOtherResourceTypes", (Object[])new Object[]{resource, this});
        }
        RecoverableUnitSection rus = null;
        if (resource instanceof WSATParticipantWrapper) {
            if (this._wsatAsyncSection == null) {
                this._wsatAsyncSection = this.createLogSection(10, this._logUnit);
            }
            rus = this._wsatAsyncSection;
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recordOtherResourceTypes", (Object)rus);
        }
        return rus;
    }

    public void reconstruct(RecoveryManager rm, RecoverableUnit log) throws SystemException {
        byte[] data;
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reconstruct", (Object[])new Object[]{rm, log});
        }
        RecoveryManager recoveryManager = rm;
        this._retryCompletion = true;
        this.reconstructHeuristics(log);
        this._xalogSection = log.lookupSection(2);
        if (this._xalogSection != null) {
            byte[] tid = this._transaction.getXidImpl().toBytes();
            LogCursor logData = null;
            try {
                logData = this._xalogSection.data();
                while (logData.hasNext()) {
                    data = (byte[])logData.next();
                    try {
                        JTAXAResourceImpl res = new JTAXAResourceImpl(recoveryManager.getPartnerLogTable(), tid, data);
                        res.setResourceStatus(2);
                        this._resourceObjects.add(res);
                        if (res.getPriority() == 0) continue;
                        this._gotPriorityResourcesEnlisted = true;
                    }
                    catch (Throwable exc) {
                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.tx.jta.embeddable.impl.EmbeddableRegisteredResources.reconstruct", (String)"843", (Object)((Object)this));
                        Tr.error((TraceComponent)tc, (String)"WTRN0045_CANNOT_RECOVER_RESOURCE", (Object[])new Object[]{Util.toHexString((byte[])data), exc});
                        throw exc;
                    }
                }
                logData.close();
            }
            catch (Throwable exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.tx.jta.embeddable.impl.EmbeddableRegisteredResources.reconstruct", (String)"853", (Object)((Object)this));
                Tr.fatal((TraceComponent)tc, (String)"WTRN0000_ERR_INT_ERROR", (Object[])new Object[]{"reconstruct", "com.ibm.ws.tx.jta.RegisteredResources", exc});
                if (logData != null) {
                    logData.close();
                }
                if (traceOn && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Exception raised reconstructing XA resource", (Object[])new Object[0]);
                }
                if (traceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"reconstruct");
                }
                throw (SystemException)new SystemException(exc.toString()).initCause(exc);
            }
        }
        this._wsatAsyncSection = log.lookupSection(10);
        if (this._wsatAsyncSection != null) {
            new TransactionWrapper((EmbeddableTransactionImpl)this._transaction);
            if (traceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"reconstructing async resources", (Object[])new Object[0]);
            }
            LogCursor logData = null;
            WSATParticipantWrapper wrapper = null;
            this._asyncResourceObjects = new ArrayList();
            try {
                logData = this._wsatAsyncSection.data();
                while (logData.hasNext()) {
                    data = (byte[])logData.next();
                    try {
                        wrapper = new WSATParticipantWrapper(data);
                        wrapper.setResourceStatus(2);
                        this._asyncResourceObjects.add(wrapper);
                    }
                    catch (Throwable exc) {
                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.tx.jta.embeddable.impl.EmbeddableRegisteredResources.reconstruct", (String)"943", (Object)((Object)this));
                        Tr.error((TraceComponent)tc, (String)"WTRN0045_CANNOT_RECOVER_RESOURCE", (Object[])new Object[]{data, exc});
                        throw exc;
                    }
                }
                logData.close();
            }
            catch (Throwable exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.tx.jta.embeddable.impl.EmbeddableRegisteredResources.reconstruct", (String)"952", (Object)((Object)this));
                Tr.fatal((TraceComponent)tc, (String)"WTRN0000_ERR_INT_ERROR", (Object[])new Object[]{"reconstruct", "com.ibm.ws.tx.jta.RegisteredResources", exc});
                if (logData != null) {
                    logData.close();
                }
                if (traceOn && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Exception raised reconstructing WSAT Async resource", (Object[])new Object[0]);
                }
                throw (SystemException)new SystemException(exc.toString()).initCause(exc);
            }
        }
        this._logUnit = log;
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reconstruct");
        }
    }
}

