/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver.internal.resource;

import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.provisioning.VersionUtility;
import com.ibm.ws.repository.common.enums.InstallPolicy;
import com.ibm.ws.repository.resolver.ProductRequirementInformation;
import com.ibm.ws.repository.resolver.internal.LibertyVersion;
import com.ibm.ws.repository.resolver.internal.LibertyVersionRange;
import com.ibm.ws.repository.resolver.internal.resource.GenericMetadataRequirement;
import com.ibm.ws.repository.resolver.internal.resource.InstallableEntityCapability;
import com.ibm.ws.repository.resolver.internal.resource.InstallableEntityRequirement;
import com.ibm.ws.repository.resolver.internal.resource.ProductRequirement;
import com.ibm.ws.repository.resolver.internal.resource.ResourceImpl;
import com.ibm.ws.repository.resources.EsaResource;
import com.ibm.ws.repository.resources.RepositoryResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class FeatureResource
extends ResourceImpl
implements Comparable<FeatureResource> {
    private final String symbolicName;
    private final Version version;
    private final boolean isAutoFeatureThatShouldBeInstalledWhenSatisfied;

    public static FeatureResource createInstance(ProvisioningFeatureDefinition feature) {
        String shortName = feature.getIbmShortName();
        String lowerCaseShortName = shortName != null ? shortName.toLowerCase() : null;
        String provisionCapability = feature.getHeader("IBM-Provision-Capability");
        boolean isAutoFeature = provisionCapability != null && !provisionCapability.isEmpty();
        boolean isAutoFeatureToInstallWhenSatisfied = false;
        if (isAutoFeature) {
            String installPolicy = feature.getHeader("IBM-Install-Policy");
            isAutoFeatureToInstallWhenSatisfied = "when-satisfied".equals(installPolicy);
        }
        return new FeatureResource(feature.getSymbolicName(), shortName, lowerCaseShortName, feature.getVersion(), null, "install", null, isAutoFeatureToInstallWhenSatisfied);
    }

    public static FeatureResource createInstance(EsaResource esaResource) {
        String provisionCapability;
        boolean isAutoFeature;
        Collection requiredFixes;
        Collection requiredFeatures;
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        String appliesTo = esaResource.getAppliesTo();
        if (appliesTo != null && !appliesTo.isEmpty()) {
            requirements.add(new ProductRequirement(appliesTo));
        }
        if ((requiredFeatures = esaResource.getRequireFeature()) != null) {
            for (Object requiredFeature : requiredFeatures) {
                requirements.add(new InstallableEntityRequirement((String)requiredFeature, "osgi.subsystem.feature"));
            }
        }
        if ((requiredFixes = esaResource.getRequireFix()) != null) {
            for (String requiredFix : requiredFixes) {
                requirements.add(new InstallableEntityRequirement(requiredFix, "ifix"));
            }
        }
        boolean bl = isAutoFeature = (provisionCapability = esaResource.getProvisionCapability()) != null && !provisionCapability.isEmpty();
        if (isAutoFeature) {
            List requirementMetadata = ManifestHeaderProcessor.parseRequirementString((String)provisionCapability);
            for (ManifestHeaderProcessor.GenericMetadata genericMetadata : requirementMetadata) {
                GenericMetadataRequirement requirement = new GenericMetadataRequirement(genericMetadata);
                requirement.getDirectives().put("classifier", "auto");
                requirements.add(requirement);
            }
        }
        boolean isAutoInstallable = isAutoFeature ? InstallPolicy.WHEN_SATISFIED.equals((Object)esaResource.getInstallPolicy()) : false;
        return new FeatureResource(esaResource.getProvideFeature(), esaResource.getShortName(), esaResource.getLowerCaseShortName(), VersionUtility.stringToVersion((String)esaResource.getVersion()), requirements, "repo", (RepositoryResource)esaResource, isAutoInstallable);
    }

    private FeatureResource(String symbolicName, String shortName, String lowerCaseShortName, Version version, List<Requirement> requirements, String location, RepositoryResource massiveResource, boolean isAutoFeatureThatShouldBeInstalledWhenSatisfied) {
        super(FeatureResource.createCapabilities(symbolicName, shortName, lowerCaseShortName, version), requirements, location, massiveResource);
        this.symbolicName = symbolicName;
        this.version = version;
        this.isAutoFeatureThatShouldBeInstalledWhenSatisfied = isAutoFeatureThatShouldBeInstalledWhenSatisfied;
    }

    private static List<Capability> createCapabilities(String symbolicName, String shortName, String lowerCaseShortName, Version version) {
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        capabilities.add(new InstallableEntityCapability(symbolicName, shortName, lowerCaseShortName, version, "osgi.subsystem.feature"));
        return capabilities;
    }

    @Override
    public int compareTo(FeatureResource o) {
        int locationCheck = this.compareLocation(o);
        if (locationCheck != 0) {
            return locationCheck;
        }
        int featureCheck = this.symbolicName.compareTo(o.symbolicName);
        if (featureCheck != 0) {
            return featureCheck;
        }
        int versionCheck = o.version.compareTo(this.version);
        if (versionCheck != 0) {
            return versionCheck;
        }
        int appliesToCheck = this.compareAppliesTo(o);
        if (appliesToCheck != 0) {
            return appliesToCheck;
        }
        return 0;
    }

    private int compareAppliesTo(FeatureResource o) {
        List<Requirement> thisRequirements = this.getRequirements("com.ibm.ws.repo.product");
        List<Requirement> otherRequirements = o.getRequirements("com.ibm.ws.repo.product");
        if (thisRequirements.size() == 0) {
            if (otherRequirements.size() > 0) {
                return 1;
            }
            return 0;
        }
        if (otherRequirements.size() == 0) {
            return -1;
        }
        VersionInformation thisVersionInformation = this.getRequirementVersionInformation(thisRequirements);
        VersionInformation otherVersionInformation = this.getRequirementVersionInformation(otherRequirements);
        if (thisVersionInformation == null) {
            if (otherVersionInformation != null) {
                return 1;
            }
            return 0;
        }
        if (otherVersionInformation == null) {
            return -1;
        }
        if (thisVersionInformation.maximumVersion != null) {
            if (otherVersionInformation.maximumVersion != null) {
                return otherVersionInformation.minimumVersion.compareTo(thisVersionInformation.minimumVersion);
            }
            return -1;
        }
        if (otherVersionInformation.maximumVersion != null) {
            return 1;
        }
        return otherVersionInformation.minimumVersion.compareTo(thisVersionInformation.minimumVersion);
    }

    private VersionInformation getRequirementVersionInformation(List<Requirement> productRequirements) {
        ProductRequirement requirement = (ProductRequirement)productRequirements.get(0);
        List<ProductRequirementInformation> productInformations = requirement.getProductInformation();
        if (productInformations == null || productInformations.size() == 0) {
            return null;
        }
        ProductRequirementInformation productInformation = productInformations.get(0);
        LibertyVersionRange versionRange = productInformation.versionRange;
        LibertyVersion minimumVersion = null;
        LibertyVersion maximumVersion = null;
        if (versionRange != null) {
            minimumVersion = versionRange.getMinVersion();
            maximumVersion = versionRange.getMaxVersion();
            return new VersionInformation(minimumVersion, maximumVersion);
        }
        return null;
    }

    public String toString() {
        return "FeatureResource [symbolicName=" + this.symbolicName + ", version=" + this.version + ", location=" + this.location + "]";
    }

    public boolean isAutoFeatureThatShouldBeInstalledWhenSatisfied() {
        return this.isAutoFeatureThatShouldBeInstalledWhenSatisfied;
    }

    private static class VersionInformation {
        private final LibertyVersion minimumVersion;
        private final LibertyVersion maximumVersion;

        public VersionInformation(LibertyVersion minimumVersion, LibertyVersion maximumVersion) {
            this.minimumVersion = minimumVersion;
            this.maximumVersion = maximumVersion;
        }
    }
}

