/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidatorUtils;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.eclipse.microprofile.openapi.models.media.Schema;

public class SchemaValidator
extends TypeValidator<Schema> {
    private static final TraceComponent tc = Tr.register(SchemaValidator.class);
    private static final SchemaValidator INSTANCE = new SchemaValidator();

    public static SchemaValidator getInstance() {
        return INSTANCE;
    }

    private SchemaValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Schema t) {
        if (t != null) {
            String message;
            String message2;
            String reference = t.getRef();
            if (reference != null && !reference.isEmpty()) {
                ValidatorUtils.referenceValidatorHelper(reference, t, helper, context, key);
                return;
            }
            if (t.getType() != null && "array".equals(t.getType().toString()) && t.getItems() == null) {
                message2 = Tr.formatMessage((TraceComponent)tc, (String)"schemaTypeArrayNullItems", (Object[])new Object[0]);
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message2));
            }
            if (t.getReadOnly() != null && t.getWriteOnly() != null && t.getReadOnly().booleanValue() && t.getWriteOnly().booleanValue()) {
                message2 = Tr.formatMessage((TraceComponent)tc, (String)"schemaReadOnlyOrWriteOnly", (Object[])new Object[0]);
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message2));
            }
            if (t.getMultipleOf() != null && t.getMultipleOf().compareTo(BigDecimal.ONE) < 1) {
                message2 = Tr.formatMessage((TraceComponent)tc, (String)"schemaMultipleOfLessThanOne", (Object[])new Object[0]);
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message2));
            }
            String type = t.getType() != null ? t.getType().toString() : "null";
            ArrayList<String> propertiesInvalidValue = new ArrayList<String>();
            ArrayList<String> propertiesNotForSchemaType = new ArrayList<String>();
            if (t.getMaxLength() != null) {
                if (t.getMaxLength() < 0) {
                    propertiesInvalidValue.add("maxLength");
                }
                if (!type.equals("string")) {
                    propertiesNotForSchemaType.add("maxLength");
                }
            }
            if (t.getMinLength() != null) {
                if (t.getMinLength() < 0) {
                    propertiesInvalidValue.add("minLength");
                }
                if (!type.equals("string")) {
                    propertiesNotForSchemaType.add("minLength");
                }
            }
            if (t.getMinItems() != null) {
                if (t.getMinItems() < 0) {
                    propertiesInvalidValue.add("minItems");
                }
                if (!type.equals("array")) {
                    propertiesNotForSchemaType.add("minItems");
                }
            }
            if (t.getMaxItems() != null) {
                if (t.getMaxItems() < 0) {
                    propertiesInvalidValue.add("maxItems");
                }
                if (!type.equals("array")) {
                    propertiesNotForSchemaType.add("maxItems");
                }
            }
            if (t.getUniqueItems() != null && !type.equals("array")) {
                propertiesNotForSchemaType.add("uniqueItems");
            }
            if (t.getMinProperties() != null) {
                if (t.getMinProperties() < 0) {
                    propertiesInvalidValue.add("minProperties");
                }
                if (!type.equals("object")) {
                    propertiesNotForSchemaType.add("minProperties");
                }
            }
            if (t.getMaxProperties() != null) {
                if (t.getMaxProperties() < 0) {
                    propertiesInvalidValue.add("maxProperties");
                }
                if (!type.equals("object")) {
                    propertiesNotForSchemaType.add("maxProperties");
                }
            }
            if (!propertiesInvalidValue.isEmpty()) {
                for (String s : propertiesInvalidValue) {
                    message = Tr.formatMessage((TraceComponent)tc, (String)"schemaPropertyLessThanZero", (Object[])new Object[]{s});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                }
            }
            if (!propertiesNotForSchemaType.isEmpty()) {
                for (String s : propertiesNotForSchemaType) {
                    message = Tr.formatMessage((TraceComponent)tc, (String)"schemaTypeDoesNotMatchProperty", (Object[])new Object[]{s, type});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
                }
            }
        }
    }
}

