/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.core.util;

import com.fasterxml.jackson.databind.type.TypeFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.openapi.impl.model.media.SchemaImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.openapi.models.media.Schema;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class PrimitiveType
extends Enum<PrimitiveType> {
    public static final /* enum */ PrimitiveType STRING;
    public static final /* enum */ PrimitiveType BOOLEAN;
    public static final /* enum */ PrimitiveType BYTE;
    public static final /* enum */ PrimitiveType BINARY;
    public static final /* enum */ PrimitiveType URI;
    public static final /* enum */ PrimitiveType URL;
    public static final /* enum */ PrimitiveType EMAIL;
    public static final /* enum */ PrimitiveType UUID;
    public static final /* enum */ PrimitiveType INT;
    public static final /* enum */ PrimitiveType LONG;
    public static final /* enum */ PrimitiveType FLOAT;
    public static final /* enum */ PrimitiveType DOUBLE;
    public static final /* enum */ PrimitiveType INTEGER;
    public static final /* enum */ PrimitiveType DECIMAL;
    public static final /* enum */ PrimitiveType DATE;
    public static final /* enum */ PrimitiveType DATE_TIME;
    public static final /* enum */ PrimitiveType FILE;
    public static final /* enum */ PrimitiveType OBJECT;
    private static final Map<Class<?>, PrimitiveType> KEY_CLASSES;
    private static final Map<Class<?>, PrimitiveType> BASE_CLASSES;
    private static final Map<String, PrimitiveType> EXTERNAL_CLASSES;
    private static final Map<String, PrimitiveType> NAMES;
    private final Class<?> keyClass;
    private final String commonName;
    public static final Map<String, String> datatypeMappings;
    private static final /* synthetic */ PrimitiveType[] $VALUES;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static PrimitiveType[] values() {
        return (PrimitiveType[])$VALUES.clone();
    }

    public static PrimitiveType valueOf(String name) {
        return Enum.valueOf(PrimitiveType.class, name);
    }

    private PrimitiveType(Class<?> keyClass) {
        this(keyClass, null);
    }

    private PrimitiveType(Class<?> keyClass, String commonName) {
        this.keyClass = keyClass;
        this.commonName = commonName;
    }

    public static PrimitiveType fromType(Type type) {
        Class<?> raw = TypeFactory.defaultInstance().constructType(type).getRawClass();
        PrimitiveType key = KEY_CLASSES.get(raw);
        if (key != null) {
            return key;
        }
        PrimitiveType external = EXTERNAL_CLASSES.get(raw.getName());
        if (external != null) {
            return external;
        }
        for (Map.Entry<Class<?>, PrimitiveType> entry : BASE_CLASSES.entrySet()) {
            if (!entry.getKey().isAssignableFrom(raw)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static PrimitiveType fromName(String name) {
        if (name == null) {
            return null;
        }
        PrimitiveType fromName = NAMES.get(name);
        if (fromName == null) {
            fromName = EXTERNAL_CLASSES.get(name);
        }
        return fromName;
    }

    public static PrimitiveType fromTypeAndFormat(String type, String format) {
        if (StringUtils.isNotBlank((CharSequence)type) && type.equals("object")) {
            return null;
        }
        return PrimitiveType.fromName(datatypeMappings.get(String.format("%s_%s", StringUtils.isBlank((CharSequence)type) ? "" : type, StringUtils.isBlank((CharSequence)format) ? "" : format)));
    }

    public static Schema createProperty(Type type) {
        PrimitiveType item = PrimitiveType.fromType(type);
        return item == null ? null : item.createProperty();
    }

    public static Schema createProperty(String name) {
        PrimitiveType item = PrimitiveType.fromName(name);
        return item == null ? null : item.createProperty();
    }

    public static String getCommonName(Type type) {
        PrimitiveType item = PrimitiveType.fromType(type);
        return item == null ? null : item.getCommonName();
    }

    public Class<?> getKeyClass() {
        return this.keyClass;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public abstract Schema createProperty();

    private static <K> void addKeys(Map<K, PrimitiveType> map, PrimitiveType type, K ... keys) {
        for (K key : keys) {
            map.put(key, type);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(PrimitiveType.class);
        STRING = new PrimitiveType((Class)String.class, "string"){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Schema createProperty() {
                return new SchemaImpl().type(Schema.SchemaType.STRING);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        };
        BOOLEAN = new PrimitiveType((Class)Boolean.class, "boolean"){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Schema createProperty() {
                return new SchemaImpl().type(Schema.SchemaType.BOOLEAN);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        };
        BYTE = new PrimitiveType((Class)Byte.class, "byte"){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Schema createProperty() {
                return new SchemaImpl().type(Schema.SchemaType.STRING).format("base64");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        };
        BINARY = new PrimitiveType((Class)Byte.class, "binary"){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Schema createProperty() {
                return new SchemaImpl().type(Schema.SchemaType.STRING).format("binary");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(4.class);
            }
        };
        URI = new PrimitiveType((Class)URI.class, "uri"){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Schema createProperty() {
                return new SchemaImpl().type(Schema.SchemaType.STRING).format("uri");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(5.class);
            }
        };
        URL = new PrimitiveType((Class)URL.class, "url"){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Schema createProperty() {
                return new SchemaImpl().type(Schema.SchemaType.STRING).format("url");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(6.class);
            }
        };
        EMAIL = new PrimitiveType((Class)String.class, "email"){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Schema createProperty() {
                return new SchemaImpl().type(Schema.SchemaType.STRING).format("email");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(7.class);
            }
        };
        UUID = new PrimitiveType((Class)UUID.class, "uuid"){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Schema createProperty() {
                return new SchemaImpl().type(Schema.SchemaType.STRING).format("uuid");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(8.class);
            }
        };
        INT = new PrimitiveType((Class)Integer.class, "integer"){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Schema createProperty() {
                return new SchemaImpl().type(Schema.SchemaType.INTEGER);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(9.class);
            }
        };
        LONG = new PrimitiveType((Class)Long.class, "long"){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Schema createProperty() {
                return new SchemaImpl().type(Schema.SchemaType.INTEGER).format("int64");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(10.class);
            }
        };
        FLOAT = new PrimitiveType((Class)Float.class, "float"){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Schema createProperty() {
                return new SchemaImpl().type(Schema.SchemaType.NUMBER).format("float");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(11.class);
            }
        };
        DOUBLE = new PrimitiveType((Class)Double.class, "double"){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Schema createProperty() {
                return new SchemaImpl().type(Schema.SchemaType.NUMBER).format("double");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(12.class);
            }
        };
        INTEGER = new PrimitiveType((Class)BigInteger.class){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Schema createProperty() {
                return new SchemaImpl().type(Schema.SchemaType.INTEGER);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(13.class);
            }
        };
        DECIMAL = new PrimitiveType((Class)BigDecimal.class, "number"){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Schema createProperty() {
                return new SchemaImpl().type(Schema.SchemaType.NUMBER);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(14.class);
            }
        };
        DATE = new PrimitiveType((Class)DateStub.class, "date"){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Schema createProperty() {
                return new SchemaImpl().type(Schema.SchemaType.STRING).format("date");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(15.class);
            }
        };
        DATE_TIME = new PrimitiveType((Class)Date.class, "date-time"){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Schema createProperty() {
                return new SchemaImpl().type(Schema.SchemaType.STRING).format("date-time");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(16.class);
            }
        };
        FILE = new PrimitiveType((Class)File.class, "file"){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Schema createProperty() {
                return new SchemaImpl().type(Schema.SchemaType.STRING).format("base64");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(17.class);
            }
        };
        OBJECT = new PrimitiveType((Class)Object.class){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Schema createProperty() {
                return new SchemaImpl().type(Schema.SchemaType.OBJECT);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(18.class);
            }
        };
        $VALUES = new PrimitiveType[]{STRING, BOOLEAN, BYTE, BINARY, URI, URL, EMAIL, UUID, INT, LONG, FLOAT, DOUBLE, INTEGER, DECIMAL, DATE, DATE_TIME, FILE, OBJECT};
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("integer_int32", "integer");
        mappings.put("integer_", "integer");
        mappings.put("integer_int64", "long");
        mappings.put("number", "number");
        mappings.put("number_float", "float");
        mappings.put("number_double", "double");
        datatypeMappings = Collections.unmodifiableMap(mappings);
        HashMap keyClasses = new HashMap();
        PrimitiveType.addKeys(keyClasses, BOOLEAN, Boolean.class, Boolean.TYPE);
        PrimitiveType.addKeys(keyClasses, STRING, String.class, Character.class, Character.TYPE);
        PrimitiveType.addKeys(keyClasses, BYTE, Byte.class, Byte.TYPE);
        PrimitiveType.addKeys(keyClasses, URL, URL.class);
        PrimitiveType.addKeys(keyClasses, URI, URI.class);
        PrimitiveType.addKeys(keyClasses, UUID, UUID.class);
        PrimitiveType.addKeys(keyClasses, INT, Integer.class, Integer.TYPE, Short.class, Short.TYPE);
        PrimitiveType.addKeys(keyClasses, LONG, Long.class, Long.TYPE);
        PrimitiveType.addKeys(keyClasses, FLOAT, Float.class, Float.TYPE);
        PrimitiveType.addKeys(keyClasses, DOUBLE, Double.class, Double.TYPE);
        PrimitiveType.addKeys(keyClasses, INTEGER, BigInteger.class);
        PrimitiveType.addKeys(keyClasses, DECIMAL, BigDecimal.class);
        PrimitiveType.addKeys(keyClasses, DATE, DateStub.class);
        PrimitiveType.addKeys(keyClasses, DATE_TIME, Date.class);
        PrimitiveType.addKeys(keyClasses, FILE, File.class);
        PrimitiveType.addKeys(keyClasses, OBJECT, Object.class);
        KEY_CLASSES = Collections.unmodifiableMap(keyClasses);
        HashMap baseClasses = new HashMap();
        PrimitiveType.addKeys(baseClasses, DATE_TIME, Date.class, Calendar.class);
        BASE_CLASSES = Collections.unmodifiableMap(baseClasses);
        HashMap externalClasses = new HashMap();
        PrimitiveType.addKeys(externalClasses, DATE, "org.joda.time.LocalDate", "java.time.LocalDate");
        PrimitiveType.addKeys(externalClasses, DATE_TIME, "org.joda.time.DateTime", "org.joda.time.ReadableDateTime", "javax.xml.datatype.XMLGregorianCalendar", "java.time.LocalDateTime", "java.time.ZonedDateTime", "java.time.OffsetDateTime");
        PrimitiveType.addKeys(externalClasses, LONG, "java.time.Instant");
        EXTERNAL_CLASSES = Collections.unmodifiableMap(externalClasses);
        TreeMap names = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (PrimitiveType item : PrimitiveType.values()) {
            String name = item.getCommonName();
            if (name == null) continue;
            PrimitiveType.addKeys(names, item, name);
        }
        PrimitiveType.addKeys(names, INT, "int");
        PrimitiveType.addKeys(names, OBJECT, "object");
        NAMES = Collections.unmodifiableMap(names);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class DateStub {
        static final long serialVersionUID = 8851999160708854677L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private DateStub() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(DateStub.class);
        }
    }
}

