/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.core.jackson;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.openapi.impl.core.converter.ModelConverter;
import com.ibm.ws.microprofile.openapi.impl.core.converter.ModelConverterContext;
import com.ibm.ws.microprofile.openapi.impl.core.jackson.AbstractModelConverter;
import com.ibm.ws.microprofile.openapi.impl.core.jackson.JAXBAnnotationsHelper;
import com.ibm.ws.microprofile.openapi.impl.core.jackson.TypeNameResolver;
import com.ibm.ws.microprofile.openapi.impl.core.util.AnnotationsUtils;
import com.ibm.ws.microprofile.openapi.impl.core.util.Json;
import com.ibm.ws.microprofile.openapi.impl.core.util.PrimitiveType;
import com.ibm.ws.microprofile.openapi.impl.core.util.RefUtils;
import com.ibm.ws.microprofile.openapi.impl.core.util.ReflectionUtils;
import com.ibm.ws.microprofile.openapi.impl.model.ExternalDocumentationImpl;
import com.ibm.ws.microprofile.openapi.impl.model.media.DiscriminatorImpl;
import com.ibm.ws.microprofile.openapi.impl.model.media.SchemaImpl;
import com.ibm.ws.microprofile.openapi.impl.model.media.XMLImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.microprofile.openapi.annotations.ExternalDocumentation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.DiscriminatorMapping;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ModelResolver
extends AbstractModelConverter
implements ModelConverter {
    static final long serialVersionUID = -9189327080582567866L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ModelResolver(ObjectMapper mapper) {
        super(mapper);
    }

    public ObjectMapper objectMapper() {
        return this._mapper;
    }

    protected boolean shouldIgnoreClass(Type type) {
        ResolvedType rt;
        Class cls;
        return type instanceof Class ? (cls = (Class)type).getName().equals("javax.ws.rs.Response") : type instanceof ResolvedType && (rt = (ResolvedType)((Object)type)).getRawClass().equals(Class.class);
    }

    @Override
    public org.eclipse.microprofile.openapi.models.media.Schema resolve(Type type, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> next) {
        if (this.shouldIgnoreClass(type)) {
            return null;
        }
        return this.resolveProperty(this._mapper.constructType(type), context, annotations, next);
    }

    @Override
    public org.eclipse.microprofile.openapi.models.media.Schema resolveAnnotatedType(Type type, Annotated member, String elementName, ModelConverterContext context, Iterator<ModelConverter> next) {
        if (this.shouldIgnoreClass(type)) {
            return null;
        }
        return this.resolveAnnotatedType(this._mapper.constructType(type), member, elementName, context, null, null);
    }

    private Schema getSchemaAnnotation(Annotation ... annotations) {
        if (annotations == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Schema)) continue;
            return (Schema)annotation;
        }
        return null;
    }

    public org.eclipse.microprofile.openapi.models.media.Schema resolveProperty(JavaType propType, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> next) {
        org.eclipse.microprofile.openapi.models.media.Schema property = null;
        if (propType.isContainerType()) {
            JavaType keyType = propType.getKeyType();
            JavaType valueType = propType.getContentType();
            if (keyType != null && valueType != null) {
                property = new SchemaImpl().type(Schema.SchemaType.OBJECT).additionalProperties(context.resolve(valueType, new Annotation[0]));
            } else if (valueType != null) {
                org.eclipse.microprofile.openapi.models.media.Schema items = context.resolve(valueType, new Annotation[0]);
                if (annotations != null && annotations.length > 0) {
                    for (Annotation annotation : annotations) {
                        XmlElement xmlElement;
                        if (!(annotation instanceof XmlElement) || (xmlElement = (XmlElement)annotation) == null || xmlElement.name() == null || "".equals(xmlElement.name()) || "##default".equals(xmlElement.name())) continue;
                        XML xml = items.getXml() != null ? items.getXml() : new XMLImpl();
                        xml.setName(xmlElement.name());
                        items.setXml(xml);
                    }
                }
                org.eclipse.microprofile.openapi.models.media.Schema arrayProperty = new SchemaImpl().type(Schema.SchemaType.ARRAY).items(items);
                if (this._isSetType(propType.getRawClass())) {
                    arrayProperty.setUniqueItems(Boolean.valueOf(true));
                }
                property = arrayProperty;
            }
        } else {
            Schema schemaAnnotation = this.getSchemaAnnotation(annotations);
            if (schemaAnnotation != null) {
                PrimitiveType primitiveType;
                String format = schemaAnnotation.format();
                String type = schemaAnnotation.type().toString();
                if (!StringUtils.isBlank((CharSequence)schemaAnnotation.format()) && propType.getRawClass().isAssignableFrom(String.class)) {
                    type = "strings";
                }
                if (StringUtils.isNotBlank((CharSequence)type)) {
                    primitiveType = PrimitiveType.fromTypeAndFormat(type, format);
                    if (primitiveType == null) {
                        primitiveType = PrimitiveType.fromType(propType);
                    }
                    if (primitiveType != null) {
                        property = primitiveType.createProperty();
                    }
                } else {
                    primitiveType = PrimitiveType.fromType(propType);
                    if (primitiveType != null) {
                        property = primitiveType.createProperty();
                    }
                }
            } else {
                property = PrimitiveType.createProperty(propType);
            }
        }
        if (property == null) {
            if (propType.isEnumType()) {
                property = new SchemaImpl().type(Schema.SchemaType.STRING);
                this._addEnumProps(propType.getRawClass(), property);
            } else if (this._isOptionalType(propType)) {
                property = context.resolve(propType.containedType(0), null);
            } else {
                org.eclipse.microprofile.openapi.models.media.Schema mi = context.resolve(propType);
                if (mi != null) {
                    if ("object".equals(mi.getType().toString())) {
                        Object beanDesc = this._mapper.getSerializationConfig().introspect(propType);
                        String name = this._typeName(propType, (BeanDescription)beanDesc);
                        Schema schema = this.getSchemaAnnotation(annotations);
                        boolean inline = false;
                        property = new SchemaImpl((SchemaImpl)mi);
                        if (schema != null && AnnotationsUtils.hasSchemaAnnotation(schema)) {
                            inline = AnnotationsUtils.overrideSchemaFromAnnotation(property, schema);
                        }
                        if (!inline) {
                            property = new SchemaImpl().ref(RefUtils.constructRef(name));
                        }
                    } else {
                        property = mi.getRef() != null ? new SchemaImpl().ref(StringUtils.isNotEmpty((CharSequence)mi.getRef()) ? mi.getRef() : ((SchemaImpl)mi).getName()) : mi;
                    }
                }
            }
        }
        return property;
    }

    private boolean _isOptionalType(JavaType propType) {
        return Arrays.asList("com.google.common.base.Optional", "java.util.Optional").contains(propType.getRawClass().getCanonicalName());
    }

    @Override
    public org.eclipse.microprofile.openapi.models.media.Schema resolve(Type type, ModelConverterContext context, Iterator<ModelConverter> next) {
        if (this.shouldIgnoreClass(type)) {
            return null;
        }
        return this.resolve(this._mapper.constructType(type), context, next);
    }

    protected void _addEnumProps(Class<?> propClass, org.eclipse.microprofile.openapi.models.media.Schema property) {
        boolean useIndex = this._mapper.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
        boolean useToString = this._mapper.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        Class<?> enumClass = propClass;
        for (Enum en : (Enum[])enumClass.getEnumConstants()) {
            String n = useIndex ? String.valueOf(en.ordinal()) : (useToString ? en.toString() : this._intr.findEnumValue(en));
            property.addEnumeration((Object)n);
        }
    }

    public org.eclipse.microprofile.openapi.models.media.Schema resolve(JavaType type, ModelConverterContext context, Iterator<ModelConverter> next) {
        Discriminator discriminator;
        XML xml;
        if (type.isEnumType()) {
            return null;
        }
        if (PrimitiveType.fromType(type) != null) {
            return PrimitiveType.fromType(type).createProperty();
        }
        Schema directSchemaAnnotation = type.getRawClass().getAnnotation(Schema.class);
        Object beanDesc = this._mapper.getSerializationConfig().introspect(type);
        String name = this._typeName(type, (BeanDescription)beanDesc);
        if (directSchemaAnnotation != null && StringUtils.isNotEmpty((CharSequence)directSchemaAnnotation.type().toString()) && !directSchemaAnnotation.type().equals((Object)"object") && PrimitiveType.fromName(directSchemaAnnotation.type().toString()) != null) {
            org.eclipse.microprofile.openapi.models.media.Schema primitive = PrimitiveType.fromName(directSchemaAnnotation.type().toString()).createProperty();
            this.resolveSchemaMembers(primitive, ((BeanDescription)beanDesc).getClassInfo());
            XML xml2 = this.resolveXml(((BeanDescription)beanDesc).getClassInfo());
            if (xml2 != null) {
                primitive.xml(xml2);
            }
            return primitive;
        }
        Schema schemaAnnotationReference = directSchemaAnnotation;
        if (schemaAnnotationReference != null && !Void.class.equals((Object)schemaAnnotationReference.implementation())) {
            Class cls = schemaAnnotationReference.implementation();
            return context.resolve(cls);
        }
        if ("Object".equals(name)) {
            return new SchemaImpl();
        }
        org.eclipse.microprofile.openapi.models.media.Schema resolvedModel = context.resolve(type.getRawClass());
        if (resolvedModel != null && name.equals(((SchemaImpl)resolvedModel).getName())) {
            return resolvedModel;
        }
        List<Class<?>> composedSchemaReferencedClasses = this.getComposedSchemaReferencedClasses(type.getRawClass());
        boolean isComposedSchema = composedSchemaReferencedClasses != null;
        org.eclipse.microprofile.openapi.models.media.Schema model = new SchemaImpl().type(Schema.SchemaType.OBJECT);
        ((SchemaImpl)model).setName(name);
        if (!type.isContainerType()) {
            context.defineModel(name, model, type, null);
        }
        if (type.isContainerType()) {
            JavaType keyType = type.getKeyType();
            JavaType valueType = type.getContentType();
            if (keyType != null && valueType != null) {
                org.eclipse.microprofile.openapi.models.media.Schema mapModel = new SchemaImpl().type(Schema.SchemaType.OBJECT).additionalProperties(context.resolve(valueType, new Annotation[0]));
                ((SchemaImpl)mapModel).name(name);
                model = mapModel;
            } else if (valueType != null) {
                org.eclipse.microprofile.openapi.models.media.Schema items = context.resolve(valueType, new Annotation[0]);
                org.eclipse.microprofile.openapi.models.media.Schema arrayModel = new SchemaImpl().type(Schema.SchemaType.ARRAY).items(items);
                if (this._isSetType(type.getRawClass())) {
                    arrayModel.setUniqueItems(Boolean.valueOf(true));
                }
                ((SchemaImpl)arrayModel).name(name);
                model = arrayModel;
            } else {
                model = new SchemaImpl().name(name).type(Schema.SchemaType.OBJECT);
            }
        }
        if ((xml = this.resolveXml(((BeanDescription)beanDesc).getClassInfo())) != null) {
            model.xml(xml);
        }
        this.resolveSchemaMembers(model, ((BeanDescription)beanDesc).getClassInfo());
        XmlAccessorType xmlAccessorTypeAnnotation = ((BeanDescription)beanDesc).getClassAnnotations().get(XmlAccessorType.class);
        HashSet<String> propertiesToIgnore = new HashSet<String>();
        JsonIgnoreProperties ignoreProperties = ((BeanDescription)beanDesc).getClassAnnotations().get(JsonIgnoreProperties.class);
        if (ignoreProperties != null) {
            propertiesToIgnore.addAll(Arrays.asList(ignoreProperties.value()));
        }
        ArrayList<org.eclipse.microprofile.openapi.models.media.Schema> props = new ArrayList<org.eclipse.microprofile.openapi.models.media.Schema>();
        LinkedHashMap<String, org.eclipse.microprofile.openapi.models.media.Schema> modelProps = new LinkedHashMap<String, org.eclipse.microprofile.openapi.models.media.Schema>();
        for (BeanPropertyDefinition propDef : ((BeanDescription)beanDesc).findProperties()) {
            JavaType propType;
            JsonProperty pd;
            String altName;
            Member member;
            org.eclipse.microprofile.openapi.models.media.Schema property = null;
            String propName = propDef.getName();
            String[] annotations = null;
            if (propDef.getPrimaryMember() != null && (member = propDef.getPrimaryMember().getMember()) != null && (altName = member.getName()) != null) {
                int length = altName.length();
                for (String prefix : Arrays.asList("get", "is")) {
                    int offset = prefix.length();
                    if (!altName.startsWith(prefix) || length <= offset || Character.isUpperCase(altName.charAt(offset))) continue;
                    propName = altName;
                    break;
                }
            }
            PropertyMetadata md = propDef.getMetadata();
            int hasSetter = 0;
            boolean hasGetter = false;
            try {
                hasSetter = propDef.getSetter() == null ? 0 : 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.microprofile.openapi.impl.core.jackson.ModelResolver", (String)"415", (Object)this, (Object[])new Object[]{type, context, next});
                hasSetter = 1;
            }
            if (propDef.getGetter() != null && (pd = propDef.getGetter().getAnnotation(JsonProperty.class)) != null) {
                hasGetter = true;
            }
            Boolean isReadOnly = null;
            isReadOnly = hasSetter == 0 & hasGetter ? Boolean.TRUE : Boolean.FALSE;
            AnnotatedMember member2 = propDef.getPrimaryMember();
            if (member2 == null || this.ignore(member2, xmlAccessorTypeAnnotation, propName, propertiesToIgnore) || (property = this.resolveAnnotatedType(propType = member2.getType(((BeanDescription)beanDesc).bindingsForBeanType()), member2, propName, context, model, (t, a) -> {
                JsonUnwrapped uw = member2.getAnnotation(JsonUnwrapped.class);
                if (uw != null && uw.enabled()) {
                    this.handleUnwrapped(props, context.resolve((Type)t), uw.prefix(), uw.suffix());
                    return null;
                }
                return context.resolve((Type)t, (Annotation[])a);
            })) == null) continue;
            if (property.getRef() == null) {
                Boolean required = md.getRequired();
                if (required != null && !Boolean.FALSE.equals(required)) {
                    this.addRequiredItem(model, propName);
                }
                if (property.getReadOnly() == null && isReadOnly.booleanValue()) {
                    property.readOnly(isReadOnly);
                }
            }
            props.add(property);
            modelProps.put(((SchemaImpl)property).getName(), property);
        }
        for (org.eclipse.microprofile.openapi.models.media.Schema prop : props) {
            modelProps.put(((SchemaImpl)prop).getName(), prop);
        }
        if (modelProps.size() > 0) {
            model.setProperties(modelProps);
        }
        Class<?> currentType = type.getRawClass();
        context.defineModel(name, model, currentType, null);
        if (!this.resolveSubtypes(model, (BeanDescription)beanDesc, context)) {
            model.setDiscriminator(null);
        }
        if ((discriminator = this.resolveDiscriminator(type, context)) != null) {
            model.setDiscriminator(discriminator);
        }
        if (directSchemaAnnotation != null) {
            Class not;
            String ref = directSchemaAnnotation.ref();
            if (!StringUtils.isBlank((CharSequence)ref)) {
                model.ref(ref);
            }
            if (!Void.class.equals((Object)(not = directSchemaAnnotation.not()))) {
                model.not(new SchemaImpl().ref(((SchemaImpl)context.resolve(not)).getName()));
            }
            if (directSchemaAnnotation.requiredProperties() != null && directSchemaAnnotation.requiredProperties().length > 0 && StringUtils.isNotBlank((CharSequence)directSchemaAnnotation.requiredProperties()[0])) {
                for (String prop : directSchemaAnnotation.requiredProperties()) {
                    this.addRequiredItem(model, prop);
                }
            }
        }
        if (isComposedSchema) {
            Class[] allOf = directSchemaAnnotation.allOf();
            Class[] anyOf = directSchemaAnnotation.anyOf();
            Class[] oneOf = directSchemaAnnotation.oneOf();
            org.eclipse.microprofile.openapi.models.media.Schema m = model;
            List<Class> allOfFiltered = Stream.of(allOf).distinct().filter(c -> !this.shouldIgnoreClass((Type)c)).filter(c -> !c.equals(Void.class)).collect(Collectors.toList());
            allOfFiltered.forEach(c -> {
                org.eclipse.microprofile.openapi.models.media.Schema allOfRef = context.resolve((Type)c);
                org.eclipse.microprofile.openapi.models.media.Schema refSchema = new SchemaImpl().ref(((SchemaImpl)allOfRef).getName());
                if (m.getAllOf() == null || !m.getAllOf().contains(refSchema)) {
                    m.addAllOf(refSchema);
                }
                this.removeParentProperties(m, allOfRef);
            });
            List<Class> anyOfFiltered = Stream.of(anyOf).distinct().filter(c -> !this.shouldIgnoreClass((Type)c)).filter(c -> !c.equals(Void.class)).collect(Collectors.toList());
            anyOfFiltered.forEach(c -> {
                org.eclipse.microprofile.openapi.models.media.Schema anyOfRef = context.resolve((Type)c);
                m.addAnyOf(new SchemaImpl().ref(((SchemaImpl)anyOfRef).getName()));
                this.removeParentProperties(m, anyOfRef);
            });
            List<Class> oneOfFiltered = Stream.of(oneOf).distinct().filter(c -> !this.shouldIgnoreClass((Type)c)).filter(c -> !c.equals(Void.class)).collect(Collectors.toList());
            oneOfFiltered.forEach(c -> {
                org.eclipse.microprofile.openapi.models.media.Schema oneOfRef = context.resolve((Type)c);
                m.addOneOf(new SchemaImpl().ref(((SchemaImpl)oneOfRef).getName()));
                this.removeParentProperties(m, oneOfRef);
            });
        }
        return model;
    }

    protected boolean ignore(Annotated member, XmlAccessorType xmlAccessorTypeAnnotation, String propName, Set<String> propertiesToIgnore) {
        if (propertiesToIgnore.contains(propName)) {
            return true;
        }
        if (xmlAccessorTypeAnnotation == null) {
            return false;
        }
        return xmlAccessorTypeAnnotation.value().equals((Object)XmlAccessType.NONE) && !member.hasAnnotation(XmlElement.class);
    }

    private void handleUnwrapped(List<org.eclipse.microprofile.openapi.models.media.Schema> props, org.eclipse.microprofile.openapi.models.media.Schema innerModel, String prefix, String suffix) {
        if (StringUtils.isBlank((CharSequence)suffix) && StringUtils.isBlank((CharSequence)prefix)) {
            props.addAll(innerModel.getProperties().values());
        } else {
            if (prefix == null) {
                prefix = "";
            }
            if (suffix == null) {
                suffix = "";
            }
            for (org.eclipse.microprofile.openapi.models.media.Schema schema : innerModel.getProperties().values()) {
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected JavaType getInnerType(String innerType) {
        try {
            Class<?> innerClass = ReflectionUtils.loadClassByName(innerType);
            if (innerClass != null) {
                TypeFactory tf = this._mapper.getTypeFactory();
                return tf.constructType(innerClass);
            }
        }
        catch (ClassNotFoundException innerClass) {
            void e;
            FFDCFilter.processException((Throwable)innerClass, (String)"com.ibm.ws.microprofile.openapi.impl.core.jackson.ModelResolver", (String)"792", (Object)this, (Object[])new Object[]{innerType});
            e.printStackTrace();
        }
        return null;
    }

    private boolean resolveSubtypes(org.eclipse.microprofile.openapi.models.media.Schema model, BeanDescription bean, ModelConverterContext context) {
        List<NamedType> types = this._intr.findSubtypes(bean.getClassInfo());
        if (types == null) {
            return false;
        }
        this.removeSuperClassAndInterfaceSubTypes(types, bean);
        boolean count = false;
        AnnotatedElement beanClass = bean.getClassInfo().getAnnotated();
        for (NamedType subtype : types) {
            Class<?> subtypeType = subtype.getType();
            if (!((Class)beanClass).isAssignableFrom(subtypeType)) continue;
            org.eclipse.microprofile.openapi.models.media.Schema subtypeModel = context.resolve(subtypeType);
            if (((SchemaImpl)subtypeModel).getName().equals(((SchemaImpl)model).getName())) {
                ((SchemaImpl)subtypeModel).setName(this._typeNameResolver.nameForType(this._mapper.constructType(subtypeType), TypeNameResolver.Options.SKIP_API_MODEL));
            }
            org.eclipse.microprofile.openapi.models.media.Schema composedSchema = null;
            org.eclipse.microprofile.openapi.models.media.Schema refSchema = new SchemaImpl().ref(((SchemaImpl)model).getName());
            if (composedSchema.getAllOf() == null || !composedSchema.getAllOf().contains(refSchema)) {
                composedSchema.addAllOf(refSchema);
            }
            this.removeParentProperties(composedSchema, model);
            Class<?> currentType = subtype.getType();
            context.defineModel(((SchemaImpl)composedSchema).getName(), composedSchema, currentType, null);
        }
        return count;
    }

    private void removeSuperClassAndInterfaceSubTypes(List<NamedType> types, BeanDescription bean) {
        Class<?> beanClass = bean.getType().getRawClass();
        Class<?> superClass = beanClass.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            this.removeSuperSubTypes(types, superClass);
        }
        if (!types.isEmpty()) {
            Class<?>[] superInterfaces;
            for (Class<?> superInterface : superInterfaces = beanClass.getInterfaces()) {
                this.removeSuperSubTypes(types, superInterface);
                if (types.isEmpty()) break;
            }
        }
    }

    private void removeSuperSubTypes(List<NamedType> resultTypes, Class<?> superClass) {
        JavaType superType = this._mapper.constructType(superClass);
        Object superBean = this._mapper.getSerializationConfig().introspect(superType);
        List<NamedType> superTypes = this._intr.findSubtypes(((BeanDescription)superBean).getClassInfo());
        if (superTypes != null) {
            resultTypes.removeAll(superTypes);
        }
    }

    private void removeParentProperties(org.eclipse.microprofile.openapi.models.media.Schema child, org.eclipse.microprofile.openapi.models.media.Schema parent) {
        Map baseProps = parent.getProperties();
        Map subtypeProps = child.getProperties();
        if (baseProps != null && subtypeProps != null) {
            for (Map.Entry entry : baseProps.entrySet()) {
                if (!((org.eclipse.microprofile.openapi.models.media.Schema)entry.getValue()).equals(subtypeProps.get(entry.getKey()))) continue;
                subtypeProps.remove(entry.getKey());
            }
        }
        if (subtypeProps.isEmpty()) {
            child.setProperties(null);
        }
    }

    protected List<Class<?>> getComposedSchemaReferencedClasses(Class<?> clazz) {
        Schema schemaAnnotation = clazz.getAnnotation(Schema.class);
        if (schemaAnnotation != null) {
            Class[] allOf = schemaAnnotation.allOf();
            Class[] anyOf = schemaAnnotation.anyOf();
            Class[] oneOf = schemaAnnotation.oneOf();
            List<Class<?>> parentClasses = Stream.of(allOf, anyOf, oneOf).flatMap(Stream::of).distinct().filter(c -> !this.shouldIgnoreClass((Type)c)).filter(c -> !c.equals(Void.class)).collect(Collectors.toList());
            if (!parentClasses.isEmpty()) {
                return parentClasses;
            }
        }
        return null;
    }

    protected String resolveDescription(Annotated ann) {
        return this._intr.findPropertyDescription(ann);
    }

    protected String resolveTitle(Annotated a) {
        Schema schema = this.getSchemaAnnotation(a);
        if (schema != null && StringUtils.isNotBlank((CharSequence)schema.title())) {
            return schema.title();
        }
        return null;
    }

    protected String resolveFormat(Annotated a) {
        Schema schema = this.getSchemaAnnotation(a);
        if (schema != null && StringUtils.isNotBlank((CharSequence)schema.format())) {
            return schema.format();
        }
        return null;
    }

    protected String resolveDefaultValue(Annotated a) {
        Schema schema = this.getSchemaAnnotation(a);
        if (schema != null && !schema.defaultValue().isEmpty()) {
            return schema.defaultValue();
        }
        XmlElement elem = a.getAnnotation(XmlElement.class);
        if (elem != null && !elem.defaultValue().isEmpty() && !"\u0000".equals(elem.defaultValue())) {
            return elem.defaultValue();
        }
        return null;
    }

    @FFDCIgnore(value={IOException.class})
    protected Object resolveExample(Annotated a) {
        Schema schema = this.getSchemaAnnotation(a);
        if (schema != null && !schema.example().isEmpty()) {
            try {
                return Json.mapper().readTree(schema.example());
            }
            catch (IOException e) {
                return schema.example();
            }
        }
        return null;
    }

    protected Boolean resolveReadOnly(Annotated a) {
        Schema schema = this.getSchemaAnnotation(a);
        if (schema != null && schema.readOnly()) {
            return schema.readOnly();
        }
        return null;
    }

    protected Boolean resolveNullable(Annotated a) {
        Schema schema = this.getSchemaAnnotation(a);
        if (schema != null && schema.nullable()) {
            return schema.nullable();
        }
        return null;
    }

    protected BigDecimal resolveMultipleOf(Annotated a) {
        Schema schema = this.getSchemaAnnotation(a);
        if (schema != null && schema.multipleOf() != 0.0) {
            return new BigDecimal(schema.multipleOf());
        }
        return null;
    }

    protected Integer resolveMaxLength(Annotated a) {
        Schema schema = this.getSchemaAnnotation(a);
        if (schema != null && schema.maxLength() != Integer.MAX_VALUE && schema.maxLength() > 0) {
            return schema.maxLength();
        }
        return null;
    }

    protected Integer resolveMinLength(Annotated a) {
        Schema schema = this.getSchemaAnnotation(a);
        if (schema != null && schema.minLength() > 0) {
            return schema.minLength();
        }
        return null;
    }

    protected BigDecimal resolveMinimum(Annotated a) {
        Schema schema = this.getSchemaAnnotation(a);
        if (schema != null && NumberUtils.isNumber((String)schema.minimum())) {
            String filteredMinimum = schema.minimum().replaceAll(",", "");
            return new BigDecimal(filteredMinimum);
        }
        return null;
    }

    protected BigDecimal resolveMaximum(Annotated a) {
        Schema schema = this.getSchemaAnnotation(a);
        if (schema != null && NumberUtils.isNumber((String)schema.maximum())) {
            String filteredMaximum = schema.maximum().replaceAll(",", "");
            return new BigDecimal(filteredMaximum);
        }
        return null;
    }

    protected Boolean resolveExclusiveMinimum(Annotated a) {
        Schema schema = this.getSchemaAnnotation(a);
        if (schema != null && schema.exclusiveMinimum()) {
            return schema.exclusiveMinimum();
        }
        return null;
    }

    protected Boolean resolveExclusiveMaximum(Annotated a) {
        Schema schema = this.getSchemaAnnotation(a);
        if (schema != null && schema.exclusiveMaximum()) {
            return schema.exclusiveMaximum();
        }
        return null;
    }

    protected String resolvePattern(Annotated a) {
        Schema schema = this.getSchemaAnnotation(a);
        if (schema != null && StringUtils.isNotBlank((CharSequence)schema.pattern())) {
            return schema.pattern();
        }
        return null;
    }

    protected Integer resolveMinProperties(Annotated a) {
        Schema schema = this.getSchemaAnnotation(a);
        if (schema != null && schema.minProperties() > 0) {
            return schema.minProperties();
        }
        return null;
    }

    protected Integer resolveMaxProperties(Annotated a) {
        Schema schema = this.getSchemaAnnotation(a);
        if (schema != null && schema.maxProperties() > 0) {
            return schema.maxProperties();
        }
        return null;
    }

    protected List<String> resolveRequiredProperties(Annotated a) {
        Schema schema = this.getSchemaAnnotation(a);
        if (schema != null && schema.requiredProperties() != null && schema.requiredProperties().length > 0 && StringUtils.isNotBlank((CharSequence)schema.requiredProperties()[0])) {
            return Arrays.asList(schema.requiredProperties());
        }
        return null;
    }

    protected Boolean resolveWriteOnly(Annotated a) {
        Schema schema = this.getSchemaAnnotation(a);
        if (schema != null && schema.writeOnly()) {
            return schema.writeOnly();
        }
        return null;
    }

    protected org.eclipse.microprofile.openapi.models.ExternalDocumentation resolveExternalDocumentation(Annotated a) {
        Schema schema = this.getSchemaAnnotation(a);
        ExternalDocumentation externalDocumentation = a.getAnnotation(ExternalDocumentation.class);
        org.eclipse.microprofile.openapi.models.ExternalDocumentation external = this.resolveExternalDocumentation(externalDocumentation);
        if (external == null && schema != null) {
            external = this.resolveExternalDocumentation(schema.externalDocs());
        }
        return external;
    }

    protected org.eclipse.microprofile.openapi.models.ExternalDocumentation resolveExternalDocumentation(ExternalDocumentation externalDocumentation) {
        if (externalDocumentation == null) {
            return null;
        }
        boolean isEmpty = true;
        ExternalDocumentationImpl external = new ExternalDocumentationImpl();
        if (StringUtils.isNotBlank((CharSequence)externalDocumentation.description())) {
            isEmpty = false;
            external.setDescription(externalDocumentation.description());
        }
        if (StringUtils.isNotBlank((CharSequence)externalDocumentation.url())) {
            isEmpty = false;
            external.setUrl(externalDocumentation.url());
        }
        if (isEmpty) {
            return null;
        }
        return external;
    }

    protected Boolean resolveDeprecated(Annotated a) {
        Schema schema = this.getSchemaAnnotation(a);
        if (schema != null && schema.deprecated()) {
            return schema.deprecated();
        }
        return null;
    }

    protected List<String> resolveAllowableValues(Annotated a) {
        Schema schema = this.getSchemaAnnotation(a);
        if (schema != null && schema.enumeration() != null && schema.enumeration().length > 0) {
            return Arrays.asList(schema.enumeration());
        }
        return null;
    }

    protected Discriminator resolveDiscriminator(JavaType type, ModelConverterContext context) {
        JsonTypeInfo typeInfo;
        String disc;
        Schema directSchemaAnnotation = type.getRawClass().getAnnotation(Schema.class);
        String string = disc = directSchemaAnnotation == null ? "" : directSchemaAnnotation.discriminatorProperty();
        if (disc.isEmpty() && (typeInfo = type.getRawClass().getAnnotation(JsonTypeInfo.class)) != null) {
            disc = typeInfo.property();
        }
        if (!disc.isEmpty()) {
            DiscriminatorMapping[] mappings;
            Discriminator discriminator = new DiscriminatorImpl().propertyName(disc);
            if (directSchemaAnnotation != null && (mappings = directSchemaAnnotation.discriminatorMapping()) != null && mappings.length > 0) {
                for (DiscriminatorMapping mapping : mappings) {
                    discriminator.addMapping(mapping.value(), RefUtils.constructRef(((SchemaImpl)context.resolve(mapping.schema())).getName()));
                }
            }
            return discriminator;
        }
        return null;
    }

    protected XML resolveXml(Annotated a) {
        XmlRootElement rootAnnotation = a.getAnnotation(XmlRootElement.class);
        if (rootAnnotation != null && !"".equals(rootAnnotation.name()) && !"##default".equals(rootAnnotation.name())) {
            XML xml = new XMLImpl().name(rootAnnotation.name());
            if (rootAnnotation.namespace() != null && !"".equals(rootAnnotation.namespace()) && !"##default".equals(rootAnnotation.namespace())) {
                xml.namespace(rootAnnotation.namespace());
            }
            return xml;
        }
        return null;
    }

    protected void resolveSchemaMembers(org.eclipse.microprofile.openapi.models.media.Schema schema, Annotated a) {
        List<String> allowableValues;
        Boolean deprecated;
        org.eclipse.microprofile.openapi.models.ExternalDocumentation externalDocs;
        Boolean writeOnly;
        List<String> requiredProperties;
        Integer maxProperties;
        Integer minProperties;
        String pattern;
        Boolean exclusiveMaximum;
        Boolean exclusiveMinimum;
        BigDecimal maximum;
        BigDecimal minimum;
        Integer minLength;
        Integer maxLength;
        BigDecimal multipleOf;
        Boolean nullable;
        Boolean readOnly;
        Object example;
        String defaultValue;
        String format;
        String title;
        String description = this.resolveDescription(a);
        if (StringUtils.isNotBlank((CharSequence)description)) {
            schema.description(description);
        }
        if (StringUtils.isNotBlank((CharSequence)(title = this.resolveTitle(a)))) {
            schema.title(title);
        }
        if (StringUtils.isNotBlank((CharSequence)(format = this.resolveFormat(a))) && StringUtils.isBlank((CharSequence)schema.getFormat())) {
            schema.format(format);
        }
        if (StringUtils.isNotBlank((CharSequence)(defaultValue = this.resolveDefaultValue(a)))) {
            schema.setDefaultValue((Object)defaultValue);
        }
        if ((example = this.resolveExample(a)) != null) {
            schema.example(example);
        }
        if ((readOnly = this.resolveReadOnly(a)) != null) {
            schema.readOnly(readOnly);
        }
        if ((nullable = this.resolveNullable(a)) != null) {
            schema.nullable(nullable);
        }
        if ((multipleOf = this.resolveMultipleOf(a)) != null) {
            schema.multipleOf(multipleOf);
        }
        if ((maxLength = this.resolveMaxLength(a)) != null) {
            schema.maxLength(maxLength);
        }
        if ((minLength = this.resolveMinLength(a)) != null) {
            schema.minLength(minLength);
        }
        if ((minimum = this.resolveMinimum(a)) != null) {
            schema.minimum(minimum);
        }
        if ((maximum = this.resolveMaximum(a)) != null) {
            schema.maximum(maximum);
        }
        if ((exclusiveMinimum = this.resolveExclusiveMinimum(a)) != null) {
            schema.exclusiveMinimum(exclusiveMinimum);
        }
        if ((exclusiveMaximum = this.resolveExclusiveMaximum(a)) != null) {
            schema.exclusiveMaximum(exclusiveMaximum);
        }
        if (StringUtils.isNotBlank((CharSequence)(pattern = this.resolvePattern(a)))) {
            schema.pattern(pattern);
        }
        if ((minProperties = this.resolveMinProperties(a)) != null) {
            schema.minProperties(minProperties);
        }
        if ((maxProperties = this.resolveMaxProperties(a)) != null) {
            schema.maxProperties(maxProperties);
        }
        if ((requiredProperties = this.resolveRequiredProperties(a)) != null) {
            for (String prop : requiredProperties) {
                this.addRequiredItem(schema, prop);
            }
        }
        if ((writeOnly = this.resolveWriteOnly(a)) != null) {
            schema.writeOnly(writeOnly);
        }
        if ((externalDocs = this.resolveExternalDocumentation(a)) != null) {
            schema.externalDocs(externalDocs);
        }
        if ((deprecated = this.resolveDeprecated(a)) != null) {
            schema.deprecated(deprecated);
        }
        if ((allowableValues = this.resolveAllowableValues(a)) != null) {
            for (String prop : allowableValues) {
                schema.addEnumeration((Object)prop);
            }
        }
    }

    protected org.eclipse.microprofile.openapi.models.media.Schema resolveAnnotatedType(JavaType type, Annotated member, String elementName, ModelConverterContext context, org.eclipse.microprofile.openapi.models.media.Schema parent, BiFunction<JavaType, Annotation[], org.eclipse.microprofile.openapi.models.media.Schema> jsonUnwrappedHandler) {
        String name = elementName;
        org.eclipse.microprofile.openapi.models.media.Schema property = null;
        Annotation[] annotations = null;
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        for (Annotation a : member.annotations()) {
            annotationList.add(a);
        }
        annotations = annotationList.toArray(new Annotation[annotationList.size()]);
        Schema mp = member.getAnnotation(Schema.class);
        if (mp != null && !mp.name().isEmpty()) {
            name = mp.name();
        }
        if (mp != null && !Void.class.equals((Object)mp.implementation())) {
            Class cls = mp.implementation();
            org.eclipse.microprofile.openapi.models.media.Schema primitiveProperty = PrimitiveType.createProperty(cls);
            property = primitiveProperty != null ? primitiveProperty : context.resolve(cls, annotations);
        }
        if (property == null) {
            if (mp != null && StringUtils.isNotEmpty((CharSequence)mp.ref())) {
                property = new SchemaImpl().ref(mp.ref());
            }
            if (property == null) {
                PrimitiveType primitiveType;
                if (mp != null && StringUtils.isNotEmpty((CharSequence)mp.type().toString())) {
                    primitiveType = PrimitiveType.fromTypeAndFormat(mp.type().toString(), mp.format());
                    if (primitiveType == null) {
                        primitiveType = PrimitiveType.fromType(type);
                    }
                    if (primitiveType != null) {
                        property = primitiveType.createProperty();
                    }
                } else {
                    primitiveType = PrimitiveType.fromType(type);
                    if (primitiveType != null) {
                        property = primitiveType.createProperty();
                    }
                }
                if (property == null) {
                    property = jsonUnwrappedHandler != null ? jsonUnwrappedHandler.apply(type, annotations) : context.resolve(type, annotations);
                }
            }
        }
        if (property != null) {
            ((SchemaImpl)property).setName(name);
            if (property.getRef() == null) {
                this.resolveSchemaMembers(property, member);
                JAXBAnnotationsHelper.apply(member, property);
            }
        }
        if (mp != null && mp.type() == SchemaType.ARRAY) {
            SchemaImpl arraySchema = (SchemaImpl)AnnotationsUtils.getSchemaFromAnnotation(mp, null).get();
            arraySchema.setItems(property);
            arraySchema.setName(name);
            property = arraySchema;
        }
        return property;
    }

    protected Schema getSchemaAnnotation(Annotated a) {
        return AnnotationsUtils.getSchemaAnnotation(a);
    }

    private void addRequiredItem(org.eclipse.microprofile.openapi.models.media.Schema model, String propName) {
        if (model == null || propName == null || StringUtils.isBlank((CharSequence)propName)) {
            return;
        }
        if (model.getRequired() == null || model.getRequired().isEmpty()) {
            model.addRequired(propName);
        }
        if (model.getRequired().stream().noneMatch(s -> propName.equals(s))) {
            model.addRequired(propName);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ModelResolver.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static abstract class GeneratorWrapper
    extends Enum<GeneratorWrapper> {
        public static final /* enum */ GeneratorWrapper PROPERTY;
        public static final /* enum */ GeneratorWrapper INT;
        public static final /* enum */ GeneratorWrapper UUID;
        public static final /* enum */ GeneratorWrapper NONE;
        private final Class<? extends ObjectIdGenerator> generator;
        private static final /* synthetic */ GeneratorWrapper[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static GeneratorWrapper[] values() {
            return (GeneratorWrapper[])$VALUES.clone();
        }

        public static GeneratorWrapper valueOf(String name) {
            return Enum.valueOf(GeneratorWrapper.class, name);
        }

        private GeneratorWrapper(Class<? extends ObjectIdGenerator> generator) {
            this.generator = generator;
        }

        protected abstract org.eclipse.microprofile.openapi.models.media.Schema processAsProperty(String var1, JavaType var2, ModelConverterContext var3, ObjectMapper var4);

        protected abstract org.eclipse.microprofile.openapi.models.media.Schema processAsId(String var1, JavaType var2, ModelConverterContext var3, ObjectMapper var4);

        public static org.eclipse.microprofile.openapi.models.media.Schema processJsonIdentity(JavaType type, ModelConverterContext context, ObjectMapper mapper, JsonIdentityInfo identityInfo, JsonIdentityReference identityReference) {
            GeneratorWrapper wrapper;
            GeneratorWrapper generatorWrapper = wrapper = identityInfo != null ? GeneratorWrapper.getWrapper(identityInfo.generator()) : null;
            if (wrapper == null) {
                return null;
            }
            if (identityReference != null && identityReference.alwaysAsId()) {
                return wrapper.processAsId(identityInfo.property(), type, context, mapper);
            }
            return wrapper.processAsProperty(identityInfo.property(), type, context, mapper);
        }

        private static GeneratorWrapper getWrapper(Class<?> generator) {
            for (GeneratorWrapper value : GeneratorWrapper.values()) {
                if (!value.generator.isAssignableFrom(generator)) continue;
                return value;
            }
            return null;
        }

        private static org.eclipse.microprofile.openapi.models.media.Schema process(org.eclipse.microprofile.openapi.models.media.Schema id, String propertyName, JavaType type, ModelConverterContext context) {
            org.eclipse.microprofile.openapi.models.media.Schema model;
            org.eclipse.microprofile.openapi.models.media.Schema mi = model = context.resolve(type);
            mi.getProperties().put(propertyName, id);
            return new SchemaImpl().ref(StringUtils.isNotEmpty((CharSequence)mi.getRef()) ? mi.getRef() : ((SchemaImpl)mi).getName());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(GeneratorWrapper.class);
            PROPERTY = new GeneratorWrapper(ObjectIdGenerators.PropertyGenerator.class){
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                protected org.eclipse.microprofile.openapi.models.media.Schema processAsProperty(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                    return null;
                }

                @Override
                protected org.eclipse.microprofile.openapi.models.media.Schema processAsId(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                    Object beanDesc = mapper.getSerializationConfig().introspect(type);
                    for (BeanPropertyDefinition def : ((BeanDescription)beanDesc).findProperties()) {
                        String name = def.getName();
                        if (name == null || !name.equals(propertyName)) continue;
                        AnnotatedMember propMember = def.getPrimaryMember();
                        JavaType propType = propMember.getType(((BeanDescription)beanDesc).bindingsForBeanType());
                        if (PrimitiveType.fromType(propType) != null) {
                            return PrimitiveType.createProperty(propType);
                        }
                        ArrayList<Annotation> anns = new ArrayList<Annotation>();
                        for (Annotation annotation : propMember.annotations()) {
                            anns.add(annotation);
                        }
                        Annotation[] annotations = new Annotation[anns.size()];
                        annotations = anns.toArray(annotations);
                        return context.resolve(propType, annotations);
                    }
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            };
            INT = new GeneratorWrapper(ObjectIdGenerators.IntSequenceGenerator.class){
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                protected org.eclipse.microprofile.openapi.models.media.Schema processAsProperty(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                    org.eclipse.microprofile.openapi.models.media.Schema id = new SchemaImpl().type(Schema.SchemaType.INTEGER);
                    return GeneratorWrapper.process(id, propertyName, type, context);
                }

                @Override
                protected org.eclipse.microprofile.openapi.models.media.Schema processAsId(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                    return new SchemaImpl().type(Schema.SchemaType.INTEGER);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            };
            UUID = new GeneratorWrapper(ObjectIdGenerators.UUIDGenerator.class){
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                protected org.eclipse.microprofile.openapi.models.media.Schema processAsProperty(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                    org.eclipse.microprofile.openapi.models.media.Schema id = new SchemaImpl().type(Schema.SchemaType.STRING).format("uuid");
                    return GeneratorWrapper.process(id, propertyName, type, context);
                }

                @Override
                protected org.eclipse.microprofile.openapi.models.media.Schema processAsId(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                    return new SchemaImpl().type(Schema.SchemaType.STRING).format("uuid");
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class);
                }
            };
            NONE = new GeneratorWrapper(ObjectIdGenerators.None.class){
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                protected org.eclipse.microprofile.openapi.models.media.Schema processAsProperty(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                    return null;
                }

                @Override
                protected org.eclipse.microprofile.openapi.models.media.Schema processAsId(String propertyName, JavaType type, ModelConverterContext context, ObjectMapper mapper) {
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(4.class);
                }
            };
            $VALUES = new GeneratorWrapper[]{PROPERTY, INT, UUID, NONE};
        }
    }
}

