/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ConfigProcessor {
    private static final TraceComponent tc = Tr.register(ConfigProcessor.class);
    private static final String VALIDATION = "mp.openapi.extensions.liberty.validation";
    private static final boolean VALIDATION_DEFAULT_VALUE = true;
    private static final String FILE_POLLING_INTERVAL = "mp.openapi.extensions.liberty.file.polling.interval";
    private static final int FILE_POLLING_INTERVAL_DEFAULT_VALUE = 2;
    private String modelReaderClassName;
    private String openAPIFilterClassName;
    private boolean scanDisabled;
    private boolean validation;
    private int pollingInterval;
    private Set<String> classesToScan;
    private Set<String> classesToExclude;
    private Set<String> packagesToScan;
    private Set<String> packagesToExclude;
    private Set<String> servers;
    private Map<String, Set<String>> pathsServers;
    private Map<String, Set<String>> operationsServers;
    private final Config config;
    static final long serialVersionUID = -4709018288802997736L;

    /*
     * WARNING - void declaration
     */
    public ConfigProcessor(ClassLoader appClassloader) {
        block2: {
            this.modelReaderClassName = null;
            this.openAPIFilterClassName = null;
            this.scanDisabled = false;
            this.validation = true;
            this.pollingInterval = 2;
            this.classesToScan = null;
            this.classesToExclude = null;
            this.packagesToScan = null;
            this.packagesToExclude = null;
            this.servers = null;
            this.pathsServers = null;
            this.operationsServers = null;
            this.config = ConfigProvider.getConfig((ClassLoader)appClassloader);
            try {
                this.modelReaderClassName = this.config.getOptionalValue("mp.openapi.model.reader", String.class).orElse(null);
                this.scanDisabled = this.config.getOptionalValue("mp.openapi.scan.disable", Boolean.class).orElse(false);
                this.openAPIFilterClassName = this.config.getOptionalValue("mp.openapi.filter", String.class).orElse(null);
                this.validation = this.config.getOptionalValue(VALIDATION, Boolean.class).orElse(true);
                this.pollingInterval = this.config.getOptionalValue(FILE_POLLING_INTERVAL, Integer.class).filter(v -> v >= 0).orElse(2);
                this.classesToScan = this.getConfigPropAsSet("mp.openapi.scan.classes");
                this.packagesToScan = this.getConfigPropAsSet("mp.openapi.scan.packages");
                this.classesToExclude = this.getConfigPropAsSet("mp.openapi.scan.exclude.classes");
                this.packagesToExclude = this.getConfigPropAsSet("mp.openapi.scan.exclude.packages");
                this.retrieveServers();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                void e;
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.microprofile.openapi.ConfigProcessor", (String)"76", (Object)this, (Object[])new Object[]{appClassloader});
                if (!OpenAPIUtils.isEventEnabled(tc)) break block2;
                Tr.event((TraceComponent)tc, (String)("Failed to read config: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    public String getModelReaderClassName() {
        return this.modelReaderClassName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ConfigProcessor : {\n");
        builder.append("mp.openapi.model.reader=" + this.modelReaderClassName + "\n");
        builder.append("mp.openapi.filter=" + this.openAPIFilterClassName + "\n");
        builder.append("mp.openapi.scan.disable=" + this.scanDisabled + "\n");
        builder.append("mp.openapi.extensions.liberty.validation=" + this.validation + "\n");
        builder.append("mp.openapi.extensions.liberty.file.polling.interval=" + this.pollingInterval + "\n");
        builder.append("mp.openapi.scan.classes=" + this.classesToScan + "\n");
        builder.append("mp.openapi.scan.packages=" + this.packagesToScan + "\n");
        builder.append("mp.openapi.scan.exclude.classes=" + this.classesToExclude + "\n");
        builder.append("mp.openapi.scan.exclude.packages=" + this.packagesToExclude + "\n");
        builder.append("mp.openapi.servers=" + this.servers + "\n");
        builder.append("mp.openapi.servers.path.=" + this.pathsServers + "\n");
        builder.append("mp.openapi.servers.operation.=" + this.operationsServers + "\n");
        builder.append("}\n");
        return builder.toString();
    }

    public boolean isScanDisabled() {
        return this.scanDisabled;
    }

    public String getOpenAPIFilterClassName() {
        return this.openAPIFilterClassName;
    }

    public boolean isValidating() {
        return this.validation;
    }

    public int getFilePollingInterval() {
        return this.pollingInterval;
    }

    private Set<String> getConfigPropAsSet(String configProperty) {
        String[] configValues = this.config.getOptionalValue(configProperty, String[].class).orElse(null);
        if (configValues == null || configValues.length == 0) {
            return null;
        }
        HashSet<String> configPropSet = new HashSet<String>();
        for (String s : configValues) {
            configPropSet.add(s);
        }
        return configPropSet;
    }

    private void retrieveServers() {
        this.servers = this.getConfigPropAsSet("mp.openapi.servers");
        for (String propertyName : this.config.getPropertyNames()) {
            String path;
            Set<String> servers;
            if (propertyName.startsWith("mp.openapi.servers.path.")) {
                servers = this.getConfigPropAsSet(propertyName);
                if (servers == null || !StringUtils.isNotBlank((CharSequence)(path = propertyName.substring("mp.openapi.servers.path.".length())))) continue;
                if (this.pathsServers == null) {
                    this.pathsServers = new HashMap<String, Set<String>>();
                }
                this.pathsServers.put(path, servers);
                continue;
            }
            if (!propertyName.startsWith("mp.openapi.servers.operation.") || (servers = this.getConfigPropAsSet(propertyName)) == null || !StringUtils.isNotBlank((CharSequence)(path = propertyName.substring("mp.openapi.servers.operation.".length())))) continue;
            if (this.operationsServers == null) {
                this.operationsServers = new HashMap<String, Set<String>>();
            }
            this.operationsServers.put(path, servers);
        }
    }

    public Set<String> getClassesToScan() {
        return this.classesToScan;
    }

    public Set<String> getClassesToExclude() {
        return this.classesToExclude;
    }

    public Set<String> getPackagesToScan() {
        return this.packagesToScan;
    }

    public Set<String> getPackagesToExclude() {
        return this.packagesToExclude;
    }

    public Set<String> getServers() {
        return this.servers;
    }

    public Map<String, Set<String>> getPathsServers() {
        return this.pathsServers;
    }

    public Map<String, Set<String>> getOperationsServers() {
        return this.operationsServers;
    }
}

