/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jaas.common.modules;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class CommonLoginModule
implements LoginModule {
    public CallbackHandler callbackHandler;
    public Subject subject;
    public Map<String, Object> sharedState;
    public Map<String, ?> options;
    public Subject temporarySubject;
    static final long serialVersionUID = -8873301121271047884L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.callbackHandler = callbackHandler;
        this.subject = subject;
        this.sharedState = sharedState;
        this.options = options;
    }

    @Override
    public boolean commit() throws LoginException {
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.cleanup();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.cleanup();
        return true;
    }

    private void cleanup() {
        this.cleanUpSubject();
        if (this.subject != null && !this.subject.isReadOnly()) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){
                static final long serialVersionUID = -8939944198056458774L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() {
                    Set<Principal> principals = CommonLoginModule.this.subject.getPrincipals();
                    principals.removeAll(CommonLoginModule.this.subject.getPrincipals());
                    Set<Object> publicCredentials = CommonLoginModule.this.subject.getPublicCredentials();
                    publicCredentials.removeAll(CommonLoginModule.this.subject.getPublicCredentials());
                    Set<Object> privateCredentials = CommonLoginModule.this.subject.getPrivateCredentials();
                    privateCredentials.removeAll(CommonLoginModule.this.subject.getPrivateCredentials());
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
            this.subject = null;
        }
    }

    public void cleanUpSubject() {
        if (this.temporarySubject != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){
                static final long serialVersionUID = 1521170073680014210L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() {
                    CommonLoginModule.this.removeSubjectPrincipals();
                    CommonLoginModule.this.removeSubjectPublicCredentials();
                    CommonLoginModule.this.removeSubjectPrivateCredentials();
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            });
        }
        this.temporarySubject = null;
    }

    private void removeSubjectPrincipals() {
        Set<Principal> principals = this.subject.getPrincipals();
        principals.removeAll(this.temporarySubject.getPrincipals());
        Object toRemove = this.sharedState.get("WSPrincipal");
        if (toRemove != null) {
            principals.remove(toRemove);
        }
    }

    private void removeSubjectPublicCredentials() {
        Set<Object> publicCredentials = this.subject.getPublicCredentials();
        publicCredentials.removeAll(this.temporarySubject.getPublicCredentials());
        Object toRemove = this.sharedState.get("WSCredential");
        if (toRemove != null) {
            publicCredentials.remove(toRemove);
        }
    }

    private void removeSubjectPrivateCredentials() {
        Set<Object> privateCredentials = this.subject.getPrivateCredentials();
        privateCredentials.removeAll(this.temporarySubject.getPrivateCredentials());
        Object toRemove = this.sharedState.get("com.ibm.wsspi.security.token.wsSingleSignonToken");
        if (toRemove != null) {
            privateCredentials.remove(toRemove);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setUpSubject(final Subject authSubj) throws LoginException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = 4262646482875537837L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws Exception {
                    CommonLoginModule.this.subject.getPrincipals().addAll(authSubj.getPrincipals());
                    CommonLoginModule.this.subject.getPublicCredentials().addAll(authSubj.getPublicCredentials());
                    CommonLoginModule.this.subject.getPrivateCredentials().addAll(authSubj.getPrivateCredentials());
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.jaas.common.modules.CommonLoginModule", (String)"144", (Object)this, (Object[])new Object[]{authSubj});
            throw new LoginException(e.getLocalizedMessage());
        }
    }

    protected void setAlreadyProcessed() {
        if (this.sharedState != null) {
            this.sharedState.put("AlreadyProcessed ", "true");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(CommonLoginModule.class);
    }
}

