/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jaas.common.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jaas.common.JAASLoginContextEntry;
import com.ibm.ws.security.jaas.common.JAASLoginModuleConfig;
import com.ibm.ws.security.jaas.common.internal.EntryConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"com.ibm.ws.security.authentication.internal.jaas.jaasLoginContextEntry"}, property={"service.vendor=IBM"})
public class JAASLoginContextEntryImpl
implements JAASLoginContextEntry {
    static final String KEY_SERVICE_PID = "service.pid";
    private EntryConfig config;
    private final Map<String, JAASLoginModuleConfig> loginModuleMap = new HashMap<String, JAASLoginModuleConfig>();
    private List<JAASLoginModuleConfig> loginModules = Collections.emptyList();
    static final long serialVersionUID = -5287328922093770925L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    protected void activate(EntryConfig config) {
        this.config = config;
        this.loginModules = new ArrayList<JAASLoginModuleConfig>(config.loginModuleRef().length);
        for (String pid : config.loginModuleRef()) {
            JAASLoginModuleConfig loginModule = this.loginModuleMap.get(pid);
            if (loginModule == null) {
                throw new IllegalStateException("missing login module for pid " + pid);
            }
            this.loginModules.add(loginModule);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    protected void setJaasLoginModuleConfig(JAASLoginModuleConfig lmc, Map<String, Object> props) {
        String pid = (String)props.get(KEY_SERVICE_PID);
        this.loginModuleMap.put(pid, lmc);
    }

    @Override
    public String getId() {
        return this.config.id();
    }

    @Override
    public String getEntryName() {
        return this.config.name();
    }

    @Override
    public List<JAASLoginModuleConfig> getLoginModules() {
        return this.loginModules;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JAASLoginContextEntryImpl.class);
    }
}

