/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.requestContext;

import com.ibm.ws.request.probe.RequestId;
import com.ibm.ws.request.probe.RequestIdGeneratorPUID;
import com.ibm.ws.request.probe.RequestProbeService;
import com.ibm.wsspi.requestContext.Event;
import com.ibm.wsspi.requestContext.EventStackFormatter;
import java.util.Map;

public class RequestContext {
    private int requestContextIndex = -1;
    private final long threadId;
    private final RequestId requestId = idgen.getNextRequestId();
    private volatile Event rootEvent;
    private Event currentEvent;
    private volatile int state = -1;
    private int eventCount = -1;
    private static final RequestIdGeneratorPUID idgen = new RequestIdGeneratorPUID();
    public static final int STATE_RUNNING = 10;
    public static final int STATE_TOO_LONG = 11;
    public static final int STATE_FINISHED = 100;
    public static final int MAX_EVENTS = 500;

    public RequestContext() {
        RequestProbeService.requestIDExtension.setValue(this.requestId.getId());
        this.threadId = Thread.currentThread().getId();
        this.eventCount = 0;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public Event getRootEvent() {
        return this.rootEvent;
    }

    public void setRootEvent(Event event) {
        this.rootEvent = event;
    }

    public Event getCurrentEvent() {
        return this.currentEvent;
    }

    public void setCurrentEvent(Event currentEvent) {
        this.currentEvent = currentEvent;
    }

    public int getRequestContextIndex() {
        return this.requestContextIndex;
    }

    public void setRequestContextIndex(int requestContextIndex) {
        this.requestContextIndex = requestContextIndex;
    }

    public int getRequestState() {
        return this.state;
    }

    public void setRequestState(int state) {
        this.state = state;
    }

    public void incrementEventCount() {
        ++this.eventCount;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public static String dumpTree(Event event, boolean includeContextInfo) {
        new EventStackFormatter();
        return EventStackFormatter.getStackFormat(event, includeContextInfo).toString();
    }

    public long getThreadId() {
        return this.threadId;
    }

    public StringBuffer getStackTrace() {
        Map<Thread, StackTraceElement[]> activeThreadStackTraces = Thread.getAllStackTraces();
        StringBuffer requestTheadStackStr = new StringBuffer();
        for (Map.Entry<Thread, StackTraceElement[]> entry : activeThreadStackTraces.entrySet()) {
            if (entry.getKey().getId() != this.threadId) continue;
            for (StackTraceElement stackTraceElement : entry.getValue()) {
                requestTheadStackStr.append("\t at " + stackTraceElement + "\n");
            }
        }
        return requestTheadStackStr;
    }

    public String toString() {
        return "RequestContext [threadId=" + this.threadId + ", requestId=" + this.requestId + ", state=" + this.state + "]";
    }
}

