/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.jta.impl.FailureScopeController;
import com.ibm.tx.jta.impl.RecoveryWrapper;
import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import com.ibm.ws.recoverylog.spi.WriteOperationFailedException;
import java.io.NotSerializableException;
import javax.transaction.xa.Xid;

public abstract class PartnerLogData {
    private static final TraceComponent tc = Tr.register(PartnerLogData.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    protected byte[] _serializedLogData;
    protected RecoveryWrapper _logData;
    protected long _recoveryId;
    protected int _index;
    protected boolean _recovered;
    public boolean _terminating;
    private boolean _logEarly;
    protected boolean _loggedToDisk;
    protected FailureScopeController _fsc;
    private RecoveryLog _partnerLog;
    protected int _recoveredInUseCount = 1;
    protected int _sectionId;

    public PartnerLogData(RecoveryWrapper logData, FailureScopeController fsc) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"PartnerLogData", (Object)new Object[]{logData, fsc});
        }
        this._logData = logData;
        this._recovered = true;
        this._fsc = fsc;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"PartnerLogData");
        }
    }

    public PartnerLogData(byte[] serializedLogData, RecoveryWrapper logData, long id, RecoveryLog partnerLog) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"PartnerLogData", (Object)new Object[]{id, logData, partnerLog});
        }
        this._serializedLogData = serializedLogData;
        this._logData = logData;
        this._recoveryId = id;
        this._loggedToDisk = true;
        this._partnerLog = partnerLog;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"PartnerLogData");
        }
    }

    public synchronized void logRecoveryEntry() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logRecoveryEntry", (Object)this);
        }
        if (!this._loggedToDisk) {
            if (this._terminating) {
                Tr.warning((TraceComponent)tc, (String)"WTRN0084_RESOURCE_ENDING");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"logRecoveryEntry", (Object)"Terminating");
                }
                throw new IllegalStateException();
            }
            if (this._serializedLogData == null) {
                Tr.warning((TraceComponent)tc, (String)"WTRN0039_SERIALIZE_FAILED");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"logRecoveryEntry", (Object)"NotSerializable");
                }
                throw new NotSerializableException("XAResource recovery information not serializable");
            }
            try {
                this.preLogData();
                this.logData(this._sectionId);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.Transaction.JTA.XARecoveryData.logRecoveryEntry", (String)"284", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"logRecoveryEntry", (Object)e);
                }
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logRecoveryEntry");
        }
    }

    protected void preLogData() throws Exception {
    }

    protected void postLogData(RecoverableUnit ru) throws Exception {
    }

    protected void logData(int sectionId) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logData", (Object)sectionId);
        }
        if (this._partnerLog == null) {
            this._partnerLog = this._fsc.getPartnerLog();
        }
        if (this._partnerLog != null) {
            RecoverableUnit ru = null;
            try {
                if (this._recoveryId == 0L) {
                    ru = this._partnerLog.createRecoverableUnit();
                    if (ru == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"logData", (Object)"RecoverableUnit returned from createRecoverableUnit was null - throwing InternalLogException");
                        }
                        throw new InternalLogException(null);
                    }
                    this._recoveryId = ru.identity();
                } else {
                    ru = this._partnerLog.lookupRecoverableUnit(this._recoveryId);
                    if (ru == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"logData", (Object)("RecoverableUnit returned from lookupRecoverableUnit for " + this._recoveryId + " was null - throwing InternalLogException"));
                        }
                        throw new InternalLogException(null);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"logData", (Object)("section=" + sectionId + ", recoveryId=" + this._recoveryId));
                }
                RecoverableUnitSection section = ru.createSection(sectionId, true);
                section.addData(this._serializedLogData);
                this.postLogData(ru);
                ru.forceSections();
                this._loggedToDisk = true;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.Transaction.JTA.PartnerLogData.logData", (String)"285", (Object)this);
                try {
                    if (ru != null) {
                        this._partnerLog.removeRecoverableUnit(ru.identity());
                        this._recoveryId = 0L;
                    }
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.Transaction.JTA.PartnerLogData.logData", (String)"156", (Object)this);
                }
                if (e instanceof WriteOperationFailedException) {
                    Tr.error((TraceComponent)tc, (String)"WTRN0066_LOG_WRITE_ERROR", (Object)e);
                } else {
                    Tr.error((TraceComponent)tc, (String)"WTRN0000_ERR_INT_ERROR", (Object)new Object[]{"logData", "com.ibm.ws.Transaction.JTA.PartnerLogData", e});
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"logData", (Object)e);
                }
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logData");
        }
    }

    public void setSerializedLogData(byte[] data) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setSerializedLogData", (Object)Util.toHexString(data));
        }
        this._serializedLogData = data;
    }

    public RecoveryWrapper getLogData() {
        return this._logData;
    }

    public long getRecoveryId() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getRecoveryId", (Object)this._recoveryId);
        }
        return this._recoveryId;
    }

    public void setRecovered(boolean flag) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setRecovered", (Object)new Object[]{"From " + this._recovered + " to " + flag, this});
        }
        this._recovered = flag;
    }

    public boolean getRecovered() {
        return this._recovered;
    }

    public synchronized void terminate() {
        this._terminating = true;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"terminate", (Object)this);
        }
    }

    public String toString() {
        String data = this._logData == null ? "<null>" : this._logData.toString();
        return "index=" + this._index + ", recoveryID=" + this._recoveryId + ", recovered=" + this._recovered + ", terminating=" + this._terminating + ", loggedToDisk=" + this._loggedToDisk + ", data=" + data + ", class=" + this.getClass().getName();
    }

    public void setIndex(int index) {
        this._index = index;
    }

    public int getIndex() {
        return this._index;
    }

    public void setLogEarly(boolean logEarly) {
        this._logEarly = logEarly;
    }

    public boolean getLogEarly() {
        return this._logEarly;
    }

    public synchronized void incrementCount() {
        ++this._recoveredInUseCount;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"incrementCount", (Object)new Object[]{this._recoveryId, this._recoveredInUseCount});
        }
    }

    public synchronized int decrementCount() {
        --this._recoveredInUseCount;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"decrementCount", (Object)new Object[]{this._recoveryId, this._recoveredInUseCount});
        }
        return this._recoveredInUseCount;
    }

    public synchronized boolean clearIfNotInUse() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"clearIfNotInUse", (Object)new Object[]{this._recoveryId, this._recoveredInUseCount});
        }
        boolean cleared = false;
        if (this._loggedToDisk && this._recoveredInUseCount == 0) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("removing recoverable unit " + this._recoveryId));
                }
                this._partnerLog.removeRecoverableUnit(this._recoveryId);
                this._loggedToDisk = false;
                this._recoveryId = 0L;
                cleared = true;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.Transaction.JTA.PartnerLogData.clearIfNotInUse", (String)"218", (Object)this);
                if (e instanceof WriteOperationFailedException) {
                    Tr.error((TraceComponent)tc, (String)"WTRN0066_LOG_WRITE_ERROR", (Object)e);
                }
                Tr.error((TraceComponent)tc, (String)"WTRN0000_ERR_INT_ERROR", (Object)new Object[]{"clearIfNotInUse", "com.ibm.ws.Transaction.JTA.PartnerLogData", e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clearIfNotInUse", (Object)cleared);
        }
        return cleared;
    }

    public void setFailureScopeController(FailureScopeController fsc) {
        this._fsc = fsc;
    }

    public boolean recover(ClassLoader cl, Xid[] xids, byte[] failedStoken, byte[] cruuid, int restartEpoch) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"recover", (Object)new Object[]{this, cl, xids, failedStoken, cruuid, restartEpoch});
        }
        this.decrementCount();
        return true;
    }
}

