/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.impl.async;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.faulttolerance.impl.ExecutionContextImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class QueuedFuture<R>
implements Future<R>,
Callable<Future<R>> {
    private static final TraceComponent tc = Tr.register(QueuedFuture.class);
    private final Callable<Future<R>> innerTask;
    private Future<Future<R>> outerFuture;
    private final ThreadContextDescriptor threadContext;
    private final ExecutionContextImpl executionContext;
    private boolean cancelled = false;
    private boolean internallyCancelled = false;
    static final long serialVersionUID = 7360805805823138679L;

    public QueuedFuture(Callable<Future<R>> innerTask, ExecutionContextImpl executionContext, ThreadContextDescriptor threadContext) {
        this.innerTask = innerTask;
        this.executionContext = executionContext;
        this.threadContext = threadContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        QueuedFuture queuedFuture = this;
        synchronized (queuedFuture) {
            boolean outerCancelled;
            if (this.cancelled) {
                return false;
            }
            if (this.internallyCancelled) {
                this.cancelled = true;
                return true;
            }
            this.cancelled = outerCancelled = this.getOuterFuture().cancel(mayInterruptIfRunning);
            this.internallyCancelled = outerCancelled;
            return outerCancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalCancel() {
        QueuedFuture queuedFuture = this;
        synchronized (queuedFuture) {
            if (!this.internallyCancelled) {
                boolean outerCancelled;
                this.internallyCancelled = outerCancelled = this.getOuterFuture().cancel(true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isCancelled() {
        Future<Future<R>> outerFuture = this.getOuterFuture();
        if (outerFuture.isDone()) {
            if (outerFuture.isCancelled()) {
                return true;
            }
            try {
                Future<R> innerFuture = outerFuture.get();
                return innerFuture.isCancelled();
            }
            catch (InterruptedException innerFuture) {
                void e;
                FFDCFilter.processException((Throwable)innerFuture, (String)"com.ibm.ws.microprofile.faulttolerance.impl.async.QueuedFuture", (String)"100", (Object)this, (Object[])new Object[0]);
                throw new FaultToleranceException((Throwable)e);
            }
            catch (ExecutionException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.faulttolerance.impl.async.QueuedFuture", (String)"103", (Object)this, (Object[])new Object[0]);
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @FFDCIgnore(value={ExecutionException.class})
    public boolean isDone() {
        Future<Future<R>> outerFuture = this.getOuterFuture();
        if (outerFuture.isDone()) {
            if (outerFuture.isCancelled()) {
                return true;
            }
            try {
                Future<R> innerFuture = outerFuture.get();
                return innerFuture.isDone();
            }
            catch (InterruptedException innerFuture) {
                void e;
                FFDCFilter.processException((Throwable)innerFuture, (String)"com.ibm.ws.microprofile.faulttolerance.impl.async.QueuedFuture", (String)"126", (Object)this, (Object[])new Object[0]);
                throw new FaultToleranceException((Throwable)e);
            }
            catch (ExecutionException e) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public R get() throws InterruptedException, ExecutionException {
        R result = null;
        Future<Future<R>> outerFuture = this.getOuterFuture();
        try {
            this.executionContext.check();
        }
        catch (org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException timeoutException) {
            void te;
            FFDCFilter.processException((Throwable)timeoutException, (String)"com.ibm.ws.microprofile.faulttolerance.impl.async.QueuedFuture", (String)"148", (Object)this, (Object[])new Object[0]);
            throw new ExecutionException((Throwable)te);
        }
        try {
            result = outerFuture.get().get();
        }
        catch (InterruptedException | CancellationException te) {
            void e;
            FFDCFilter.processException((Throwable)te, (String)"com.ibm.ws.microprofile.faulttolerance.impl.async.QueuedFuture", (String)"154", (Object)this, (Object[])new Object[0]);
            try {
                this.executionContext.check();
            }
            catch (org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException timeoutException) {
                void te2;
                FFDCFilter.processException((Throwable)timeoutException, (String)"com.ibm.ws.microprofile.faulttolerance.impl.async.QueuedFuture", (String)"158", (Object)this, (Object[])new Object[0]);
                throw new ExecutionException((Throwable)te2);
            }
            throw e;
        }
        catch (ExecutionException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.faulttolerance.impl.async.QueuedFuture", (String)"163", (Object)this, (Object[])new Object[0]);
            if (e.getCause() instanceof com.ibm.ws.microprofile.faulttolerance.spi.ExecutionException) {
                throw new ExecutionException(e.getCause().getCause());
            }
            throw e;
        }
        return result;
    }

    @Override
    @FFDCIgnore(value={CancellationException.class, org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException.class})
    public R get(long methodTimeout, TimeUnit methodUnit) throws InterruptedException, ExecutionException, TimeoutException {
        R result = null;
        Future<Future<R>> outerFuture = this.getOuterFuture();
        try {
            this.executionContext.check();
        }
        catch (org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException te) {
            throw new ExecutionException(te);
        }
        try {
            long start = System.nanoTime();
            long methodNanos = TimeUnit.NANOSECONDS.convert(methodTimeout, methodUnit);
            Future<R> innerFuture = outerFuture.get(methodNanos, TimeUnit.NANOSECONDS);
            long middle = System.nanoTime();
            long diff = middle - start;
            long remaining = methodNanos - diff;
            result = innerFuture.get(remaining, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException | CancellationException e) {
            try {
                this.executionContext.check();
            }
            catch (org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException te) {
                throw new ExecutionException(te);
            }
            throw e;
        }
        catch (ExecutionException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.faulttolerance.impl.async.QueuedFuture", (String)"203", (Object)this, (Object[])new Object[]{methodTimeout, methodUnit});
            if (e.getCause() instanceof com.ibm.ws.microprofile.faulttolerance.spi.ExecutionException) {
                throw new ExecutionException(e.getCause().getCause());
            }
            throw e;
        }
        return result;
    }

    @Override
    public Future<R> call() throws Exception {
        Future<R> result = null;
        ArrayList contextAppliedToThread = null;
        if (this.threadContext != null) {
            contextAppliedToThread = this.threadContext.taskStarting();
        }
        try {
            result = this.innerTask.call();
        }
        finally {
            if (contextAppliedToThread != null) {
                this.threadContext.taskStopping(contextAppliedToThread);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Future<R>> getOuterFuture() {
        QueuedFuture queuedFuture = this;
        synchronized (queuedFuture) {
            if (this.outerFuture == null) {
                throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT4999E", (Object[])new Object[0]));
            }
        }
        return this.outerFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ExecutorService executorService) {
        QueuedFuture queuedFuture = this;
        synchronized (queuedFuture) {
            this.outerFuture = executorService.submit(this);
        }
    }
}

