/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;

public final class Jdk14Logger
implements Log {
    protected Logger logger = null;

    public Jdk14Logger(String name) {
        this.logger = Logger.getLogger(name);
    }

    private void log(Level level, String msg, Throwable ex) {
        if (this.logger.isLoggable(level)) {
            Throwable dummyException = new Throwable();
            StackTraceElement[] locations = dummyException.getStackTrace();
            String cname = "unknown";
            String method = "unknown";
            if (locations != null && locations.length > 2) {
                StackTraceElement caller = locations[2];
                cname = caller.getClassName();
                method = caller.getMethodName();
            }
            if (ex == null) {
                this.logger.logp(level, cname, method, msg);
            } else {
                this.logger.logp(level, cname, method, msg, ex);
            }
        }
    }

    @Override
    public void debug(Object message) {
        this.log(Level.FINE, String.valueOf(message), null);
    }

    @Override
    public void debug(Object message, Throwable exception) {
        this.log(Level.FINE, String.valueOf(message), exception);
    }

    @Override
    public void error(Object message) {
        this.log(Level.SEVERE, String.valueOf(message), null);
    }

    @Override
    public void error(Object message, Throwable exception) {
        this.log(Level.SEVERE, String.valueOf(message), exception);
    }

    @Override
    public void fatal(Object message) {
        this.log(Level.SEVERE, String.valueOf(message), null);
    }

    @Override
    public void fatal(Object message, Throwable exception) {
        this.log(Level.SEVERE, String.valueOf(message), exception);
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void info(Object message) {
        this.log(Level.INFO, String.valueOf(message), null);
    }

    @Override
    public void info(Object message, Throwable exception) {
        this.log(Level.INFO, String.valueOf(message), exception);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public void trace(Object message) {
        this.log(Level.FINEST, String.valueOf(message), null);
    }

    @Override
    public void trace(Object message, Throwable exception) {
        this.log(Level.FINEST, String.valueOf(message), exception);
    }

    @Override
    public void warn(Object message) {
        this.log(Level.WARNING, String.valueOf(message), null);
    }

    @Override
    public void warn(Object message, Throwable exception) {
        this.log(Level.WARNING, String.valueOf(message), exception);
    }
}

