/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.config.tss;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.csiv2.Authenticator;
import com.ibm.ws.transport.iiop.security.SASException;
import com.ibm.ws.transport.iiop.security.SASInvalidEvidenceException;
import com.ibm.ws.transport.iiop.security.config.tss.TSSSASIdentityToken;
import com.ibm.ws.transport.iiop.security.util.Util;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import org.omg.CSI.IdentityToken;
import org.omg.IOP.Codec;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TSSITTX509CertChain
extends TSSSASIdentityToken {
    public static final String OID = "";
    private final String realmName;
    private final String domainName;
    private transient Authenticator authenticator;
    static final long serialVersionUID = -6216988350360525259L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public TSSITTX509CertChain(String realmName, String domainName) {
        this.realmName = realmName;
        this.domainName = domainName;
    }

    public TSSITTX509CertChain(Authenticator authenticator) {
        this.authenticator = authenticator;
        this.realmName = null;
        this.domainName = null;
    }

    @Override
    public short getType() {
        return 4;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    @FFDCIgnore(value={Exception.class})
    public Subject check(IdentityToken identityToken, Codec codec) throws SASException {
        Subject identityAssertionSubject = null;
        byte[] encodedCertChain = identityToken.certificate_chain();
        X509Certificate[] certificateChain = Util.decodeCertChain(codec, encodedCertChain);
        try {
            identityAssertionSubject = this.authenticator.authenticate(certificateChain);
            SubjectHelper subjectHelper = new SubjectHelper();
            WSCredential wsCredential = subjectHelper.getWSCredential(identityAssertionSubject);
            wsCredential.set("wssecurity.identity_name", (Object)"ClientCertificate");
            wsCredential.set("wssecurity.identity_value", (Object)certificateChain);
        }
        catch (Exception e) {
            throw new SASInvalidEvidenceException(e.getMessage(), 1229079296);
        }
        return identityAssertionSubject;
    }

    @Override
    @Trivial
    public void toString(String spaces, StringBuilder buf) {
        String moreSpaces = spaces + "  ";
        buf.append(spaces).append("TSSITTX509CertChain: [\n");
        buf.append(moreSpaces).append("domain: ").append(this.domainName).append("\n");
        buf.append(moreSpaces).append("realm: ").append(this.realmName).append("\n");
        buf.append(spaces).append("]\n");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(TSSITTX509CertChain.class);
    }
}

