/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.asn1;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.asn1.ASN1OctetString;
import com.ibm.ws.transport.iiop.asn1.ASN1OutputStream;
import com.ibm.ws.transport.iiop.asn1.ASN1TaggedObject;
import com.ibm.ws.transport.iiop.asn1.DERObject;
import com.ibm.ws.transport.iiop.asn1.DEROutputStream;
import com.ibm.ws.transport.iiop.asn1.DERString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DERUniversalString
extends DERObject
implements DERString {
    private static final char[] table;
    private byte[] string;
    static final long serialVersionUID = 5343609468314941160L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static DERUniversalString getInstance(Object obj) {
        if (obj == null || obj instanceof DERUniversalString) {
            return (DERUniversalString)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERUniversalString(((ASN1OctetString)obj).getOctets());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERUniversalString getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERUniversalString.getInstance(obj.getObject());
    }

    public DERUniversalString(byte[] string) {
        this.string = string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getString() {
        StringBuilder buf = new StringBuilder("#");
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        try {
            aOut.writeObject(this);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.transport.iiop.asn1.DERUniversalString", (String)"86", (Object)this, (Object[])new Object[0]);
            throw new RuntimeException("internal error encoding BitString", (Throwable)e);
        }
        byte[] string = bOut.toByteArray();
        for (int i = 0; i != string.length; ++i) {
            buf.append(table[(string[i] >>> 4) % 15]);
            buf.append(table[string[i] & 0xF]);
        }
        return buf.toString();
    }

    public byte[] getOctets() {
        return this.string;
    }

    @Override
    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(28, this.getOctets());
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof DERUniversalString)) {
            return false;
        }
        return this.getString().equals(((DERUniversalString)o).getString());
    }

    @Override
    public int hashCode() {
        return this.getString().hashCode();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DERUniversalString.class);
        table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

