/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.clientcontainer.internal;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.clientcontainer.internal.CallbackHandlerProviderImpl;
import com.ibm.ws.clientcontainer.internal.ClientComponentMetaDataImpl;
import com.ibm.ws.clientcontainer.internal.ClientModuleInjection;
import com.ibm.ws.clientcontainer.internal.ClientModuleMetaDataImpl;
import com.ibm.ws.clientcontainer.internal.ClientRunnerImpl;
import com.ibm.ws.clientcontainer.metadata.CallbackHandlerProvider;
import com.ibm.ws.clientcontainer.metadata.ClientModuleMetaData;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ModuleRuntimeContainer;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.extended.DeferredMetaDataFactory;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.javaee.dd.client.ApplicationClient;
import com.ibm.ws.javaee.dd.clientbnd.ApplicationClientBnd;
import com.ibm.ws.kernel.LibertyProcess;
import com.ibm.ws.kernel.launch.service.ClientRunner;
import com.ibm.ws.managedobject.ManagedObjectService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.resource.ResourceRefConfigFactory;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.ws.transport.iiop.spi.ClientORBRef;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.injectionengine.InjectionEngine;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.CallbackHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ModuleRuntimeContainer.class, DeferredMetaDataFactory.class}, property={"type=client", "deferredMetaData=CLIENT"})
public class ClientModuleRuntimeContainer
implements ModuleRuntimeContainer,
DeferredMetaDataFactory {
    private FutureMonitor futureMonitor;
    private BundleContext bundleContext;
    private ServiceRegistration<CallbackHandlerProvider> serviceReg;
    private InjectionEngine injectionEngine;
    private final Map<ClientModuleMetaData, ApplicationClientBnd> appClientBnds = new HashMap<ClientModuleMetaData, ApplicationClientBnd>();
    private final Map<ClientModuleMetaData, CallbackHandler> callbackHandlers = new HashMap<ClientModuleMetaData, CallbackHandler>();
    private ResourceRefConfigFactory resourceRefConfigFactory;
    private LibertyProcess libertyProcess;
    private J2EENameFactory j2eeNameFactory;
    private final Map<J2EEName, ComponentMetaData> activeCMDs = new HashMap<J2EEName, ComponentMetaData>();
    private boolean runningInClient;
    private ClassLoadingService classLoadingService;
    private final AtomicServiceReference<ManagedObjectService> managedObjectServiceRef = new AtomicServiceReference("managedObjectService");
    private ClassLoader appContextClassLoader;
    private final CountDownLatch latch = new CountDownLatch(1);
    private ClientRunnerImpl clientRunner;
    static final long serialVersionUID = -4465883352935535615L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference
    protected void setClassLoadingService(ClassLoadingService classLoadingService) {
        this.classLoadingService = classLoadingService;
    }

    protected void unsetClassLoadingService(ClassLoadingService classLoadingService) {
        this.classLoadingService = null;
    }

    @Reference(name="managedObjectService", service=ManagedObjectService.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setManagedObjectService(ServiceReference<ManagedObjectService> ref) {
        this.managedObjectServiceRef.setReference(ref);
    }

    protected void unsetManagedObjectService(ServiceReference<ManagedObjectService> ref) {
        this.managedObjectServiceRef.unsetReference(ref);
    }

    @Reference
    protected void setFutureMonitor(FutureMonitor futureMonitor) {
        this.futureMonitor = futureMonitor;
    }

    protected void unsetFutureMonitor(FutureMonitor futureMonitor) {
        this.futureMonitor = null;
    }

    @Reference
    protected void setInjectionEngine(InjectionEngine injectionEngine) {
        this.injectionEngine = injectionEngine;
    }

    protected void unsetInjectionEngine(InjectionEngine injectionEngine) {
    }

    @Reference
    protected void setResourceRefConfigFactory(ResourceRefConfigFactory resourceRefConfigFactory) {
        this.resourceRefConfigFactory = resourceRefConfigFactory;
    }

    protected void unsetResourceRefConfigFactory(ResourceRefConfigFactory resourceRefConfigFactory) {
    }

    @Reference
    protected void setJ2EENameFactory(J2EENameFactory j2eeNameFactory) {
        this.j2eeNameFactory = j2eeNameFactory;
    }

    protected void unsetJ2EENameFactory(J2EENameFactory j2eeNameFactory) {
        if (this.j2eeNameFactory == j2eeNameFactory) {
            this.j2eeNameFactory = null;
        }
    }

    @Reference(service=LibertyProcess.class)
    protected void setLibertyProcess(ServiceReference<LibertyProcess> libertyProcessSR) {
        this.runningInClient = "client".equals(libertyProcessSR.getProperty("wlp.process.type"));
        this.libertyProcess = (LibertyProcess)libertyProcessSR.getBundle().getBundleContext().getService(libertyProcessSR);
    }

    protected void unsetLibertyProcess(ServiceReference<LibertyProcess> libertyProcessSR) {
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setORBRef(ClientORBRef orbRef) {
        this.latch.countDown();
    }

    protected void unsetORBRef(ClientORBRef orbRef) {
    }

    /*
     * WARNING - void declaration
     */
    public ModuleMetaData createModuleMetaData(ExtendedModuleInfo moduleInfo) throws MetaDataException {
        ClientModuleMetaDataImpl cmmd;
        Container container = moduleInfo.getContainer();
        Hashtable<String, String> props = new Hashtable<String, String>();
        try {
            J2EEName j2eeName = this.j2eeNameFactory.create(moduleInfo.getApplicationInfo().getName(), moduleInfo.getURI(), null);
            cmmd = new ClientModuleMetaDataImpl((ApplicationClient)container.adapt(ApplicationClient.class), (ModuleInfo)moduleInfo, j2eeName);
            this.appClientBnds.put(cmmd, (ApplicationClientBnd)container.adapt(ApplicationClientBnd.class));
            CallbackHandlerProviderImpl callbackHandlerProvider = new CallbackHandlerProviderImpl((ModuleInfo)moduleInfo, cmmd.getAppClient().getCallbackHandler());
            this.callbackHandlers.put(cmmd, callbackHandlerProvider.getCallbackHandler());
            ((Dictionary)props).put("service.vendor", "IBM");
            this.serviceReg = this.bundleContext.registerService(CallbackHandlerProvider.class, (Object)callbackHandlerProvider, props);
        }
        catch (UnableToAdaptException j2eeName) {
            void e;
            FFDCFilter.processException((Throwable)j2eeName, (String)"com.ibm.ws.clientcontainer.internal.ClientModuleRuntimeContainer", (String)"188", (Object)this, (Object[])new Object[]{moduleInfo});
            throw new MetaDataException((Throwable)e);
        }
        return cmmd;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={InterruptedException.class})
    public Future<Boolean> startModule(ExtendedModuleInfo moduleInfo) throws StateChangeException {
        try {
            this.latch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e1) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                static final long serialVersionUID = 8600221060591795691L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() {
                    Thread.currentThread().interrupt();
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
        ClientModuleMetaData cmmd = (ClientModuleMetaData)moduleInfo.getMetaData();
        ClientComponentMetaDataImpl cmd = new ClientComponentMetaDataImpl(cmmd);
        ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().setDefaultCMD((ComponentMetaData)cmd);
        String[] args = this.libertyProcess.getArgs();
        this.appContextClassLoader = this.classLoadingService.createThreadContextClassLoader(moduleInfo.getClassLoader());
        ClassLoader origLoader = AccessController.doPrivileged(new GetTCCL());
        ClassLoader newLoader = AccessController.doPrivileged(new SetTCCL(this.appContextClassLoader));
        try {
            ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().beginContext((ComponentMetaData)cmd);
            ApplicationClientBnd appClientBnd = this.appClientBnds.get(cmmd);
            CallbackHandler callbackHandler = this.callbackHandlers.get(cmmd);
            ClientModuleInjection cmi = new ClientModuleInjection(cmmd, appClientBnd, this.resourceRefConfigFactory, this.injectionEngine, this.managedObjectServiceRef, callbackHandler, this.runningInClient);
            cmi.processReferences();
            this.activeCMDs.put(cmmd.getJ2EEName(), cmd);
            this.clientRunner.readyToRun(cmi, args, cmd, newLoader);
        }
        catch (ClassNotFoundException appClientBnd) {
            void e;
            FFDCFilter.processException((Throwable)appClientBnd, (String)"com.ibm.ws.clientcontainer.internal.ClientModuleRuntimeContainer", (String)"231", (Object)this, (Object[])new Object[]{moduleInfo});
            this.clientRunner.setupFailure();
            throw new StateChangeException((Throwable)e);
        }
        catch (InjectionException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.clientcontainer.internal.ClientModuleRuntimeContainer", (String)"234", (Object)this, (Object[])new Object[]{moduleInfo});
            this.clientRunner.setupFailure();
            throw new StateChangeException((Throwable)e);
        }
        finally {
            ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().endContext();
            if (origLoader != newLoader) {
                AccessController.doPrivileged(new SetTCCL(origLoader));
            }
        }
        return this.futureMonitor.createFutureWithResult((Object)true);
    }

    public void stopModule(ExtendedModuleInfo moduleInfo) {
        try {
            this.activeCMDs.remove(moduleInfo.getMetaData().getJ2EEName());
            this.serviceReg.unregister();
            int state = this.bundleContext.getBundle(0L).getState();
            if (state == 8 || state == 32) {
                this.bundleContext.getBundle(0L).stop();
            }
            this.classLoadingService.destroyThreadContextClassLoader(this.appContextClassLoader);
        }
        catch (BundleException bundleException) {
            FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.clientcontainer.internal.ClientModuleRuntimeContainer", (String)"256", (Object)this, (Object[])new Object[]{moduleInfo});
        }
    }

    public void activate(ComponentContext cc) {
        this.managedObjectServiceRef.activate(cc);
        this.bundleContext = cc.getBundleContext();
        this.clientRunner = new ClientRunnerImpl();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.vendor", "IBM");
        this.bundleContext.registerService(ClientRunner.class, (Object)this.clientRunner, props);
    }

    public void deactivate(ComponentContext cc) {
        this.managedObjectServiceRef.deactivate(cc);
        this.bundleContext = null;
        this.clientRunner = null;
    }

    public ComponentMetaData createComponentMetaData(String identifier) {
        String[] parts = identifier.split("#");
        J2EEName j2eeName = this.j2eeNameFactory.create(parts[1], parts[2], null);
        ComponentMetaData cmd = this.activeCMDs.get(j2eeName);
        return cmd;
    }

    public void initialize(ComponentMetaData metadata) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public String getMetaDataIdentifier(String appName, String moduleName, String componentName) {
        return "CLIENT#" + appName + "#" + moduleName;
    }

    public ClassLoader getClassLoader(ComponentMetaData metadata) {
        throw new UnsupportedOperationException();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ClientModuleRuntimeContainer.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class SetTCCL
    implements PrivilegedAction<ClassLoader> {
        private final ClassLoader newClassLoader;
        static final long serialVersionUID = 6160266383995268166L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        SetTCCL(ClassLoader newClassLoader) {
            this.newClassLoader = newClassLoader;
        }

        @Override
        public ClassLoader run() {
            Thread.currentThread().setContextClassLoader(this.newClassLoader);
            return this.newClassLoader;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SetTCCL.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class GetTCCL
    implements PrivilegedAction<ClassLoader> {
        static final long serialVersionUID = 7300988840654670540L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        GetTCCL() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(GetTCCL.class);
        }
    }
}

