/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.health.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.health.internal.AppTracker;
import com.ibm.ws.microprofile.health.internal.AppTrackerServletContextListener;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.webapp.WebAppConfigExtended;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import org.eclipse.microprofile.health.HealthCheck;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@HandlesTypes(value={HealthCheck.class})
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={AppTracker.class, ServletContainerInitializer.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class AppTrackerImpl
implements ServletContainerInitializer,
AppTracker {
    private static final TraceComponent tc = Tr.register(AppTrackerImpl.class);
    private static final String BUNDLE_CONTEXT_KEY = "osgi-bundlecontext";
    private final HashMap<String, Set<String>> appModules = new HashMap();
    static final long serialVersionUID = -8803387035558459959L;

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"AppTrackerImpl is activated", (Object[])new Object[0]);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc, int reason) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"AppTrackerImpl is deactivated", (Object[])new Object[0]);
        }
    }

    @Override
    public void onStartup(Set<Class<?>> arg0, ServletContext ctx) throws ServletException {
        IServletContext isc = (IServletContext)ctx;
        AppModuleName pair = this.setAppModuleNames(isc);
        if (pair != null) {
            isc.addListener((EventListener)((Object)new AppTrackerServletContextListener(pair, this)));
        }
    }

    @Override
    public Set<String> getAppNames() {
        return this.appModules.keySet();
    }

    @Override
    public Set<String> getModuleNames(String appName) {
        return this.appModules.get(appName);
    }

    private AppModuleName setAppModuleNames(IServletContext isc) {
        WebAppConfig webAppConfig = isc.getWebAppConfig();
        if (webAppConfig.isSystemApp()) {
            Tr.debug((TraceComponent)tc, (String)"Detected system app so won't track for health check; appName = ", (Object[])new Object[]{webAppConfig.getApplicationName()});
            return null;
        }
        if (this.isOsgiApp(isc)) {
            Tr.debug((TraceComponent)tc, (String)"Detected OSGi app, so won't track for health check; appName = ", (Object[])new Object[]{webAppConfig.getApplicationName()});
            return null;
        }
        WebModuleMetaData webModuleMetaData = ((WebAppConfigExtended)webAppConfig).getMetaData();
        String appName = webModuleMetaData.getApplicationMetaData().getName();
        String moduleName = webModuleMetaData.getJ2EEName().toString();
        return this.addAppModuleNames(appName, moduleName);
    }

    private boolean isOsgiApp(IServletContext isc) {
        Object bundleCtxAttr = isc.getAttribute(BUNDLE_CONTEXT_KEY);
        Tr.debug((TraceComponent)tc, (String)("Servet context attr for key = osgi-bundlecontext, = " + bundleCtxAttr), (Object[])new Object[0]);
        return bundleCtxAttr != null;
    }

    private synchronized AppModuleName addAppModuleNames(String appName, String moduleAndAppName) {
        HashSet moduleNames = null;
        String moduleName = moduleAndAppName.split("#")[1];
        if (this.appModules.containsKey(appName)) {
            moduleNames = (HashSet)this.appModules.get(appName);
            moduleNames.add(moduleName);
        } else {
            moduleNames = new HashSet();
            moduleNames.add(moduleName);
            this.appModules.put(appName, moduleNames);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addAppModuleNames(): modules added = " + this.appModules.toString() + " for app: " + appName), (Object[])new Object[0]);
        }
        AppModuleName retVal = new AppModuleName();
        retVal.appName = appName;
        retVal.moduleName = moduleName;
        return retVal;
    }

    public void moduleStopped(AppModuleName pair) {
        Set<String> modules = this.appModules.get(pair.appName);
        if (modules != null) {
            modules.remove(pair.moduleName);
            if (modules.size() <= 0) {
                this.appModules.remove(pair.appName);
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class AppModuleName {
        String appName;
        String moduleName;
        static final long serialVersionUID = -3934414536131665644L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        AppModuleName() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AppModuleName.class);
        }
    }
}

