/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.web.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.internal.interfaces.CDIUtils;
import com.ibm.ws.cdi.web.factories.WeldListenerFactory;
import com.ibm.ws.cdi.web.impl.ProbeDummyServlet;
import com.ibm.ws.cdi.web.impl.security.PrincipalServletRequestListener;
import com.ibm.ws.cdi.web.interfaces.CDIWebRuntime;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.webcontainer.facade.ServletContextFacade;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.util.EventListener;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.jboss.weld.probe.ProbeFilter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class AbstractServletInitializer
implements ServletContainerInitializer {
    private static final TraceComponent tc = Tr.register(AbstractServletInitializer.class);
    private final AtomicServiceReference<CDIWebRuntime> cdiWebRuntimeRef = new AtomicServiceReference("cdiWebRuntime");
    static final long serialVersionUID = 2075701207646636103L;

    public void activate(ComponentContext context) {
        this.cdiWebRuntimeRef.activate(context);
    }

    protected void deactivate(ComponentContext context) {
        this.cdiWebRuntimeRef.deactivate(context);
    }

    @Reference(name="cdiWebRuntime", service=CDIWebRuntime.class)
    protected void setCdiWebRuntime(ServiceReference<CDIWebRuntime> ref) {
        this.cdiWebRuntimeRef.setReference(ref);
    }

    protected void unsetCdiWebRuntime(ServiceReference<CDIWebRuntime> ref) {
        this.cdiWebRuntimeRef.unsetReference(ref);
    }

    protected CDIWebRuntime getCDIWebRuntime() {
        return (CDIWebRuntime)this.cdiWebRuntimeRef.getService();
    }

    protected abstract String getApplicationJ2EEName(IServletContext var1);

    public void onStartup(Set<Class<?>> c, ServletContext ctx) {
        CDIWebRuntime cdiWebRuntime;
        IServletContext isc = (IServletContext)ctx;
        while (isc instanceof ServletContextFacade) {
            isc = ((ServletContextFacade)isc).getIServletContext();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"calling isCDIEnabled()", (Object[])new Object[0]);
        }
        if ((cdiWebRuntime = this.getCDIWebRuntime()) != null && cdiWebRuntime.isCdiEnabled(isc)) {
            String contextID = this.getApplicationJ2EEName(isc);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CDI WEB APP: " + contextID), (Object[])new Object[0]);
            }
            isc.setInitParameter("WELD_CONTEXT_ID_KEY", contextID);
            BeanManager beanManager = cdiWebRuntime.getCurrentBeanManager();
            if (beanManager == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Bean Manager not found: " + contextID), (Object[])new Object[0]);
                }
            } else {
                isc.addListener((EventListener)((Object)new PrincipalServletRequestListener()));
                JspFactory factory = JspFactory.getDefaultFactory();
                if (factory != null) {
                    JspApplicationContext applicationCtx = factory.getJspApplicationContext(ctx);
                    applicationCtx.addELContextListener(WeldListenerFactory.newWeldELContextListener());
                    beanManager.wrapExpressionFactory(applicationCtx.getExpressionFactory());
                    applicationCtx.addELResolver(beanManager.getELResolver());
                }
                if (CDIUtils.isDevelopementMode()) {
                    ServletRegistration.Dynamic servletDynamic = isc.addServlet("ProbeServlet", ProbeDummyServlet.class);
                    servletDynamic.addMapping(new String[]{"/weld-probe/*"});
                    FilterRegistration.Dynamic filterDynamic = isc.addFilter("ProbeFilter", ProbeFilter.class);
                    filterDynamic.addMappingForUrlPatterns(null, false, new String[]{"/*"});
                }
            }
        }
    }
}

