/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cds;

import com.ibm.cds.CDSBundleEntry;
import com.ibm.oti.shared.SharedClassURLHelper;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.BundleFileWrapper;

public class CDSBundleFile
extends BundleFileWrapper {
    private URL url;
    private SharedClassURLHelper urlHelper;
    private boolean primed = false;

    public CDSBundleFile(BundleFile wrapped) {
        super(wrapped);
        try {
            this.url = new URL("file", "", wrapped.getBaseFile().getAbsolutePath());
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public CDSBundleFile(BundleFile bundleFile, SharedClassURLHelper urlHelper) {
        this(bundleFile);
        this.urlHelper = urlHelper;
    }

    public BundleEntry getEntry(String path) {
        String classFileExt = ".class";
        BundleEntry wrappedEntry = super.getEntry(path);
        if (wrappedEntry == null) {
            return null;
        }
        if (!this.primed || !path.endsWith(classFileExt)) {
            return wrappedEntry;
        }
        byte[] classbytes = this.getClassBytes(path.substring(0, path.length() - classFileExt.length()));
        CDSBundleEntry be = new CDSBundleEntry(path, classbytes, wrappedEntry);
        return be;
    }

    URL getURL() {
        return this.url;
    }

    SharedClassURLHelper getURLHelper() {
        return this.urlHelper;
    }

    void setURLHelper(SharedClassURLHelper urlHelper) {
        this.urlHelper = urlHelper;
        this.primed = false;
    }

    void setPrimed(boolean primed) {
        this.primed = primed;
    }

    private byte[] getClassBytes(String name) {
        if (this.urlHelper == null || this.url == null) {
            return null;
        }
        return this.urlHelper.findSharedClass(this.url, name);
    }
}

