/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.ExternalUserRegistryWrapper;
import com.ibm.ws.security.registry.FederationRegistry;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.registry.UserRegistryChangeListener;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.ws.security.registry.internal.UserRegistryProxy;
import com.ibm.ws.security.registry.internal.UserRegistryWrapper;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.scr.ext.annotation.DSExt;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(immediate=true, configurationPid={"com.ibm.ws.security.registry.internal.UserRegistryRefConfig", "com.ibm.ws.security.registry"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, property={"service.vendor=IBM"})
@DSExt.ConfigurableServiceProperties
public class UserRegistryServiceImpl
implements UserRegistryService {
    private static final TraceComponent tc = Tr.register(UserRegistryServiceImpl.class, (String)"UserRegistry", (String)"com.ibm.ws.security.registry.internal.resources.LoggingMessages");
    final ConcurrentServiceReferenceMap<String, UserRegistry> userRegistries = new ConcurrentServiceReferenceMap("UserRegistry");
    private final ConcurrentServiceReferenceSet<UserRegistryChangeListener> listeners = new ConcurrentServiceReferenceSet("UserRegistryChangeListener");
    private final AtomicServiceReference<FederationRegistry> federationRegistryServiceRef = new AtomicServiceReference("FederationRegistry");
    private final AtomicReference<UserRegistry> userRegistry = new AtomicReference();
    private final Object userRegistrySync = new Object(){
        static final long serialVersionUID = 4146229960389327208L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    private final List<String> registryTypes = new ArrayList<String>();
    static final String KEY_FEDERATION_REGISTRY = "FederationRegistry";
    static final String KEY_USER_REGISTRY = "UserRegistry";
    static final String KEY_LISTENER = "UserRegistryChangeListener";
    static final String KEY_CONFIG_ID = "config.id";
    static final String KEY_TYPE = "com.ibm.ws.security.registry.type";
    static final String KEY_COMPONENT_NAME = "component.name";
    static final String UNKNOWN_TYPE = "UNKNOWN";
    static final String CFG_KEY_REFID = "refId";
    static final String CFG_KEY_REALM = "realm";
    private static final String CFG_KEY_UR_COUNT = "UserRegistry.cardinality.minimum";
    private static final String FEDERATION_REGISTRY_TYPE = "WIM";
    private String[] refId;
    private String realm;
    private int urCount;
    static final String SERVICE_PROPERTY_USER_REGISTRY_CONFIGURED = "userRegistryConfigured";
    private static final String SERVICE_PROPERTY_REALM = "realm";
    private volatile Map<String, Object> props;
    private boolean isFederationActive = false;
    static final long serialVersionUID = 5653987925790475879L;

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, target="(!(objectClass=com.ibm.ws.security.registry.FederationRegistry))")
    protected Map<String, Object> setUserRegistry(ServiceReference<UserRegistry> ref) {
        String configId = (String)ref.getProperty(KEY_CONFIG_ID);
        String type = (String)ref.getProperty(KEY_TYPE);
        if (configId != null && type != null) {
            configId = this.parseIdFromConfigID(configId);
            this.userRegistries.putReference((Object)configId, ref);
        } else {
            if (type == null) {
                Tr.error((TraceComponent)tc, (String)"USER_REGISTRY_SERVICE_WITHOUT_TYPE", (Object[])new Object[]{ref.getProperty(KEY_COMPONENT_NAME)});
            }
            if (configId == null) {
                if (type != null) {
                    Tr.error((TraceComponent)tc, (String)"USER_REGISTRY_SERVICE_CONFIGURATION_WITHOUT_ID", (Object[])new Object[]{type});
                } else {
                    Tr.error((TraceComponent)tc, (String)"USER_REGISTRY_SERVICE_CONFIGURATION_WITHOUT_ID", (Object[])new Object[]{UNKNOWN_TYPE});
                }
            }
        }
        if (type != null) {
            this.registryTypes.add(type);
        } else {
            this.registryTypes.add(UNKNOWN_TYPE);
        }
        this.notifyListeners();
        return this.refreshUserRegistryCache();
    }

    private String parseIdFromConfigID(String configId) {
        Matcher idMatcher = Pattern.compile("\\Q[\\E(.+?)\\Q]\\E").matcher(configId);
        if (idMatcher.find()) {
            return idMatcher.group(1);
        }
        return configId;
    }

    protected Map<String, Object> updatedUserRegistry(ServiceReference<UserRegistry> ref) {
        this.notifyListeners();
        return this.refreshUserRegistryCache();
    }

    protected Map<String, Object> unsetUserRegistry(ServiceReference<UserRegistry> ref) {
        String id = this.parseIdFromConfigID((String)ref.getProperty(KEY_CONFIG_ID));
        this.userRegistries.removeReference((Object)id, ref);
        this.notifyListeners();
        String type = (String)ref.getProperty(KEY_TYPE);
        if (type != null) {
            this.registryTypes.remove(type);
        } else {
            this.registryTypes.remove(UNKNOWN_TYPE);
        }
        if (FrameworkState.isStopping()) {
            return null;
        }
        return this.refreshUserRegistryCache();
    }

    @Reference(name="FederationRegistry", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected Map<String, Object> setFederationRegistry(ServiceReference<FederationRegistry> federationRegistryRef) {
        this.federationRegistryServiceRef.setReference(federationRegistryRef);
        return this.refreshUserRegistryCache();
    }

    protected Map<String, Object> unsetFederationRegistry(ServiceReference<FederationRegistry> federationRegistryRef) {
        this.federationRegistryServiceRef.unsetReference(federationRegistryRef);
        if (FrameworkState.isStopping()) {
            return null;
        }
        return this.refreshUserRegistryCache();
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void setUserRegistryChangeListener(ServiceReference<UserRegistryChangeListener> ref) {
        this.listeners.addReference(ref);
    }

    protected void unsetUserRegistryChangeListener(ServiceReference<UserRegistryChangeListener> ref) {
        this.listeners.removeReference(ref);
    }

    @Activate
    protected Map<String, Object> activate(ComponentContext cc, Map<String, Object> props) {
        this.props = props;
        this.refId = (String[])props.get(CFG_KEY_REFID);
        this.realm = (String)props.get("realm");
        this.urCount = props.get(CFG_KEY_UR_COUNT) == null ? -1 : Integer.valueOf((String)props.get(CFG_KEY_UR_COUNT));
        this.userRegistries.activate(cc);
        this.listeners.activate(cc);
        this.federationRegistryServiceRef.activate(cc);
        return this.getServiceProperties();
    }

    @Modified
    protected Map<String, Object> modify(Map<String, Object> props) {
        this.refId = (String[])props.get(CFG_KEY_REFID);
        this.realm = (String)props.get("realm");
        this.urCount = props.get(CFG_KEY_UR_COUNT) == null ? -1 : Integer.valueOf((String)props.get(CFG_KEY_UR_COUNT));
        this.props = props;
        this.notifyListeners();
        return this.refreshUserRegistryCache();
    }

    @Deactivate
    protected Map<String, Object> deactivate(ComponentContext cc) {
        this.refId = null;
        this.realm = null;
        this.userRegistries.deactivate(cc);
        this.listeners.deactivate(cc);
        this.federationRegistryServiceRef.deactivate(cc);
        return this.getServiceProperties();
    }

    private void notifyListeners() {
        for (UserRegistryChangeListener listener : this.listeners.services()) {
            listener.notifyOfUserRegistryChange();
        }
    }

    private boolean isConfigured() {
        return this.refId != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserRegistry determineActiveUserRegistry(boolean exceptionOnError) throws RegistryException {
        Object object = this.userRegistrySync;
        synchronized (object) {
            UserRegistry ur = this.userRegistry.get();
            if (ur == null) {
                ur = this.isConfigured() ? this.getUserRegistryFromConfiguration() : this.autoDetectUserRegistry(exceptionOnError);
                this.userRegistry.set(ur);
            }
            return ur;
        }
    }

    @Override
    public boolean isUserRegistryConfigured() throws RegistryException {
        return null != this.determineActiveUserRegistry(false);
    }

    @Override
    public UserRegistry getUserRegistry() throws RegistryException {
        return this.determineActiveUserRegistry(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserRegistry autoDetectUserRegistry(boolean exceptionOnError) throws RegistryException {
        UserRegistry ur = this.getFederationRegistry(exceptionOnError);
        Object object = this.userRegistrySync;
        synchronized (object) {
            if (ur != null) {
                this.setRegistriesToBeFederated((FederationRegistry)ur, exceptionOnError);
                this.isFederationActive = true;
                return ur;
            }
            this.isFederationActive = false;
        }
        if (this.userRegistries.isEmpty()) {
            if (exceptionOnError) {
                Tr.error((TraceComponent)tc, (String)"USER_REGISTRY_SERVICE_NO_USER_REGISTRY_AVAILABLE", (Object[])new Object[0]);
                throw new RegistryException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.registry.internal.resources.LoggingMessages", (String)"USER_REGISTRY_SERVICE_NO_USER_REGISTRY_AVAILABLE", (Object[])new Object[0], (String)"CWWKS3005E: A configuration exception has occurred. No UserRegistry implementation service is available.  Ensure that you have a user registry configured."));
            }
            return null;
        }
        if (this.urCount > 1) {
            if (exceptionOnError) {
                Tr.error((TraceComponent)tc, (String)"USER_REGISTRY_SERVICE_MULTIPLE_USER_REGISTRY_AVAILABLE", (Object[])new Object[0]);
                throw new RegistryException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.registry.internal.resources.LoggingMessages", (String)"USER_REGISTRY_SERVICE_MULTIPLE_USER_REGISTRY_AVAILABLE", (Object[])new Object[0], (String)"CWWKS3006E: A configuration error has occurred. Multiple available UserRegistry implementation services, unable to determine which to use."));
            }
            return null;
        }
        String id = (String)this.userRegistries.keySet().iterator().next();
        return this.getUserRegistry(id, exceptionOnError);
    }

    private UserRegistry getFederationRegistry(boolean exceptionOnError) throws RegistryException {
        return (UserRegistry)this.federationRegistryServiceRef.getService();
    }

    private UserRegistry getUserRegistryFromConfiguration() throws RegistryException {
        String[] refIds = this.refId;
        if (refIds == null || refIds.length == 0) {
            Tr.error((TraceComponent)tc, (String)"USER_REGISTRY_SERVICE_CONFIG_ERROR_NO_REFID", (Object[])new Object[0]);
            throw new RegistryException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.registry.internal.resources.LoggingMessages", (String)"USER_REGISTRY_SERVICE_CONFIG_ERROR_NO_REFID", null, (String)"CWWKS3000E: A configuration error has occurred. There is no configured refId parameter for the userRegistry configuration."));
        }
        if (refIds.length == 1) {
            return this.getUserRegistry(refIds[0]);
        }
        ArrayList<UserRegistry> delegates = new ArrayList<UserRegistry>();
        for (String refId : refIds) {
            delegates.add(this.getUserRegistry(refId));
        }
        return new UserRegistryProxy(this.realm, delegates);
    }

    @Override
    public UserRegistry getUserRegistry(String id) throws RegistryException {
        return this.getUserRegistry(id, true);
    }

    private UserRegistry getUserRegistry(String id, boolean exceptionOnError) throws RegistryException {
        if (id == null) {
            throw new IllegalArgumentException("getUserRegistry(String) does not support null id");
        }
        UserRegistry userRegistry = (UserRegistry)this.userRegistries.getService((Object)id);
        if (userRegistry != null) {
            return userRegistry;
        }
        Tr.error((TraceComponent)tc, (String)"USER_REGISTRY_SERVICE_CONFIG_ERROR_NO_SUCH_ID", (Object[])new Object[]{id});
        if (exceptionOnError) {
            throw new RegistryException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.registry.internal.resources.LoggingMessages", (String)"USER_REGISTRY_SERVICE_CONFIG_ERROR_NO_SUCH_ID", (Object[])new Object[]{id}, (String)"CWWKS3001E: A configuration error has occurred. The requested UserRegistry instance with id {0} could not be found."));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUserRegistryType() {
        Object object = this.userRegistrySync;
        synchronized (object) {
            if (this.isFederationActive && this.userRegistry != null) {
                return FEDERATION_REGISTRY_TYPE;
            }
        }
        if (this.registryTypes.isEmpty() || this.registryTypes.size() > 1) {
            return UNKNOWN_TYPE;
        }
        return this.registryTypes.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> refreshUserRegistryCache() {
        Object object = this.userRegistrySync;
        synchronized (object) {
            this.userRegistry.set(null);
            return this.getServiceProperties();
        }
    }

    @FFDCIgnore(value={RegistryException.class})
    private Map<String, Object> getServiceProperties() {
        Map<String, Object> props = this.props;
        if (props == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(props);
        try {
            UserRegistry userRegistry = this.determineActiveUserRegistry(false);
            if (userRegistry == null) {
                result.put(SERVICE_PROPERTY_USER_REGISTRY_CONFIGURED, false);
            } else {
                result.put(SERVICE_PROPERTY_USER_REGISTRY_CONFIGURED, true);
                result.put("realm", userRegistry.getRealm());
            }
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void setRegistriesToBeFederated(FederationRegistry federationRegistry, boolean exceptionOnError) throws RegistryException {
        federationRegistry.removeAllFederatedRegistries();
        try {
            ArrayList<UserRegistry> urs = new ArrayList<UserRegistry>();
            for (String id : this.userRegistries.keySet()) {
                urs.add((UserRegistry)this.userRegistries.getServiceWithException((Object)id));
            }
            federationRegistry.addFederationRegistries(urs);
        }
        catch (Exception urs) {
            void e;
            FFDCFilter.processException((Throwable)urs, (String)"com.ibm.ws.security.registry.internal.UserRegistryServiceImpl", (String)"561", (Object)this, (Object[])new Object[]{federationRegistry, exceptionOnError});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to federate user registries.", (Object[])new Object[0]);
            }
            Tr.error((TraceComponent)tc, (String)"USER_REGISTRY_SERVICE_FEDERATION_FAILED", (Object[])new Object[]{e});
            throw new RegistryException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.registry.internal.resources.LoggingMessages", (String)"USER_REGISTRY_SERVICE_FEDERATION_FAILED", (Object[])new Object[]{e}, (String)("CWWKS3010E: An unexpected exception occurred federating user registries: " + e)), (Throwable)e);
        }
    }

    @Override
    public com.ibm.websphere.security.UserRegistry getExternalUserRegistry(UserRegistry userRegistry) {
        if (userRegistry instanceof ExternalUserRegistryWrapper) {
            return ((ExternalUserRegistryWrapper)((Object)userRegistry)).getExternalUserRegistry();
        }
        return new UserRegistryWrapper(userRegistry);
    }
}

