/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal;

import com.ibm.tx.jta.embeddable.EmbeddableTransactionManagerFactory;
import com.ibm.websphere.concurrent.persistent.TaskState;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.ejbcontainer.mbean.EJBPersistentTimerInfo;
import com.ibm.websphere.ejbcontainer.mbean.EJBPersistentTimerServiceMXBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.persistent.ejb.TimerStatus;
import com.ibm.ws.concurrent.persistent.ejb.TimersPersistentExecutor;
import com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerRuntimeImpl;
import com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.PersistentTimerTaskHandlerImpl;
import com.ibm.ws.ejbcontainer.util.ParsedScheduleExpression;
import com.ibm.ws.ejbcontainer.util.ScheduleExpressionParser;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.ejb.ScheduleExpression;
import javax.transaction.TransactionManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(property={"jmx.objectname=WebSphere:feature=ejbPersistentTimer,type=EJBPersistentTimerService,name=EJBPersistentTimerService"})
public class EJBPersistentTimerServiceMXBeanImpl
implements EJBPersistentTimerServiceMXBean {
    private static final TraceComponent tc = Tr.register(EJBPersistentTimerServiceMXBeanImpl.class);
    private static final Character ESCAPE = Character.valueOf('\\');
    private EJBPersistentTimerRuntimeImpl persistentTimerRuntime;
    private J2EENameFactory j2eeNameFactory;
    static final long serialVersionUID = -8168050409068162326L;

    @Reference
    protected void setEJBPersistentTimerRuntime(EJBPersistentTimerRuntimeImpl persistentTimerRuntime) {
        this.persistentTimerRuntime = persistentTimerRuntime;
    }

    @Reference
    protected void setJ2EENameFactory(J2EENameFactory j2eeNameFactory) {
        this.j2eeNameFactory = j2eeNameFactory;
    }

    @Trivial
    private static void requiresNonNull(String s, String name) {
        if (s == null) {
            throw new IllegalArgumentException(name);
        }
    }

    @Trivial
    private static void requiresJ2EENamePiece(String s, String name) {
        EJBPersistentTimerServiceMXBeanImpl.requiresNonNull(s, name);
        if (s.indexOf(35) != -1) {
            throw new IllegalArgumentException(name);
        }
    }

    @Trivial
    private static void requiresJ2EEName(String appName) {
        EJBPersistentTimerServiceMXBeanImpl.requiresJ2EENamePiece(appName, "appName");
    }

    @Trivial
    private static void requiresJ2EEName(String appName, String moduleURI) {
        EJBPersistentTimerServiceMXBeanImpl.requiresJ2EEName(appName);
        EJBPersistentTimerServiceMXBeanImpl.requiresJ2EENamePiece(moduleURI, "moduleURI");
    }

    @Trivial
    private static void requiresJ2EEName(String appName, String moduleURI, String ejbName) {
        EJBPersistentTimerServiceMXBeanImpl.requiresJ2EEName(appName, moduleURI);
        EJBPersistentTimerServiceMXBeanImpl.requiresJ2EENamePiece(ejbName, "ejbName");
    }

    private static RuntimeException handleError(Throwable t) {
        return new RuntimeException(t.toString());
    }

    @Trivial
    private TimersPersistentExecutor getPersistentExecutor() {
        return this.persistentTimerRuntime.getPersistentExecutor();
    }

    @Trivial
    private PersistentTimerTaskHandlerImpl getTaskHandler(TimerStatus<?> taskStatus) throws ClassNotFoundException, IOException {
        return (PersistentTimerTaskHandlerImpl)taskStatus.getTimer();
    }

    @Sensitive
    @FFDCIgnore(value={Throwable.class})
    private static String getUserInfoString(PersistentTimerTaskHandlerImpl taskHandler) {
        block3: {
            try {
                Serializable info = taskHandler.getUserInfo();
                if (info != null) {
                    return info.toString();
                }
            }
            catch (Throwable t) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"unable to get user info string", (Object[])new Object[]{t});
            }
        }
        return null;
    }

    private EJBPersistentTimerInfo[] getTimers(List<TimerStatus<?>> tasks) throws ClassNotFoundException, IOException {
        EJBPersistentTimerInfo[] results = new EJBPersistentTimerInfo[tasks.size()];
        for (int i = 0; i < tasks.size(); ++i) {
            EJBPersistentTimerInfo timerMXBean;
            TimerStatus<?> task = tasks.get(i);
            PersistentTimerTaskHandlerImpl taskHandler = this.getTaskHandler(task);
            J2EEName timerJ2EEName = taskHandler.getJ2EEName();
            results[i] = timerMXBean = new EJBPersistentTimerInfo();
            timerMXBean.setId(String.valueOf(task.getTaskId()));
            timerMXBean.setApplication(timerJ2EEName.getApplication());
            timerMXBean.setModule(timerJ2EEName.getModule());
            timerMXBean.setEJB(timerJ2EEName.getComponent());
            timerMXBean.setNextTimeout(task.getNextExecutionTime().getTime());
            timerMXBean.setInfo(EJBPersistentTimerServiceMXBeanImpl.getUserInfoString(taskHandler));
            ParsedScheduleExpression parsedScheduleExpr = taskHandler.getParsedSchedule();
            if (parsedScheduleExpr != null) {
                timerMXBean.setScheduleExpression(ScheduleExpressionParser.toString((ScheduleExpression)parsedScheduleExpr.getSchedule()));
            }
            timerMXBean.setAutomaticTimerMethod(taskHandler.getAutomaticTimerMethodName());
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    public EJBPersistentTimerInfo[] getTimers(String appName) {
        try {
            EJBPersistentTimerServiceMXBeanImpl.requiresJ2EEName(appName);
            return this.getTimers(this.getPersistentExecutor().findTimerStatus(appName, null, null, TaskState.ANY, true, null, null));
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerServiceMXBeanImpl", (String)"155", (Object)this, (Object[])new Object[]{appName});
            throw EJBPersistentTimerServiceMXBeanImpl.handleError((Throwable)t);
        }
    }

    /*
     * WARNING - void declaration
     */
    public EJBPersistentTimerInfo[] getTimers(String appName, String moduleURI) {
        try {
            EJBPersistentTimerServiceMXBeanImpl.requiresJ2EEName(appName, moduleURI);
            String pattern = PersistentTimerTaskHandlerImpl.getTaskNameModulePattern(moduleURI);
            return this.getTimers(this.getPersistentExecutor().findTimerStatus(appName, pattern, ESCAPE, TaskState.ANY, true, null, null));
        }
        catch (Throwable pattern) {
            void t;
            FFDCFilter.processException((Throwable)pattern, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerServiceMXBeanImpl", (String)"167", (Object)this, (Object[])new Object[]{appName, moduleURI});
            throw EJBPersistentTimerServiceMXBeanImpl.handleError((Throwable)t);
        }
    }

    /*
     * WARNING - void declaration
     */
    public EJBPersistentTimerInfo[] getTimers(String appName, String moduleURI, String ejbName) {
        try {
            EJBPersistentTimerServiceMXBeanImpl.requiresJ2EEName(appName, moduleURI, ejbName);
            String pattern = PersistentTimerTaskHandlerImpl.getTaskNameBeanPattern(this.j2eeNameFactory.create(appName, moduleURI, ejbName));
            return this.getTimers(this.getPersistentExecutor().findTimerStatus(appName, pattern, ESCAPE, TaskState.ANY, true, null, null));
        }
        catch (Throwable pattern) {
            void t;
            FFDCFilter.processException((Throwable)pattern, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerServiceMXBeanImpl", (String)"179", (Object)this, (Object[])new Object[]{appName, moduleURI, ejbName});
            throw EJBPersistentTimerServiceMXBeanImpl.handleError((Throwable)t);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean cancelTimer(String id) {
        try {
            EJBPersistentTimerServiceMXBeanImpl.requiresNonNull(id, "id");
            return this.getPersistentExecutor().removeTimer(Long.parseLong(id));
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerServiceMXBeanImpl", (String)"190", (Object)this, (Object[])new Object[]{id});
            throw EJBPersistentTimerServiceMXBeanImpl.handleError((Throwable)t);
        }
    }

    @Trivial
    private TransactionManager getTransactionManager() {
        return EmbeddableTransactionManagerFactory.getTransactionManager();
    }

    /*
     * WARNING - void declaration
     */
    public boolean cancelTimers(String appName) {
        try {
            EJBPersistentTimerServiceMXBeanImpl.requiresJ2EEName(appName);
            return this.getPersistentExecutor().removeTimers(appName, null, null, TaskState.ANY, true) != 0;
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerServiceMXBeanImpl", (String)"206", (Object)this, (Object[])new Object[]{appName});
            throw EJBPersistentTimerServiceMXBeanImpl.handleError((Throwable)t);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean cancelTimers(String appName, String moduleURI) {
        try {
            EJBPersistentTimerServiceMXBeanImpl.requiresJ2EEName(appName, moduleURI);
            String pattern = PersistentTimerTaskHandlerImpl.getTaskNameModulePattern(moduleURI);
            return this.getPersistentExecutor().removeTimers(appName, pattern, ESCAPE, TaskState.ANY, true) != 0;
        }
        catch (Throwable pattern) {
            void t;
            FFDCFilter.processException((Throwable)pattern, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerServiceMXBeanImpl", (String)"218", (Object)this, (Object[])new Object[]{appName, moduleURI});
            throw EJBPersistentTimerServiceMXBeanImpl.handleError((Throwable)t);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean cancelTimers(String appName, String moduleURI, String ejbName) {
        try {
            EJBPersistentTimerServiceMXBeanImpl.requiresJ2EEName(appName, moduleURI, ejbName);
            String pattern = PersistentTimerTaskHandlerImpl.getTaskNameBeanPattern(this.j2eeNameFactory.create(appName, moduleURI, ejbName));
            return this.getPersistentExecutor().removeTimers(appName, pattern, ESCAPE, TaskState.ANY, true) != 0;
        }
        catch (Throwable pattern) {
            void t;
            FFDCFilter.processException((Throwable)pattern, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerServiceMXBeanImpl", (String)"230", (Object)this, (Object[])new Object[]{appName, moduleURI, ejbName});
            throw EJBPersistentTimerServiceMXBeanImpl.handleError((Throwable)t);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsAutomaticTimers(String appName) {
        try {
            String pattern = PersistentTimerTaskHandlerImpl.getAutomaticTimerPropertyPattern(appName, null);
            Map properties = this.getPersistentExecutor().findProperties(pattern, ESCAPE);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("properties=" + properties), (Object[])new Object[0]);
            }
            return !properties.isEmpty();
        }
        catch (Throwable pattern) {
            void t;
            FFDCFilter.processException((Throwable)pattern, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerServiceMXBeanImpl", (String)"243", (Object)this, (Object[])new Object[]{appName});
            throw EJBPersistentTimerServiceMXBeanImpl.handleError((Throwable)t);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsAutomaticTimers(String appName, String moduleURI) {
        try {
            EJBPersistentTimerServiceMXBeanImpl.requiresJ2EEName(appName, moduleURI);
            String propertyName = PersistentTimerTaskHandlerImpl.getAutomaticTimerPropertyName(appName, moduleURI);
            String property = this.getPersistentExecutor().getProperty(propertyName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("property=" + property), (Object[])new Object[0]);
            }
            return property != null;
        }
        catch (Throwable propertyName) {
            void t;
            FFDCFilter.processException((Throwable)propertyName, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerServiceMXBeanImpl", (String)"258", (Object)this, (Object[])new Object[]{appName, moduleURI});
            throw EJBPersistentTimerServiceMXBeanImpl.handleError((Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeAutomaticTimersImpl(String appName, String moduleURI) throws Exception {
        boolean success = false;
        TransactionManager tm = this.getTransactionManager();
        tm.begin();
        try {
            boolean result;
            TimersPersistentExecutor persistentExecutor = this.getPersistentExecutor();
            String propertyPattern = PersistentTimerTaskHandlerImpl.getAutomaticTimerPropertyPattern(appName, moduleURI);
            int numProperties = persistentExecutor.removeProperties(propertyPattern, ESCAPE);
            String taskPattern = moduleURI == null ? null : PersistentTimerTaskHandlerImpl.getAutomaticTimerTaskNameModulePattern(moduleURI);
            int numTimers = persistentExecutor.removeTimers(appName, taskPattern, ESCAPE, TaskState.ANY, true);
            boolean bl = result = numProperties != 0 || numTimers != 0;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("result=" + result + "; removed " + numProperties + " properties and " + numTimers + " timers"), (Object[])new Object[0]);
            }
            success = true;
            boolean bl2 = result;
            return bl2;
        }
        finally {
            if (success) {
                tm.commit();
            } else {
                tm.rollback();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeAutomaticTimers(String appName) {
        try {
            EJBPersistentTimerServiceMXBeanImpl.requiresJ2EEName(appName);
            return this.removeAutomaticTimersImpl(appName, null);
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerServiceMXBeanImpl", (String)"299", (Object)this, (Object[])new Object[]{appName});
            throw EJBPersistentTimerServiceMXBeanImpl.handleError((Throwable)t);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeAutomaticTimers(String appName, String moduleURI) {
        try {
            EJBPersistentTimerServiceMXBeanImpl.requiresJ2EEName(appName);
            return this.removeAutomaticTimersImpl(appName, moduleURI);
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerServiceMXBeanImpl", (String)"309", (Object)this, (Object[])new Object[]{appName, moduleURI});
            throw EJBPersistentTimerServiceMXBeanImpl.handleError((Throwable)t);
        }
    }
}

