/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.generator;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.internal.generator.FeatureListOptions;
import com.ibm.ws.kernel.feature.internal.generator.Indenter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FeatureListUtils {
    private static final String FEATURE_LIST_DEFAULT_ENCODING = "UTF-8";
    private final Indenter indenter;
    private final XMLStreamWriter xmlStreamWriter;
    private String encoding;
    private FeatureListOptions options;
    private final FileOutputStream fileOutputStream;
    static final long serialVersionUID = 151718845466701335L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    public FeatureListUtils(FeatureListOptions options) {
        try {
            this.fileOutputStream = new FileOutputStream(options.getOutputFile());
            String encoding = options.getEncoding();
            if (encoding == null) {
                encoding = FEATURE_LIST_DEFAULT_ENCODING;
            }
            this.options = options;
            this.encoding = encoding;
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)this.fileOutputStream, encoding);
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            try {
                this.xmlStreamWriter = factory.createXMLStreamWriter(w);
            }
            catch (XMLStreamException xMLStreamException) {
                void e;
                FFDCFilter.processException((Throwable)xMLStreamException, (String)"com.ibm.ws.kernel.feature.internal.generator.FeatureListUtils", (String)"58", (Object)this, (Object[])new Object[]{options});
                throw new IOException("Error generating feature list", (Throwable)e);
            }
            this.indenter = new Indenter(this.xmlStreamWriter, w);
        }
        catch (IOException encoding) {
            void ex;
            FFDCFilter.processException((Throwable)encoding, (String)"com.ibm.ws.kernel.feature.internal.generator.FeatureListUtils", (String)"62", (Object)this, (Object[])new Object[]{options});
            options.setReturnCode(FeatureListOptions.ReturnCode.RUNTIME_EXCEPTION);
            throw new RuntimeException((Throwable)ex);
        }
    }

    protected XMLStreamWriter getXMLStreamWriter() {
        return this.xmlStreamWriter;
    }

    protected Indenter getIndenter() {
        return this.indenter;
    }

    /*
     * WARNING - void declaration
     */
    public void writeStartDocument() {
        try {
            this.xmlStreamWriter.writeStartDocument(this.encoding, "1.0");
        }
        catch (XMLStreamException xMLStreamException) {
            void e;
            FFDCFilter.processException((Throwable)xMLStreamException, (String)"com.ibm.ws.kernel.feature.internal.generator.FeatureListUtils", (String)"80", (Object)this, (Object[])new Object[0]);
            IOException ex = new IOException("Error generating feature list", (Throwable)e);
            this.options.setReturnCode(FeatureListOptions.ReturnCode.RUNTIME_EXCEPTION);
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeEndDocument() {
        try {
            try {
                this.indenter.indent(0);
                this.xmlStreamWriter.writeEndDocument();
            }
            catch (XMLStreamException xMLStreamException) {
                void ex;
                FFDCFilter.processException((Throwable)xMLStreamException, (String)"com.ibm.ws.kernel.feature.internal.generator.FeatureListUtils", (String)"92", (Object)this, (Object[])new Object[0]);
                throw new IOException("Error generating feature list", (Throwable)ex);
            }
        }
        catch (IOException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.kernel.feature.internal.generator.FeatureListUtils", (String)"96", (Object)this, (Object[])new Object[0]);
            this.options.setReturnCode(FeatureListOptions.ReturnCode.RUNTIME_EXCEPTION);
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void startFeatureInfo(String name, String location, String productId) {
        try {
            try {
                this.indenter.indent(0);
                this.xmlStreamWriter.writeStartElement("featureInfo");
                this.xmlStreamWriter.writeAttribute("name", name);
                if (productId != null) {
                    this.xmlStreamWriter.writeAttribute("productId", productId);
                }
                this.xmlStreamWriter.writeAttribute("location", location);
            }
            catch (XMLStreamException xMLStreamException) {
                void ex;
                FFDCFilter.processException((Throwable)xMLStreamException, (String)"com.ibm.ws.kernel.feature.internal.generator.FeatureListUtils", (String)"114", (Object)this, (Object[])new Object[]{name, location, productId});
                throw new IOException("Error generating feature list", (Throwable)ex);
            }
        }
        catch (IOException ex) {
            void e;
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.kernel.feature.internal.generator.FeatureListUtils", (String)"118", (Object)this, (Object[])new Object[]{name, location, productId});
            this.options.setReturnCode(FeatureListOptions.ReturnCode.RUNTIME_EXCEPTION);
            throw new RuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void endFeatureInfo() {
        try {
            try {
                this.indenter.indent(0);
                this.xmlStreamWriter.writeEndElement();
            }
            catch (XMLStreamException xMLStreamException) {
                void e;
                FFDCFilter.processException((Throwable)xMLStreamException, (String)"com.ibm.ws.kernel.feature.internal.generator.FeatureListUtils", (String)"130", (Object)this, (Object[])new Object[0]);
                throw new IOException("Error generating feature list", (Throwable)e);
            }
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.kernel.feature.internal.generator.FeatureListUtils", (String)"133", (Object)this, (Object[])new Object[0]);
            this.options.setReturnCode(FeatureListOptions.ReturnCode.RUNTIME_EXCEPTION);
            throw new RuntimeException(e);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(FeatureListUtils.class);
    }
}

