/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RestrictedFeatureRespository
implements FeatureResolver.Repository {
    private final FeatureResolver.Repository repo;
    private final Collection<String> restricted;
    private final Collection<String> restrictedAttempts = new ArrayList<String>();
    static final long serialVersionUID = 8478830605266972601L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public RestrictedFeatureRespository(FeatureResolver.Repository repo, Collection<String> restricted) {
        this.repo = repo;
        this.restricted = restricted;
    }

    @Override
    public Collection<ProvisioningFeatureDefinition> getAutoFeatures() {
        return this.repo.getAutoFeatures();
    }

    @Override
    public ProvisioningFeatureDefinition getFeature(String featureName) {
        ProvisioningFeatureDefinition result = this.repo.getFeature(featureName);
        if (result == null) {
            return null;
        }
        if (this.restricted.contains(result.getSymbolicName())) {
            if (!this.restrictedAttempts.contains(result.getSymbolicName())) {
                this.restrictedAttempts.add(result.getSymbolicName());
            }
            return null;
        }
        return result;
    }

    Collection<String> getRestrictedFeatureAttempts() {
        return this.restrictedAttempts;
    }

    @Override
    public List<String> getConfiguredTolerates(String baseSymbolicName) {
        return this.repo.getConfiguredTolerates(baseSymbolicName);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(RestrictedFeatureRespository.class);
    }
}

