/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.services.IJobXMLSource;
import com.ibm.jbatch.container.services.impl.JobXMLSource;
import com.ibm.jbatch.spi.services.IBatchConfig;
import com.ibm.jbatch.spi.services.IJobXMLLoaderService;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DirectoryJobXMLLoaderServiceImpl
implements IJobXMLLoaderService {
    private static final String CLASSNAME;
    public static final String JOB_XML_DIR_PROP = "com.ibm.jbatch.jsl.directory";
    public static final String JOB_XML_PATH;
    static final long serialVersionUID = 2580019205179927061L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public IJobXMLSource loadJSL(String id) {
        IJobXMLSource jobXML = DirectoryJobXMLLoaderServiceImpl.loadJobFromDirectory(JOB_XML_PATH, id);
        return jobXML;
    }

    /*
     * WARNING - void declaration
     */
    private static IJobXMLSource loadJobFromDirectory(String dir, String id) {
        URL fileURL;
        File jobXMLFile = new File(JOB_XML_PATH, id + ".xml");
        if (!jobXMLFile.exists()) {
            throw new BatchContainerRuntimeException("The file: " + jobXMLFile + " doesn't exist");
        }
        StreamSource strSource = new StreamSource(jobXMLFile);
        strSource.setSystemId(jobXMLFile);
        try {
            fileURL = jobXMLFile.toURI().toURL();
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.jbatch.container.services.impl.DirectoryJobXMLLoaderServiceImpl", (String)"70", null, (Object[])new Object[]{dir, id});
            throw new BatchContainerRuntimeException("Exception converting file to URL", (Throwable)e);
        }
        return new JobXMLSource(fileURL, strSource);
    }

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DirectoryJobXMLLoaderServiceImpl.class);
        CLASSNAME = DirectoryJobXMLLoaderServiceImpl.class.getName();
        JOB_XML_PATH = System.getProperty(JOB_XML_DIR_PROP);
    }
}

