/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.osgi.locator.activator;

import java.util.ArrayList;
import java.util.List;
import org.apache.yoko.osgi.locator.BundleProviderLoader;
import org.apache.yoko.osgi.locator.PackageProvider;
import org.apache.yoko.osgi.locator.Register;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class AbstractBundleActivator
implements BundleActivator {
    private static final Info[] NO_INFO = new Info[0];
    private final Info[] providerInfo;
    private final Info[] serviceInfo;
    private final String[] providedPackages;
    private ServiceTracker<Register, Register> tracker;
    private BundleContext context;
    private boolean registered;
    private final List<BundleProviderLoader> providerLoaders = new ArrayList<BundleProviderLoader>();
    private final List<BundleProviderLoader> serviceLoaders = new ArrayList<BundleProviderLoader>();
    private PackageProvider packageProvider;

    protected AbstractBundleActivator(Info[] providerInfo, Info[] serviceInfo, String ... providedPackages) {
        this.providerInfo = providerInfo;
        this.serviceInfo = serviceInfo;
        this.providedPackages = providedPackages;
    }

    protected AbstractBundleActivator(String ... providedPackages) {
        this(NO_INFO, NO_INFO, providedPackages);
    }

    public void start(final BundleContext context) throws Exception {
        this.context = context;
        this.tracker = new ServiceTracker(context, Register.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Register, Register>(){

            public Register addingService(ServiceReference<Register> reference) {
                Register register = (Register)context.getService(reference);
                AbstractBundleActivator.this.register(register);
                return register;
            }

            public void modifiedService(ServiceReference<Register> reference, Register service) {
            }

            public void removedService(ServiceReference<Register> reference, Register service) {
            }
        });
        this.tracker.open();
        Register register = (Register)this.tracker.getService();
        if (register != null) {
            this.register(register);
        }
    }

    private synchronized void register(Register register) {
        if (!this.registered) {
            BundleProviderLoader loader;
            this.registered = true;
            Bundle bundle = this.context.getBundle();
            for (Info classInfo : this.providerInfo) {
                loader = new BundleProviderLoader(classInfo.id, classInfo.className, bundle, classInfo.priority);
                this.providerLoaders.add(loader);
                register.registerProvider(loader);
            }
            for (Info classInfo : this.serviceInfo) {
                loader = new BundleProviderLoader(classInfo.id, classInfo.className, bundle, classInfo.priority);
                this.serviceLoaders.add(loader);
                register.registerService(loader);
            }
            if (this.providedPackages.length > 0) {
                this.packageProvider = new PackageProvider(bundle, this.providedPackages);
                register.registerPackages(this.packageProvider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        Register register = (Register)this.tracker.getService();
        this.tracker.close();
        AbstractBundleActivator abstractBundleActivator = this;
        synchronized (abstractBundleActivator) {
            if (register != null && this.registered) {
                for (BundleProviderLoader loader : this.providerLoaders) {
                    register.unregisterProvider(loader);
                }
                for (BundleProviderLoader loader : this.serviceLoaders) {
                    register.unregisterService(loader);
                }
                if (this.packageProvider != null) {
                    register.unregisterPackages(this.packageProvider);
                }
            }
        }
    }

    public static class Info {
        final String id;
        final String className;
        final int priority;

        public Info(String id, String className, int priority) {
            this.id = id;
            this.className = className;
            this.priority = priority;
        }
    }
}

