/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.osgi.locator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.osgi.ProviderLocator;
import org.apache.yoko.osgi.ProviderRegistry;
import org.apache.yoko.osgi.locator.BundleProviderLoader;
import org.apache.yoko.osgi.locator.PackageProvider;
import org.apache.yoko.osgi.locator.Register;

public class ProviderRegistryImpl
implements ProviderRegistry,
Register {
    private static final Logger log = Logger.getLogger(ProviderRegistryImpl.class.getName());
    private SPIRegistry providers = new SPIRegistry();
    private SPIRegistry serviceProviders = new SPIRegistry();
    private final ConcurrentHashMap<String, PackageProvider> packageProviders = new ConcurrentHashMap();

    public void start() {
        ProviderLocator.setRegistry(this);
    }

    public void stop() {
        ProviderLocator.setRegistry(null);
    }

    @Override
    public void registerProvider(BundleProviderLoader provider) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "registering provider " + provider);
        }
        this.providers.register(provider);
    }

    @Override
    public void unregisterProvider(BundleProviderLoader provider) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "unregistering provider " + provider);
        }
        this.providers.unregister(provider);
    }

    @Override
    public void registerService(BundleProviderLoader provider) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "registering service " + provider);
        }
        this.serviceProviders.register(provider);
    }

    @Override
    public void unregisterService(BundleProviderLoader provider) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "unregistering service " + provider);
        }
        this.serviceProviders.unregister(provider);
    }

    @Override
    public void registerPackages(PackageProvider provider) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("registering package provider: " + provider);
        }
        for (String name : provider.getRegisteredPackageNames()) {
            PackageProvider oldProvider = this.packageProviders.put(name, provider);
            if (oldProvider == null) continue;
            log.warning(String.format("Replaced provider for package %s: was %s, but now %s", name, oldProvider, provider));
        }
    }

    @Override
    public void unregisterPackages(PackageProvider provider) {
        for (String name : provider.getRegisteredPackageNames()) {
            this.packageProviders.remove(name, provider);
        }
    }

    @Override
    public Class<?> locate(String providerId) {
        String packageName;
        PackageProvider provider;
        BundleProviderLoader loader = this.providers.getLoader(providerId);
        if (loader != null) {
            try {
                return loader.loadClass();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((provider = this.packageProviders.get(packageName = PackageProvider.packageName(providerId))) == null) {
            return null;
        }
        return provider.loadClass(providerId);
    }

    @Override
    public Object getService(String providerId) throws Exception {
        BundleProviderLoader loader = this.serviceProviders.getLoader(providerId);
        if (loader != null) {
            return loader.createInstance();
        }
        return null;
    }

    @Override
    public List<Object> getServices(String providerId) {
        ArrayList<Object> instances = new ArrayList<Object>();
        List l = this.serviceProviders.getLoaders(providerId);
        if (l != null) {
            for (BundleProviderLoader c : l) {
                try {
                    instances.add(c.createInstance());
                }
                catch (Exception exception) {}
            }
        }
        return instances;
    }

    @Override
    public List<Class<?>> getServiceClasses(String providerId) {
        ArrayList classes = new ArrayList();
        List l = this.serviceProviders.getLoaders(providerId);
        if (l != null) {
            for (BundleProviderLoader c : l) {
                try {
                    classes.add(c.loadClass());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return classes;
    }

    @Override
    public Class<?> getServiceClass(String providerId) throws ClassNotFoundException {
        BundleProviderLoader loader = this.serviceProviders.getLoader(providerId);
        if (loader != null) {
            return loader.loadClass();
        }
        return null;
    }

    private class SPIRegistry {
        private Map<String, List<BundleProviderLoader>> registry;

        private SPIRegistry() {
        }

        public synchronized void register(BundleProviderLoader provider) {
            String providerId;
            List<BundleProviderLoader> l;
            if (this.registry == null) {
                this.registry = new HashMap<String, List<BundleProviderLoader>>();
            }
            if ((l = this.registry.get(providerId = provider.id())) == null) {
                l = new ArrayList<BundleProviderLoader>(2);
                this.registry.put(providerId, l);
            }
            l.add(provider);
            Collections.sort(l);
        }

        public synchronized void unregister(BundleProviderLoader provider) {
            List<BundleProviderLoader> l;
            if (this.registry != null && (l = this.registry.get(provider.id())) != null) {
                l.remove(provider);
            }
        }

        private synchronized BundleProviderLoader getLoader(String id) {
            if (this.registry != null) {
                List<BundleProviderLoader> list;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("registry: " + this.registry);
                }
                if ((list = this.registry.get(id)) != null && !list.isEmpty()) {
                    return list.get(0);
                }
            }
            return null;
        }

        private synchronized List<BundleProviderLoader> getLoaders(String id) {
            List<BundleProviderLoader> list;
            if (this.registry != null && (list = this.registry.get(id)) != null && !list.isEmpty()) {
                return new ArrayList<BundleProviderLoader>(list);
            }
            return null;
        }
    }
}

