/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.client;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.bus.LibertyApplicationBus;
import com.ibm.ws.jaxrs20.client.bus.LibertyJAXRSClientBusFactory;
import com.ibm.ws.jaxrs20.client.configuration.LibertyJaxRsClientProxyInterceptor;
import com.ibm.ws.jaxrs20.client.configuration.LibertyJaxRsClientTimeOutInterceptor;
import com.ibm.ws.jaxrs20.client.security.LibertyJaxRsClientSSLOutInterceptor;
import com.ibm.ws.jaxrs20.client.security.ltpa.LibertyJaxRsClientLtpaInterceptor;
import com.ibm.ws.jaxrs20.client.security.oauth.LibertyJaxRsClientOAuthInterceptor;
import com.ibm.ws.jaxrs20.client.security.saml.PropagationHandler;
import com.ibm.ws.jaxrs20.client.util.JaxRSClientUtil;
import com.ibm.ws.jaxrs20.providers.api.JaxRsProviderRegister;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.client.spec.ClientImpl;
import org.apache.cxf.jaxrs.client.spec.TLSConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JAXRSClientImpl
extends ClientImpl {
    private static final TraceComponent tc = Tr.register(JAXRSClientImpl.class);
    protected final AtomicBoolean closed;
    protected Set<WebClient> baseClients;
    protected boolean hasSSLConfigInfo;
    private TLSConfiguration secConfig;
    private static final Map<String, LibertyApplicationBus> busCache = new ConcurrentHashMap<String, LibertyApplicationBus>();
    private static final Map<String, List<JAXRSClientImpl>> clientsPerModule = new HashMap<String, List<JAXRSClientImpl>>();
    static final long serialVersionUID = -1008304864695338806L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public JAXRSClientImpl(Configuration config, TLSConfiguration secConfig) {
        block9: {
            super(config, secConfig);
            this.closed = new AtomicBoolean(false);
            this.baseClients = Collections.newSetFromMap(new WeakHashMap());
            this.hasSSLConfigInfo = false;
            this.secConfig = null;
            this.secConfig = secConfig;
            TLSClientParameters ttClientParams = secConfig.getTlsClientParams();
            if (secConfig.getSslContext() != null || ttClientParams.getTrustManagers() != null && ttClientParams.getTrustManagers().length > 0 && ttClientParams.getKeyManagers() != null && ttClientParams.getKeyManagers().length > 0) {
                this.hasSSLConfigInfo = true;
            }
            try {
                final BundleContext bc = AccessController.doPrivileged(new PrivilegedExceptionAction<BundleContext>(){
                    static final long serialVersionUID = 8581728577506525843L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public BundleContext run() throws Exception {
                        Bundle b = FrameworkUtil.getBundle(JAXRSClientImpl.class);
                        return b == null ? null : b.getBundleContext();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                });
                if (bc != null) {
                    final ArrayList providers = new ArrayList();
                    final Set features = Collections.emptySet();
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){
                        static final long serialVersionUID = 3979451387488944876L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public Void run() throws Exception {
                            Collection refs = bc.getServiceReferences(JaxRsProviderRegister.class, null);
                            for (ServiceReference ref : refs) {
                                JaxRsProviderRegister providerRegister = (JaxRsProviderRegister)bc.getService(ref);
                                try {
                                    providerRegister.installProvider(true, providers, features);
                                }
                                catch (Throwable throwable) {
                                    void t;
                                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jaxrs20.client.JAXRSClientImpl$2", (String)"120", (Object)this, (Object[])new Object[0]);
                                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                    String providerRegisterBundleLoc = ref.getBundle() == null ? "unknown" : ref.getBundle().getSymbolicName() + " " + ref.getBundle().getVersion();
                                    Tr.debug((TraceComponent)tc, (String)("<init> failed to install providers from " + providerRegister.getClass().getName() + " loaded from " + providerRegisterBundleLoc), (Object[])new Object[]{t});
                                }
                            }
                            return null;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(2.class);
                        }
                    });
                    for (Object provider : providers) {
                        if (provider == null) continue;
                        this.register(provider);
                    }
                }
            }
            catch (Exception bc) {
                void ex;
                FFDCFilter.processException((Throwable)bc, (String)"com.ibm.ws.jaxrs20.client.JAXRSClientImpl", (String)"140", (Object)((Object)this), (Object[])new Object[]{config, secConfig});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                Tr.debug((TraceComponent)tc, (String)"<init> failed to find and install declared providers ", (Object[])new Object[]{ex});
            }
        }
        String moduleName = this.getModuleName();
        Map<String, List<JAXRSClientImpl>> map = clientsPerModule;
        synchronized (map) {
            List<JAXRSClientImpl> clients = clientsPerModule.get(moduleName);
            if (clients == null) {
                clients = new ArrayList<JAXRSClientImpl>();
                clientsPerModule.put(moduleName, clients);
            }
            clients.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebTarget target(UriBuilder builder) {
        LibertyApplicationBus bus;
        this.checkClosed();
        ClientImpl.WebTargetImpl wt = (ClientImpl.WebTargetImpl)super.target(builder);
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        URI uri = builder.build(new Object[0]);
        bean.setAddress(uri.toString());
        WebClient targetClient = bean.createWebClient();
        ClientConfiguration ccfg = WebClient.getConfig((Object)targetClient);
        ccfg.getOutInterceptors().add(new LibertyJaxRsClientTimeOutInterceptor("pre-logical"));
        ccfg.getOutInterceptors().add(new LibertyJaxRsClientProxyInterceptor("pre-logical"));
        ccfg.getOutInterceptors().add(new LibertyJaxRsClientLtpaInterceptor());
        ccfg.getOutInterceptors().add(new LibertyJaxRsClientOAuthInterceptor());
        ccfg.getOutInterceptors().add(new PropagationHandler());
        if (!this.hasSSLConfigInfo) {
            LibertyJaxRsClientSSLOutInterceptor sslOutInterceptor = new LibertyJaxRsClientSSLOutInterceptor("pre-logical");
            sslOutInterceptor.setTLSConfiguration(this.secConfig);
            ccfg.getOutInterceptors().add(sslOutInterceptor);
        }
        String moduleName = this.getModuleName();
        String id = moduleName + JaxRSClientUtil.convertURItoBusId(uri.toString());
        Object object = busCache;
        synchronized (object) {
            bus = busCache.get(id);
            if (bus == null) {
                bus = LibertyJAXRSClientBusFactory.getInstance().getClientScopeBus(id);
                busCache.put(id, bus);
            }
        }
        ccfg.setBus((Bus)bus);
        object = this.baseClients;
        synchronized (object) {
            this.baseClients.add(targetClient);
        }
        return new ClientImpl.WebTargetImpl((ClientImpl)this, wt.getUriBuilder(), wt.getConfiguration(), targetClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            super.close();
            Set<WebClient> set = this.baseClients;
            synchronized (set) {
                for (WebClient wc : this.baseClients) {
                    wc.close();
                }
            }
            String moduleName = this.getModuleName();
            Map<String, List<JAXRSClientImpl>> map = clientsPerModule;
            synchronized (map) {
                List<JAXRSClientImpl> clients = clientsPerModule.get(moduleName);
                if (clients != null) {
                    clients.remove((Object)this);
                    if (clients.isEmpty()) {
                        for (String id : busCache.keySet()) {
                            if (!id.startsWith(moduleName) && !id.startsWith("unknown:")) continue;
                            busCache.remove(id).shutdown(false);
                        }
                        clientsPerModule.remove(moduleName);
                    }
                }
            }
            this.baseClients = null;
        }
    }

    public Map<String, LibertyApplicationBus> getBusCache() {
        return busCache;
    }

    public Client property(String name, @Sensitive Object value) {
        this.checkClosed();
        if ("com.ibm.ws.jaxrs.client.proxy.password".equals(name) && value != null && !(value instanceof ProtectedString)) {
            return super.property(name, (Object)new ProtectedString(value.toString().toCharArray()));
        }
        return super.property(name, value);
    }

    private String getModuleName() {
        ModuleMetaData mmd;
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cmd != null && (mmd = cmd.getModuleMetaData()) != null) {
            return mmd.getName() + ":";
        }
        return "unknown:";
    }

    private void checkClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("client is closed");
        }
    }
}

