/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bytebuffer.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.bytebuffer.internal.FCWsByteBufferImpl;
import com.ibm.ws.bytebuffer.internal.PooledWsByteBufferImpl;
import com.ibm.ws.bytebuffer.internal.RefCountWsByteBufferImpl;
import com.ibm.ws.bytebuffer.internal.WsBBConfigException;
import com.ibm.ws.bytebuffer.internal.WsByteBufferImpl;
import com.ibm.ws.bytebuffer.internal.WsByteBufferPool;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class WsByteBufferPoolManagerImpl
implements WsByteBufferPoolManager {
    private static final TraceComponent tc = Tr.register(WsByteBufferPoolManagerImpl.class, (String)"WsByteBuffer", (String)"com.ibm.ws.bytebuffer.internal.resources.ByteBufferMessages");
    private static int CONFIG_DEFAULT = -1;
    private static int MEMORY_LEAK_INTERVAL_MIN = 5;
    private static int MEMORY_LEAK_INTERVAL_MAX = 3600;
    private static int VALIDATE_OK = 0;
    private static int VALIDATE_ERROR = 1;
    private static WsByteBufferPoolManager instanceRef = null;
    private final AtomicReference<WsByteBufferPoolManager.DirectByteBufferHelper> directByteBufferHelper;
    private WsByteBufferPool[] pools = null;
    private WsByteBufferPool[] poolsDirect = null;
    private int[] poolSizes = null;
    private static int[] defaultPoolSizes = new int[]{32, 1024, 8192, 16384, 24576, 32768, 49152, 65536};
    private static int[] defaultPoolDepths = new int[]{30, 30, 30, 20, 20, 20, 10, 10};
    private static final String MEM_LEAK_INTERVAL = "memoryLeakDetectionInterval";
    private static final String MEM_LEAK_FILE = "memoryLeakOutputFile";
    private static final String TRUSTED_USERS = "trustedUsers";
    private static final String POOL_SIZES = "poolSizes";
    private static final String POOL_DEPTHS = "poolDepths";
    private static final String CLEAN_UP = "cleanUp";
    private static final String CONFIG_ALIAS = "bytebuffer";
    private boolean trustedUsers = false;
    private long lastTimeCheck = 0L;
    private int leakDetectionInterval = -1;
    private String leakDetectionOutput = null;
    private final Object leakDetectionSyncObject = new Object(){};
    protected boolean cleanUpOld = false;

    public WsByteBufferPoolManagerImpl(AtomicReference<WsByteBufferPoolManager.DirectByteBufferHelper> directByteBufferHelper, Map<String, Object> properties) throws WsBBConfigException {
        WsBBConfigException e;
        this.directByteBufferHelper = directByteBufferHelper;
        String key = null;
        Object value = null;
        int result = VALIDATE_OK;
        int leakInterval = -1;
        String leakFile = "";
        int[] sizes = null;
        int[] depths = null;
        try {
            for (Map.Entry<String, Object> prop : properties.entrySet()) {
                if (result == VALIDATE_OK) {
                    key = prop.getKey();
                    value = prop.getValue();
                    if (key.startsWith("service.") || key.startsWith("component.") || key.startsWith("config.") || key.startsWith("parentPid") || key.startsWith("id")) continue;
                    if (null == value) {
                        result = VALIDATE_ERROR;
                        continue;
                    }
                    if (key.equalsIgnoreCase(MEM_LEAK_INTERVAL)) {
                        result = this.testMemoryLeakDetectionInterval(leakInterval = MetatypeUtils.parseInteger((Object)CONFIG_ALIAS, (String)MEM_LEAK_INTERVAL, (Object)value, (int)leakInterval));
                        if (result != VALIDATE_OK) continue;
                        leakInterval *= 1000;
                        continue;
                    }
                    if (key.equalsIgnoreCase(MEM_LEAK_FILE)) {
                        leakFile = (String)value;
                        continue;
                    }
                    if (key.equalsIgnoreCase(TRUSTED_USERS)) {
                        this.trustedUsers = MetatypeUtils.parseBoolean((Object)CONFIG_ALIAS, (String)MEM_LEAK_INTERVAL, (Object)value, (boolean)this.trustedUsers);
                        continue;
                    }
                    if (key.equalsIgnoreCase(POOL_SIZES)) {
                        sizes = MetatypeUtils.parseIntegerArray((Object)CONFIG_ALIAS, (String)POOL_SIZES, (Object)value, sizes);
                        continue;
                    }
                    if (key.equalsIgnoreCase(POOL_DEPTHS)) {
                        depths = MetatypeUtils.parseIntegerArray((Object)CONFIG_ALIAS, (String)POOL_DEPTHS, (Object)value, depths);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CLEAN_UP)) {
                        this.cleanUpOld = MetatypeUtils.parseBoolean((Object)CONFIG_ALIAS, (String)CLEAN_UP, (Object)value, (boolean)this.cleanUpOld);
                        continue;
                    }
                    Tr.warning((TraceComponent)tc, (String)"UNRECOGNIZED_CUSTOM_PROPERTY", (Object[])new Object[]{key});
                    continue;
                }
                break;
            }
        }
        catch (NumberFormatException x) {
            Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NUMBER_EXCEPTION", (Object[])new Object[]{key, value});
            WsBBConfigException e2 = new WsBBConfigException("NumberFormatException processing name: " + key + " value: " + value, x);
            FFDCFilter.processException((Throwable)e2, (String)this.getClass().getName(), (String)"102", (Object)this);
            throw e2;
        }
        if (result != VALIDATE_OK) {
            Tr.error((TraceComponent)tc, (String)"NOT_VALID_CUSTOM_PROPERTY", (Object[])new Object[]{key, value});
            e = new WsBBConfigException("Property has a value that is not valid, name: " + key + " value: [" + value + "]");
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"103", (Object)this);
            throw e;
        }
        if (leakInterval != -1) {
            if (leakFile != null && 0 != leakFile.length()) {
                try {
                    this.setLeakDetectionSettings(leakInterval, leakFile);
                }
                catch (IOException x) {
                    Tr.error((TraceComponent)tc, (String)"NOT_VALID_CUSTOM_PROPERTY", (Object[])new Object[]{MEM_LEAK_FILE, leakFile});
                    WsBBConfigException e3 = new WsBBConfigException("Error with leak detection file, memoryLeakOutputFile=[" + leakFile + "]", x);
                    FFDCFilter.processException((Throwable)e3, (String)this.getClass().getName(), (String)"104", (Object)this);
                    throw e3;
                }
            } else {
                Tr.error((TraceComponent)tc, (String)"NOT_VALID_CUSTOM_PROPERTY", (Object[])new Object[]{MEM_LEAK_FILE, "null"});
                e = new WsBBConfigException("Leak interval set without an output file");
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"105", (Object)this);
                throw e;
            }
        }
        if (sizes == null || depths == null) {
            this.initialize(defaultPoolSizes, defaultPoolDepths);
        } else {
            if (sizes.length != depths.length) {
                Tr.error((TraceComponent)tc, (String)"POOL_MISMATCH", (Object[])new Object[]{sizes, depths});
                e = new WsBBConfigException("Mismatch in pool sizes (" + sizes.length + ") and depths(" + depths.length + ")");
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"106", (Object)this);
                throw e;
            }
            this.initialize(sizes, depths);
        }
        instanceRef = this;
    }

    public WsByteBufferPoolManagerImpl(AtomicReference<WsByteBufferPoolManager.DirectByteBufferHelper> directByteBufferHelper) throws WsBBConfigException {
        this(directByteBufferHelper, new HashMap<String, Object>());
    }

    public static WsByteBufferPoolManager getRef() {
        if (instanceRef == null) {
            return DefaultPoolHolder.defaultInstance;
        }
        return instanceRef;
    }

    public void initialize(int[] bufferEntrySizes, int[] bufferEntryDepths) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object[])new Object[0]);
        }
        int len = bufferEntrySizes.length;
        int[] bSizes = new int[len];
        int[] bDepths = new int[len];
        for (int i = 0; i < len; ++i) {
            int j;
            int sizeCompare = bufferEntrySizes[i];
            int depth = bufferEntryDepths[i];
            for (j = i - 1; j >= 0; --j) {
                int sizeSort = bSizes[j];
                if (sizeCompare > sizeSort) {
                    bSizes[j + 1] = sizeCompare;
                    bDepths[j + 1] = depth;
                    break;
                }
                bSizes[j + 1] = sizeSort;
                bDepths[j + 1] = bDepths[j];
            }
            if (j >= 0) continue;
            bSizes[0] = sizeCompare;
            bDepths[0] = depth;
        }
        boolean tracking = this.trackingBuffers();
        this.pools = new WsByteBufferPool[len];
        this.poolsDirect = new WsByteBufferPool[len];
        this.poolSizes = new int[len];
        for (int i = 0; i < len; ++i) {
            this.pools[i] = new WsByteBufferPool(bSizes[i], bDepths[i], bDepths[i] * 10, tracking, false, this.cleanUpOld);
            this.poolsDirect[i] = new WsByteBufferPool(bSizes[i], bDepths[i], bDepths[i] * 10, tracking, true, this.cleanUpOld);
            this.poolSizes[i] = bSizes[i];
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Number of pools created: " + this.poolSizes.length), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void setLeakDetectionSettings(int interval, String output) throws IOException {
        this.leakDetectionInterval = interval;
        this.leakDetectionOutput = TrConfigurator.getLogLocation() + File.separator + output;
        if (interval > -1 && output != null) {
            FileWriter outFile = new FileWriter(this.leakDetectionOutput, false);
            outFile.close();
        }
    }

    private int testMemoryLeakDetectionInterval(int value) {
        if (value == CONFIG_DEFAULT) {
            return VALIDATE_OK;
        }
        if (value < MEMORY_LEAK_INTERVAL_MIN || value > MEMORY_LEAK_INTERVAL_MAX) {
            return VALIDATE_ERROR;
        }
        return VALIDATE_OK;
    }

    private boolean trackingBuffers() {
        return this.leakDetectionInterval > -1;
    }

    public int getLeakDetectionInterval() {
        return this.leakDetectionInterval;
    }

    public Object getLeakDetectionSyncObject() {
        return this.leakDetectionSyncObject;
    }

    @Override
    public WsByteBuffer allocate(int entrySize) {
        return this.allocateCommon(entrySize, false);
    }

    @Override
    public WsByteBuffer allocateDirect(int entrySize) {
        return this.allocateCommon(entrySize, true);
    }

    @Override
    public WsByteBuffer allocateFileChannelBuffer(FileChannel fc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"allocateFileChannelBuffer", (Object[])new Object[0]);
        }
        return new FCWsByteBufferImpl(fc);
    }

    public WsByteBuffer allocateCommon(int entrySize, boolean direct) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("allocateCommon: " + entrySize), (Object[])new Object[0]);
        }
        if (this.trackingBuffers()) {
            this.lookForLeaks(false);
        }
        for (int i = 0; i < this.poolSizes.length; ++i) {
            ByteBuffer bytebufferFromPool = null;
            int intPoolSize = this.poolSizes[i];
            if (entrySize > intPoolSize) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("found a pool of size: " + intPoolSize), (Object[])new Object[0]);
            }
            WsByteBufferPool oWsByteBufferPool = null;
            oWsByteBufferPool = direct ? this.poolsDirect[i] : this.pools[i];
            PooledWsByteBufferImpl pooledWSBB = oWsByteBufferPool.getEntry();
            pooledWSBB.resetReleaseCalled();
            bytebufferFromPool = pooledWSBB.getWrappedByteBufferNonSafe();
            if (bytebufferFromPool == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"no ByteBuffer so alloc a new one", (Object[])new Object[0]);
                }
                if (direct) {
                    this.allocateBufferDirect(pooledWSBB, intPoolSize, false);
                    pooledWSBB.setIsDirectPool(true);
                } else {
                    bytebufferFromPool = ByteBuffer.allocate(intPoolSize);
                    pooledWSBB.setIsDirectPool(false);
                    pooledWSBB.setByteBufferNonSafe(bytebufferFromPool);
                }
                pooledWSBB.pool = oWsByteBufferPool;
                pooledWSBB.setPoolManagerRef(this);
            } else {
                bytebufferFromPool.clear();
                bytebufferFromPool.order(ByteOrder.BIG_ENDIAN);
                pooledWSBB.intReferenceCount = 1;
                pooledWSBB.getMin = -1;
                pooledWSBB.getMax = -1;
                pooledWSBB.putMin = -1;
                pooledWSBB.putMax = -1;
                pooledWSBB.readMin = -1;
                pooledWSBB.readMax = -1;
                pooledWSBB.actionState = 0;
                pooledWSBB.quickBufferAction = 0;
            }
            pooledWSBB.limit(entrySize);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() || this.trackingBuffers()) {
                Throwable t = new Throwable();
                StackTraceElement[] ste = t.getStackTrace();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    if (ste.length >= 3) {
                        Tr.debug((TraceComponent)tc, (String)("BUFFER OBTAINED: Allocate: Calling Element: " + ste[2] + " Main ID: " + pooledWSBB.getID()), (Object[])new Object[0]);
                    }
                    Tr.debug((TraceComponent)tc, (String)("Buffer allocated: " + pooledWSBB), (Object[])new Object[0]);
                }
                if (this.trackingBuffers()) {
                    String sEntry = this.fillOutStackTrace(" (Allocate) ", ste);
                    pooledWSBB.setOwnerID(sEntry);
                    pooledWSBB.addWsByteBuffer(pooledWSBB);
                    pooledWSBB.addOwner(pooledWSBB.getOwnerID());
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"allocateCommon");
            }
            return pooledWSBB;
        }
        WsByteBufferImpl buffer = new WsByteBufferImpl();
        if (direct) {
            buffer = this.allocateBufferDirect(buffer, entrySize, true);
        } else {
            buffer.setByteBufferNonSafe(ByteBuffer.allocate(entrySize));
        }
        buffer.setPoolManagerRef(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Buffer allocated: " + buffer), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"allocateCommon");
        }
        return buffer;
    }

    protected WsByteBufferImpl allocateBufferDirect(WsByteBufferImpl buffer, int size, boolean overrideRefCount) {
        WsByteBufferPoolManager.DirectByteBufferHelper directByteBufferHelper = this.directByteBufferHelper.get();
        ByteBuffer byteBuffer = directByteBufferHelper != null ? directByteBufferHelper.allocateDirectByteBuffer(size) : ByteBuffer.allocateDirect(size);
        buffer.setByteBufferNonSafe(byteBuffer);
        return buffer;
    }

    @Override
    public WsByteBuffer wrap(byte[] array) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"wrap", (Object[])new Object[0]);
        }
        WsByteBufferImpl buffer = new WsByteBufferImpl();
        buffer.setByteBuffer(ByteBuffer.wrap(array));
        buffer.setPoolManagerRef(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"wrap");
        }
        return buffer;
    }

    @Override
    public WsByteBuffer wrap(byte[] array, int offset, int length) throws IndexOutOfBoundsException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("wrap(byte[], int, int): offset= " + offset + ", length= " + length), (Object[])new Object[0]);
        }
        WsByteBufferImpl buffer = new WsByteBufferImpl();
        buffer.setByteBuffer(ByteBuffer.wrap(array, offset, length));
        buffer.setPoolManagerRef(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"wrap(byte[], int, int)");
        }
        return buffer;
    }

    public void release(PooledWsByteBufferImpl buffer, boolean isDirectPool, WsByteBufferPool pool) {
        pool.release(buffer, buffer.getID());
    }

    protected void releasing(ByteBuffer buffer) {
        WsByteBufferPoolManager.DirectByteBufferHelper directByteBufferHelper;
        if (buffer != null && buffer.isDirect() && (directByteBufferHelper = this.directByteBufferHelper.get()) != null) {
            directByteBufferHelper.releaseDirectByteBuffer(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WsByteBuffer duplicate(WsByteBuffer buffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"duplicate", (Object[])new Object[0]);
        }
        if (this.trackingBuffers()) {
            this.lookForLeaks(false);
        }
        WsByteBufferImpl newBuffer = new WsByteBufferImpl();
        WsByteBufferImpl srcBuffer = (WsByteBufferImpl)buffer;
        newBuffer.setPoolManagerRef(this);
        PooledWsByteBufferImpl bRoot = srcBuffer.getWsBBRoot();
        if (bRoot != null) {
            newBuffer.setWsBBRoot(bRoot);
            PooledWsByteBufferImpl pooledWsByteBufferImpl = bRoot;
            synchronized (pooledWsByteBufferImpl) {
                ++bRoot.intReferenceCount;
            }
        }
        RefCountWsByteBufferImpl rRoot = srcBuffer.getWsBBRefRoot();
        if (rRoot != null) {
            newBuffer.setWsBBRefRoot(rRoot);
            RefCountWsByteBufferImpl refCountWsByteBufferImpl = rRoot;
            synchronized (refCountWsByteBufferImpl) {
                ++rRoot.intReferenceCount;
            }
        }
        srcBuffer.updateDuplicate(newBuffer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() || this.trackingBuffers()) {
            Throwable t = new Throwable();
            StackTraceElement[] ste = t.getStackTrace();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && ste.length >= 3) {
                if (srcBuffer.getWsBBRoot() == null || srcBuffer.getWsBBRoot().pool == null) {
                    Tr.debug((TraceComponent)tc, (String)("BUFFER OBTAINED: Duplicate: Calling Element: " + ste[2] + " Main ID: none"), (Object[])new Object[0]);
                } else {
                    Tr.debug((TraceComponent)tc, (String)("BUFFER OBTAINED: Duplicate: Calling Element: " + ste[2] + " Main ID: " + srcBuffer.getWsBBRoot().getID()), (Object[])new Object[0]);
                }
            }
            if (this.trackingBuffers()) {
                String sEntry = this.fillOutStackTrace(" (Duplicate) ", ste);
                newBuffer.setOwnerID(sEntry);
            }
            if (newBuffer.getWsBBRoot() != null && newBuffer.getWsBBRoot().pool != null && this.trackingBuffers()) {
                newBuffer.getWsBBRoot().addWsByteBuffer(newBuffer);
                newBuffer.getWsBBRoot().owners.put(newBuffer.getOwnerID(), newBuffer.getOwnerID());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"duplicate");
        }
        return newBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WsByteBuffer slice(WsByteBuffer buffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"slice", (Object[])new Object[0]);
        }
        if (this.trackingBuffers()) {
            this.lookForLeaks(false);
        }
        WsByteBufferImpl newBuffer = new WsByteBufferImpl();
        WsByteBufferImpl srcBuffer = (WsByteBufferImpl)buffer;
        newBuffer.setPoolManagerRef(this);
        PooledWsByteBufferImpl bRoot = srcBuffer.getWsBBRoot();
        if (bRoot != null) {
            newBuffer.setWsBBRoot(bRoot);
            PooledWsByteBufferImpl pooledWsByteBufferImpl = bRoot;
            synchronized (pooledWsByteBufferImpl) {
                ++bRoot.intReferenceCount;
            }
        }
        RefCountWsByteBufferImpl rRoot = srcBuffer.getWsBBRefRoot();
        if (rRoot != null) {
            newBuffer.setWsBBRefRoot(rRoot);
            RefCountWsByteBufferImpl refCountWsByteBufferImpl = rRoot;
            synchronized (refCountWsByteBufferImpl) {
                ++rRoot.intReferenceCount;
            }
        }
        srcBuffer.updateSlice(newBuffer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() || this.trackingBuffers()) {
            Throwable t = new Throwable();
            StackTraceElement[] ste = t.getStackTrace();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && ste.length >= 3) {
                if (srcBuffer.getWsBBRoot() == null || srcBuffer.getWsBBRoot().pool == null) {
                    Tr.debug((TraceComponent)tc, (String)("BUFFER OBTAINED: Slice: Calling Element: " + ste[2] + " Main ID: none"), (Object[])new Object[0]);
                } else {
                    Tr.debug((TraceComponent)tc, (String)("BUFFER OBTAINED: Slice: Calling Element: " + ste[2] + " Main ID: " + srcBuffer.getWsBBRoot().getID()), (Object[])new Object[0]);
                }
            }
            if (this.trackingBuffers()) {
                String sEntry = this.fillOutStackTrace(" (Slice) ", ste);
                newBuffer.setOwnerID(sEntry);
            }
            if (newBuffer.getWsBBRoot() != null && newBuffer.getWsBBRoot().pool != null && this.trackingBuffers()) {
                newBuffer.getWsBBRoot().addWsByteBuffer(newBuffer);
                newBuffer.getWsBBRoot().owners.put(newBuffer.getOwnerID(), newBuffer.getOwnerID());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"slice");
        }
        return newBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lookForLeaks(boolean force) {
        if (this.leakDetectionInterval < -1) {
            return;
        }
        Object object = this.leakDetectionSyncObject;
        synchronized (object) {
            try {
                FileWriter outFile2;
                String sOutput;
                Hashtable possibleLeakers;
                PooledWsByteBufferImpl x;
                int j;
                Object[] buffers;
                WsByteBufferImpl buffer2;
                int i;
                long now = System.currentTimeMillis();
                if (!force) {
                    if (this.lastTimeCheck == 0L) {
                        this.lastTimeCheck = now;
                        return;
                    }
                    if (now - this.lastTimeCheck < (long)this.getLeakDetectionInterval()) {
                        return;
                    }
                }
                this.lastTimeCheck = now;
                int iterIndex = 1;
                for (i = 0; i < this.poolSizes.length; ++i) {
                    buffer2 = null;
                    buffers = this.pools[i].getInUse();
                    if (buffers == null) continue;
                    for (j = 0; j < buffers.length; ++j) {
                        x = (PooledWsByteBufferImpl)buffers[j];
                        if (x.getallBuffers() == null) continue;
                        possibleLeakers = (Hashtable)x.getallBuffers().clone();
                        for (WsByteBufferImpl buffer2 : possibleLeakers.values()) {
                            if (now - buffer2.getLastAccessTime() <= (long)this.getLeakDetectionInterval()) continue;
                            sOutput = iterIndex + " Possible Leak Entry: Buffer ID - " + x.getID() + "\nNon-Direct Buffer Pool\n" + x.toString(buffer2.getOwnerID());
                            try {
                                outFile2 = new FileWriter(this.leakDetectionOutput, true);
                                if (iterIndex == 1) {
                                    outFile2.write("\n\n\n****  " + new Date() + "  ***\n");
                                } else {
                                    outFile2.write("\n----------\n");
                                }
                                outFile2.write(sOutput);
                                outFile2.close();
                            }
                            catch (IOException outFile2) {
                                // empty catch block
                            }
                            ++iterIndex;
                        }
                    }
                }
                for (i = 0; i < this.poolSizes.length; ++i) {
                    buffer2 = null;
                    buffers = this.poolsDirect[i].getInUse();
                    if (buffers == null) continue;
                    for (j = 0; j < buffers.length; ++j) {
                        x = (PooledWsByteBufferImpl)buffers[j];
                        if (x.getallBuffers() == null) continue;
                        possibleLeakers = (Hashtable)x.getallBuffers().clone();
                        for (WsByteBufferImpl buffer2 : possibleLeakers.values()) {
                            if (now - buffer2.getLastAccessTime() <= (long)this.getLeakDetectionInterval()) continue;
                            sOutput = iterIndex + " Possible Leak Entry: Buffer ID - " + x.getID() + "\nDirect Buffer Pool\n" + x.toString(buffer2.getOwnerID());
                            try {
                                outFile2 = new FileWriter(this.leakDetectionOutput, true);
                                if (iterIndex == 1) {
                                    outFile2.write("\n\n\n****  " + new Date() + "  ***\n");
                                } else {
                                    outFile2.write("\n----------\n");
                                }
                                outFile2.write(sOutput);
                                outFile2.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            ++iterIndex;
                        }
                    }
                }
            }
            catch (NullPointerException xe) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WsByteBuffer Leak Detection Caught an NPE looking through the inUse tables", (Object[])new Object[0]);
                }
                RuntimeException re = new RuntimeException("WsByteBuffer Leak Detection Caught an NPE looking through the inUse table", xe);
                FFDCFilter.processException((Throwable)re, (String)this.getClass().getName(), (String)"932", (Object)this);
                throw re;
            }
        }
    }

    private String fillOutStackTrace(String starter, StackTraceElement[] _ste) {
        StringBuilder sb = new StringBuilder(starter);
        if (_ste.length >= 3) {
            for (int i = 2; i < _ste.length && i < 12; ++i) {
                sb.append("\n").append(_ste[i].toString());
            }
            return sb.toString();
        }
        for (int i = 0; i < _ste.length; ++i) {
            sb.append("\n").append(_ste[i].toString());
        }
        return sb.toString();
    }

    protected boolean isTrustedUsers() {
        return this.trustedUsers;
    }

    @Override
    public WsByteBuffer wrap(ByteBuffer buffer) {
        return this.wrap(buffer, false);
    }

    public WsByteBuffer wrap(ByteBuffer buffer, boolean doRefCount) {
        String methodName = "wrap(ByteBuffer, boolean)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"wrap(ByteBuffer, boolean)", (Object[])new Object[]{buffer, "doRefCount=" + doRefCount});
        }
        WsByteBufferImpl oWsByteBuffer = null;
        oWsByteBuffer = doRefCount ? new RefCountWsByteBufferImpl() : new WsByteBufferImpl();
        oWsByteBuffer.setByteBuffer(buffer);
        oWsByteBuffer.setPoolManagerRef(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"wrap(ByteBuffer, boolean)", (Object)oWsByteBuffer);
        }
        return oWsByteBuffer;
    }

    public void purgeThreadLocals() {
        for (int i = 0; i < this.poolSizes.length; ++i) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Purging the " + this.poolSizes[i] + " sized pools"), (Object[])new Object[0]);
            }
            this.pools[i].purgeThreadLocal();
            this.poolsDirect[i].purgeThreadLocal();
        }
    }

    private static class DefaultPoolHolder {
        static final WsByteBufferPoolManager defaultInstance;

        private DefaultPoolHolder() {
        }

        static {
            WsByteBufferPoolManagerImpl newInstance;
            try {
                newInstance = new WsByteBufferPoolManagerImpl(new AtomicReference<WsByteBufferPoolManager.DirectByteBufferHelper>());
            }
            catch (WsBBConfigException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Error constructing default instance", (Object[])new Object[]{e});
                }
                newInstance = null;
            }
            defaultInstance = newInstance;
        }
    }
}

