/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.cdi.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.AbstractAnnotationConfig;
import com.ibm.ws.microprofile.faulttolerance.spi.FaultToleranceProvider;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RetryConfig
extends AbstractAnnotationConfig<Retry>
implements Retry {
    private static final TraceComponent tc = Tr.register(RetryConfig.class);
    private final AbstractAnnotationConfig.AnnotationParameterConfig<Integer> maxRetriesConfig = this.getParameterConfig("maxRetries", Integer.class);
    private final AbstractAnnotationConfig.AnnotationParameterConfig<Long> delayConfig = this.getParameterConfig("delay", Long.class);
    private final AbstractAnnotationConfig.AnnotationParameterConfig<ChronoUnit> delayUnitConfig = this.getParameterConfig("delayUnit", ChronoUnit.class);
    private final AbstractAnnotationConfig.AnnotationParameterConfig<Long> maxDurationConfig = this.getParameterConfig("maxDuration", Long.class);
    private final AbstractAnnotationConfig.AnnotationParameterConfig<ChronoUnit> durationUnitConfig = this.getParameterConfig("durationUnit", ChronoUnit.class);
    private final AbstractAnnotationConfig.AnnotationParameterConfig<Long> jitterConfig = this.getParameterConfig("jitter", Long.class);
    private final AbstractAnnotationConfig.AnnotationParameterConfig<ChronoUnit> jitterDelayUnitConfig = this.getParameterConfig("jitterDelayUnit", ChronoUnit.class);
    private final AbstractAnnotationConfig.AnnotationParameterConfig<Class<? extends Throwable>[]> retryOnConfig = this.getParameterConfigClassArray("retryOn", Throwable.class);
    private final AbstractAnnotationConfig.AnnotationParameterConfig<Class<? extends Throwable>[]> abortOnConfig = this.getParameterConfigClassArray("abortOn", Throwable.class);
    static final long serialVersionUID = -7833188656836877757L;

    public RetryConfig(Class<?> annotatedClass, Retry annotation) {
        super(annotatedClass, annotation, Retry.class);
    }

    public RetryConfig(Method annotatedMethod, Class<?> annotatedClass, Retry annotation) {
        super(annotatedMethod, annotatedClass, annotation, Retry.class);
    }

    public int maxRetries() {
        return this.maxRetriesConfig.getValue();
    }

    public long delay() {
        return this.delayConfig.getValue();
    }

    public ChronoUnit delayUnit() {
        return this.delayUnitConfig.getValue();
    }

    public long maxDuration() {
        return this.maxDurationConfig.getValue();
    }

    public ChronoUnit durationUnit() {
        return this.durationUnitConfig.getValue();
    }

    public long jitter() {
        return this.jitterConfig.getValue();
    }

    public ChronoUnit jitterDelayUnit() {
        return this.jitterDelayUnitConfig.getValue();
    }

    public Class<? extends Throwable>[] retryOn() {
        return this.retryOnConfig.getValue();
    }

    public Class<? extends Throwable>[] abortOn() {
        return this.abortOnConfig.getValue();
    }

    @Override
    public void validate() {
        Duration jitter;
        Duration delay;
        Duration maxDuration;
        String target = this.getTargetName();
        if (this.maxRetries() < -1) {
            throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"retry.parameter.invalid.value.CWMFT5010E", (Object[])new Object[]{"maxRetries", this.maxRetries(), target, "-1"}));
        }
        if (this.delay() < 0L) {
            throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"retry.parameter.invalid.value.CWMFT5010E", (Object[])new Object[]{"delay", this.delay(), target, "0"}));
        }
        if (this.jitter() < 0L) {
            throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"retry.parameter.invalid.value.CWMFT5010E", (Object[])new Object[]{"jitter", this.jitter(), target, "0"}));
        }
        if (this.maxDuration() < 0L) {
            throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"retry.parameter.invalid.value.CWMFT5010E", (Object[])new Object[]{"maxDuration", this.maxDuration(), target, "0"}));
        }
        if (this.maxDuration() != 0L && (maxDuration = Duration.of(this.maxDuration(), this.durationUnit())).compareTo(delay = Duration.of(this.delay(), this.delayUnit())) < 0) {
            throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"retry.parameter.invalid.value.CWMFT5017E", (Object[])new Object[]{this.maxDuration(), this.durationUnit(), target, this.delay(), this.delayUnit()}));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled() && this.delay() != 0L && this.jitter() != 0L && (jitter = Duration.of(this.jitter(), this.jitterDelayUnit())).compareTo(delay = Duration.of(this.delay(), this.delayUnit())) >= 0) {
            Tr.warning((TraceComponent)tc, (String)"retry.parameter.invalid.value.CWMFT5019W", (Object[])new Object[]{this.jitter(), this.jitterDelayUnit(), target, this.delay(), this.delayUnit()});
        }
    }

    public RetryPolicy generatePolicy() {
        int maxRetries = this.maxRetries();
        Duration delay = Duration.of(this.delay(), this.delayUnit());
        Duration maxDuration = Duration.of(this.maxDuration(), this.durationUnit());
        Duration jitter = Duration.of(this.jitter(), this.jitterDelayUnit());
        Class[] retryOn = this.retryOn();
        Class[] abortOn = this.abortOn();
        RetryPolicy retryPolicy = FaultToleranceProvider.newRetryPolicy();
        retryPolicy.setMaxRetries(maxRetries);
        retryPolicy.setDelay(delay);
        retryPolicy.setMaxDuration(maxDuration);
        retryPolicy.setJitter(jitter);
        retryPolicy.setRetryOn(retryOn);
        retryPolicy.setAbortOn(abortOn);
        return retryPolicy;
    }
}

