/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.extension.WebSphereCDIExtension;
import com.ibm.ws.microprofile.faulttolerance.cdi.AnnotatedTypeWrapper;
import com.ibm.ws.microprofile.faulttolerance.cdi.FaultTolerance;
import com.ibm.ws.microprofile.faulttolerance.cdi.FaultToleranceInterceptor;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.AsynchronousConfig;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.BulkheadConfig;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.CircuitBreakerConfig;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.FTGlobalConfig;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.FallbackConfig;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.RetryConfig;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.TimeoutConfig;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={WebSphereCDIExtension.class}, immediate=true)
public class FaultToleranceCDIExtension
implements Extension,
WebSphereCDIExtension {
    private static final TraceComponent tc = Tr.register(FaultToleranceCDIExtension.class);
    static final long serialVersionUID = -8789528557999042495L;

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        AnnotatedType bindingType = beanManager.createAnnotatedType(FaultTolerance.class);
        beforeBeanDiscovery.addInterceptorBinding(bindingType);
        AnnotatedType interceptorType = beanManager.createAnnotatedType(FaultToleranceInterceptor.class);
        beforeBeanDiscovery.addAnnotatedType(interceptorType);
        AnnotatedType executorCleanup = beanManager.createAnnotatedType(FaultToleranceInterceptor.ExecutorCleanup.class);
        beforeBeanDiscovery.addAnnotatedType(executorCleanup);
    }

    public <T> void processAnnotatedType(@Observes @WithAnnotations(value={Asynchronous.class, Fallback.class, Timeout.class, CircuitBreaker.class, Retry.class, Bulkhead.class}) ProcessAnnotatedType<T> processAnnotatedType, BeanManager beanManager) {
        HashSet interceptedMethods = new HashSet();
        boolean interceptedClass = false;
        AsynchronousConfig classLevelAsync = null;
        AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        Class clazz = processAnnotatedType.getAnnotatedType().getJavaClass();
        Set annotations = annotatedType.getAnnotations();
        for (Annotation annotation : annotations) {
            if (!FTGlobalConfig.getActiveAnnotations(clazz).contains(annotation.annotationType())) continue;
            interceptedClass = true;
            if (annotation.annotationType() == Asynchronous.class) {
                AsynchronousConfig asynchronousConfig = new AsynchronousConfig(clazz, (Asynchronous)annotation);
                asynchronousConfig.validate();
                classLevelAsync = asynchronousConfig;
                continue;
            }
            if (annotation.annotationType() == Retry.class) {
                RetryConfig retry = new RetryConfig(clazz, (Retry)annotation);
                retry.validate();
                continue;
            }
            if (annotation.annotationType() == Timeout.class) {
                TimeoutConfig timeout = new TimeoutConfig(clazz, (Timeout)annotation);
                timeout.validate();
                continue;
            }
            if (annotation.annotationType() == CircuitBreaker.class) {
                CircuitBreakerConfig circuitBreaker = new CircuitBreakerConfig(clazz, (CircuitBreaker)annotation);
                circuitBreaker.validate();
                continue;
            }
            if (annotation.annotationType() != Bulkhead.class) continue;
            BulkheadConfig bulkhead = new BulkheadConfig(clazz, (Bulkhead)annotation);
            bulkhead.validate();
        }
        Set methods = annotatedType.getMethods();
        for (AnnotatedMethod method : methods) {
            this.validateMethod(method, clazz, classLevelAsync);
            annotations = method.getAnnotations();
            for (Annotation annotation : annotations) {
                if (!FTGlobalConfig.getActiveAnnotations(clazz).contains(annotation.annotationType())) continue;
                interceptedMethods.add(method);
            }
        }
        if (interceptedClass || !interceptedMethods.isEmpty()) {
            this.addFaultToleranceAnnotation(beanManager, processAnnotatedType, interceptedClass, interceptedMethods);
        }
    }

    private <T> void validateMethod(AnnotatedMethod<T> method, Class<?> clazz, Asynchronous classLevelAsync) {
        Method javaMethod = method.getJavaMember();
        if (javaMethod.isBridge()) {
            return;
        }
        if (classLevelAsync != null) {
            AsynchronousConfig asynchronous = new AsynchronousConfig(javaMethod, clazz, classLevelAsync);
            asynchronous.validate();
        }
        Set annotations = method.getAnnotations();
        for (Annotation annotation : annotations) {
            if (!FTGlobalConfig.getActiveAnnotations(clazz).contains(annotation.annotationType())) continue;
            if (annotation.annotationType() == Asynchronous.class) {
                AsynchronousConfig asynchronous = new AsynchronousConfig(javaMethod, clazz, (Asynchronous)annotation);
                asynchronous.validate();
                continue;
            }
            if (annotation.annotationType() == Fallback.class) {
                FallbackConfig fallback = new FallbackConfig(javaMethod, clazz, (Fallback)annotation);
                fallback.validate();
                continue;
            }
            if (annotation.annotationType() == Retry.class) {
                RetryConfig retry = new RetryConfig(javaMethod, clazz, (Retry)annotation);
                retry.validate();
                continue;
            }
            if (annotation.annotationType() == Timeout.class) {
                TimeoutConfig timeout = new TimeoutConfig(javaMethod, clazz, (Timeout)annotation);
                timeout.validate();
                continue;
            }
            if (annotation.annotationType() == CircuitBreaker.class) {
                CircuitBreakerConfig circuitBreaker = new CircuitBreakerConfig(javaMethod, clazz, (CircuitBreaker)annotation);
                circuitBreaker.validate();
                continue;
            }
            if (annotation.annotationType() != Bulkhead.class) continue;
            BulkheadConfig bulkhead = new BulkheadConfig(javaMethod, clazz, (Bulkhead)annotation);
            bulkhead.validate();
        }
    }

    private <T> void addFaultToleranceAnnotation(BeanManager beanManager, ProcessAnnotatedType<T> processAnnotatedType, boolean interceptedClass, Set<AnnotatedMethod<?>> interceptedMethods) {
        AnnotatedTypeWrapper wrapper = new AnnotatedTypeWrapper(beanManager, processAnnotatedType.getAnnotatedType(), interceptedClass, interceptedMethods);
        processAnnotatedType.setAnnotatedType(wrapper);
    }
}

