/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.Executor;
import com.ibm.ws.microprofile.faulttolerance.spi.ExecutorBuilder;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.FaultToleranceProvider;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.TimeoutPolicy;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AggregatedFTPolicy {
    private boolean asynchronous = false;
    private RetryPolicy retryPolicy = null;
    private CircuitBreakerPolicy circuitBreakerPolicy = null;
    private BulkheadPolicy bulkheadPolicy = null;
    private TimeoutPolicy timeout;
    private FallbackPolicy fallbackPolicy;
    private Executor<?> executor;
    static final long serialVersionUID = -3674244559014298514L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    public void setTimeoutPolicy(TimeoutPolicy timeout) {
        this.timeout = timeout;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public void setCircuitBreakerPolicy(CircuitBreakerPolicy circuitBreakerPolicy) {
        this.circuitBreakerPolicy = circuitBreakerPolicy;
    }

    public void setBulkheadPolicy(BulkheadPolicy bulkheadPolicy) {
        this.bulkheadPolicy = bulkheadPolicy;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public BulkheadPolicy getBulkheadPolicy() {
        return this.bulkheadPolicy;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public TimeoutPolicy getTimeoutPolicy() {
        return this.timeout;
    }

    public CircuitBreakerPolicy getCircuitBreakerPolicy() {
        return this.circuitBreakerPolicy;
    }

    public void setFallbackPolicy(FallbackPolicy fallbackPolicy) {
        this.fallbackPolicy = fallbackPolicy;
    }

    public FallbackPolicy getFallbackPolicy() {
        return this.fallbackPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Executor<?> getExecutor() {
        AggregatedFTPolicy aggregatedFTPolicy = this;
        synchronized (aggregatedFTPolicy) {
            if (this.executor == null) {
                ExecutorBuilder<ExecutionContext, ?> builder = this.newBuilder();
                this.executor = this.isAsynchronous() ? builder.buildAsync() : builder.build();
            }
            return this.executor;
        }
    }

    private ExecutorBuilder<ExecutionContext, ?> newBuilder() {
        ExecutorBuilder builder = FaultToleranceProvider.newExecutionBuilder();
        builder = this.updateBuilder(builder);
        return builder;
    }

    private <R> ExecutorBuilder<ExecutionContext, R> updateBuilder(ExecutorBuilder<ExecutionContext, R> builder) {
        TimeoutPolicy timeoutPolicy = this.getTimeoutPolicy();
        CircuitBreakerPolicy circuitBreakerPolicy = this.getCircuitBreakerPolicy();
        RetryPolicy retryPolicy = this.getRetryPolicy();
        FallbackPolicy fallbackPolicy = this.getFallbackPolicy();
        BulkheadPolicy bulkheadPolicy = this.getBulkheadPolicy();
        if (timeoutPolicy != null) {
            builder.setTimeoutPolicy(timeoutPolicy);
        }
        if (circuitBreakerPolicy != null) {
            builder.setCircuitBreakerPolicy(circuitBreakerPolicy);
        }
        if (retryPolicy != null) {
            builder.setRetryPolicy(retryPolicy);
        }
        if (fallbackPolicy != null) {
            builder.setFallbackPolicy(fallbackPolicy);
        }
        if (bulkheadPolicy != null) {
            builder.setBulkheadPolicy(bulkheadPolicy);
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AggregatedFTPolicy aggregatedFTPolicy = this;
        synchronized (aggregatedFTPolicy) {
            if (this.executor != null) {
                this.executor.close();
                this.executor = null;
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(AggregatedFTPolicy.class);
    }
}

