/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.ee6;

import com.ibm.ws.jsf.shared.JSFConstants;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.CustomScoped;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.NoneScoped;
import javax.faces.bean.ReferencedBean;
import javax.faces.bean.RequestScoped;
import javax.faces.bean.SessionScoped;
import javax.faces.bean.ViewScoped;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;
import javax.faces.event.ListenerFor;
import javax.faces.event.ListenersFor;
import javax.faces.event.NamedEvent;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.FacesRenderer;
import javax.faces.render.Renderer;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.webapp.FacesServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.HandlesTypes;
import org.apache.myfaces.context.servlet.StartupServletExternalContextImpl;
import org.apache.myfaces.shared_impl.webapp.webxml.DelegatedFacesServlet;
import org.apache.myfaces.spi.FacesConfigResourceProvider;
import org.apache.myfaces.spi.FacesConfigResourceProviderFactory;
import org.apache.myfaces.webapp.StartupServletContextListener;

@HandlesTypes(value={ApplicationScoped.class, CustomScoped.class, FacesBehavior.class, FacesBehaviorRenderer.class, FacesComponent.class, FacesConverter.class, FacesRenderer.class, FacesValidator.class, ListenerFor.class, ListenersFor.class, ManagedBean.class, ManagedProperty.class, NamedEvent.class, NoneScoped.class, ReferencedBean.class, RequestScoped.class, ResourceDependencies.class, ResourceDependency.class, SessionScoped.class, ViewScoped.class, UIComponent.class, Converter.class, Renderer.class, Validator.class})
public class MyFacesContainerInitializer
implements ServletContainerInitializer {
    private static final String FACES_SERVLET_ADDED_ATTRIBUTE = "org.apache.myfaces.DYNAMICALLY_ADDED_FACES_SERVLET";
    private static final String INITIALIZE_ALWAYS_STANDALONE = "org.apache.myfaces.INITIALIZE_ALWAYS_STANDALONE";
    private static final String FACES_CONFIG_RESOURCE = "/WEB-INF/faces-config.xml";
    private static final Logger log = Logger.getLogger(MyFacesContainerInitializer.class.getName());
    private static final String[] FACES_SERVLET_MAPPINGS = new String[]{"/faces/*", "*.jsf", "*.faces"};
    private static final String FACES_SERVLET_NAME = "FacesServlet";
    private static final Class<? extends Servlet> FACES_SERVLET_CLASS = FacesServlet.class;
    private static final Class<?> DELEGATED_FACES_SERVLET_CLASS = DelegatedFacesServlet.class;

    public void onStartup(Set<Class<?>> clazzes, ServletContext servletContext) throws ServletException {
        boolean startDireclty = this.shouldStartupRegardless(servletContext);
        if (startDireclty) {
            return;
        }
        if (clazzes != null && !clazzes.isEmpty() || this.isFacesConfigPresent(servletContext)) {
            Object[] mappings;
            Map servlets = servletContext.getServletRegistrations();
            for (Map.Entry servletEntry : servlets.entrySet()) {
                String className = ((ServletRegistration)servletEntry.getValue()).getClassName();
                if (!FACES_SERVLET_CLASS.getName().equals(className) && !this.isDelegatedFacesServlet(className)) continue;
                return;
            }
            ServletRegistration.Dynamic servlet = servletContext.addServlet(FACES_SERVLET_NAME, FACES_SERVLET_CLASS);
            Set conflictMappings = servlet.addMapping((String[])(mappings = FACES_SERVLET_MAPPINGS));
            if (conflictMappings != null && !conflictMappings.isEmpty()) {
                HashSet<String> newMappings = new HashSet<String>(Arrays.asList(mappings));
                newMappings.removeAll(conflictMappings);
                mappings = newMappings.toArray(new String[newMappings.size()]);
                servlet.addMapping((String[])mappings);
            }
            if (mappings != null && mappings.length > 0) {
                servletContext.setAttribute(FACES_SERVLET_ADDED_ATTRIBUTE, (Object)Boolean.TRUE);
                this.addLifecycleListener(servletContext);
                log.log(Level.INFO, "Added FacesServlet with mappings=" + Arrays.toString(mappings));
            }
        }
    }

    private boolean shouldStartupRegardless(ServletContext servletContext) {
        try {
            String standaloneStartup = servletContext.getInitParameter(INITIALIZE_ALWAYS_STANDALONE);
            return "true".equalsIgnoreCase(standaloneStartup);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isFacesConfigPresent(ServletContext servletContext) {
        try {
            StartupServletExternalContextImpl externalContext;
            FacesConfigResourceProviderFactory factory;
            FacesConfigResourceProvider provider;
            Collection<URL> metaInfFacesConfigUrls;
            if (servletContext.getResource(FACES_CONFIG_RESOURCE) != null) {
                return true;
            }
            String configFilesAttrValue = servletContext.getInitParameter("javax.faces.CONFIG_FILES");
            if (configFilesAttrValue != null) {
                String[] configFiles;
                for (String file : configFiles = configFilesAttrValue.split(",")) {
                    if (servletContext.getResource(file.trim()) == null) continue;
                    return true;
                }
            }
            return (metaInfFacesConfigUrls = (provider = (factory = FacesConfigResourceProviderFactory.getFacesConfigResourceProviderFactory(externalContext = new StartupServletExternalContextImpl(servletContext, true))).createFacesConfigResourceProvider(externalContext)).getMetaInfConfigurationResources(externalContext)) != null && !metaInfFacesConfigUrls.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isDelegatedFacesServlet(String className) {
        if (className == null) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName(className);
            return DELEGATED_FACES_SERVLET_CLASS.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    private void addLifecycleListener(ServletContext servletContext) {
        StartupServletContextListener startupServletContextListener = null;
        startupServletContextListener = new StartupServletContextListener();
        servletContext.addListener((EventListener)((Object)startupServletContextListener));
        this.setJSFImplEnabled(servletContext, JSFConstants.JSFImplEnabled.MyFaces);
    }

    private void setJSFImplEnabled(ServletContext servletContext, JSFConstants.JSFImplEnabled impl) {
        servletContext.setAttribute("com.ibm.ws.jsf.JSF_IMPL_ENABLED", (Object)impl);
    }
}

