/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jtc.adapter.PlatformAdapterAccessor;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.util.BoundedBuffer;
import com.ibm.ws.util.ThreadContextAccessor;
import com.ibm.ws.util.ThreadPoolListener;
import com.ibm.wsspi.runtime.ThreadPool;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TooManyListenersException;

public class ThreadPool {
    private static TraceComponent tc = Tr.register(ThreadPool.class, (String)"Runtime", (String)"com.ibm.ws.runtime.runtime");
    private static ThreadContextAccessor THREAD_CONTEXT_ACCESSOR = ThreadContextAccessor.getThreadContextAccessor();
    public static final int DEFAULT_MAXIMUMPOOLSIZE = 10;
    public static final int DEFAULT_MINIMUMPOOLSIZE = 0;
    public static final long DEFAULT_KEEPALIVETIME = 5000L;
    public static final int WAIT_WHEN_QUEUE_IS_FULL = 0;
    public static final int ERROR_WHEN_QUEUE_IS_FULL = 1;
    public static final int EXPAND_WHEN_QUEUE_IS_FULL_ERROR_AT_LIMIT = 2;
    public static final int EXPAND_WHEN_QUEUE_IS_FULL_WAIT_AT_LIMIT = 3;
    @Deprecated
    protected int maximumPoolSize_ = 10;
    @Deprecated
    protected int minimumPoolSize_ = 0;
    @Deprecated
    protected int poolSize_ = 0;
    @Deprecated
    protected int activeThreads = 0;
    @Deprecated
    protected long keepAliveTime_ = 5000L;
    @Deprecated
    protected BoundedBuffer requestBuffer;
    @Deprecated
    protected boolean shutdown_ = false;
    @Deprecated
    protected final Map threads_;
    @Deprecated
    protected int threadid = 0;
    @Deprecated
    protected boolean growasneeded = false;
    private ClassLoader contextClassLoader;
    @Deprecated
    private boolean clearJavaLangThreadLocals = false;
    @Deprecated
    protected int threadpriority = 5;
    private static ThreadPoolListener[] ZERO_TP_LISTENERS = new ThreadPoolListener[0];
    @Deprecated
    protected ThreadPoolListener[] threadPoolListeners;
    @Deprecated
    protected String name;
    private MonitorPlugin monitorPlugin = null;
    private int requestBufferExpansionLimit_;
    private int requestBufferInitialCapacity_;
    private boolean lastThreadCheckDidntComplete = false;
    private boolean poolGrowthLogged = false;
    private final boolean isZOS = false;
    protected boolean _isDecoratedZOS = false;
    protected static volatile Method xMemSetupThread = null;
    private boolean bufferLimitReached = false;
    private int daemonId = -1;
    static Object[] ZERO_OBJECTS = new Object[0];

    public ThreadPool(int minSize, int maxSize, ThreadPoolListener[] tpls) {
        this(null, minSize, maxSize, tpls);
    }

    public ThreadPool(String name, int minSize, int maxSize) {
        this(name, minSize, maxSize, null);
    }

    public ThreadPool(String name, int minPoolSize, int maxPoolSize, ThreadPoolListener[] tpls) {
        this.name = name;
        this.maximumPoolSize_ = maxPoolSize;
        this.minimumPoolSize_ = minPoolSize;
        this.requestBufferExpansionLimit_ = maxPoolSize * 10;
        this.threads_ = new HashMap();
        String clearThreadLocals = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("com.ibm.websphere.threadpool.clearThreadLocal");
            }
        });
        if (clearThreadLocals != null && Boolean.valueOf(clearThreadLocals).booleanValue()) {
            this.setClearThreadLocals(true);
        }
        this.requestBufferInitialCapacity_ = this.maximumPoolSize_;
        this.requestBuffer = new BoundedBuffer(this.requestBufferInitialCapacity_);
        this.threadPoolListeners = tpls == null ? ZERO_TP_LISTENERS : (ThreadPoolListener[])tpls.clone();
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadPoolCreated(this);
        }
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public void setClearThreadLocals(boolean b) {
        this.clearJavaLangThreadLocals = b;
        if (b) {
            Tr.warning((TraceComponent)tc, (String)"WSVR0623W", (Object)this.name);
        }
    }

    public synchronized int getMaximumPoolSize() {
        return this.maximumPoolSize_;
    }

    public synchronized void setMaximumPoolSize(int newMaximum) {
        if (newMaximum <= 0) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize_ = newMaximum;
    }

    public synchronized int getMinimumPoolSize() {
        return this.minimumPoolSize_;
    }

    public synchronized void setMinimumPoolSize(int newMinimum) {
        if (newMinimum < 0) {
            throw new IllegalArgumentException();
        }
        this.minimumPoolSize_ = newMinimum;
    }

    public synchronized int getPoolSize() {
        return this.poolSize_;
    }

    public synchronized long getKeepAliveTime() {
        return this.keepAliveTime_;
    }

    public synchronized void setKeepAliveTime(long msecs) {
        this.keepAliveTime_ = msecs;
    }

    public synchronized void setRequestBufferSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("request buffer size must be greater than zero");
        }
        if (this.requestBuffer.size() != 0) {
            throw new IllegalStateException("cannot resize non-empty ThreadPool request buffer");
        }
        this.requestBuffer = new BoundedBuffer(size);
        this.requestBufferInitialCapacity_ = size;
        this.requestBufferExpansionLimit_ = this.requestBufferInitialCapacity_ * 10;
    }

    public synchronized int getRequestBufferSize() {
        return this.requestBuffer.capacity();
    }

    @Deprecated
    protected void addThread(Runnable command) {
        Worker worker = this._isDecoratedZOS ? new DecoratedZOSWorker(command, this.threadid++) : new Worker(command, this.threadid++);
        if (this.contextClassLoader != null && THREAD_CONTEXT_ACCESSOR.getContextClassLoader(worker) != this.contextClassLoader) {
            THREAD_CONTEXT_ACCESSOR.setContextClassLoader(worker, this.contextClassLoader);
        }
        Thread.interrupted();
        this.threads_.put(worker, worker);
        ++this.poolSize_;
        ++this.activeThreads;
        if (command == null) {
            this.requestBuffer.incrementWaitingThreads();
        }
        this.fireThreadCreated(this.poolSize_);
        try {
            worker.start();
        }
        catch (OutOfMemoryError error) {
            this.threads_.remove(worker);
            --this.poolSize_;
            --this.activeThreads;
            this.fireThreadDestroyed(this.poolSize_);
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int createThreads(int numberOfThreads) {
        int ncreated = 0;
        for (int i = 0; i < numberOfThreads; ++i) {
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (this.poolSize_ < this.maximumPoolSize_) {
                    this.addThread(null);
                    ++ncreated;
                } else {
                    break;
                }
                continue;
            }
        }
        return ncreated;
    }

    public synchronized void shutdownNow() {
        this.shutdown_ = true;
        this.maximumPoolSize_ = 0;
        this.minimumPoolSize_ = 0;
        this.interruptAll();
    }

    @Deprecated
    public synchronized void shutdownAfterProcessingCurrentlyQueuedTasks() {
        this.shutdown_ = true;
        if (this.poolSize_ == 0) {
            this.maximumPoolSize_ = 0;
            this.minimumPoolSize_ = 0;
        }
    }

    @Deprecated
    public synchronized void interruptAll() {
        for (Thread t : this.threads_.values()) {
            t.interrupt();
        }
    }

    @Deprecated
    public synchronized boolean awaitTerminationAfterShutdown(long maxWaitTime) throws InterruptedException {
        if (!this.shutdown_) {
            throw new IllegalStateException();
        }
        if (this.poolSize_ == 0) {
            return true;
        }
        long waitTime = maxWaitTime;
        if (waitTime <= 0L) {
            return false;
        }
        long start = System.currentTimeMillis();
        do {
            this.wait(waitTime);
            if (this.poolSize_ != 0) continue;
            return true;
        } while ((waitTime = maxWaitTime - (System.currentTimeMillis() - start)) > 0L);
        return false;
    }

    @Deprecated
    public synchronized void awaitTerminationAfterShutdown() throws InterruptedException {
        if (!this.shutdown_) {
            throw new IllegalStateException();
        }
        while (this.poolSize_ > 0) {
            this.wait();
        }
    }

    @Deprecated
    protected synchronized void workerDone(Worker w, boolean taskDied) {
        this.threads_.remove(w);
        if (taskDied) {
            --this.activeThreads;
            --this.poolSize_;
        }
        if (this.poolSize_ == 0 && this.shutdown_) {
            this.minimumPoolSize_ = 0;
            this.maximumPoolSize_ = 0;
            this.notifyAll();
        }
        this.fireThreadDestroyed(this.poolSize_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected Runnable getTask(boolean oldThread) throws InterruptedException {
        Runnable r = null;
        boolean firstTime = true;
        while (true) {
            long waitTime;
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (firstTime) {
                    --this.activeThreads;
                    if (oldThread) {
                        this.requestBuffer.incrementWaitingThreads();
                    }
                }
                if (!(this.poolSize_ <= this.maximumPoolSize_ || this.growasneeded && firstTime)) {
                    --this.poolSize_;
                    this.requestBuffer.decrementWaitingThreads();
                    return null;
                }
                waitTime = this.shutdown_ ? 0L : (this.poolSize_ <= this.minimumPoolSize_ ? -1L : this.keepAliveTime_);
            }
            try {
                r = waitTime >= 0L ? (Runnable)this.requestBuffer.poll(waitTime) : (Runnable)this.requestBuffer.take();
            }
            catch (InterruptedException e) {
                ++this.activeThreads;
                ThreadPool threadPool2 = this;
                synchronized (threadPool2) {
                    this.requestBuffer.decrementWaitingThreads();
                }
                throw e;
            }
            threadPool = this;
            synchronized (threadPool) {
                if (r == null) {
                    r = (Runnable)this.requestBuffer.poll(0L);
                }
                if (r != null) {
                    ++this.activeThreads;
                    break;
                }
                if (this.poolSize_ > this.minimumPoolSize_) {
                    --this.poolSize_;
                    this.requestBuffer.decrementWaitingThreads();
                    break;
                }
            }
            firstTime = false;
        }
        return r;
    }

    public void setGrowAsNeeded(boolean onoff) {
        this.growasneeded = onoff;
    }

    public boolean isGrowAsNeeded() {
        return this.growasneeded;
    }

    public void setContextClassLoader(ClassLoader cl) {
        this.contextClassLoader = cl;
    }

    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public void setThreadPriority(int priority) {
        this.threadpriority = priority;
    }

    public int getThreadPriority() {
        return this.threadpriority;
    }

    public void setDecoratedZOS() {
        block4: {
            if (xMemSetupThread == null) {
                try {
                    Class<?> xMemCRBridgeClass = Class.forName("com.ibm.ws390.xmem.XMemCRBridgeImpl");
                    xMemSetupThread = xMemCRBridgeClass.getMethod("setupThreadStub", Object.class);
                }
                catch (Throwable t) {
                    if (!tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)"Unexpected exception caught accessing XMemCRBridgeImpl.setupThreadStub", (Object)t);
                }
            }
        }
        if (xMemSetupThread != null) {
            this._isDecoratedZOS = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeOnDaemon(Runnable command) {
        int id = 0;
        final Runnable commandToRun = command;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            ++this.daemonId;
            id = this.daemonId;
        }
        final String runId = this.name + " : DMN" + id;
        Thread t = (Thread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread temp = new Thread(commandToRun, runId);
                temp.setDaemon(true);
                return temp;
            }
        });
        t.start();
    }

    public void execute(Runnable command) throws InterruptedException, IllegalStateException {
        try {
            this.execute(command, 0, 0L);
        }
        catch (ThreadPoolQueueIsFullException threadPoolQueueIsFullException) {
            // empty catch block
        }
    }

    public void execute(Runnable command, int blockingMode) throws InterruptedException, ThreadPoolQueueIsFullException, IllegalStateException {
        this.execute(command, blockingMode, 0L);
    }

    public Runnable execute(Runnable command, long timeoutInMillis) throws InterruptedException, IllegalStateException {
        try {
            return this.execute(command, 0, timeoutInMillis);
        }
        catch (ThreadPoolQueueIsFullException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable execute(Runnable command, int blockingMode, long timeoutInMillis) throws InterruptedException, ThreadPoolQueueIsFullException, IllegalStateException {
        if (this.shutdown_) {
            throw new IllegalStateException();
        }
        boolean offered = this.requestBuffer.offer(command, 0L);
        if (offered && this.minimumPoolSize_ == this.maximumPoolSize_ && this.poolSize_ == this.minimumPoolSize_ && !this.growasneeded) {
            return command;
        }
        boolean yield = false;
        while (true) {
            if (yield) {
                Thread.yield();
            }
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                int currentCapacity;
                if (!offered && (offered = this.requestBuffer.offer(command, 0L)) && this.minimumPoolSize_ == this.maximumPoolSize_ && this.poolSize_ == this.minimumPoolSize_ && !this.growasneeded) {
                    return command;
                }
                if (this.shutdown_) {
                    throw new IllegalStateException();
                }
                if (this.growasneeded && !offered && !yield) {
                    yield = true;
                    continue;
                }
                int size = this.poolSize_;
                if (offered && this.requestBuffer.excessWaitingThreads() >= 0) {
                    return command;
                }
                if (size < this.maximumPoolSize_) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            ThreadPool.this.addThread(null);
                            return null;
                        }
                    });
                }
                if (size >= this.maximumPoolSize_ && this.growasneeded) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            ThreadPool.this.addThread(null);
                            return null;
                        }
                    });
                    if (!this.poolGrowthLogged) {
                        Tr.info((TraceComponent)tc, (String)"WSVR0630I", (Object)new Object[]{this.name, this.poolSize_});
                        this.poolGrowthLogged = true;
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"WSVR0630I", (Object)new Object[]{this.name, this.poolSize_});
                    }
                }
                if (offered) {
                    return command;
                }
                if ((blockingMode == 2 || blockingMode == 3) && (currentCapacity = this.requestBuffer.capacity()) != this.requestBufferExpansionLimit_) {
                    int additionalCapacity = Math.min(currentCapacity / 2, this.requestBufferExpansionLimit_ - currentCapacity);
                    Tr.uncondEvent((TraceComponent)tc, (String)("Exanding buffer of ThreadPool " + this.name + " by " + additionalCapacity));
                    this.requestBuffer.expand(additionalCapacity);
                    continue;
                }
            }
            if (!this.bufferLimitReached) {
                Tr.info((TraceComponent)tc, (String)"WSVR0629I", (Object)this.name);
                this.bufferLimitReached = true;
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WSVR0629I", (Object)this.name);
            }
            if (blockingMode == 0) {
                if (timeoutInMillis > 0L) {
                    return (Runnable)this.requestBuffer.put(command, timeoutInMillis, this.requestBufferInitialCapacity_);
                }
                this.requestBuffer.put(command);
                offered = true;
                continue;
            }
            if (blockingMode != 3) break;
            if (timeoutInMillis > 0L) {
                return (Runnable)this.requestBuffer.put(command, timeoutInMillis);
            }
            this.requestBuffer.put(command);
            offered = true;
        }
        throw new ThreadPoolQueueIsFullException();
    }

    public boolean cancel(Runnable command) {
        return this.requestBuffer.cancel(command);
    }

    public void addThreadPoolListener(ThreadPoolListener tpl) {
        int size = this.threadPoolListeners.length + 1;
        ThreadPoolListener[] tpls = new ThreadPoolListener[size];
        System.arraycopy(this.threadPoolListeners, 0, tpls, 0, size - 1);
        tpls[size - 1] = tpl;
        this.threadPoolListeners = tpls;
    }

    public void removeThreadPoolListener(ThreadPoolListener tpl) {
        int idx;
        for (idx = 0; idx < this.threadPoolListeners.length && this.threadPoolListeners[idx] != tpl; ++idx) {
        }
        if (idx < this.threadPoolListeners.length) {
            int size = this.threadPoolListeners.length - 1;
            ThreadPoolListener[] tpls = new ThreadPoolListener[size];
            System.arraycopy(this.threadPoolListeners, 0, tpls, 0, idx);
            System.arraycopy(this.threadPoolListeners, idx + 1, tpls, idx, size - idx - 1);
            this.threadPoolListeners = tpls;
        }
    }

    protected void fireThreadCreated(int poolSize) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadCreated(this, poolSize);
        }
    }

    protected void fireThreadStarted(int activeThreads, int maxThreads) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadStarted(this, activeThreads, maxThreads);
        }
    }

    protected void fireThreadReturned(int activeThreads, int maxThreads) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadReturned(this, activeThreads, maxThreads);
        }
    }

    protected void fireThreadDestroyed(int poolSize) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadDestroyed(this, poolSize);
        }
    }

    public synchronized boolean areRequestsOutstanding() {
        if (this.poolSize_ == 0) {
            return false;
        }
        for (Thread t : this.threads_.values()) {
            if (!t.isAlive()) continue;
            return true;
        }
        return false;
    }

    public void setMonitorPlugin(MonitorPlugin plugin) throws TooManyListenersException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setMonitorPlugin", (Object)plugin);
        }
        if (this.monitorPlugin != null && !this.monitorPlugin.equals(plugin)) {
            throw new TooManyListenersException("INTERNAL ERROR: ThreadPool.MonitorPlugin already set.");
        }
        this.monitorPlugin = plugin;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setMonitorPlugin", (Object)plugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAllThreads() {
        if (this.monitorPlugin == null) {
            return;
        }
        long currentTime = 0L;
        try {
            Iterator i = this.threads_.values().iterator();
            while (i.hasNext()) {
                Worker thread;
                Worker worker = thread = (Worker)i.next();
                synchronized (worker) {
                    if (thread.getStartTime() > 0L) {
                        if (currentTime == 0L) {
                            currentTime = System.currentTimeMillis();
                        }
                        if (!thread.isHung && this.monitorPlugin.checkThread(thread, thread.threadNumber, currentTime - thread.getStartTime())) {
                            thread.isHung = true;
                        }
                    }
                }
            }
            this.lastThreadCheckDidntComplete = false;
        }
        catch (ConcurrentModificationException e) {
            if (this.lastThreadCheckDidntComplete) {
                // empty if block
            }
            this.lastThreadCheckDidntComplete = true;
        }
    }

    public void setRequestBufferExpansionLimit(int limit) {
        this.requestBufferExpansionLimit_ = limit;
    }

    public void setThreadWaiting(boolean isWaiting) {
        try {
            Worker worker = (Worker)Thread.currentThread();
            if (isWaiting) {
                worker.disableHungThreadDetection();
                worker.clearThreadLocals();
            } else {
                worker.enableHungThreadDetection();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private synchronized void incActive() {
        ++this.activeThreads;
    }

    private synchronized void decActive() {
        --this.activeThreads;
    }

    private synchronized void decPoolSize() {
        --this.poolSize_;
    }

    class DecoratedZOSWorker
    extends Worker
    implements DecoratedCRThread {
        protected DecoratedZOSWorker(Runnable firstTask, int id) {
            super(firstTask, id);
        }

        @Override
        public void run() {
            this.threadNumber = RasHelper.getThreadId();
            try {
                xMemSetupThread.invoke(null, this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void processTasks() {
            super.run();
        }
    }

    private static class WasThreadLocalData {
        Object key = null;
        Object value = null;

        private WasThreadLocalData() {
        }
    }

    class Worker
    extends Thread
    implements WorkerThread,
    WasThreadLocalSupport {
        protected Runnable firstTask_;
        Object[] wsThreadLocals;
        private volatile long startTime;
        protected volatile boolean isHung;
        protected String threadNumber;
        WasThreadLocalData[] activeWasThreadLocals;
        int numberOfActiveWasThreadLocals;

        protected synchronized long getStartTime() {
            return this.startTime;
        }

        protected synchronized void setStartTime(long timeValue) {
            this.startTime = timeValue;
        }

        protected Worker(ThreadGroup tg, Runnable r, String n, long ss) {
            super(tg, r, n, ss);
            this.wsThreadLocals = ZERO_OBJECTS;
            this.startTime = 0L;
            this.isHung = false;
            this.threadNumber = "-1";
            this.activeWasThreadLocals = new WasThreadLocalData[0];
            this.numberOfActiveWasThreadLocals = 0;
        }

        protected Worker(Runnable firstTask, int id) {
            super(ThreadPool.this.name + " : " + id);
            this.wsThreadLocals = ZERO_OBJECTS;
            this.startTime = 0L;
            this.isHung = false;
            this.threadNumber = "-1";
            this.activeWasThreadLocals = new WasThreadLocalData[0];
            this.numberOfActiveWasThreadLocals = 0;
            this.firstTask_ = firstTask;
            this.setPriority(ThreadPool.this.getThreadPriority());
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.threadNumber = RasHelper.getThreadId();
            Runnable task = this.firstTask_;
            boolean oldThread = task != null;
            try {
                this.firstTask_ = null;
                do {
                    if (task != null) {
                        this.threadStarted();
                        try {
                            task.run();
                        }
                        finally {
                            this.threadReturned();
                        }
                    }
                    task = ThreadPool.this.getTask(oldThread);
                    oldThread = true;
                } while (task != null);
            }
            catch (InterruptedException ex) {
                block10: {
                    try {
                        if (!tc.isEventEnabled()) break block10;
                        Tr.event((TraceComponent)tc, (String)"InterruptedException Caught", (Object)new Object[]{ThreadPool.this.activeThreads});
                    }
                    catch (Throwable throwable) {
                        Thread.interrupted();
                        ThreadPool.this.workerDone(this, task != null);
                        throw throwable;
                    }
                }
                Thread.interrupted();
                ThreadPool.this.workerDone(this, task != null);
            }
            Thread.interrupted();
            ThreadPool.this.workerDone(this, task != null);
        }

        public void threadStarted() {
            ThreadPool.this.fireThreadStarted(ThreadPool.this.activeThreads, ThreadPool.this.maximumPoolSize_);
            this.enableHungThreadDetection();
        }

        public void threadReturned() {
            this.disableHungThreadDetection();
            ThreadPool.this.fireThreadReturned(ThreadPool.this.activeThreads, ThreadPool.this.maximumPoolSize_);
            this.clearThreadLocals();
        }

        @Override
        public void disableHangDetectionForCurrentDispatch() {
            this.setStartTime(0L);
        }

        protected void enableHungThreadDetection() {
            if (ThreadPool.this.monitorPlugin != null) {
                this.setStartTime(System.currentTimeMillis());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void disableHungThreadDetection() {
            if (ThreadPool.this.monitorPlugin != null) {
                Worker worker = this;
                synchronized (worker) {
                    if (this.isHung) {
                        ThreadPool.this.monitorPlugin.clearThread(this, this.threadNumber, System.currentTimeMillis() - this.getStartTime());
                        this.isHung = false;
                    }
                    this.setStartTime(0L);
                }
            }
        }

        protected void clearThreadLocals() {
            if (this.numberOfActiveWasThreadLocals > 0) {
                for (int i = 0; i < this.numberOfActiveWasThreadLocals; ++i) {
                    this.activeWasThreadLocals[i].key = null;
                    this.activeWasThreadLocals[i].value = null;
                }
                this.numberOfActiveWasThreadLocals = 0;
            }
            if (ThreadPool.this.clearJavaLangThreadLocals) {
                PlatformAdapterAccessor.getInstance().cleanThreadLocals(this);
            }
        }

        @Override
        public Object get(Object key) {
            if (key == null) {
                return null;
            }
            for (int i = 0; i < this.numberOfActiveWasThreadLocals; ++i) {
                if (!key.equals(this.activeWasThreadLocals[i].key)) continue;
                return this.activeWasThreadLocals[i].value;
            }
            return null;
        }

        @Override
        public void set(Object key, Object value) {
            if (key == null) {
                return;
            }
            for (int i = 0; i < this.numberOfActiveWasThreadLocals; ++i) {
                if (!key.equals(this.activeWasThreadLocals[i].key)) continue;
                this.activeWasThreadLocals[i].value = value;
                return;
            }
            if (this.numberOfActiveWasThreadLocals == this.activeWasThreadLocals.length) {
                WasThreadLocalData[] newArray = new WasThreadLocalData[this.numberOfActiveWasThreadLocals + 1];
                System.arraycopy(this.activeWasThreadLocals, 0, newArray, 0, this.numberOfActiveWasThreadLocals);
                newArray[this.numberOfActiveWasThreadLocals] = new WasThreadLocalData();
                this.activeWasThreadLocals = newArray;
            }
            this.activeWasThreadLocals[this.numberOfActiveWasThreadLocals].key = key;
            this.activeWasThreadLocals[this.numberOfActiveWasThreadLocals].value = value;
            ++this.numberOfActiveWasThreadLocals;
        }

        @Override
        public void setContextClassLoader(ClassLoader newClassLoader) {
            if (ThreadContextAccessor.PRINT_STACK_ON_SET_CTX_CLASSLOADER) {
                String msg = "Stack trace - new ContextClassLoader: " + newClassLoader.toString();
                Throwable t = new Throwable(msg);
                t.printStackTrace(System.out);
            }
            super.setContextClassLoader(newClassLoader);
        }
    }

    public static class ThreadPoolQueueIsFullException
    extends WsException {
        private static final long serialVersionUID = 5986384706904725945L;

        public ThreadPoolQueueIsFullException() {
        }

        public ThreadPoolQueueIsFullException(String arg0) {
            super(arg0);
        }

        public ThreadPoolQueueIsFullException(Throwable arg0) {
            super(arg0);
        }

        public ThreadPoolQueueIsFullException(String arg0, Throwable arg1) {
            super(arg0, arg1);
        }
    }

    public static interface WasThreadLocalSupport {
        public Object get(Object var1);

        public void set(Object var1, Object var2);
    }

    public static interface WorkerZOSThread {
        public void threadStarted();

        public void threadReturned();
    }

    public static interface WorkerThread
    extends ThreadPool.WorkerThread {
        public void disableHangDetectionForCurrentDispatch();
    }

    public static interface DecoratedCRThread
    extends WorkerThread {
        public void processTasks();
    }

    public static interface MonitorPlugin {
        public boolean checkThread(Thread var1, String var2, long var3);

        public void clearThread(Thread var1, String var2, long var3);
    }
}

