/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.ClaimValue;
import org.eclipse.microprofile.jwt.JsonWebToken;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClaimBean<T>
implements Bean<T>,
PassivationCapable {
    private static final TraceComponent tc = Tr.register(ClaimBean.class);
    private final Class<T> beanClass;
    private Type beanType;
    private Claim claim;
    private Set<Type> types;
    private Set<Annotation> qualifiers;
    private String name;
    private String id;
    private Class<? extends Annotation> scope;
    private final String claimName;
    static final long serialVersionUID = 6777984925572295623L;

    public ClaimBean(BeanManager beanManager, Class<T> beanClass, Claim claim) {
        this(beanManager, beanClass, beanClass, claim);
    }

    @ManualTrace
    public ClaimBean(BeanManager beanManager, Type beanType, Class<T> beanClass, Claim claim) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[]{beanManager, beanType, beanClass, claim});
        }
        this.beanType = beanType;
        this.beanClass = beanClass;
        this.claim = claim;
        this.types = new HashSet<Type>();
        this.types.add(beanType);
        this.qualifiers = new HashSet<Annotation>();
        this.qualifiers.add((Annotation)claim);
        this.name = this.getClass().getName() + "[" + claim + "," + beanType + "]";
        this.id = beanManager.hashCode() + "#" + this.name;
        this.setScope(beanType);
        this.claimName = this.getClaimName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    private void setScope(Type beanType) {
        Class beanTypeClass = null;
        if (beanType instanceof ParameterizedType) {
            beanTypeClass = (Class)((ParameterizedType)beanType).getRawType();
        } else if (beanType instanceof Class) {
            beanTypeClass = (Class)beanType;
        }
        this.scope = ClaimValue.class.isAssignableFrom(beanTypeClass) ? RequestScoped.class : Dependent.class;
    }

    @ManualTrace
    private String getClaimName() {
        String claimName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getClaimName", (Object[])new Object[0]);
        }
        if ((claimName = this.claim.value()) == null || claimName.trim().isEmpty()) {
            claimName = this.claim.standard().name();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getClaimName", (Object)claimName);
        }
        return claimName;
    }

    @ManualTrace
    public T create(CreationalContext<T> creationalContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"create", (Object[])new Object[]{creationalContext});
        }
        T instance = null;
        CDI cdi = CDI.current();
        BeanManager beanManager = cdi.getBeanManager();
        if (this.beanType instanceof ParameterizedType) {
            instance = this.createInstanceForParameterizedType(creationalContext, beanManager);
        } else if (this.beanType instanceof Class) {
            instance = this.createClaimValueForClassType();
        } else {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"MPJWT_CDI_INVALID_INJECTION_TYPE", (Object[])new Object[]{this.beanType}));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"create", instance);
        }
        return instance;
    }

    @ManualTrace
    private T createInstanceForParameterizedType(CreationalContext<T> creationalContext, BeanManager beanManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createInstanceForParameterizedType", (Object[])new Object[]{creationalContext, beanManager});
        }
        Optional<Object> instance = null;
        boolean isOptional = false;
        ParameterizedType parameterizedType = (ParameterizedType)this.beanType;
        Tr.debug((TraceComponent)tc, (String)"parameterizedType", (Object[])new Object[]{parameterizedType});
        Class<?> returnClass = (Class<?>)parameterizedType.getRawType();
        if (ClaimValue.class.isAssignableFrom(returnClass)) {
            returnClass = this.getTypeClass(parameterizedType.getActualTypeArguments()[0]);
            isOptional = Optional.class.isAssignableFrom(returnClass);
            if (isOptional) {
                Class<?> wrappedClass = this.getTypeClass(((ParameterizedType)parameterizedType.getActualTypeArguments()[0]).getActualTypeArguments()[0]);
                instance = this.createClaimValueWithOptional(returnClass, wrappedClass);
            } else {
                instance = (Optional<Object>)this.createClaimValue(returnClass);
            }
        } else if (Optional.class.isAssignableFrom(returnClass)) {
            returnClass = this.getTypeClass(parameterizedType.getActualTypeArguments()[0]);
            instance = Optional.ofNullable(this.getPlainValue(returnClass, this.getCurrentJsonWebToken()));
        } else {
            instance = (Optional<Object>)this.getPlainValue(returnClass, this.getCurrentJsonWebToken());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createInstanceForParameterizedType", instance);
        }
        return (T)instance;
    }

    private Class<?> getTypeClass(Type type) {
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
        }
        return (Class)type;
    }

    @ManualTrace
    private <U> T createClaimValueWithOptional(Class<U> returnClass, final Class<?> wrappedClass) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createClaimValueWithOptional", (Object[])new Object[]{returnClass, wrappedClass});
        }
        ClaimValue instance = null;
        instance = new ClaimValue(){
            static final long serialVersionUID = 8522523022756012642L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public String getName() {
                return ClaimBean.this.claimName;
            }

            public U getValue() {
                Optional<Object> value = null;
                Instance jsonWebTokenInstance = CDI.current().select(JsonWebToken.class, new Annotation[0]);
                if (jsonWebTokenInstance != null && !jsonWebTokenInstance.isAmbiguous() && !jsonWebTokenInstance.isUnsatisfied()) {
                    value = Optional.ofNullable(ClaimBean.this.getPlainValue(wrappedClass, (JsonWebToken)jsonWebTokenInstance.get()));
                }
                return value;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        };
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createClaimValueWithOptional", (Object)instance);
        }
        return (T)instance;
    }

    @ManualTrace
    private <U> T createClaimValue(final Class<U> returnClass) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createClaimValue", (Object[])new Object[]{returnClass});
        }
        ClaimValue instance = null;
        instance = new ClaimValue(){
            static final long serialVersionUID = -5452909858169529310L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public String getName() {
                return ClaimBean.this.claimName;
            }

            public U getValue() {
                Object value = null;
                Instance jsonWebTokenInstance = CDI.current().select(JsonWebToken.class, new Annotation[0]);
                if (jsonWebTokenInstance != null && !jsonWebTokenInstance.isAmbiguous() && !jsonWebTokenInstance.isUnsatisfied()) {
                    value = ClaimBean.this.getPlainValue(returnClass, (JsonWebToken)jsonWebTokenInstance.get());
                }
                return value;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        };
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createClaimValue", (Object)instance);
        }
        return (T)instance;
    }

    private <U> U getPlainValue(Class<U> returnClass, JsonWebToken jsonWebToken) {
        Object value = null;
        value = JsonValue.class.isAssignableFrom(returnClass) ? this.getJsonValue(jsonWebToken) : jsonWebToken.getClaim(this.claimName);
        return (U)value;
    }

    private JsonValue getJsonValue(JsonWebToken jsonWebToken) {
        String jsonWebTokenAsString = jsonWebToken.toString();
        JsonReader reader = Json.createReader((Reader)new StringReader(jsonWebTokenAsString));
        JsonObject jsonObject = reader.readObject();
        return (JsonValue)jsonObject.get((Object)this.claimName);
    }

    @ManualTrace
    private T createClaimValueForClassType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createClaimValueForClassType", (Object[])new Object[0]);
        }
        Object instance = null;
        Class ipClass = (Class)this.beanType;
        instance = ClaimValue.class.equals((Object)ipClass) ? new ClaimValue(){
            static final long serialVersionUID = 5388525875724836029L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public String getName() {
                return ClaimBean.this.claimName;
            }

            public Object getValue() {
                Object value = null;
                Instance jsonWebTokenInstance = CDI.current().select(JsonWebToken.class, new Annotation[0]);
                if (jsonWebTokenInstance != null && !jsonWebTokenInstance.isAmbiguous() && !jsonWebTokenInstance.isUnsatisfied()) {
                    value = ((JsonWebToken)jsonWebTokenInstance.get()).getClaim(ClaimBean.this.claimName);
                }
                return value;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        } : this.getPlainValue(ipClass, this.getCurrentJsonWebToken());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createClaimValueForClassType", (Object)instance);
        }
        return (T)instance;
    }

    private JsonWebToken getCurrentJsonWebToken() {
        Instance jsonWebTokenInstance = CDI.current().select(JsonWebToken.class, new Annotation[0]);
        return (JsonWebToken)jsonWebTokenInstance.get();
    }

    @ManualTrace
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy", (Object[])new Object[]{instance, creationalContext});
        }
        creationalContext.release();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    @ManualTrace
    public Class<?> getBeanClass() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getBeanClass", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getBeanClass", this.beanClass);
        }
        return this.beanClass;
    }

    @ManualTrace
    public boolean isNullable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isNullable", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isNullable", (Object)true);
        }
        return true;
    }

    @ManualTrace
    public Class<? extends Annotation> getScope() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getScope", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getScope", this.scope);
        }
        return this.scope;
    }

    @ManualTrace
    public Set<Type> getTypes() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTypes", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTypes", this.types);
        }
        return this.types;
    }

    @ManualTrace
    public Set<Annotation> getQualifiers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getQualifiers", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getQualifiers", this.qualifiers);
        }
        return this.qualifiers;
    }

    @ManualTrace
    public String getName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getName", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getName", (Object)this.name);
        }
        return this.name;
    }

    @ManualTrace
    public Set<Class<? extends Annotation>> getStereotypes() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getStereotypes", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getStereotypes", Collections.emptySet());
        }
        return Collections.emptySet();
    }

    @ManualTrace
    public boolean isAlternative() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isAlternative", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isAlternative", (Object)false);
        }
        return false;
    }

    @ManualTrace
    public Set<InjectionPoint> getInjectionPoints() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInjectionPoints", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInjectionPoints", Collections.emptySet());
        }
        return Collections.emptySet();
    }

    @ManualTrace
    public String getId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getId", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getId", (Object)this.id);
        }
        return this.id;
    }

    public String toString() {
        return "Bean for " + this.types + " with Qualifiers " + this.qualifiers;
    }
}

