/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.metadata;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.metadata.CollectionMatch;
import com.ibm.ws.webcontainer.security.metadata.CustomMatchingStrategy;
import com.ibm.ws.webcontainer.security.metadata.MatchResponse;
import com.ibm.ws.webcontainer.security.metadata.ResponseAggregate;
import com.ibm.ws.webcontainer.security.metadata.SecurityConstraint;
import com.ibm.ws.webcontainer.security.metadata.SecurityConstraintCollection;
import com.ibm.ws.webcontainer.security.metadata.StandardMatchingStrategy;
import com.ibm.ws.webcontainer.security.metadata.WebResourceCollection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class MatchingStrategy {
    private static final Set<String> STANDARD_METHODS;
    private static StandardMatchingStrategy standardMatchingStrategy;
    private static CustomMatchingStrategy customMatchingStrategy;
    static final long serialVersionUID = 5668108442599630623L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static MatchResponse match(SecurityConstraintCollection securityConstraintCollection, String resourceName, String method) {
        MatchingStrategy matchingStrategy = MatchingStrategy.getMatchingStrategy(method);
        return matchingStrategy.performMatch(securityConstraintCollection, resourceName, method);
    }

    private static MatchingStrategy getMatchingStrategy(String method) {
        MatchingStrategy matchingStrategy = MatchingStrategy.isStandardHttpMethod(method) ? MatchingStrategy.getStandardMatchingStrategy() : MatchingStrategy.getCustomMatchingStrategy();
        return matchingStrategy;
    }

    public static boolean isStandardHttpMethod(String method) {
        return STANDARD_METHODS.contains(method);
    }

    private static MatchingStrategy getCustomMatchingStrategy() {
        if (customMatchingStrategy != null) {
            return customMatchingStrategy;
        }
        customMatchingStrategy = new CustomMatchingStrategy();
        return customMatchingStrategy;
    }

    private static MatchingStrategy getStandardMatchingStrategy() {
        if (standardMatchingStrategy != null) {
            return standardMatchingStrategy;
        }
        standardMatchingStrategy = new StandardMatchingStrategy();
        return standardMatchingStrategy;
    }

    public MatchResponse performMatch(SecurityConstraintCollection securityConstraintCollection, String resourceName, String method) {
        MatchResponse currentResponse = null;
        ResponseAggregate responseAggregate = this.createResponseAggregate();
        for (SecurityConstraint securityConstraint : securityConstraintCollection.getSecurityConstraints()) {
            currentResponse = this.getMatchResponse(securityConstraint, resourceName, method);
            this.optionallySetAggregateResponseDefault(currentResponse, responseAggregate);
            if (!this.isMatch(currentResponse)) continue;
            responseAggregate = currentResponse.aggregateResponse(responseAggregate);
        }
        return responseAggregate.selectMatchResponse();
    }

    protected abstract ResponseAggregate createResponseAggregate();

    protected abstract MatchResponse getMatchResponse(SecurityConstraint var1, String var2, String var3);

    protected void optionallySetAggregateResponseDefault(MatchResponse currentResponse, ResponseAggregate responseAggregate) {
    }

    protected abstract boolean isMatch(MatchResponse var1);

    protected CollectionMatch getCollectionMatch(List<WebResourceCollection> webResourceCollections, String resourceName, String method) {
        CollectionMatch bestMatch = this.getInitialCollectionMatch();
        for (WebResourceCollection webResourceCollection : webResourceCollections) {
            CollectionMatch currentMatch = this.getCollectionMatchForWebResourceCollection(webResourceCollection, resourceName, method);
            if (currentMatch != null) {
                bestMatch = this.selectBestCollectionMatch(bestMatch, currentMatch);
            }
            if (bestMatch == null || !bestMatch.isExactMatch()) continue;
            break;
        }
        return bestMatch;
    }

    protected abstract CollectionMatch getInitialCollectionMatch();

    protected abstract CollectionMatch getCollectionMatchForWebResourceCollection(WebResourceCollection var1, String var2, String var3);

    protected CollectionMatch selectBestCollectionMatch(CollectionMatch previousMatch, CollectionMatch currentMatch) {
        CollectionMatch bestMatch = null;
        bestMatch = previousMatch == null ? currentMatch : (previousMatch.isDenyMatchByOmission() ? previousMatch : (currentMatch.isDenyMatchByOmission() ? currentMatch : (previousMatch.isDenyMatch() ? previousMatch : (currentMatch.isDenyMatch() ? currentMatch : (previousMatch.isPermitMatch() ? previousMatch : (currentMatch.isPermitMatch() ? currentMatch : (previousMatch.isExactMatch() ? previousMatch : (currentMatch.isExactMatch() ? currentMatch : (previousMatch.isPathMatch() && previousMatch.getUrlPattern().length() >= currentMatch.getUrlPattern().length() ? previousMatch : currentMatch)))))))));
        return bestMatch;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MatchingStrategy.class);
        STANDARD_METHODS = new HashSet<String>(Arrays.asList("GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "TRACE"));
        standardMatchingStrategy = null;
        customMatchingStrategy = null;
    }
}

