/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.product.utility.extension.ifix.xml;

import com.ibm.ws.product.utility.extension.ifix.xml.Applicability;
import com.ibm.ws.product.utility.extension.ifix.xml.Categories;
import com.ibm.ws.product.utility.extension.ifix.xml.Information;
import com.ibm.ws.product.utility.extension.ifix.xml.MetadataOutput;
import com.ibm.ws.product.utility.extension.ifix.xml.Offering;
import com.ibm.ws.product.utility.extension.ifix.xml.Problem;
import com.ibm.ws.product.utility.extension.ifix.xml.Property;
import com.ibm.ws.product.utility.extension.ifix.xml.Resolves;
import com.ibm.ws.product.utility.extension.ifix.xml.UpdatedFile;
import com.ibm.ws.product.utility.extension.ifix.xml.Updates;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="fix")
public class IFixInfo
implements MetadataOutput {
    private final String aparIdPrefix = "com.ibm.ws.apar.";
    private String id;
    @XmlAttribute
    private String version;
    @XmlElement
    private Applicability applicability;
    @XmlElement
    private final Categories categories = new Categories();
    @XmlElement
    private Information information;
    @XmlElement(name="property")
    private List<Property> properties;
    @XmlElement
    private Resolves resolves;
    @XmlElement
    private Updates updates;

    public IFixInfo() {
    }

    public IFixInfo(String setId, String setVersion, Set<String> aparList, String fixDescription, ArrayList<Offering> offerings, List<Property> properties, Set<UpdatedFile> updatedFiles) {
        this.id = setId;
        this.version = setVersion;
        this.applicability = new Applicability(offerings);
        this.information = new Information(setId, setVersion, fixDescription);
        this.properties = properties;
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (aparList != null) {
            for (String apar : aparList) {
                String aparId = apar.toString();
                Problem myProblem = new Problem("com.ibm.ws.apar." + aparId, aparId, aparId);
                problems.add(myProblem);
            }
        }
        this.resolves = new Resolves(problems);
        this.updates = new Updates(updatedFiles);
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    @XmlAttribute
    public void setId(String id) {
        this.id = id;
    }

    public Resolves getResolves() {
        return this.resolves;
    }

    public Updates getUpdates() {
        return this.updates;
    }

    public Applicability getApplicability() {
        return this.applicability;
    }

    public List<Property> getProperties() {
        return this.properties;
    }
}

