/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfigChangeListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class LibertySSLSocketFactory
extends SSLSocketFactory {
    private static final TraceComponent tc = Tr.register(LibertySSLSocketFactory.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    protected Properties props;
    private SSLSocketFactory default_factory = null;
    protected boolean default_constructor = true;
    private static LibertySSLSocketFactory thisClass = null;

    public LibertySSLSocketFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"LibertySSLSocketFactory");
        }
        try {
            HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            this.props = SSLConfigManager.getInstance().getDefaultSystemProperties(true);
            if (this.props == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Getting default SSL properties from WebSphere configuration.");
                }
                this.props = LibertySSLSocketFactory.getProperties(null, connectionInfo, null);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Getting javax.net.ssl.* SSL System properties.");
                }
                this.default_constructor = false;
            }
            this.default_factory = this.props != null ? LibertySSLSocketFactory.getSSLSocketFactory(connectionInfo, this.props) : (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"LibertySSLSocketFactory exception getting default SSL properties.", (Object)new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"LibertySSLSocketFactory", (Object)this);
            this.props = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"LibertySSLSocketFactory");
        }
    }

    public LibertySSLSocketFactory(String alias) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"LibertySSLSocketFactory", (Object)new Object[]{alias});
        }
        try {
            this.default_constructor = false;
            HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            this.props = LibertySSLSocketFactory.getProperties(alias, connectionInfo, null);
            this.default_factory = LibertySSLSocketFactory.getSSLSocketFactory(connectionInfo, this.props);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"LibertySSLSocketFactory exception getting SSL factory from alias.", (Object)new Object[]{e});
            }
            this.props = null;
            throw new SSLException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"LibertySSLSocketFactory");
        }
    }

    public LibertySSLSocketFactory(Properties sslprops) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"LibertySSLSocketFactory", (Object)new Object[]{sslprops});
        }
        try {
            this.default_constructor = false;
            this.props = sslprops;
            HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            this.default_factory = LibertySSLSocketFactory.getSSLSocketFactory(connectionInfo, this.props);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"LibertySSLSocketFactory exception getting SSL properties from properties.", (Object)new Object[]{e});
            }
            this.props = null;
            throw new SSLException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"LibertySSLSocketFactory");
        }
    }

    public LibertySSLSocketFactory(String alias, Map<String, Object> connectionInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"LibertySSLSocketFactory", (Object)new Object[]{alias, connectionInfo});
        }
        try {
            this.default_constructor = false;
            this.props = LibertySSLSocketFactory.getProperties(alias, connectionInfo, null);
            this.default_factory = LibertySSLSocketFactory.getSSLSocketFactory(connectionInfo, this.props);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"LibertySSLSocketFactory exception getting SSL properties from selections.", (Object)new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"LibertySSLSocketFactory", (Object)this, (Object[])new Object[]{alias, connectionInfo});
            this.props = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"LibertySSLSocketFactory");
        }
    }

    public static SocketFactory getDefault() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefault");
        }
        if (thisClass == null) {
            try {
                thisClass = new LibertySSLSocketFactory();
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SSLSocketFactory exception getting default socket factory.", (Object)new Object[]{e});
                }
                FFDCFilter.processException((Throwable)e, (String)"SSLSocketFactory", (String)"getDefault", (Object)thisClass);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDefault");
        }
        return thisClass;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefaultCipherSuites");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("default_factory: " + this.default_factory));
        }
        String[] output = null;
        if (this.default_factory != null) {
            output = this.default_factory.getDefaultCipherSuites();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDefaultCipherSuites", (Object)new Object[]{output});
        }
        return output;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSupportedCipherSuites");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("default_factory: " + this.default_factory));
        }
        String[] output = null;
        if (this.default_factory != null) {
            output = this.default_factory.getSupportedCipherSuites();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSupportedCipherSuites", (Object)new Object[]{output});
        }
        return output;
    }

    @Override
    public Socket createSocket() throws IOException {
        Properties sslProps;
        SSLSocket socket;
        SSLSocketFactory currentFactory;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"createSocket");
            }
            currentFactory = this.default_factory;
            socket = null;
            sslProps = this.props;
            if (this.default_constructor) {
                try {
                    Properties sslPropsOnThread = LibertySSLSocketFactory.getSSLPropertiesOnThread();
                    Map<String, Object> currentConnectionInfo = JSSEHelper.getInstance().getOutboundConnectionInfo();
                    if (sslPropsOnThread != null || currentConnectionInfo != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"either SSLProperties on thread or connectionInfo is available.");
                        }
                        if (currentConnectionInfo == null) {
                            currentConnectionInfo = new HashMap<String, Object>();
                            currentConnectionInfo.put("com.ibm.ssl.direction", "outbound");
                        }
                        sslProps = LibertySSLSocketFactory.getProperties(null, currentConnectionInfo, null);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Getting SSLSocketFactory");
                        }
                        currentFactory = LibertySSLSocketFactory.getSSLSocketFactory(currentConnectionInfo, sslProps);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Got SSLSocketFactory", (Object)new Object[]{currentFactory});
                        }
                        break block16;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Neither SSLProperties nor outboundConnectionInfo is set and this is an unconnected socket so create a WSSocket.");
                    }
                    Socket ws_socket = (Socket)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            return new WSSocket(new Socket());
                        }
                    });
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"createSocket");
                    }
                    return ws_socket;
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception getting SSLSocketFactory. Fall back to the default SSLSocketFactory", (Object)new Object[]{e});
                    }
                    FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createSocket", (Object)this);
                    currentFactory = this.default_factory;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Use default SSLSocketFactory - the default constructor was not used");
            }
        }
        if (currentFactory == null) {
            throw new SSLException("SSLSocketFactory is null. This can occur if javax.net.ssl.SSLSocketFactory.getDefault() is called to create a socket and javax.net.ssl.* properties are not set.");
        }
        socket = (SSLSocket)currentFactory.createSocket();
        socket = SSLConfigManager.getInstance().setCipherListOnSocket(sslProps, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSocket");
        }
        return socket;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createSocket", (Object)new Object[]{s, host, port, autoClose});
        }
        SSLSocketFactory factory = this.default_factory;
        SSLSocket socket = null;
        Properties sslprops = this.props;
        try {
            HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            connectionInfo.put("com.ibm.ssl.remoteHost", host);
            connectionInfo.put("com.ibm.ssl.remotePort", Integer.toString(port));
            if (this.default_constructor) {
                sslprops = LibertySSLSocketFactory.getProperties(null, connectionInfo, null);
            }
            if (sslprops != null) {
                factory = LibertySSLSocketFactory.getSSLSocketFactory(connectionInfo, sslprops);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting SSLSocketFactory.", (Object)new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"checkClientTrusted", (Object)this, (Object[])new Object[]{socket, host, port});
        }
        if (factory == null) {
            throw new SSLException("SSLSocketFactory is null. This can occur if javax.net.ssl.SSLSocketFactory.getDefault() is called to create a socket and javax.net.ssl.* properties are not set.");
        }
        socket = (SSLSocket)factory.createSocket(s, host, port, autoClose);
        socket = SSLConfigManager.getInstance().setCipherListOnSocket(sslprops, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSocket");
        }
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createSocket", (Object)new Object[]{host, port});
        }
        SSLSocketFactory factory = this.default_factory;
        SSLSocket socket = null;
        Properties sslprops = this.props;
        try {
            String remoteHostName = null;
            final InetAddress host_final = host;
            final Integer port_final = port;
            if (host_final != null) {
                remoteHostName = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        String remoteHost = null;
                        try {
                            remoteHost = host_final.getHostName();
                            if (remoteHost == null) {
                                remoteHost = host_final.getCanonicalHostName();
                            }
                            return remoteHost;
                        }
                        catch (Throwable e) {
                            remoteHost = host_final.getHostAddress();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Exception getting hostname from socket.", (Object)new Object[]{e});
                            }
                            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"checkClientTrusted", (Object)this, (Object[])new Object[]{host_final, port_final});
                            return remoteHost;
                        }
                    }
                });
            }
            HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            connectionInfo.put("com.ibm.ssl.remoteHost", remoteHostName);
            connectionInfo.put("com.ibm.ssl.remotePort", Integer.toString(port));
            if (this.default_constructor) {
                sslprops = LibertySSLSocketFactory.getProperties(null, connectionInfo, null);
            }
            if (sslprops != null) {
                factory = LibertySSLSocketFactory.getSSLSocketFactory(connectionInfo, sslprops);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting SSLSocketFactory.", (Object)new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createSocket", (Object)this, (Object[])new Object[]{host, port});
        }
        if (factory == null) {
            throw new SSLException("SSLSocketFactory is null. This can occur if javax.net.ssl.SSLSocketFactory.getDefault() is called to create a socket and javax.net.ssl.* properties are not set.");
        }
        socket = (SSLSocket)factory.createSocket(host, port);
        socket = SSLConfigManager.getInstance().setCipherListOnSocket(sslprops, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSocket");
        }
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createSocket", (Object)new Object[]{address, port, localAddress, localPort});
        }
        SSLSocketFactory factory = this.default_factory;
        SSLSocket socket = null;
        Properties sslprops = this.props;
        try {
            String remoteHostName = null;
            final InetAddress address_final = address;
            final Integer port_final = port;
            final InetAddress localAddress_final = localAddress;
            final Integer localPort_final = localPort;
            if (address != null) {
                remoteHostName = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        String remoteHost = null;
                        try {
                            remoteHost = address_final.getHostName();
                            if (remoteHost == null) {
                                remoteHost = address_final.getCanonicalHostName();
                            }
                            return remoteHost;
                        }
                        catch (Throwable e) {
                            remoteHost = address_final.getHostAddress();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Exception getting hostname from socket.", (Object)new Object[]{e});
                            }
                            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createSocket", (Object)this, (Object[])new Object[]{address_final, port_final, localAddress_final, localPort_final});
                            return remoteHost;
                        }
                    }
                });
            }
            HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            connectionInfo.put("com.ibm.ssl.remoteHost", remoteHostName);
            connectionInfo.put("com.ibm.ssl.remotePort", Integer.toString(port));
            if (this.default_constructor) {
                sslprops = LibertySSLSocketFactory.getProperties(null, connectionInfo, null);
            }
            if (sslprops != null) {
                factory = LibertySSLSocketFactory.getSSLSocketFactory(connectionInfo, sslprops);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting SSLSocketFactory.", (Object)new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"checkClientTrusted", (Object)this, (Object[])new Object[]{address, port, localAddress, localPort});
        }
        if (factory == null) {
            throw new SSLException("SSLSocketFactory is null. This can occur if javax.net.ssl.SSLSocketFactory.getDefault() is called to create a socket and javax.net.ssl.* properties are not set.");
        }
        socket = (SSLSocket)factory.createSocket(address, port, localAddress, localPort);
        socket = SSLConfigManager.getInstance().setCipherListOnSocket(sslprops, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSocket");
        }
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createSocket", (Object)new Object[]{host, port});
        }
        SSLSocketFactory factory = this.default_factory;
        SSLSocket socket = null;
        Properties sslprops = this.props;
        try {
            HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            connectionInfo.put("com.ibm.ssl.remoteHost", host);
            connectionInfo.put("com.ibm.ssl.remotePort", Integer.toString(port));
            if (this.default_constructor) {
                sslprops = LibertySSLSocketFactory.getProperties(null, connectionInfo, null);
            }
            if (sslprops != null) {
                factory = LibertySSLSocketFactory.getSSLSocketFactory(connectionInfo, sslprops);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting SSLSocketFactory.", (Object)new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createSocket", (Object)this, (Object[])new Object[]{host, port});
        }
        if (factory == null) {
            throw new SSLException("SSLSocketFactory is null. This can occur if javax.net.ssl.SSLSocketFactory.getDefault() is called to create a socket and javax.net.ssl.* properties are not set.");
        }
        socket = (SSLSocket)factory.createSocket(host, port);
        socket = SSLConfigManager.getInstance().setCipherListOnSocket(sslprops, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSocket");
        }
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createSocket", (Object)new Object[]{host, port, localHost, localPort});
        }
        SSLSocketFactory factory = this.default_factory;
        SSLSocket socket = null;
        Properties sslprops = this.props;
        try {
            HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            connectionInfo.put("com.ibm.ssl.remoteHost", host);
            connectionInfo.put("com.ibm.ssl.remotePort", Integer.toString(port));
            if (this.default_constructor) {
                sslprops = LibertySSLSocketFactory.getProperties(null, connectionInfo, null);
            }
            if (sslprops != null) {
                factory = LibertySSLSocketFactory.getSSLSocketFactory(connectionInfo, sslprops);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting SSLSocketFactory.", (Object)new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createSocket", (Object)this, (Object[])new Object[]{host, port, localHost, localPort});
        }
        if (factory == null) {
            throw new SSLException("SSLSocketFactory is null. This can occur if javax.net.ssl.SSLSocketFactory.getDefault() is called to create a socket and javax.net.ssl.* properties are not set.");
        }
        socket = (SSLSocket)factory.createSocket(host, port, localHost, localPort);
        socket = SSLConfigManager.getInstance().setCipherListOnSocket(sslprops, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSocket");
        }
        return socket;
    }

    public int compare(SocketFactory sf1, SocketFactory sf2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"compare", (Object)new Object[]{sf1, sf2});
        }
        if (sf1 != null && sf2 != null) {
            int sf1hash = sf1.hashCode();
            int sf2hash = sf2.hashCode();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("compare is invoked: \nsf1hash : " + sf1hash + " \nsf2hash : " + sf2hash));
            }
            int output = sf1hash - sf2hash;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("compare : " + output));
            }
            return output;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"one of parameters is null, throwing NullPointerException.");
        }
        throw new NullPointerException();
    }

    private static Properties getSSLPropertiesOnThread() {
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return JSSEHelper.getInstance().getSSLPropertiesOnThread();
            }
        });
    }

    private static Properties getProperties(final String sslAliasName, final Map<String, Object> currentConnectionInfo, final SSLConfigChangeListener listener) throws com.ibm.websphere.ssl.SSLException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() throws Exception {
                    return JSSEHelper.getInstance().getProperties(sslAliasName, currentConnectionInfo, listener);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw (com.ibm.websphere.ssl.SSLException)cause;
        }
    }

    private static SSLSocketFactory getSSLSocketFactory(final Map<String, Object> currentConnectionInfo, final Properties sslProps) throws com.ibm.websphere.ssl.SSLException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<SSLSocketFactory>(){

                @Override
                public SSLSocketFactory run() throws Exception {
                    return JSSEHelper.getInstance().getSSLSocketFactory(currentConnectionInfo, sslProps);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw (com.ibm.websphere.ssl.SSLException)cause;
        }
    }
}

