/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.JSSEProvider;
import com.ibm.ws.ssl.optional.SSLSupportOptional;
import com.ibm.wsspi.ssl.SSLSupport;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class SSLSupportImpl
implements SSLSupport {
    private SSLSupportOptional delegate;
    private Map<String, Object> props;
    private volatile ServiceRegistration<SSLSupport> registration;
    private static final TraceComponent tc = Tr.register(SSLSupportImpl.class);

    public SSLSupportImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"<init>", (Object[])new Object[0]);
        }
    }

    @Activate
    protected void activate(BundleContext ctx) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Activated: " + ctx), (Object[])new Object[0]);
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>(this.props);
        this.registration = ctx.registerService(SSLSupport.class, (Object)this, props);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Activated: return registerService: " + this.registration), (Object[])new Object[0]);
        }
    }

    @Deactivate
    protected void deactivate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Deactivated: ", (Object[])new Object[0]);
        }
        this.registration.unregister();
        this.registration = null;
    }

    @Reference(target="(SSLSupport=active)")
    protected void setSSLSupportOptional(SSLSupportOptional delegate, Map<String, Object> props) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("setSSLSupportOptional: delegate: " + delegate + " props: " + props), (Object[])new Object[0]);
        }
        this.delegate = delegate;
        this.props = props;
    }

    protected void updatedSSLSupportOptional(SSLSupportOptional delegate, Map<String, Object> props) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("updatedSSLSupportOptional: delegate: " + delegate + " props: " + props), (Object[])new Object[0]);
        }
        this.props = props;
        ServiceRegistration<SSLSupport> registration = this.registration;
        if (registration != null) {
            registration.setProperties(new Hashtable<String, Object>(this.props));
        }
    }

    @Override
    public JSSEHelper getJSSEHelper() {
        return this.delegate.getJSSEHelper();
    }

    @Override
    public JSSEProvider getJSSEProvider() {
        return this.delegate.getJSSEProvider();
    }

    @Override
    public JSSEProvider getJSSEProvider(String providerName) {
        return this.delegate.getJSSEProvider(providerName);
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory() {
        return this.delegate.getSSLSocketFactory();
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory(String sslAlias) throws SSLException {
        return this.delegate.getSSLSocketFactory(sslAlias);
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory(Properties sslProps) throws SSLException {
        return this.delegate.getSSLSocketFactory(sslProps);
    }
}

