/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.JSSEProvider;
import com.ibm.ws.kernel.feature.FeatureProvisioner;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.internal.GenericSSLConfigService;
import com.ibm.ws.ssl.internal.KeystoreConfig;
import com.ibm.ws.ssl.internal.LibertyConstants;
import com.ibm.ws.ssl.internal.RepertoireConfigService;
import com.ibm.ws.ssl.internal.SSLConfigValidator;
import com.ibm.ws.ssl.optional.SSLSupportOptional;
import com.ibm.ws.ssl.protocol.LibertySSLSocketFactory;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.felix.scr.component.ExtComponentContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, configurationPid={"com.ibm.ws.ssl.default"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"})
public class SSLComponent
extends GenericSSLConfigService
implements SSLSupportOptional {
    private static final String SSL_SUPPORT_VALUE_ACTIVE = "active";
    private static final String SSL_SUPPORT_KEY = "SSLSupport";
    private static final TraceComponent tc = Tr.register(SSLComponent.class);
    protected static final String MY_ALIAS = "sslDefault";
    private final Map<String, RepertoireConfigService> repertoireMap = new HashMap<String, RepertoireConfigService>();
    private final Map<String, String> repertoirePIDMap = new HashMap<String, String>();
    private final Map<String, Map<String, Object>> repertoirePropertiesMap = new HashMap<String, Map<String, Object>>();
    private final Map<String, WSKeyStore> keystoreIdMap = new HashMap<String, WSKeyStore>();
    private final Map<String, WSKeyStore> keystorePidMap = new HashMap<String, WSKeyStore>();
    private volatile WsLocationAdmin locSvc;
    private FeatureProvisioner provisionerService;
    private SSLConfigValidator validator;
    private boolean transportSecurityEnabled;
    private ExtComponentContext componentContext;

    @Activate
    protected synchronized void activate(ComponentContext ctx, Map<String, Object> properties) {
        Set installedFeatures;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Activated: " + properties), (Object[])new Object[0]);
        }
        if ((installedFeatures = this.provisionerService.getInstalledFeatures()).contains("transportSecurity-1.0")) {
            this.transportSecurityEnabled = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"transportSecurityEnable installed", (Object[])new Object[0]);
            }
        } else {
            this.transportSecurityEnabled = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"transportSecurityEnable is not installed", (Object[])new Object[0]);
            }
        }
        super.activate(MY_ALIAS, properties);
        this.componentContext = (ExtComponentContext)ctx;
        SSLConfigManager.getInstance().setConfigValidator(this.validator);
        this.processConfig(true);
    }

    @Deactivate
    protected synchronized void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Deactivated: " + reason), (Object[])new Object[0]);
        }
        super.deactivate(MY_ALIAS, reason);
        this.repertoireMap.clear();
        this.repertoirePIDMap.clear();
        this.keystoreIdMap.clear();
        this.keystorePidMap.clear();
        this.processConfig(true);
        this.componentContext = null;
    }

    @Modified
    protected synchronized void modified(Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Modified: " + properties), (Object[])new Object[0]);
        }
        super.modified(MY_ALIAS, properties);
        this.processConfig(true);
    }

    @Reference(service=KeystoreConfig.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(id=*)")
    protected synchronized void setKeyStore(KeystoreConfig config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Adding keystore: " + config.getId()), (Object[])new Object[0]);
        }
        this.addKeyStores(false, config);
    }

    protected synchronized void updatedKeyStore(KeystoreConfig config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Updating keystore: " + config.getId()), (Object[])new Object[0]);
        }
        this.addKeyStores(false, config);
    }

    protected synchronized void unsetKeyStore(KeystoreConfig config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Removing keystore: " + config.getId()), (Object[])new Object[0]);
        }
        this.keystoreIdMap.remove(config.getId());
        this.keystorePidMap.remove(config.getPid());
        KeyStoreManager.getInstance().clearKeyStoreFromMap(config.getId());
        Iterator<Map.Entry<String, RepertoireConfigService>> it = this.repertoireMap.entrySet().iterator();
        while (it.hasNext()) {
            RepertoireConfigService rep = it.next().getValue();
            if (rep.getKeyStore() != config && rep.getTrustStore() != config) continue;
            it.remove();
            this.repertoirePropertiesMap.remove(rep.getAlias());
            this.repertoirePIDMap.remove(rep.getPID());
        }
        this.processConfig(true);
    }

    private void addKeyStores(boolean updateSSLConfigManager, KeystoreConfig ... keystores) {
        for (KeystoreConfig config : keystores) {
            WSKeyStore keystore = config.getKeyStore();
            if (keystore == this.keystoreIdMap.put(config.getId(), keystore)) continue;
            updateSSLConfigManager = true;
            this.keystorePidMap.put(config.getPid(), keystore);
        }
        this.processConfig(updateSSLConfigManager);
    }

    @Reference(service=RepertoireConfigService.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(id=*)")
    protected synchronized void setRepertoire(RepertoireConfigService config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Adding repertoire: " + config.getAlias()), (Object[])new Object[0]);
        }
        Map<String, Object> properties = config.getProperties();
        this.repertoireMap.put(config.getAlias(), config);
        this.repertoirePIDMap.put(config.getPID(), config.getAlias());
        this.repertoirePropertiesMap.put(config.getAlias(), properties);
        this.addKeyStores(true, config.getKeyStore(), config.getTrustStore());
    }

    protected synchronized void updatedRepertoire(RepertoireConfigService config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Updating repertoire: " + config.getAlias()), (Object[])new Object[0]);
        }
        Map<String, Object> properties = config.getProperties();
        this.repertoirePropertiesMap.put((String)properties.get("id"), properties);
        this.repertoirePIDMap.put(config.getPID(), config.getAlias());
        this.addKeyStores(true, config.getKeyStore(), config.getTrustStore());
    }

    protected synchronized void unsetRepertoire(RepertoireConfigService config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Removing repertoire: " + config.getAlias()), (Object[])new Object[0]);
        }
        this.repertoireMap.remove(config.getAlias());
        this.repertoirePIDMap.remove(config.getPID());
        this.repertoirePropertiesMap.remove(config.getAlias());
        this.processConfig(this.repertoirePropertiesMap.remove(config.getAlias()) != null);
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setLocMgr(WsLocationAdmin locSvc) {
        this.locSvc = locSvc;
    }

    protected void unsetLocMgr(ServiceReference<WsLocationAdmin> ref) {
    }

    @Reference(service=FeatureProvisioner.class)
    protected synchronized void setKernelProvisioner(FeatureProvisioner provisionerService) {
        this.provisionerService = provisionerService;
    }

    protected synchronized void unsetKernelProvisioner(FeatureProvisioner provisionerService) {
        this.transportSecurityEnabled = false;
        this.provisionerService = null;
    }

    @Reference(service=SSLConfigValidator.class)
    protected synchronized void setSSLConfigValidator(SSLConfigValidator validator) {
        this.validator = validator;
    }

    protected synchronized void unsetSSLConfigValidator(SSLConfigValidator validator) {
        this.validator = null;
    }

    private synchronized void processConfig(boolean updateSSLConfigManager) {
        Hashtable<String, Object> serviceProps;
        block7: {
            if (this.componentContext == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Not yet activated, can not process config", (Object[])new Object[0]);
                }
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Processing configuration", (Object[])new Object[0]);
            }
            boolean isServer = this.locSvc.resolveString("${wlp.process.type}").equals("server");
            serviceProps = new Hashtable<String, Object>(this.config);
            ((Dictionary)serviceProps).put("repertoireIds", this.repertoireMap.keySet().toArray(new String[this.repertoireMap.size()]));
            ((Dictionary)serviceProps).put("keystoreIds", this.keystoreIdMap.keySet().toArray(new String[this.keystoreIdMap.size()]));
            ((Dictionary)serviceProps).put("repertoirePIDs", this.repertoirePIDMap.keySet().toArray(new String[this.repertoirePIDMap.size()]));
            if (updateSSLConfigManager) {
                try {
                    SSLConfigManager.getInstance().initializeSSL(this.getGlobalProps(), this.getRepertoireProps(), this.getKeyStores(), true, isServer, this.transportSecurityEnabled, this.repertoirePIDMap);
                }
                catch (com.ibm.websphere.ssl.SSLException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                    Tr.event((TraceComponent)tc, (String)("Exception processing SSL configuration; " + e), (Object[])new Object[0]);
                }
            }
        }
        if (!this.repertoireMap.isEmpty() && !this.keystoreIdMap.isEmpty()) {
            ((Dictionary)serviceProps).put(SSL_SUPPORT_KEY, SSL_SUPPORT_VALUE_ACTIVE);
        }
        this.componentContext.setServiceProperties(serviceProps);
    }

    Map<String, Object> getGlobalProps() {
        String hostNameVerification;
        Map<String, Object> props = this.getProperties();
        String repertoire = (String)props.get("sslRef");
        if (repertoire != null) {
            props.put("com.ibm.ssl.defaultAlias", repertoire);
        } else {
            props.put("com.ibm.ssl.defaultAlias", "defaultSSLConfig");
        }
        String outBoundDefault = (String)props.get(LibertyConstants.KEY_OUTBOUND_DEFAULT_REPERTOIRE);
        if (outBoundDefault != null) {
            props.put("com.ibm.ws.ssl.outboundDefaultAlias", outBoundDefault);
        }
        if ((hostNameVerification = (String)props.get(LibertyConstants.KEY_OUTBOUND_HOSTNAME_VERIFICATION)) != null) {
            props.put("com.ibm.ssl.performURLHostNameVerification", hostNameVerification);
        }
        return props;
    }

    Map<String, Map<String, Object>> getRepertoireProps() {
        return this.repertoirePropertiesMap;
    }

    Map<String, WSKeyStore> getKeyStores() {
        HashMap<String, WSKeyStore> ret = new HashMap<String, WSKeyStore>(this.keystoreIdMap);
        ret.putAll(this.keystorePidMap);
        return ret;
    }

    @Override
    public synchronized JSSEHelper getJSSEHelper() {
        return JSSEHelper.getInstance();
    }

    @Override
    public JSSEProvider getJSSEProvider() {
        return JSSEProviderFactory.getInstance();
    }

    @Override
    public JSSEProvider getJSSEProvider(String providerName) {
        return JSSEProviderFactory.getInstance(providerName);
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory() {
        return new LibertySSLSocketFactory();
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory(String sslAlias) throws SSLException {
        if (sslAlias != null) {
            return new LibertySSLSocketFactory(sslAlias);
        }
        return new LibertySSLSocketFactory();
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory(Properties sslProps) throws SSLException {
        if (sslProps != null && sslProps.isEmpty() || sslProps == null) {
            return new LibertySSLSocketFactory();
        }
        return new LibertySSLSocketFactory(sslProps);
    }
}

