/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.adaptable.module.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.PrivHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.adaptable.module.adapters.AdapterFactoryService;
import com.ibm.wsspi.adaptable.module.adapters.ContainerAdapter;
import com.ibm.wsspi.adaptable.module.adapters.EntryAdapter;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSetMap;
import com.ibm.wsspi.kernel.service.utils.ServiceAndServiceReferencePair;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.ext.annotation.DSExt;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
@DSExt.ConfigurableServiceProperties
public class AdapterFactoryServiceImpl
implements AdapterFactoryService {
    private static final String toType = "toType";
    private final ConcurrentServiceReferenceSetMap<String, ContainerAdapter<?>> containerHelperMap = new ConcurrentServiceReferenceSetMap("containerHelper");
    private final ConcurrentServiceReferenceSetMap<String, EntryAdapter<?>> entryHelperMap = new ConcurrentServiceReferenceSetMap("entryHelper");
    private final Set<String> containerToTypes = Collections.synchronizedSet(new HashSet());
    private final Set<String> entryToTypes = Collections.synchronizedSet(new HashSet());
    private Map<String, Object> baseProperties;
    static final long serialVersionUID = 952155456255648568L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    protected Map<String, Object> activate(ComponentContext cCtx, Map<String, Object> properties) {
        this.entryHelperMap.activate(cCtx);
        this.containerHelperMap.activate(cCtx);
        this.baseProperties = properties;
        return this.getProperties();
    }

    @Deactivate
    protected void deactivate(ComponentContext cCtx) {
        this.entryHelperMap.deactivate(cCtx);
        this.containerHelperMap.deactivate(cCtx);
        this.baseProperties = null;
    }

    @Reference(name="containerHelper", service=ContainerAdapter.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected Map<String, Object> setContainerHelper(ServiceReference<ContainerAdapter<?>> helper) {
        Object o = helper.getProperty(toType);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            String key = (String)o;
            this.containerToTypes.add(key);
            this.containerHelperMap.putReference((Object)key, helper);
        } else if (o instanceof String[]) {
            for (String key : (String[])o) {
                this.containerToTypes.add(key);
                this.containerHelperMap.putReference((Object)key, helper);
            }
        }
        return this.getProperties();
    }

    @Reference(name="entryHelper", service=EntryAdapter.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected Map<String, Object> setEntryHelper(ServiceReference<EntryAdapter<?>> helper) {
        Object o = helper.getProperty(toType);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            String key = (String)o;
            this.entryToTypes.add(key);
            this.entryHelperMap.putReference((Object)key, helper);
        } else if (o instanceof String[]) {
            for (String key : (String[])o) {
                this.entryToTypes.add(key);
                this.entryHelperMap.putReference((Object)key, helper);
            }
        }
        return this.getProperties();
    }

    protected Map<String, Object> unsetContainerHelper(ServiceReference<ContainerAdapter<?>> helper) {
        Object o = helper.getProperty(toType);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            String key = (String)o;
            this.containerHelperMap.removeReference((Object)key, helper);
            Iterator test = this.containerHelperMap.getServices((Object)key);
            if (test == null || !test.hasNext()) {
                this.containerToTypes.remove(key);
            }
        } else if (o instanceof String[]) {
            for (String key : (String[])o) {
                this.containerHelperMap.removeReference((Object)key, helper);
                Iterator test = this.containerHelperMap.getServices((Object)key);
                if (test != null && test.hasNext()) continue;
                this.containerToTypes.remove(key);
            }
        }
        return this.getProperties();
    }

    protected Map<String, Object> unsetEntryHelper(ServiceReference<EntryAdapter<?>> helper) {
        Object o = helper.getProperty(toType);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            String key = (String)o;
            this.entryHelperMap.removeReference((Object)key, helper);
            Iterator test = this.entryHelperMap.getServices((Object)key);
            if (test == null || !test.hasNext()) {
                this.entryToTypes.remove(key);
            }
        } else if (o instanceof String[]) {
            for (String key : (String[])o) {
                this.entryHelperMap.removeReference((Object)key, helper);
                Iterator test = this.entryHelperMap.getServices((Object)key);
                if (test != null && test.hasNext()) continue;
                this.entryToTypes.remove(key);
            }
        }
        return this.getProperties();
    }

    private Map<String, Object> getProperties() {
        if (this.baseProperties == null) {
            return null;
        }
        HashMap<String, Object> props = new HashMap<String, Object>(this.baseProperties);
        props.put("containerToType", this.containerToTypes.toArray(new String[this.containerToTypes.size()]));
        props.put("entryToType", this.entryToTypes.toArray(new String[this.entryToTypes.size()]));
        return props;
    }

    @Override
    public <T> T adapt(Container root, OverlayContainer rootOverlay, ArtifactContainer artifactContainer, Container containerToAdapt, Class<T> t) throws UnableToAdaptException {
        String key = t.getName();
        Iterator i = this.containerHelperMap.getServicesWithReferences((Object)key);
        if (i != null) {
            while (i.hasNext()) {
                ServiceAndServiceReferencePair sandr = (ServiceAndServiceReferencePair)i.next();
                ServiceReference sr = sandr.getServiceReference();
                try {
                    Object adapted;
                    ContainerAdapter ca;
                    Class clz = PrivHelper.loadClass((Bundle)sr.getBundle(), (String)t.getName());
                    if (clz != t || (ca = (ContainerAdapter)sandr.getService()) == null || (adapted = ca.adapt(root, rootOverlay, artifactContainer, containerToAdapt)) == null) continue;
                    return adapted;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.adaptable.module.internal.AdapterFactoryServiceImpl", (String)"199", (Object)this, (Object[])new Object[]{root, rootOverlay, artifactContainer, containerToAdapt, t});
                }
            }
        }
        return null;
    }

    @Override
    public <T> T adapt(Container root, OverlayContainer rootOverlay, ArtifactEntry artifactEntry, Entry entryToAdapt, Class<T> t) throws UnableToAdaptException {
        String key = t.getName();
        Iterator i = this.entryHelperMap.getServicesWithReferences((Object)key);
        if (i != null) {
            while (i.hasNext()) {
                ServiceAndServiceReferencePair sandr = (ServiceAndServiceReferencePair)i.next();
                ServiceReference sr = sandr.getServiceReference();
                try {
                    Object adapted;
                    EntryAdapter ea;
                    Class clz = PrivHelper.loadClass((Bundle)sr.getBundle(), (String)t.getName());
                    if (clz != t || (ea = (EntryAdapter)sandr.getService()) == null || (adapted = ea.adapt(root, rootOverlay, artifactEntry, entryToAdapt)) == null) continue;
                    return adapted;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.adaptable.module.internal.AdapterFactoryServiceImpl", (String)"230", (Object)this, (Object[])new Object[]{root, rootOverlay, artifactEntry, entryToAdapt, t});
                }
            }
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(AdapterFactoryServiceImpl.class);
    }
}

