/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.itemstreams;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.msgstore.DeliveryDelayDeleteFilter;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.Statistics;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.BaseMessageItemStream;
import com.ibm.ws.sib.processor.runtime.impl.LocalTopicSpaceControl;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public final class PubSubMessageItemStream
extends BaseMessageItemStream {
    private static final TraceComponent tc = SibTr.register(PubSubMessageItemStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private LocalizationDefinition _lastLocalizationDefinitionSetByAdmin = null;
    private boolean _isSendAllowed;
    private long _alterationTime;
    private String _name;
    private long _remoteQueueHighLimit;
    private long referenceStreamCount;
    private volatile boolean HasToStop = false;
    private final ReentrantLock deleteMessageslock = new ReentrantLock();

    public PubSubMessageItemStream() {
    }

    public PubSubMessageItemStream(BaseDestinationHandler destinationHandler, Transaction transaction) throws OutOfCacheSpace, MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"PubSubMessageItemStream", (Object)new Object[]{destinationHandler, transaction});
        }
        this.setStorageStrategy(destinationHandler.getStorageStrategy());
        destinationHandler.addItemStream(this, transaction);
        this.initializeNonPersistent(destinationHandler);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"PubSubMessageItemStream", (Object)this);
        }
    }

    @Override
    public void removeItemStream(Transaction transaction, long lockID) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeItemStream", (Object)new Object[]{transaction, lockID});
        }
        this.deregisterControlAdapterMBean();
        this.remove(transaction, lockID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeItemStream");
        }
    }

    public void reconstitute(BaseDestinationHandler destinationHandler) throws SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitute", (Object)destinationHandler);
        }
        this.initializeNonPersistent(destinationHandler);
        this.setDestMsgInterval();
        try {
            Statistics statistics = this.getStatistics();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"reconstitute - counts total items, available items", (Object)new Object[]{statistics.getTotalItemCount(), statistics.getAvailableItemCount()});
            }
        }
        catch (MessageStoreException e) {
            SibTr.exit((TraceComponent)tc, (String)"reconstitute", (Object)((Object)e));
        }
    }

    public void stopDeletingMsgsWihoutReferencesTask(boolean hasToStop) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopDeletingMsgsWihoutReferencesTask", (Object)hasToStop);
        }
        this.HasToStop = hasToStop;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopDeletingMsgsWihoutReferencesTask", (Object)hasToStop);
        }
    }

    private boolean HasToStop() {
        return this.HasToStop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMsgsWithNoReferences() {
        block18: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"deleteMsgsWithNoReferences");
            }
            NonLockingCursor cursor = null;
            try {
                if (!this.deleteMessageslock.tryLock(0L, TimeUnit.SECONDS)) break block18;
                LocalTransaction transaction = this.destinationHandler.getTxManager().createLocalTransaction(true);
                cursor = this.newNonLockingItemCursor(new ClassEqualsFilter(MessageItem.class));
                MessageItem messageItem = (MessageItem)cursor.next();
                while (messageItem != null && !this.HasToStop()) {
                    if (messageItem.getReferenceCount() == 0) {
                        try {
                            messageItem.remove((Transaction)transaction, -2L);
                        }
                        catch (NotInMessageStore e) {
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        }
                    }
                    messageItem = (MessageItem)cursor.next();
                }
                transaction.commit();
            }
            catch (InterruptedException e) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream.deleteMsgsWithNoReferences", (String)"1:244:1.71", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteMsgsWithNoReferences", (Object)((Object)e));
                }
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream.deleteMsgsWithNoReferences", (String)"1:244:1.72", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteMsgsWithNoReferences", (Object)((Object)e));
                }
            }
            finally {
                if (cursor != null) {
                    cursor.finished();
                }
                if (this.deleteMessageslock.getHoldCount() > 0) {
                    this.deleteMessageslock.unlock();
                }
            }
        }
    }

    public boolean isRemoteQueueHighLimit() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isRemoteQueueHighLimit");
        }
        boolean limited = false;
        if (this._destHighMsgs != -1L) {
            boolean bl = limited = this.getTotalMsgCount() >= this._remoteQueueHighLimit;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isRemoteQueueHighLimit", (Object)limited);
        }
        return limited;
    }

    public boolean isQLowRemoteLimit() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isQLowRemoteLimit");
        }
        long remoteLowLimit = this._destHighMsgs;
        boolean isUnderDestinationLowLimit = false;
        if (this._remoteQueueHighLimit > this._destHighMsgs) {
            remoteLowLimit = this._remoteQueueHighLimit - (this._remoteQueueHighLimit - this._destHighMsgs) / 2L;
        }
        boolean bl = isUnderDestinationLowLimit = this.getTotalMsgCount() <= remoteLowLimit;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Queue depth=" + this.getTotalMsgCount() + ", RemoteLowLimit=" + remoteLowLimit));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isQLowRemoteLimit", (Object)isUnderDestinationLowLimit);
        }
        return isUnderDestinationLowLimit;
    }

    @Override
    public BaseDestinationHandler getDestinationHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationHandler");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationHandler", (Object)this.destinationHandler);
        }
        return this.destinationHandler;
    }

    public long countAvailablePublications() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"countAvailablePublications");
        }
        int subs = this.destinationHandler.getSubscriptionIndex().getTotalSubscriptions();
        long pubs = -1L;
        try {
            pubs = this.getStatistics().getAvailableItemCount() - (long)subs - 1L;
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream.countAvailablePublications", (String)"1:465:1.74", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"countAvailablePublications", (Object)pubs);
        }
        return pubs;
    }

    public LocalizationDefinition getLocalizationDefinition() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalizationDefinition");
            SibTr.exit((TraceComponent)tc, (String)"getLocalizationDefinition", (Object)this._lastLocalizationDefinitionSetByAdmin);
        }
        return this._lastLocalizationDefinitionSetByAdmin;
    }

    public void updateLocalizationDefinition(LocalizationDefinition newLocalizationDefinition) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateLocalizationDefinition", (Object)newLocalizationDefinition);
        }
        if (null != newLocalizationDefinition) {
            boolean isDestHighMsgsChanged = false;
            boolean isDestLowMsgsChanged = false;
            boolean isSendAllowedChanged = false;
            boolean isAlterationTimeChanged = false;
            boolean isNameChanged = false;
            if (null == this._lastLocalizationDefinitionSetByAdmin) {
                isDestHighMsgsChanged = true;
                isDestLowMsgsChanged = true;
                isSendAllowedChanged = true;
                isAlterationTimeChanged = true;
                isNameChanged = true;
            } else {
                if (this._lastLocalizationDefinitionSetByAdmin.getDestinationHighMsgs() != newLocalizationDefinition.getDestinationHighMsgs()) {
                    isDestHighMsgsChanged = true;
                }
                if (this._lastLocalizationDefinitionSetByAdmin.getDestinationLowMsgs() != newLocalizationDefinition.getDestinationLowMsgs()) {
                    isDestLowMsgsChanged = true;
                }
                if (this._lastLocalizationDefinitionSetByAdmin.isSendAllowed() != newLocalizationDefinition.isSendAllowed()) {
                    isSendAllowedChanged = true;
                }
                if (this._lastLocalizationDefinitionSetByAdmin.getAlterationTime() != newLocalizationDefinition.getAlterationTime()) {
                    isAlterationTimeChanged = true;
                }
                String oldName = this._lastLocalizationDefinitionSetByAdmin.getName();
                String newName = newLocalizationDefinition.getName();
                if (null == newName && oldName != null || null != newName && oldName == null) {
                    isNameChanged = true;
                }
            }
            this._lastLocalizationDefinitionSetByAdmin = newLocalizationDefinition;
            if (isDestHighMsgsChanged) {
                this.setDestHighMsgs(newLocalizationDefinition.getDestinationHighMsgs());
            }
            if (isDestLowMsgsChanged) {
                this.setDestLowMsgs(newLocalizationDefinition.getDestinationLowMsgs());
            }
            if (isSendAllowedChanged) {
                this.setSendAllowed(newLocalizationDefinition.isSendAllowed());
            }
            if (isAlterationTimeChanged) {
                this.setAlterationTime(newLocalizationDefinition.getAlterationTime());
            }
            if (isNameChanged) {
                this.setName(newLocalizationDefinition.getName());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateLocalizationDefinition");
        }
    }

    @Override
    public void createControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        this.controlAdapter = new LocalTopicSpaceControl(this.destinationHandler.getMessageProcessor(), this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    @Override
    public void deregisterControlAdapterMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
        LocalTopicSpaceControl control = (LocalTopicSpaceControl)this.getControlAdapter();
        control.deregisterControlAdapterMBean();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
    }

    @Override
    public void setDestHighMsgs(long newDestHighMsgs) {
        long newRemoteQueueHigh;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestHighMsgs", (Object)newDestHighMsgs);
        }
        super.setDestHighMsgs(newDestHighMsgs);
        long increase = (long)((double)this._destHighMsgs * this.destinationHandler.getMessageProcessor().getCustomProperties().get_remote_queue_high_percentage_excess());
        if (increase == 0L) {
            ++increase;
        }
        if ((newRemoteQueueHigh = this._destHighMsgs + increase) < this._destHighMsgs) {
            this._remoteQueueHighLimit = Long.MAX_VALUE;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"remote Queue High Limit might be too small to prevent deadlock");
            }
        } else {
            this._remoteQueueHighLimit = newRemoteQueueHigh;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("remoteQueueHighLimit=" + this._remoteQueueHighLimit));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestHighMsgs");
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
        LocalTopicSpaceControl control = (LocalTopicSpaceControl)this.getControlAdapter();
        control.registerControlAdapterAsMBean();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
    }

    @Override
    public void dereferenceControlAdapter() {
        this.controlAdapter.dereferenceControllable();
        this.controlAdapter = null;
    }

    private void setName(String newName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setName", (Object)newName);
        }
        this._name = newName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setName");
        }
    }

    public String getName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)this._name);
        }
        return this._name;
    }

    public boolean isSendAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSendAllowed");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSendAllowed", (Object)this._isSendAllowed);
        }
        return this._isSendAllowed;
    }

    public void setSendAllowed(boolean newIsSendAllowedValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setSendAllowed", (Object)newIsSendAllowedValue);
        }
        this._isSendAllowed = newIsSendAllowedValue;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setSendAllowed");
        }
    }

    public long getAlterationTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAlterationTime");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAlterationTime", (Object)this._alterationTime);
        }
        return this._alterationTime;
    }

    public void setAlterationTime(long newAlterationTime) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setAlterationTime", (Object)newAlterationTime);
        }
        this._alterationTime = newAlterationTime;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setAlterationTime");
        }
    }

    public boolean removeAllItemsWithNoRefCount(Transaction tran) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeAllItemsWithNoRefCount", (Object)tran);
        }
        Item item = null;
        boolean deletedItems = false;
        try {
            this.deleteMessageslock.lockInterruptibly();
            while (null != (item = this.findFirstMatchingItem((Filter)new DeliveryDelayDeleteFilter()))) {
                try {
                    if (item.getReferenceCount() != 0) continue;
                    item.remove(tran, -2L);
                    deletedItems = true;
                }
                catch (NotInMessageStore e) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
            }
        }
        catch (InterruptedException e) {
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream.removeAllItemsWithNoRefCount", (String)"1:840:1.74", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeAllItemsWithNoRefCount", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        finally {
            this.deleteMessageslock.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeAllItemsWithNoRefCount", (Object)deletedItems);
        }
        return deletedItems;
    }

    @Override
    public long getTotalMsgCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTotalMsgCount");
        }
        long count = -1L;
        try {
            count = this.getStatistics().getTotalItemCount() - this.getSubscriberCount();
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream.getTotalMsgCount", (String)"1:872:1.74", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTotalMsgCount", (Object)count);
        }
        return count;
    }

    private synchronized long getSubscriberCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriberCount");
            SibTr.exit((TraceComponent)tc, (String)"getSubscriberCount", (Object)this.referenceStreamCount);
        }
        return this.referenceStreamCount;
    }

    public synchronized void decrementReferenceStreamCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"decrementReferenceStreamCount");
        }
        --this.referenceStreamCount;
        this.updateWatermarks(this.getTotalMsgCount());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"decrementReferenceStreamCount", (Object)this.referenceStreamCount);
        }
    }

    public synchronized void incrementReferenceStreamCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"incrementReferenceStreamCount");
        }
        ++this.referenceStreamCount;
        this.updateWatermarks(this.getTotalMsgCount());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"incrementReferenceStreamCount", (Object)this.referenceStreamCount);
        }
    }

    @Override
    protected void setWatermarks(long nextLowWatermark, long nextHighWatermark) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setWatermarks", (Object)new Object[]{new Long(nextLowWatermark), new Long(nextHighWatermark), new Long(this.referenceStreamCount)});
        }
        super.setWatermarks(nextLowWatermark + this.referenceStreamCount, nextHighWatermark + this.referenceStreamCount);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setWatermarks");
        }
    }

    @Override
    public long getCountHighWaterMark() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCountHighWaterMark");
        }
        long destHigh = this._destHighMsgs + this.getSubscriberCount();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getCountHighWaterMark", (Object)destHigh);
        }
        return destHigh;
    }

    @Override
    public long getCountLowWaterMark() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCountLowWaterMark");
        }
        long destLow = this._destLowMsgs + this.getSubscriberCount();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getCountLowWaterMark", (Object)destLow);
        }
        return destLow;
    }
}

