/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.processor.MPConsumerSession;
import com.ibm.ws.sib.processor.MPSubscription;
import com.ibm.ws.sib.processor.exceptions.SIMPMessageNotLockedException;
import com.ibm.ws.sib.processor.exceptions.SIMPTemporaryDestinationNotFoundException;
import com.ibm.ws.sib.processor.impl.BifurcatedConsumerSessionImpl;
import com.ibm.ws.sib.processor.impl.ConnectionImpl;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.OrderingContextImpl;
import com.ibm.ws.sib.processor.impl.corespitrace.CoreSPIConsumerSession;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerManager;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.LocalConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.MPDestinationSession;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.StoppableAsynchConsumerCallback;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINonDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.util.LinkedList;
import java.util.List;

public final class ConsumerSessionImpl
implements MPConsumerSession,
MPDestinationSession {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(ConsumerSessionImpl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private final MessageProcessor _messageProcessor;
    private final boolean _enableReadAhead;
    private final boolean _forwardScanning;
    private final ConnectionImpl _connection;
    private final LocalConsumerPoint _localConsumerPoint;
    private final SIDestinationAddress _destAddr;
    private final boolean _bifurcatable;
    private final boolean _ignoreInitialIndoubts;
    private long _consumerId;
    private List<BifurcatedConsumerSessionImpl> _bifurcatedConsumers;
    private final SIBUuid12 uuid;
    private boolean bumpRedeliveryOnBifurcatedClose = true;

    ConsumerSessionImpl(DestinationHandler destination, SIDestinationAddress destAddr, ConsumerDispatcherState state, ConnectionImpl connection, boolean enableReadAhead, boolean forwardScanning, Reliability unrecoverableReliability, boolean bifurcatable, boolean ignoreInitialIndoubts, boolean gatherMessages) throws SINotPossibleInCurrentConfigurationException, SITemporaryDestinationNotFoundException, SISessionDroppedException, SIDestinationLockedException, SIDurableSubscriptionMismatchException, SINonDurableSubscriptionMismatchException, SIDiscriminatorSyntaxException, SISelectorSyntaxException, SIDurableSubscriptionNotFoundException, SISessionUnavailableException, SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ConsumerSessionImpl", (Object)new Object[]{destination, destAddr, state, connection, enableReadAhead, forwardScanning, unrecoverableReliability, bifurcatable, ignoreInitialIndoubts, gatherMessages});
        }
        this._connection = connection;
        this._messageProcessor = connection.getMessageProcessor();
        this._enableReadAhead = enableReadAhead;
        this._forwardScanning = forwardScanning;
        this._bifurcatable = bifurcatable;
        this._ignoreInitialIndoubts = ignoreInitialIndoubts;
        this._destAddr = destAddr;
        this.uuid = new SIBUuid12();
        ((JsDestinationAddress)destAddr).setBusName(this._messageProcessor.getMessagingEngineBus());
        JsDestinationAddress jsDestAddr = (JsDestinationAddress)destAddr;
        if (!destination.isPubSub()) {
            ConsumerManager consumerManager = destination.getLocalPtoPConsumerManager();
            if (jsDestAddr.getME() == null && jsDestAddr.isLocalOnly() && consumerManager != null) {
                jsDestAddr.setME(this._messageProcessor.getMessagingEngineUuid());
            }
            if (consumerManager == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"ConsumerDispatcher not found ");
                }
            } else if (consumerManager.isLocked()) {
                if (consumerManager.getDestination().isTemporary()) {
                    SIMPTemporaryDestinationNotFoundException e = new SIMPTemporaryDestinationNotFoundException(nls.getFormattedMessage("DESTINATION_IS_LOCKED_ERROR_CWSIP0133", new Object[]{destination.getName(), this._messageProcessor.getMessagingEngineName()}, null));
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"ConsumerSessionImpl", (Object)e);
                    }
                    throw e;
                }
                SINotPossibleInCurrentConfigurationException e = new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_IS_LOCKED_ERROR_CWSIP0133", new Object[]{destination.getName(), this._messageProcessor.getMessagingEngineName()}, null));
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"ConsumerSessionImpl", (Object)((Object)e));
                }
                throw e;
            }
        }
        this._localConsumerPoint = new JSLocalConsumerPoint(destination, jsDestAddr, state, this, unrecoverableReliability, bifurcatable, gatherMessages);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ConsumerSessionImpl", (Object)this);
        }
    }

    public SIBusMessage receiveNoWait(SITransaction siTran) throws SIErrorException, SISessionUnavailableException, SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"receiveNoWait", (Object)new Object[]{this, siTran});
        }
        this.checkTransaction(siTran, "TRANSACTION_RECEIVE_USAGE_ERROR_CWSIP0777");
        JsMessage jsMsg = null;
        boolean sucessful = false;
        try {
            jsMsg = this._localConsumerPoint.receive(-1L, (TransactionCommon)siTran);
            sucessful = true;
        }
        catch (SINotPossibleInCurrentConfigurationException e) {
            if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"receiveNoWait", (Object)"SISessionUnavailableException");
            }
            throw new SISessionUnavailableException(nls.getFormattedMessage("CONSUMER_CLOSED_ERROR_CWSIP0177", new Object[]{this._destAddr.getDestinationName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
            UserTrace.trace_Receive(siTran, jsMsg, this._destAddr, this.getIdInternal());
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"receiveNoWait", (Object)jsMsg);
        }
        return jsMsg;
    }

    public SIBusMessage receiveWithWait(SITransaction siTran, long timeout) throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"receiveWithWait", (Object)new Object[]{this, new Long(timeout), siTran});
        }
        this.checkTransaction(siTran, "TRANSACTION_RECEIVE_USAGE_ERROR_CWSIP0777");
        JsMessage jsMsg = null;
        boolean sucessful = false;
        try {
            jsMsg = this._localConsumerPoint.receive(timeout, (TransactionCommon)siTran);
            sucessful = true;
        }
        catch (SINotPossibleInCurrentConfigurationException e) {
            if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"receiveWithWait", (Object)"SISessionUnavailableException");
            }
            throw new SISessionUnavailableException(nls.getFormattedMessage("CONSUMER_CLOSED_ERROR_CWSIP0177", new Object[]{this._destAddr.getDestinationName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
            UserTrace.trace_Receive(siTran, jsMsg, this._destAddr, this.getIdInternal());
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"receiveWithWait", (Object)jsMsg);
        }
        return jsMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attachBifurcatedConsumer(BifurcatedConsumerSessionImpl consumer) {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachBifurcatedConsumer", (Object)consumer);
        }
        if (this._bifurcatedConsumers == null) {
            object = this;
            synchronized (object) {
                if (this._bifurcatedConsumers == null) {
                    this._bifurcatedConsumers = new LinkedList<BifurcatedConsumerSessionImpl>();
                }
            }
        }
        object = this._bifurcatedConsumers;
        synchronized (object) {
            this._bifurcatedConsumers.add(consumer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attachBifurcatedConsumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeBifurcatedConsumer(BifurcatedConsumerSessionImpl consumer) throws SIResourceException, SISessionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeBifurcatedConsumer", (Object)consumer);
        }
        List<BifurcatedConsumerSessionImpl> list = this._bifurcatedConsumers;
        synchronized (list) {
            this._bifurcatedConsumers.remove(consumer);
        }
        this._localConsumerPoint.cleanupBifurcatedConsumer(consumer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeBifurcatedConsumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"close", (Object)this);
        }
        this._close();
        this._connection.removeConsumerSession(this);
        if (this._bifurcatedConsumers != null) {
            BifurcatedConsumerSessionImpl[] bifurcatedConsumersCopy;
            List<BifurcatedConsumerSessionImpl> list = this._bifurcatedConsumers;
            synchronized (list) {
                bifurcatedConsumersCopy = new BifurcatedConsumerSessionImpl[this._bifurcatedConsumers.size()];
                bifurcatedConsumersCopy = this._bifurcatedConsumers.toArray(bifurcatedConsumersCopy);
            }
            for (int i = 0; i < bifurcatedConsumersCopy.length; ++i) {
                bifurcatedConsumersCopy[i]._close();
            }
            this._bifurcatedConsumers = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"close");
        }
    }

    void _close() throws SIResourceException, SIConnectionLostException, SIErrorException {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"_close");
            }
            try {
                this._localConsumerPoint.close();
            }
            catch (SINotPossibleInCurrentConfigurationException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                SibTr.debug((TraceComponent)tc, (String)"_close", (Object)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNotClosed() throws SISessionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkNotClosed");
        }
        try {
            LocalConsumerPoint localConsumerPoint = this._localConsumerPoint;
            synchronized (localConsumerPoint) {
                this._localConsumerPoint.checkNotClosed();
            }
        }
        catch (SISessionUnavailableException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkNotClosed", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkNotClosed");
        }
    }

    public void registerAsynchConsumerCallback(AsynchConsumerCallback callback, int maxActiveMessages, long messageLockExpiry, int maxBatchSize, OrderingContext context) throws SISessionUnavailableException, SISessionDroppedException, SIErrorException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"registerAsynchConsumerCallback", (Object)new Object[]{this, callback, new Integer(maxActiveMessages), new Long(messageLockExpiry), new Integer(maxBatchSize), context});
        }
        this.registerAsynchConsumerCallback(callback, maxActiveMessages, messageLockExpiry, maxBatchSize, null, false, context);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"registerAsynchConsumerCallback");
        }
    }

    public void registerAsynchConsumerCallback(AsynchConsumerCallback callback, int maxActiveMessages, long messageLockExpiry, int maxBatchSize, Reliability unrecoverableReliability, boolean inLine, OrderingContext context) throws SISessionDroppedException, SISessionUnavailableException, SIErrorException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"registerAsynchConsumerCallback", (Object)new Object[]{this, callback, new Integer(maxActiveMessages), new Long(messageLockExpiry), new Integer(maxBatchSize), unrecoverableReliability, inLine, context});
        }
        this._localConsumerPoint.registerAsynchConsumer(callback, maxActiveMessages, messageLockExpiry, maxBatchSize, unrecoverableReliability, inLine, (OrderingContextImpl)context, null);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"registerAsynchConsumerCallback");
        }
    }

    public void deregisterAsynchConsumerCallback() throws SISessionUnavailableException, SISessionDroppedException, SIErrorException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"deregisterAsynchConsumerCallback", (Object)this);
        }
        this.registerAsynchConsumerCallback(null, 1, 0L, 1, null);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"deregisterAsynchConsumerCallback");
        }
    }

    public void start(boolean deliverImmediately) throws SISessionUnavailableException, SISessionDroppedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"start", (Object)new Object[]{this, deliverImmediately});
        }
        this._localConsumerPoint.start(deliverImmediately);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"start");
        }
    }

    public void stop() throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"stop", (Object)this);
        }
        this._localConsumerPoint.stop();
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"stop");
        }
    }

    public SICoreConnection getConnection() throws SISessionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"getConnection", (Object)this);
        }
        this.checkNotClosed();
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"getConnection", (Object)this._connection);
        }
        return this._connection;
    }

    protected SICoreConnection getConnectionInternal() {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"getConnectionInternal", (Object)this);
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"getConnectionInternal", (Object)this._connection);
        }
        return this._connection;
    }

    public void unlockSet(SIMessageHandle[] msgHandles) throws SIMPMessageNotLockedException, SISessionUnavailableException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"unlockSet", (Object)new Object[]{this, SIMPUtils.messageHandleArrayToString(msgHandles)});
        }
        this._localConsumerPoint.processMsgSet(msgHandles, null, null, true, false, false, true);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"unlockSet");
        }
    }

    public void unlockSet(SIMessageHandle[] msgHandles, boolean incrementLockCount) throws SIMPMessageNotLockedException, SISessionUnavailableException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"unlockSet", (Object)new Object[]{this, SIMPUtils.messageHandleArrayToString(msgHandles), incrementLockCount});
        }
        this._localConsumerPoint.processMsgSet(msgHandles, null, null, true, false, false, incrementLockCount);
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"unlockSet");
        }
    }

    public void deleteSet(SIMessageHandle[] msgHandles, SITransaction siTran) throws SIMPMessageNotLockedException, SISessionUnavailableException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"deleteSet", (Object)new Object[]{this, SIMPUtils.messageHandleArrayToString(msgHandles), siTran});
        }
        this.checkTransaction(siTran, "TRANSACTION_DELETE_USAGE_ERROR_CWSIP0778");
        this._localConsumerPoint.processMsgSet(msgHandles, (TransactionCommon)siTran, null, false, true, false, true);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"deleteSet");
        }
    }

    public void unlockAll() throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"unlockAll", (Object)this);
            }
            try {
                this._localConsumerPoint.unlockAll();
            }
            catch (SIMPMessageNotLockedException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"unlockAll");
        }
    }

    public SIBUuid12 getConnectionUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConnectionUuid");
        }
        SIBUuid12 uuid = this._connection.getUuid();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConnectionUuid", (Object)uuid);
        }
        return uuid;
    }

    public boolean getReadAhead() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReadAhead");
            SibTr.exit((TraceComponent)tc, (String)"getReadAhead", (Object)this._enableReadAhead);
        }
        return this._enableReadAhead;
    }

    public boolean getForwardScanning() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForwardScanning");
            SibTr.exit((TraceComponent)tc, (String)"getForwardScanning", (Object)this._forwardScanning);
        }
        return this._forwardScanning;
    }

    public void activateAsynchConsumer(boolean deliverImmediately) throws SIErrorException, SISessionUnavailableException, SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"activateAsynchConsumer", (Object)new Object[]{this, deliverImmediately});
        }
        this._localConsumerPoint.runIsolatedAsynch(deliverImmediately);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"activateAsynchConsumer");
        }
    }

    public SIDestinationAddress getDestinationAddress() {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"getDestinationAddress", (Object)this);
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"getDestinationAddress", (Object)this._destAddr);
        }
        return this._destAddr;
    }

    public LocalConsumerPoint getLocalConsumerPoint() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalConsumerPoint");
            SibTr.exit((TraceComponent)tc, (String)"getLocalConsumerPoint", (Object)this._localConsumerPoint);
        }
        return this._localConsumerPoint;
    }

    public long getId() throws SISessionUnavailableException, SISessionDroppedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"getId", (Object)this);
        }
        this._localConsumerPoint.checkNotClosed();
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"getId", (Object)new Long(this._consumerId));
        }
        return this._consumerId;
    }

    public long getIdInternal() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getIdInternal");
            SibTr.exit((TraceComponent)tc, (String)"getIdInternal", (Object)new Long(this._consumerId));
        }
        return this._consumerId;
    }

    public MPSubscription getSubscription() throws SIDurableSubscriptionNotFoundException {
        ConsumerDispatcher cd;
        MPSubscription mpSubscription;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscription");
        }
        if ((mpSubscription = (cd = (ConsumerDispatcher)this._localConsumerPoint.getConsumerManager()).getMPSubscription()) == null) {
            if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"getSubscription", (Object)"SIDurableSubscriptionNotFoundException");
            }
            throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0146", new Object[]{null, this._messageProcessor.getMessagingEngineName()}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubscription", (Object)mpSubscription);
        }
        return mpSubscription;
    }

    void setId(long id) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setId", (Object)new Long(id));
        }
        this._consumerId = id;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setId");
        }
    }

    public SIBusMessage relockMessageUnderAsynchCursor() throws SISessionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"relockMessageUnderAsynchCursor");
        }
        SIBusMessage msg = null;
        msg = this._localConsumerPoint.relockMessageUnderAsynchCursor();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"relockMessageUnderAsynchCursor", (Object)msg);
        }
        return msg;
    }

    protected boolean isBifurcatable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isBifurcatable");
            SibTr.exit((TraceComponent)tc, (String)"isBifurcatable", (Object)this._bifurcatable);
        }
        return this._bifurcatable;
    }

    protected boolean ignoreInitialIndoubts() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ignoreInitialIndoubts");
            SibTr.exit((TraceComponent)tc, (String)"ignoreInitialIndoubts", (Object)this._ignoreInitialIndoubts);
        }
        return this._ignoreInitialIndoubts;
    }

    private void checkTransaction(SITransaction siTran, String msg) throws SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkTransaction", (Object)new Object[]{siTran, msg});
        }
        if (siTran != null && !((TransactionCommon)siTran).isAlive()) {
            SIIncorrectCallException e = new SIIncorrectCallException(nls.getFormattedMessage(msg, new Object[]{this._destAddr}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkTransaction", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkTransaction");
        }
    }

    @Override
    public SIBUuid12 getUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUuid");
            SibTr.exit((TraceComponent)tc, (String)"getUuid", (Object)this.uuid);
        }
        return this.uuid;
    }

    public synchronized void setBifurcatedConsumerCloseRedeliveryMode(boolean bumpRedeliveryOnClose) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setBifurcatedConsumerCloseRedeliveryMode", (Object)bumpRedeliveryOnClose);
            SibTr.exit((TraceComponent)tc, (String)"setBifurcatedConsumerCloseRedeliveryMode");
        }
        this.bumpRedeliveryOnBifurcatedClose = bumpRedeliveryOnClose;
    }

    protected synchronized boolean getBifurcatedConsumerCloseRedeliveryMode() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBifurcatedConsumerCloseRedeliveryMode");
            SibTr.exit((TraceComponent)tc, (String)"getBifurcatedConsumerCloseRedeliveryMode", (Object)this.bumpRedeliveryOnBifurcatedClose);
        }
        return this.bumpRedeliveryOnBifurcatedClose;
    }

    public void registerStoppableAsynchConsumerCallback(StoppableAsynchConsumerCallback callback, int maxActiveMessages, long messageLockExpiry, int maxBatchSize, OrderingContext extendedMessageOrderingContext, int maxSequentialFailures, long hiddenMessageDelay) throws SISessionUnavailableException, SISessionDroppedException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerStoppableAsynchConsumerCallback", (Object)new Object[]{callback, maxActiveMessages, messageLockExpiry, maxBatchSize, extendedMessageOrderingContext, maxSequentialFailures, hiddenMessageDelay});
        }
        this.registerStoppableAsynchConsumerCallback(callback, maxActiveMessages, messageLockExpiry, maxBatchSize, null, false, extendedMessageOrderingContext, maxSequentialFailures, hiddenMessageDelay);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerStoppableAsynchConsumerCallback");
        }
    }

    public void registerStoppableAsynchConsumerCallback(StoppableAsynchConsumerCallback callback, int maxActiveMessages, long messageLockExpiry, int maxBatchSize, Reliability unrecoverableReliability, boolean inLine, OrderingContext extendedMessageOrderingContext, int maxSequentialFailures, long hiddenMessageDelay) throws SISessionUnavailableException, SISessionDroppedException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerStoppableAsynchConsumerCallback", (Object)new Object[]{callback, maxActiveMessages, messageLockExpiry, maxBatchSize, unrecoverableReliability, inLine, extendedMessageOrderingContext, maxSequentialFailures, hiddenMessageDelay});
        }
        this._localConsumerPoint.registerStoppableAsynchConsumer(callback, maxActiveMessages, messageLockExpiry, maxBatchSize, unrecoverableReliability, inLine, (OrderingContextImpl)extendedMessageOrderingContext, null, maxSequentialFailures, hiddenMessageDelay);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerStoppableAsynchConsumerCallback");
        }
    }

    public void deregisterStoppableAsynchConsumerCallback() throws SISessionUnavailableException, SISessionDroppedException, SIErrorException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"deregisterStoppableAsynchConsumerCallback", (Object)this);
        }
        this.registerStoppableAsynchConsumerCallback(null, 1, 0L, 1, null, 0, 0L);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"deregisterStoppableAsynchConsumerCallback");
        }
    }

    public void unlockAll(boolean incrementUnlockCount) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIIncorrectCallException {
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"unlockAll", (Object)new Object[]{this, incrementUnlockCount});
            }
            try {
                if (incrementUnlockCount) {
                    this.unlockAll();
                } else {
                    this._localConsumerPoint.unlockAll(incrementUnlockCount);
                }
            }
            catch (SIMPMessageNotLockedException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block6;
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"unlockAll", (Object)incrementUnlockCount);
        }
    }
}

