/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIApiConstants;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.InvalidAddOperation;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.msgstore.RollbackException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.processor.MPSubscription;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.UndeliverableReturnCode;
import com.ibm.ws.sib.processor.exceptions.SIMPMessageNotLockedException;
import com.ibm.ws.sib.processor.impl.AbstractConsumerManager;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.JSBrowseCursor;
import com.ibm.ws.sib.processor.impl.JSConsumerSet;
import com.ibm.ws.sib.processor.impl.JSLockedMessageEnumeration;
import com.ibm.ws.sib.processor.impl.LocalQPConsumerKey;
import com.ibm.ws.sib.processor.impl.LocalQPConsumerKeyGroup;
import com.ibm.ws.sib.processor.impl.MPSubscriptionImpl;
import com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ReportHandler;
import com.ibm.ws.sib.processor.impl.SIMPState;
import com.ibm.ws.sib.processor.impl.interfaces.BrowseCursor;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerKey;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableSubscription;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DispatchableConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.DispatchableKey;
import com.ibm.ws.sib.processor.impl.interfaces.InputHandlerStore;
import com.ibm.ws.sib.processor.impl.interfaces.JSConsumerKey;
import com.ibm.ws.sib.processor.impl.interfaces.JSConsumerManager;
import com.ibm.ws.sib.processor.impl.interfaces.JSKeyGroup;
import com.ibm.ws.sib.processor.impl.interfaces.MessageEventListener;
import com.ibm.ws.sib.processor.impl.interfaces.OutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.filters.MessageSelectorFilter;
import com.ibm.ws.sib.processor.impl.store.items.AOValue;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.items.MessageItemReference;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream;
import com.ibm.ws.sib.processor.matching.MatchingConsumerPoint;
import com.ibm.ws.sib.processor.matching.MessageProcessorSearchResults;
import com.ibm.ws.sib.processor.runtime.SIMPTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.LocalSubscriptionControl;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.linkedlist.SimpleEntry;
import com.ibm.ws.sib.processor.utils.linkedlist.SimpleLinkedList;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.transactions.TransactionCallback;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ConsumerDispatcher
extends AbstractConsumerManager
implements OutputHandler,
MessageEventListener,
ControllableSubscription,
JSConsumerManager,
TransactionCallback {
    private static final TraceComponent tc = SibTr.register(ConsumerDispatcher.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private SubscriptionItemStream subscriptionItemStream = null;
    protected PtoPMessageItemStream itemStream = null;
    protected LinkedList<DispatchableKey> consumerPoints;
    protected SimpleLinkedList nonSpecificReadyCPs;
    private final SimpleLinkedList readyFwdScanningCPs;
    private boolean currentReceiveAllowed;
    protected long specificReadyConsumerCount = 0L;
    protected long specificConsumerVersion = 0L;
    protected long readyConsumerVersion = 0L;
    protected ConsumerDispatcherState dispatcherState;
    protected MPSubscription mpSubscription = null;
    protected PersistentTranId currentTran;
    protected JSLockedMessageEnumeration currentLME;
    protected Object orderLock = new Object();
    protected Set transactionSet = null;
    protected boolean streamHasInDoubtRemoves = true;
    protected SIMPState state;
    private int shortLivedProducerSeed = 0;
    private ReportHandler reportHandler = null;
    private boolean isGuess = false;
    private boolean _isPubSub;
    private final SIBUuid12 subscriptionUuid = new SIBUuid12();
    private boolean isInMatchSpace = false;
    private ControlAdapter subscriptionControlAdaptor;
    private ReceiveAllowedThread _receiveAllowedThread = null;

    public ConsumerDispatcher(BaseDestinationHandler destination, SubscriptionItemStream subscriptionItemStream, ConsumerDispatcherState dispatcherState) {
        this(destination, dispatcherState);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ConsumerDispatcher", (Object)new Object[]{destination, subscriptionItemStream, dispatcherState});
        }
        subscriptionItemStream.setConsumerDispatcher(this);
        this.subscriptionItemStream = subscriptionItemStream;
        this._isPubSub = destination.isPubSub();
        if (dispatcherState != null && this._isPubSub && !dispatcherState.isDurable()) {
            try {
                String subscriptionID = null;
                subscriptionID = dispatcherState.getSubscriberID() == null ? "_NON_DURABLE_NON_SHARED" + subscriptionItemStream.getID() : dispatcherState.getSubscriberID();
                dispatcherState.setSubscriberID(subscriptionID);
            }
            catch (NotInMessageStore nims) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"NotInMessageStore exception caught retrieving subscription id!", (Object)((Object)nims));
                }
                dispatcherState.setSubscriberID("_NON_DURABLE_XXXX");
            }
        }
        if (subscriptionItemStream.isUnableToOrder()) {
            destination.setIsUnableToOrder(true);
        }
        this.createControlAdapter();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ConsumerDispatcher", (Object)this);
        }
    }

    public ConsumerDispatcher(BaseDestinationHandler destination, PtoPMessageItemStream itemStream, ConsumerDispatcherState dispatcherState) {
        this(destination, dispatcherState);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ConsumerDispatcher", (Object)new Object[]{destination, itemStream, dispatcherState});
        }
        this.itemStream = itemStream;
        this._isPubSub = destination.isPubSub();
        if (itemStream.isUnableToOrder()) {
            destination.setIsUnableToOrder(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ConsumerDispatcher", (Object)this);
        }
    }

    private ConsumerDispatcher(BaseDestinationHandler destination, ConsumerDispatcherState dispatcherState) {
        super(destination);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ConsumerDispatcher", (Object)new Object[]{destination, dispatcherState});
        }
        this.dispatcherState = dispatcherState;
        this.consumerPoints = new LinkedList();
        this.nonSpecificReadyCPs = new SimpleLinkedList();
        this.readyFwdScanningCPs = new SimpleLinkedList();
        this.state = SIMPState.LOCKED;
        this.currentReceiveAllowed = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ConsumerDispatcher", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    boolean storeMessage(MessageItem msg, TransactionCommon transaction, InputHandlerStore inputHandlerStore, boolean storedByIH) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && ConsumerDispatcher.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)ConsumerDispatcher.tc, (String)"storeMessage", (Object)new Object[]{msg, transaction, inputHandlerStore, storedByIH});
        }
        if (this._isPubSub) {
            try {
                if (this.dispatcherState.getTargetDestination() == null) {
                    if (!storedByIH) {
                        inputHandlerStore.storeMessage(msg, transaction);
                        storedByIH = true;
                    }
                    downgradePersistence = false;
                    if (this.dispatcherState.isDurable()) {
                        msg.addPersistentRef();
                    } else {
                        msg.addNonPersistentRef();
                        downgradePersistence = true;
                    }
                    msgRef = new MessageItemReference(msg, downgradePersistence);
                    this.subscriptionItemStream.getSubscriptionLockManager().lock();
                    try {
                        if (this.subscriptionItemStream.isToBeDeleted()) ** GOTO lbl102
                        this.registerForEvents(msgRef);
                        msTran = this._messageProcessor.resolveAndEnlistMsgStoreTransaction(transaction);
                        this.subscriptionItemStream.add(msgRef, msTran);
                        msTran.registerCallback((TransactionCallback)msgRef);
                    }
                    finally {
                        this.subscriptionItemStream.getSubscriptionLockManager().unlock();
                    }
                }
                try {
                    target = this._baseDestHandler.getDestinationManager().getDestination(this.dispatcherState.getTargetDestination(), false);
                    if (target == null) {
                        e = new SIResourceException(ConsumerDispatcher.nls.getFormattedMessage("INTERNAL_SUBSCRIPTION_TARGET_NOT_FOUND_CWSIP0115", new Object[]{this.dispatcherState.getSubscriberID(), this.dispatcherState.getDurableHome(), this.dispatcherState.getTargetDestination()}, null));
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.storeMessage", (String)"1:583:1.280.5.25", (Object)this);
                        SibTr.exception((TraceComponent)ConsumerDispatcher.tc, (Exception)e);
                        if (TraceComponent.isAnyTracingEnabled() && ConsumerDispatcher.tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)ConsumerDispatcher.tc, (String)"storeMessage", (Object)e);
                        }
                        throw e;
                    }
                    msgCopy = null;
                    try {
                        msgCopy = msg.getMessage().getReceived();
                    }
                    catch (MessageCopyFailedException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.storeMessage", (String)"1:606:1.280.5.25", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && ConsumerDispatcher.tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)ConsumerDispatcher.tc, (String)"storeMessage", (Object)"MessageCopyFailedException");
                        }
                        throw new SIResourceException((Throwable)e);
                    }
                    inputHandler = target.getInputHandler(target.isPubSub() != false ? ProtocolType.PUBSUBINPUT : ProtocolType.UNICASTINPUT, this._messageProcessor.getMessagingEngineUuid(), null);
                    inputHandler.handleMessage(new MessageItem(msgCopy), transaction, this._messageProcessor.getMessagingEngineUuid());
                }
                catch (SITemporaryDestinationNotFoundException e) {
                    if (TraceComponent.isAnyTracingEnabled() && ConsumerDispatcher.tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)ConsumerDispatcher.tc, (String)"storeMessage", (Object)"SITemporaryDestinationNotFoundException");
                    }
                    throw new SIResourceException((Throwable)e);
                }
                catch (SINotPossibleInCurrentConfigurationException e) {
                    if (TraceComponent.isAnyTracingEnabled() && ConsumerDispatcher.tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)ConsumerDispatcher.tc, (String)"storeMessage", (Object)"SINotPossibleInCurrentConfigurationException");
                    }
                    throw new SIResourceException((Throwable)e);
                }
                catch (SIIncorrectCallException e) {
                    if (TraceComponent.isAnyTracingEnabled() && ConsumerDispatcher.tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)ConsumerDispatcher.tc, (String)"storeMessage", (Object)"SIIncorrectCallException");
                    }
                    throw new SIResourceException((Throwable)e);
                }
            }
            catch (RollbackException e) {
                SibTr.exception((TraceComponent)ConsumerDispatcher.tc, (Exception)e);
                if (TraceComponent.isAnyTracingEnabled() && ConsumerDispatcher.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)ConsumerDispatcher.tc, (String)"storeMessage", (Object)e);
                }
                throw new SIResourceException((Throwable)e);
            }
            catch (InvalidAddOperation e) {
                if (this.state != SIMPState.DELETED) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.storeMessage", (String)"1:668:1.280.5.25", (Object)this);
                    SibTr.exception((TraceComponent)ConsumerDispatcher.tc, (Exception)e);
                    SibTr.error((TraceComponent)ConsumerDispatcher.tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:675:1.280.5.25", e});
                    if (TraceComponent.isAnyTracingEnabled() && ConsumerDispatcher.tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)ConsumerDispatcher.tc, (String)"storeMessage", (Object)e);
                    }
                    throw new SIResourceException(ConsumerDispatcher.nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:686:1.280.5.25", e}, null), (Throwable)e);
                }
                if (!TraceComponent.isAnyTracingEnabled() || !ConsumerDispatcher.tc.isDebugEnabled()) ** GOTO lbl102
                SibTr.debug((TraceComponent)ConsumerDispatcher.tc, (String)("ConsumerDeispatcher deleted " + this));
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.storeMessage", (String)"1:702:1.280.5.25", (Object)this);
                SibTr.exception((TraceComponent)ConsumerDispatcher.tc, (Exception)e);
                SibTr.error((TraceComponent)ConsumerDispatcher.tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:709:1.280.5.25", e});
                if (TraceComponent.isAnyTracingEnabled() && ConsumerDispatcher.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)ConsumerDispatcher.tc, (String)"storeMessage", (Object)e);
                }
                throw new SIResourceException(ConsumerDispatcher.nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:720:1.280.5.25", e}, null), (Throwable)e);
            }
        } else {
            try {
                this._baseDestHandler.registerForEvents(msg);
                this.registerForEvents(msg);
                msTran = this._messageProcessor.resolveAndEnlistMsgStoreTransaction(transaction);
                this.itemStream.addItem(msg, msTran);
            }
            catch (OutOfCacheSpace e) {
                SibTr.exception((TraceComponent)ConsumerDispatcher.tc, (Exception)e);
                if (TraceComponent.isAnyTracingEnabled() && ConsumerDispatcher.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)ConsumerDispatcher.tc, (String)"storeMessage", (Object)e);
                }
                throw new SIResourceException((Throwable)e);
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.storeMessage", (String)"1:769:1.280.5.25", (Object)this);
                SibTr.exception((TraceComponent)ConsumerDispatcher.tc, (Exception)e);
                SibTr.error((TraceComponent)ConsumerDispatcher.tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:776:1.280.5.25", e});
                if (TraceComponent.isAnyTracingEnabled() && ConsumerDispatcher.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)ConsumerDispatcher.tc, (String)"storeMessage", (Object)e);
                }
                throw new SIResourceException(ConsumerDispatcher.nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:787:1.280.5.25", e}, null), (Throwable)e);
            }
            storedByIH = false;
        }
lbl102:
        // 6 sources

        if (TraceComponent.isAnyTracingEnabled() && ConsumerDispatcher.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)ConsumerDispatcher.tc, (String)"storeMessage", (Object)storedByIH);
        }
        return storedByIH;
    }

    @Override
    public void registerForEvents(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerForEvents", (Object)msg);
        }
        msg.registerMessageEventListener(2, this);
        msg.registerMessageEventListener(3, this);
        msg.registerMessageEventListener(5, this);
        msg.registerMessageEventListener(6, this);
        msg.registerMessageEventListener(12, this);
        if (this.itemStream != null) {
            this.itemStream.registerForEvents(msg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerForEvents");
        }
    }

    private boolean giveMessageToConsumer(SIMPMessage msg, TransactionCommon tran, DispatchableConsumerPoint consumerPoint, boolean storedByCD) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"giveMessageToConsumer", (Object)new Object[]{msg, tran, consumerPoint, storedByCD});
        }
        boolean messageTaken = false;
        if (msg.getLocalisingMEUuid() == null) {
            msg.setLocalisingME(this._messageProcessor.getMessagingEngineUuid());
        }
        messageTaken = consumerPoint.put(msg, storedByCD);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"giveMessageToConsumer", (Object)messageTaken);
        }
        return messageTaken;
    }

    @Override
    public boolean put(SIMPMessage msg, TransactionCommon tran, InputHandlerStore inputHandlerStore, boolean storedByIH) throws SIDiscriminatorSyntaxException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{msg, tran, inputHandlerStore, storedByIH});
        }
        JsMessage jsMsg = msg.getMessage();
        if (msg.getRequiresNewId() || jsMsg.getSystemMessageId() == null) {
            jsMsg.setSystemMessageSourceUuid(this._messageProcessor.getMessagingEngineUuid());
            jsMsg.setSystemMessageValue(this._messageProcessor.nextTick());
            msg.setRequiresNewId(false);
        }
        if (msg.getMessage().getReportCOA() != null) {
            if (!this._baseDestHandler.isMQLink()) {
                if (this.reportHandler == null) {
                    this.reportHandler = new ReportHandler(this._messageProcessor);
                }
                try {
                    this.reportHandler.handleMessage(msg, tran, SIApiConstants.REPORT_COA);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.put", (String)"1:912:1.280.5.25", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"put", (Object)"SIResourceException");
                    }
                    throw new SIResourceException((Throwable)e);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Ignored report message generation for the request message targeted for MQ destination (via MQLink)", (Object)this._baseDestHandler.getName());
            }
        }
        if (msg.isTransacted() && !this._isPubSub) {
            boolean retVal = this.storeMessage((MessageItem)msg, tran, inputHandlerStore, storedByIH);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"put", (Object)retVal);
            }
            return retVal;
        }
        boolean retVal = this.internalPut(msg, tran, inputHandlerStore, storedByIH, false, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put", (Object)retVal);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalPut(SIMPMessage msg, TransactionCommon tran, InputHandlerStore inputHandlerStore, boolean storedByIH, boolean storedByCD, boolean firstPut) throws SIResourceException, SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalPut", (Object)new Object[]{msg, tran, inputHandlerStore, storedByIH, storedByCD, firstPut, msg.getMessage().getSystemMessageId()});
        }
        long lastSpecificVersion = 0L;
        boolean finalMatch = false;
        boolean continueSearch = true;
        DispatchableKey readyConsumer = null;
        boolean newMatchRequired = false;
        boolean grabCurrentReadyVersion = false;
        boolean statsNeedUpdating = firstPut;
        long newestReadyVersion = Long.MAX_VALUE;
        MatchingConsumerPoint[] matchResults = null;
        MessageProcessorSearchResults searchResults = null;
        boolean specificConsumer = false;
        boolean eligibleForDelivery = true;
        boolean shortLivedProducerSeedIncremented = false;
        ArrayList<DispatchableKey> forwardScanningReadyConsumers = null;
        boolean referenceCreatedEarly = false;
        if (storedByCD) {
            grabCurrentReadyVersion = true;
        }
        while (continueSearch) {
            block37: {
                Object object = this._baseDestHandler.getReadyConsumerPointLock();
                synchronized (object) {
                    DispatchableKey readyFSConsumer;
                    block35: {
                        block38: {
                            block36: {
                                block33: {
                                    block34: {
                                        block32: {
                                            if (grabCurrentReadyVersion) {
                                                newestReadyVersion = this.readyConsumerVersion;
                                                grabCurrentReadyVersion = false;
                                            }
                                            if ((readyConsumer = (DispatchableKey)((Object)this.nonSpecificReadyCPs.getFirst())) != null && readyConsumer.getVersion() > newestReadyVersion) {
                                                readyConsumer = null;
                                            }
                                            if (readyConsumer == null) break block32;
                                            specificConsumer = false;
                                            readyConsumer = readyConsumer.resolvedKey();
                                            break block33;
                                        }
                                        specificConsumer = true;
                                        if (this.specificReadyConsumerCount <= 0L) break block33;
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            SibTr.debug((TraceComponent)tc, (String)("sepcificReadyConsumerCount:" + this.specificReadyConsumerCount));
                                        }
                                        if (this.specificConsumerVersion == lastSpecificVersion || finalMatch) break block34;
                                        if (lastSpecificVersion > 0L && !storedByCD) break block33;
                                        newMatchRequired = true;
                                        lastSpecificVersion = this.specificConsumerVersion;
                                        if (storedByCD) {
                                            finalMatch = true;
                                        }
                                        break block33;
                                    }
                                    if (matchResults == null) {
                                        Object[] allResults = searchResults.getResults(this._baseDestHandler.getName());
                                        Set matchSet = (Set)allResults[2];
                                        matchResults = matchSet.toArray(new MatchingConsumerPoint[0]);
                                    }
                                    if (matchResults.length > 0) {
                                        int startPoint;
                                        int seed = msg.getProducerSeed();
                                        if (seed < SIMPConstants.LONG_LIVED_PRODUCER_THRESHOLD && seed >= 0) {
                                            seed = this.shortLivedProducerSeed++;
                                            if (!shortLivedProducerSeedIncremented && matchResults.length > 1) {
                                                shortLivedProducerSeedIncremented = true;
                                            }
                                        }
                                        if ((startPoint = seed % matchResults.length) < 0) {
                                            startPoint = 0 - startPoint;
                                        }
                                        int index = startPoint;
                                        while (readyConsumer == null) {
                                            DispatchableKey match = matchResults[index].getConsumerPointData();
                                            if (match.isKeyReady() && match.getVersion() <= newestReadyVersion) {
                                                readyConsumer = match;
                                                continue;
                                            }
                                            if ((index = (index + 1) % matchResults.length) != startPoint) continue;
                                            break;
                                        }
                                    }
                                }
                                if (readyConsumer == null) break block35;
                                if (!this.dispatcherState.isNoLocal() || !readyConsumer.getConnectionUuid().equals((Object)msg.getProducerConnectionUuid())) break block36;
                                eligibleForDelivery = false;
                                continueSearch = false;
                                break block37;
                            }
                            if (storedByCD || !readyConsumer.requiresRecovery(msg) && !msg.isTransacted()) break block38;
                            readyConsumer = null;
                            if (msg.isTransacted()) {
                                continueSearch = false;
                            }
                            break block37;
                        }
                        readyConsumer.markNotReady();
                        this.removeReadyConsumer(readyConsumer.getParent(), specificConsumer);
                        if (!this.isPubSub()) break block37;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"An non-recoverable or non-transacted pubsub message, create MsgReference");
                        }
                        if (!(msg instanceof MessageItem)) break block37;
                        referenceCreatedEarly = true;
                        MessageItemReference msgRef = new MessageItemReference((MessageItem)msg, true);
                        msg = msgRef;
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block37;
                        SibTr.debug((TraceComponent)tc, (String)("MsgReference created: " + msg));
                        break block37;
                    }
                    if (storedByCD && (readyFSConsumer = (DispatchableKey)((Object)this.readyFwdScanningCPs.getFirst())) != null) {
                        forwardScanningReadyConsumers = new ArrayList<DispatchableKey>();
                        while (readyFSConsumer != null) {
                            DispatchableKey nextReadyFSConsumer = (DispatchableKey)((Object)((SimpleEntry)((Object)readyFSConsumer)).next());
                            forwardScanningReadyConsumers.add(readyFSConsumer);
                            readyFSConsumer.markNotReady();
                            ((SimpleEntry)((Object)readyFSConsumer)).remove();
                            readyFSConsumer = nextReadyFSConsumer;
                        }
                    }
                }
            }
            if (!eligibleForDelivery) continue;
            if (readyConsumer != null) {
                continueSearch = !this.giveMessageToConsumer(msg, tran, readyConsumer.getConsumerPoint(), storedByCD);
                if (!continueSearch) continue;
                readyConsumer = null;
                continue;
            }
            if (forwardScanningReadyConsumers != null) {
                Iterator consumerIterator = forwardScanningReadyConsumers.iterator();
                while (consumerIterator.hasNext()) {
                    this.giveMessageToConsumer(msg, tran, ((DispatchableKey)consumerIterator.next()).getConsumerPoint(), storedByCD);
                }
                continueSearch = false;
                continue;
            }
            if (newMatchRequired) {
                searchResults = (MessageProcessorSearchResults)this._messageProcessor.getSearchResultsObjectPool().remove();
                this.searchMatchSpace(msg, searchResults);
                Object[] allResults = searchResults.getResults(this._baseDestHandler.getName());
                Set matchSet = (Set)allResults[2];
                matchResults = matchSet.toArray(new MatchingConsumerPoint[0]);
                newMatchRequired = false;
                continue;
            }
            if (!storedByCD) {
                if (referenceCreatedEarly) {
                    try {
                        msg = (MessageItem)((MessageItemReference)msg).getReferredItem();
                    }
                    catch (SevereMessageStoreException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.internalPut", (String)"1:1553:1.280.5.25", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"internalPut", (Object)"SevereMessageStoreException");
                        }
                        throw new SIResourceException((Throwable)e);
                    }
                }
                storedByIH = this.storeMessage((MessageItem)msg, tran, inputHandlerStore, storedByIH);
                storedByCD = true;
                grabCurrentReadyVersion = true;
                if (tran == null || tran.isAutoCommit()) continue;
                continueSearch = false;
                continue;
            }
            continueSearch = false;
        }
        if (searchResults != null) {
            this._messageProcessor.getSearchResultsObjectPool().add(searchResults);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalPut", (Object)storedByIH);
        }
        return storedByIH;
    }

    @Override
    public boolean isDurable() {
        boolean dur;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isDurable");
        }
        boolean bl = dur = this._isPubSub && this.dispatcherState.isDurable();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isDurable", (Object)dur);
        }
        return dur;
    }

    @Override
    public long newReadyConsumer(JSConsumerKey consumerKey, boolean bSelector) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"newReadyConsumer", (Object)new Object[]{consumerKey, bSelector});
        }
        if (consumerKey.getForwardScanning()) {
            this.readyFwdScanningCPs.put((SimpleEntry)((Object)consumerKey));
        } else if (bSelector) {
            ++this.specificReadyConsumerCount;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("sepcificReadyConsumerCount:" + this.specificReadyConsumerCount));
            }
        } else {
            this.nonSpecificReadyCPs.put((SimpleEntry)((Object)consumerKey));
        }
        ++this.readyConsumerVersion;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"newReadyConsumer", (Object)this.readyConsumerVersion);
        }
        return this.readyConsumerVersion;
    }

    @Override
    public void removeReadyConsumer(JSConsumerKey consumerKey, boolean bSelector) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeReadyConsumer", (Object)new Object[]{consumerKey, bSelector});
        }
        if (consumerKey == null) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:1684:1.280.5.25"}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.removeReadyConsumer", (String)"1:1690:1.280.5.25", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:1698:1.280.5.25"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeReadyConsumer", (Object)((Object)e));
            }
            throw e;
        }
        if (consumerKey.getForwardScanning()) {
            ((SimpleEntry)((Object)consumerKey)).remove();
        } else if (bSelector) {
            --this.specificReadyConsumerCount;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("sepcificReadyConsumerCount:" + this.specificReadyConsumerCount));
            }
        } else {
            ((SimpleEntry)((Object)consumerKey)).remove();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeReadyConsumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsumerKey attachConsumerPoint(ConsumerPoint consumerPoint, SelectionCriteria criteria, SIBUuid12 connectionUuid, boolean readAhead, boolean forwardScanning, JSConsumerSet consumerSet) throws SINotPossibleInCurrentConfigurationException, SIDestinationLockedException, SISelectorSyntaxException, SIDiscriminatorSyntaxException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachConsumerPoint", (Object)new Object[]{consumerPoint, criteria, connectionUuid, readAhead, consumerSet});
        }
        DispatchableConsumerPoint dispatchableConsumerPoint = (DispatchableConsumerPoint)consumerPoint;
        ConsumerKey consumerKey = null;
        Object object = this.consumerPoints;
        synchronized (object) {
            if (dispatchableConsumerPoint.getNamedDestination(this).isToBeDeleted() || dispatchableConsumerPoint.getNamedDestination(this).isDeleted()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"attachConsumerPoint", (Object)"destination deleted");
                }
                throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_DELETED_ERROR_CWSIP0111", new Object[]{this._baseDestHandler.getName(), this._messageProcessor.getMessagingEngineName()}, null));
            }
            if (!this._isPubSub) {
                if (this.consumerPoints.size() > 0) {
                    if (dispatchableConsumerPoint.getNamedDestination(this).isReceiveExclusive()) {
                        SIDestinationLockedException e = new SIDestinationLockedException(nls.getFormattedMessage("DESTINATION_RECEIVE_EXCLUSIVE_CWSIP0114", new Object[]{this._baseDestHandler.getName(), this._messageProcessor.getMessagingEngineName()}, null));
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"attachConsumerPoint", (Object)"Destination receive exclusive");
                        }
                        throw e;
                    }
                    if (!dispatchableConsumerPoint.ignoreInitialIndoubts()) {
                        SIDestinationLockedException e = new SIDestinationLockedException(nls.getFormattedMessage("TEMPORARY_CWSIP9999", new Object[]{this._baseDestHandler.getName(), this._messageProcessor.getMessagingEngineName()}, null));
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"attachConsumerPoint", (Object)"Destination locked due to indoubt messages");
                        }
                        throw e;
                    }
                    if (!this.consumerPoints.get(0).getConsumerPoint().ignoreInitialIndoubts()) {
                        SIDestinationLockedException e = new SIDestinationLockedException(nls.getFormattedMessage("TEMPORARY_CWSIP9999", new Object[]{this._baseDestHandler.getName(), this._messageProcessor.getMessagingEngineName()}, null));
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"attachConsumerPoint", (Object)"Destination locked for ordering");
                        }
                        throw e;
                    }
                }
            } else if (this.isDurable() && !this.dispatcherState.isCloned() && this.consumerPoints.size() > 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"attachConsumerPoint", (Object)"SIDestinationLockedException");
                }
                throw new SIDestinationLockedException(nls.getFormattedMessage("SUBSCRIPTION_IN_USE_ERROR_CWSIP0152", new Object[]{this.dispatcherState.getSubscriberID(), this._messageProcessor.getMessagingEngineName()}, null));
            }
            if (this._baseDestHandler.isOrdered() && this.consumerPoints.size() > 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"attachConsumerPoint", (Object)"SIDestinationLockedException");
                }
                throw new SIDestinationLockedException(nls.getFormattedMessage("ORDERED_DESTINATION_IN_USE_CWSIP0116", new Object[]{this._baseDestHandler.getName(), this._messageProcessor.getMessagingEngineName()}, null));
            }
            consumerKey = this.createConsumerKey(dispatchableConsumerPoint, criteria, connectionUuid, readAhead, forwardScanning, consumerSet);
            this.consumerPoints.add((DispatchableKey)consumerKey);
        }
        if (!this._isPubSub) {
            this._baseDestHandler.addConsumerPointMatchTarget((DispatchableKey)consumerKey, this.getUuid(), criteria);
            if (((DispatchableKey)consumerKey).isSpecific()) {
                object = this._baseDestHandler.getReadyConsumerPointLock();
                synchronized (object) {
                    ++this.specificConsumerVersion;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attachConsumerPoint", (Object)consumerKey);
        }
        return consumerKey;
    }

    private boolean initialiseTransactionSet() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialiseTransactionSet");
        }
        boolean suspend = false;
        this.transactionSet = new HashSet();
        try {
            if (this.itemStream != null) {
                this.itemStream.getActiveTransactions(this.transactionSet);
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.initialiseTransactionSet", (String)"1:1957:1.280.5.25", (Object)this);
            SIResourceException e2 = new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:1965:1.280.5.25", e}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e2));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:1972:1.280.5.25", e2});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"initialiseTransactionSet", (Object)((Object)e2));
            }
            throw e2;
        }
        if (this.transactionSet.size() > 0) {
            suspend = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialiseTransactionSet", (Object)new Object[]{this.transactionSet, suspend});
        }
        return suspend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachConsumerPoint(ConsumerKey consumerKey) throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        LinkedList<DispatchableKey> linkedList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"detachConsumerPoint", (Object)consumerKey);
        }
        if (!this._isPubSub) {
            this._baseDestHandler.removeConsumerPointMatchTarget((DispatchableKey)consumerKey);
        } else {
            this.state = SIMPState.DELETED;
        }
        Object deletionLock = this.isPubSub() ? this._baseDestHandler.getPubSubRealization().getRemotePubSubSupport() : this.consumerPoints;
        Serializable serializable = deletionLock;
        synchronized (serializable) {
            linkedList = this.consumerPoints;
            synchronized (linkedList) {
                if (this.consumerPoints.contains(consumerKey)) {
                    this.consumerPoints.remove(consumerKey);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Consumer key removed - new size of consumerPoints is " + this.consumerPoints.size()));
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Consumer key not in map", (Object)consumerKey);
                }
                if (this.consumerPoints.isEmpty() && this._isPubSub && this.dispatcherState.getSubscriberID().contains("_NON_DURABLE_NON_SHARED") && (!this.isDurable() || this instanceof RemoteConsumerDispatcher)) {
                    this.deleteConsumerDispatcher(!this.isDurable());
                }
            }
        }
        if (this._isPubSub && !this.isDurable() && !this.dispatcherState.getSubscriberID().contains("_NON_DURABLE_NON_SHARED")) {
            serializable = this._baseDestHandler.getDestinationManager().getNondurableSharedSubscriptions();
            synchronized (serializable) {
                linkedList = this.consumerPoints;
                synchronized (linkedList) {
                    if (this.consumerPoints.isEmpty()) {
                        this.deleteConsumerDispatcher(!this.isDurable());
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"detachConsumerPoint");
        }
    }

    protected ConsumerKey createConsumerKey(DispatchableConsumerPoint consumerPoint, SelectionCriteria criteria, SIBUuid12 connectionUuid, boolean readAhead, boolean forwardScanning, JSConsumerSet consumerSet) throws SISelectorSyntaxException, SIDiscriminatorSyntaxException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConsumerKey", (Object)new Object[]{consumerPoint, criteria, connectionUuid, readAhead, forwardScanning, consumerSet});
        }
        LocalQPConsumerKey key = new LocalQPConsumerKey(consumerPoint, this, criteria, connectionUuid, forwardScanning, consumerSet);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConsumerKey", (Object)key);
        }
        return key;
    }

    @Override
    protected JSKeyGroup createConsumerKeyGroup(JSConsumerSet consumerSet) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConsumerKeyGroup", (Object)consumerSet);
        }
        LocalQPConsumerKeyGroup ckg = new LocalQPConsumerKeyGroup(this, consumerSet);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConsumerKeyGroup", (Object)ckg);
        }
        return ckg;
    }

    public boolean hasConsumersAttached() {
        boolean hasConsumersAttached;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasConsumersAttached");
        }
        boolean bl = hasConsumersAttached = this.getConsumerCount() > 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"hasConsumersAttached", (Object)hasConsumersAttached);
        }
        return hasConsumersAttached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConsumerCount() {
        int consumerCount;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerCount");
        }
        LinkedList<DispatchableKey> linkedList = this.consumerPoints;
        synchronized (linkedList) {
            consumerCount = this.consumerPoints.size();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConsumerCount", (Object)consumerCount);
        }
        return consumerCount;
    }

    @Override
    public List<DispatchableKey> getConsumerPoints() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerPoints");
            SibTr.exit((TraceComponent)tc, (String)"getConsumerPoints", this.consumerPoints);
        }
        return (List)this.consumerPoints.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteConsumerDispatcher(boolean callProxyCode) throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteConsumerDispatcher", (Object)new Object[]{callProxyCode, this.isInMatchSpace});
        }
        LinkedList<DispatchableKey> linkedList = this.consumerPoints;
        synchronized (linkedList) {
            if (this.hasConsumersAttached()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteConsumerDispatcher", (Object)"Consumers attached ");
                }
                throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_DELETION_ERROR_CWSIP0112", new Object[]{this._baseDestHandler.getName()}, null));
            }
        }
        this.state = SIMPState.DELETED;
        if (this.isInMatchSpace) {
            this._baseDestHandler.dereferenceSubscriptionConsumerDispatcher(this, !this.isDurable(), callProxyCode);
        }
        try {
            if (this.isDurable()) {
                if (this instanceof RemoteConsumerDispatcher) {
                    this._baseDestHandler.deleteRemoteDurableRME(this.dispatcherState);
                } else {
                    this._baseDestHandler.deleteRemoteDurableDME(this.dispatcherState.getSubscriberID());
                }
            }
        }
        catch (SIDurableSubscriptionNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.deleteConsumerDispatcher", (String)"1:2265:1.280.5.25", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        this.getControlAdapter().dereferenceControllable();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteConsumerDispatcher");
        }
    }

    @Override
    public BrowseCursor getBrowseCursor(SelectionCriteria criteria) throws SIResourceException, SISelectorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBrowseCursor", (Object)criteria);
        }
        NonLockingCursor msgStoreCur = null;
        MessageSelectorFilter filter = null;
        JSBrowseCursor cursor = null;
        try {
            if (criteria != null && (criteria.getSelectorString() != null && !criteria.getSelectorString().equals("") || criteria.getDiscriminator() != null && !criteria.getDiscriminator().equals(""))) {
                filter = new MessageSelectorFilter(this._messageProcessor, criteria);
            }
            if (this.itemStream != null) {
                msgStoreCur = this.itemStream.newNonLockingItemCursor(filter);
            } else if (this.subscriptionItemStream != null) {
                msgStoreCur = this.subscriptionItemStream.newNonLockingCursor(filter);
            }
            cursor = new JSBrowseCursor(msgStoreCur);
        }
        catch (SISelectorSyntaxException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.getBrowseCursor", (String)"1:2314:1.280.5.25", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:2321:1.280.5.25", e});
            if (cursor != null) {
                try {
                    cursor.finished();
                }
                catch (SISessionDroppedException e1) {
                    FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.getBrowseCursor", (String)"1:2338:1.280.5.25", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e1));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.getBrowseCursor", "1:2345:1.280.5.25", SIMPUtils.getStackTrace(e1)});
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getBrowseCursor", (Object)((Object)e));
            }
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.getBrowseCursor", (String)"1:2361:1.280.5.25", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:2368:1.280.5.25", e});
            if (cursor != null) {
                try {
                    cursor.finished();
                }
                catch (SISessionDroppedException e1) {
                    FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.getBrowseCursor", (String)"1:2382:1.280.5.25", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e1));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.getBrowseCursor", "1:2389:1.280.5.25", SIMPUtils.getStackTrace(e1)});
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getBrowseCursor", (Object)e);
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:2402:1.280.5.25", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBrowseCursor", (Object)cursor);
        }
        return cursor;
    }

    @Override
    public ConsumerDispatcherState getConsumerDispatcherState() {
        return this.dispatcherState;
    }

    public String toString() {
        String output = "@" + Integer.toHexString(this.hashCode()) + "[" + this._baseDestHandler.getName() + ",";
        output = this.itemStream != null ? output + "IS@" + Integer.toHexString(this.itemStream.hashCode()) : (this.subscriptionItemStream != null ? output + "SIS@" + Integer.toHexString(this.subscriptionItemStream.hashCode()) : output + "null");
        return output + "]";
    }

    @Override
    public void messageEventOccurred(int event, SIMPMessage msg, TransactionCommon tran) throws SIDiscriminatorSyntaxException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messageEventOccurred", (Object)new Object[]{event, msg, tran});
        }
        if (event == 2) {
            this.eventPostCommitAdd(msg, tran);
        } else if (3 == event) {
            this.eventPostCommitRemove(msg, tran);
        } else if (event == 5) {
            this.eventPostRollbackRemove(msg, tran);
        } else if (event == 6) {
            this.eventUnlocked(msg);
        } else if (event == 12) {
            this.eventPreUnlocked(msg, tran);
        } else {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:2476:1.280.5.25"}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.messageEventOccurred", (String)"1:2482:1.280.5.25", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:2490:1.280.5.25"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred");
        }
    }

    protected void eventPostCommitAdd(SIMPMessage msg, TransactionCommon transaction) throws SIDiscriminatorSyntaxException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitAdd", (Object)new Object[]{msg, transaction});
        }
        this.internalPut(msg, transaction, null, true, true, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitAdd");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void eventPostCommitRemove(SIMPMessage msg, TransactionCommon transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitRemove", (Object)new Object[]{msg, transaction});
        }
        Object object = this.orderLock;
        synchronized (object) {
            if (this.transactionSet != null) {
                this.transactionSet.remove(transaction.getPersistentTranId());
                if (this.transactionSet.isEmpty()) {
                    this.transactionSet = null;
                    this.consumerPoints.get(0).getConsumerPoint().resumeConsumer(4);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitRemove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void eventPostRollbackRemove(SIMPMessage msg, TransactionCommon transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostRollbackRemove", (Object)new Object[]{msg, transaction});
        }
        Object object = this.orderLock;
        synchronized (object) {
            if (this.transactionSet != null) {
                this.transactionSet.remove(transaction.getPersistentTranId());
                if (this.transactionSet.isEmpty()) {
                    this.transactionSet = null;
                    this.consumerPoints.get(0).getConsumerPoint().resumeConsumer(4);
                }
            }
        }
        try {
            if (!msg.isPersistentlyLocked() && !msg.isHidden()) {
                if (msg.isLocked()) {
                    msg.unlockMsg(msg.getLockID(), null, true);
                } else {
                    msg.eventUnlocked();
                }
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.eventPostRollbackRemove", (String)"1:2618:1.280.5.25", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:2625:1.280.5.25", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackRemove", (Object)((Object)e));
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:2636:1.280.5.25", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackRemove");
        }
    }

    protected void eventPreUnlocked(SIMPMessage msg, TransactionCommon tran) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPreUnlocked", (Object)new Object[]{msg, msg.guessRedeliveredCount()});
        }
        if (msg.guessRedeliveredCount() + 1 >= this._baseDestHandler.getMaxFailedDeliveries()) {
            msg.deregisterMessageEventListener(5, this);
            msg.deregisterMessageEventListener(4, this);
            UndeliverableReturnCode rc = null;
            try {
                rc = this._isPubSub ? this._baseDestHandler.handleUndeliverableMessage(msg, 35, new String[]{this._baseDestHandler.getName(), this._messageProcessor.getMessagingEngineName()}, tran, this.dispatcherState.getSubscriberID()) : this._baseDestHandler.handleUndeliverableMessage(msg, 35, new String[]{this._baseDestHandler.getName(), this._messageProcessor.getMessagingEngineName()}, tran);
            }
            catch (SIResourceException sIResourceException) {
                // empty catch block
            }
            msg.registerMessageEventListener(5, this);
            msg.registerMessageEventListener(4, this);
            if (rc == null || rc == UndeliverableReturnCode.ERROR) {
                this._messageProcessor.getAlarmManager().create(1000L, new ExceptionDestinationRetryHandler(msg, this));
            }
            if (rc == UndeliverableReturnCode.BLOCK) {
                this.pauseConsumers(msg, this._baseDestHandler.getBlockedRetryInterval());
            }
            if (rc != UndeliverableReturnCode.BLOCK) {
                msg.setRedeliveryCountReached();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPreUnlocked");
        }
    }

    protected void eventUnlocked(SIMPMessage msg) throws SIDiscriminatorSyntaxException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventUnlocked", (Object)msg);
        }
        this.internalPut(msg, null, null, true, true, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventUnlocked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pauseConsumers(SIMPMessage msg, long retryInterval) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"pauseConsumers", (Object)new Object[]{msg, retryInterval});
        }
        LinkedList<DispatchableKey> cachedConsumerPoints = new LinkedList<DispatchableKey>();
        LinkedList<DispatchableKey> linkedList = this.consumerPoints;
        synchronized (linkedList) {
            for (DispatchableKey cKey : this.consumerPoints) {
                if (!((LocalQPConsumerKey)cKey).filterMatches((AbstractItem)msg)) continue;
                cachedConsumerPoints.add(cKey);
            }
        }
        for (DispatchableKey cKey : cachedConsumerPoints) {
            DispatchableConsumerPoint consumerPoint = cKey.getConsumerPoint();
            BlockedConsumerRetryHandler blockedConsumerRetryHandler = new BlockedConsumerRetryHandler(consumerPoint);
            if (!blockedConsumerRetryHandler.startSuspend()) continue;
            this._messageProcessor.getAlarmManager().create(retryInterval, blockedConsumerRetryHandler);
        }
        this._messageProcessor.getAlarmManager().create(retryInterval, new BlockedRetryHandler());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"pauseConsumers");
        }
    }

    @Override
    public void setReadyForUse() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setReadyForUse");
        }
        this.state = SIMPState.READY_FOR_USE;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setReadyForUse");
        }
    }

    public void setIsInMatchSpace(boolean inMatchSpace) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setIsInMatchSpace", (Object)inMatchSpace);
        }
        this.isInMatchSpace = inMatchSpace;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setIsInMatchSpace");
        }
    }

    public boolean isInMatchSpace() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isInMatchSpace");
            SibTr.exit((TraceComponent)tc, (String)"isInMatchSpace", (Object)this.isInMatchSpace);
        }
        return this.isInMatchSpace;
    }

    @Override
    public boolean isLocked() {
        boolean isLocked;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isLocked");
        }
        boolean bl = isLocked = this.state == SIMPState.LOCKED;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isLocked", (Object)isLocked);
        }
        return isLocked;
    }

    @Override
    public SIBUuid8 getTargetMEUuid() {
        return this._messageProcessor.getMessagingEngineUuid();
    }

    public ReferenceStream getReferenceStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReferenceStream");
            SibTr.exit((TraceComponent)tc, (String)"getReferenceStream", (Object)this.subscriptionItemStream);
        }
        return this.subscriptionItemStream;
    }

    public ItemStream getItemStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getItemStream");
            SibTr.exit((TraceComponent)tc, (String)"getItemStream", (Object)this.itemStream);
        }
        return this.itemStream;
    }

    @Override
    public boolean commitInsert(MessageItem msg) {
        return true;
    }

    @Override
    public boolean rollbackInsert(MessageItem msg) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConsumersForDelete(DestinationHandler destinationBeingDeleted) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeAllConsumersForDelete", (Object)destinationBeingDeleted);
        }
        Iterator itr = null;
        Iterator clonedItr = null;
        Object object = this.consumerPoints;
        synchronized (object) {
            clonedItr = ((LinkedList)this.consumerPoints.clone()).iterator();
            itr = ((LinkedList)this.consumerPoints.clone()).iterator();
        }
        object = this._baseDestHandler.getReadyConsumerPointLock();
        synchronized (object) {
            while (itr.hasNext()) {
                DispatchableKey consumerKey = (DispatchableKey)itr.next();
                if (consumerKey.isKeyReady()) {
                    this.removeReadyConsumer(consumerKey.getParent(), consumerKey.isSpecific());
                }
                consumerKey.markNotReady();
            }
        }
        while (clonedItr.hasNext()) {
            DispatchableKey consumerKey = (DispatchableKey)clonedItr.next();
            consumerKey.getConsumerPoint().implicitClose(destinationBeingDeleted.getUuid(), null, this._messageProcessor.getMessagingEngineUuid());
        }
        this.closeBrowsersDestinationDeleted(destinationBeingDeleted);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeAllConsumersForDelete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConsumersForReceiveExclusive() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeAllConsumersForReceiveExclusive");
        }
        Iterator itr = null;
        Iterator clonedItr = null;
        Object object = this.consumerPoints;
        synchronized (object) {
            clonedItr = ((LinkedList)this.consumerPoints.clone()).iterator();
            itr = ((LinkedList)this.consumerPoints.clone()).iterator();
        }
        object = this._baseDestHandler.getReadyConsumerPointLock();
        synchronized (object) {
            while (itr.hasNext()) {
                DispatchableKey consumerKey = (DispatchableKey)itr.next();
                if (consumerKey.isKeyReady()) {
                    this.removeReadyConsumer(consumerKey.getParent(), consumerKey.isSpecific());
                }
                consumerKey.markNotReady();
            }
        }
        while (clonedItr.hasNext()) {
            DispatchableKey consumerKey = (DispatchableKey)clonedItr.next();
            consumerKey.getConsumerPoint().implicitClose(null, null, this._messageProcessor.getMessagingEngineUuid());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeAllConsumersForReceiveExclusive");
        }
    }

    public void notifyReceiveAllowed(DestinationHandler destinationHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyReceiveAllowed", (Object)new Object[]{destinationHandler});
        }
        try {
            ReceiveAllowedThread receiveAllowedThread = this.getReceiveAllowedThread(destinationHandler);
            if (receiveAllowedThread != null) {
                this._messageProcessor.startNewThread(receiveAllowedThread);
            }
        }
        catch (InterruptedException e) {
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyReceiveAllowed");
        }
    }

    private synchronized ReceiveAllowedThread getReceiveAllowedThread(DestinationHandler destinationHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReceiveAllowedThread", (Object)destinationHandler);
        }
        if (this._receiveAllowedThread == null) {
            this._receiveAllowedThread = new ReceiveAllowedThread(destinationHandler);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getReceiveAllowedThread", (Object)this._receiveAllowedThread);
            }
            return this._receiveAllowedThread;
        }
        this._receiveAllowedThread.markForUpdate();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getReceiveAllowedThread", null);
        }
        return null;
    }

    private synchronized boolean deleteReceiveAllowedThread() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteReceiveAllowedThread");
        }
        if (this._receiveAllowedThread.isMarkedForUpdate()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteReceiveAllowedThread", (Object)Boolean.FALSE);
            }
            return false;
        }
        this._receiveAllowedThread = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteReceiveAllowedThread", (Object)Boolean.TRUE);
        }
        return true;
    }

    public void registerForEventsPostAddItem(SIMPMessage msg) {
    }

    @Override
    public boolean isWLMGuess() {
        return this.isGuess;
    }

    @Override
    public void setWLMGuess(boolean guess) {
        this.isGuess = guess;
    }

    public boolean dispatcherStateEquals(ConsumerDispatcherState comparisionState) {
        boolean same;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dispatcherStateEquals", (Object)comparisionState);
        }
        boolean bl = same = this.dispatcherState == comparisionState;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dispatcherStateEquals", (Object)same);
        }
        return same;
    }

    @Override
    public boolean isQHighLimit() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isQHighLimit");
        }
        boolean limited = this.itemStream.isQHighLimit();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isQHighLimit", (Object)limited);
        }
        return limited;
    }

    @Override
    public SIBUuid12 getSubscriptionUuid() {
        return this.subscriptionUuid;
    }

    @Override
    public OutputHandler getOutputHandler() {
        return this;
    }

    @Override
    public ControlAdapter getControlAdapter() {
        return this.subscriptionControlAdaptor;
    }

    @Override
    public void dereferenceControlAdapter() {
        this.subscriptionControlAdaptor.dereferenceControllable();
        this.subscriptionControlAdaptor = null;
    }

    @Override
    public void createControlAdapter() {
        if (this._isPubSub) {
            this.subscriptionControlAdaptor = new LocalSubscriptionControl(this, (SIMPTopicSpaceControllable)this._baseDestHandler.getControlAdapter(), this._messageProcessor);
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
        LocalSubscriptionControl subscriptionControlAdaptor = (LocalSubscriptionControl)this.getControlAdapter();
        subscriptionControlAdaptor.registerControlAdapterAsMBean();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
    }

    @Override
    public void deregisterControlAdapterMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterControlAdapterAsMBean");
        }
        this.subscriptionControlAdaptor.dereferenceControllable();
        this.subscriptionControlAdaptor = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterControlAdapterAsMBean");
        }
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isPubSub() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isPubSub");
            SibTr.exit((TraceComponent)tc, (String)"isPubSub", (Object)this._isPubSub);
        }
        return this._isPubSub;
    }

    protected boolean isReceiveAllowed(DestinationHandler destinationHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isReceiveAllowed", (Object)destinationHandler);
        }
        boolean allowed = true;
        if (!destinationHandler.isToBeDeleted() && !destinationHandler.isReceiveAllowed()) {
            allowed = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isReceiveAllowed", (Object)allowed);
        }
        return allowed;
    }

    public MPSubscription getMPSubscription() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMPSubscription");
        }
        if (this.mpSubscription == null && this.dispatcherState.isDurable()) {
            this.mpSubscription = new MPSubscriptionImpl(this, this._messageProcessor);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMPSubscription", (Object)this.mpSubscription);
        }
        return this.mpSubscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(TransactionCommon transaction, boolean committed) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"afterCompletion", (Object)new Object[]{transaction, committed});
        }
        Object object = this.orderLock;
        synchronized (object) {
            try {
                if (!committed && this.currentLME != null) {
                    this.currentLME.unlockAll();
                }
            }
            catch (SIResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.afterCompletion", (String)"1:3673:1.280.5.25", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"ORDERED_MESSAGING_ERROR_CWSIP0117", (Object)new Object[]{this._baseDestHandler.getName(), this._messageProcessor.getMessagingEngineName()});
            }
            catch (SISessionDroppedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.afterCompletion", (String)"1:3689:1.280.5.25", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"ORDERED_MESSAGING_ERROR_CWSIP0117", (Object)new Object[]{this._baseDestHandler.getName(), this._messageProcessor.getMessagingEngineName()});
            }
            catch (SIMPMessageNotLockedException sIMPMessageNotLockedException) {
                // empty catch block
            }
            this.currentTran = null;
            this.currentLME = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"afterCompletion");
        }
    }

    public void beforeCompletion(TransactionCommon transaction) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNewTransactionAllowed(TransactionCommon transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isNewTransactionAllowed", (Object)transaction);
        }
        boolean allowed = true;
        if (this.isPubSub() && !this.isDurable()) {
            allowed = true;
        } else {
            Object object = this.orderLock;
            synchronized (object) {
                if (this.streamHasInDoubtRemoves) {
                    if (this.itemStream != null) {
                        this.currentTran = this.itemStream.getOrderedActiveTran();
                    } else if (this.subscriptionItemStream != null) {
                        this.currentTran = this.subscriptionItemStream.getOrderedActiveTran();
                    }
                    if (this.currentTran == null) {
                        this.streamHasInDoubtRemoves = false;
                    }
                }
                if (!(this.currentTran == null || transaction != null && this.currentTran.equals((Object)transaction.getPersistentTranId()))) {
                    allowed = false;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isNewTransactionAllowed", (Object)allowed);
        }
        return allowed;
    }

    @Override
    public void setCurrentTransaction(TransactionCommon transaction, JSLockedMessageEnumeration lme) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCurrentTransaction", (Object)transaction);
        }
        if (this.currentTran == null) {
            this.currentTran = transaction.getPersistentTranId();
            this.currentLME = lme;
            transaction.registerCallback((TransactionCallback)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCurrentTransaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkInitialIndoubts(DispatchableConsumerPoint consumer) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkInitialIndoubts");
        }
        if (!this._isPubSub && !consumer.ignoreInitialIndoubts()) {
            Object object = this.orderLock;
            synchronized (object) {
                if (this.initialiseTransactionSet()) {
                    consumer.suspendConsumer(4);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkInitialIndoubts");
        }
    }

    private void searchMatchSpace(SIMPMessage msg, MessageProcessorSearchResults searchResults) throws SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"searchMatchSpace", (Object)new Object[]{msg, searchResults});
        }
        JsMessage searchMsg = msg.getMessage();
        int redelCount = msg.guessRedeliveredCount();
        if (redelCount > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Set deliverycount into message: " + redelCount));
            }
            searchMsg.setDeliveryCount(redelCount);
        }
        this._messageProcessor.getMessageProcessorMatching().retrieveMatchingConsumerPoints(this._baseDestHandler.getUuid(), this.getUuid(), searchMsg, searchResults);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"searchMatchSpace", (Object)searchResults);
        }
    }

    @Override
    public SIMPMessage getMessageByValue(AOValue value) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageByValue", (Object)value.getMsgId());
        }
        SIMPMessage msgItem = null;
        try {
            if (value.isRestored()) {
                msgItem = (SIMPMessage)(this.itemStream == null ? this.subscriptionItemStream.findById(value.getMsgId()) : this.itemStream.findById(value.getMsgId()));
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.getMessageByValue", (String)"1:4101:1.280.5.25", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMessageByValue", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageByValue", msgItem);
        }
        return msgItem;
    }

    @Override
    public void setCurrentTransaction(SIMPMessage msg, boolean isInDoubtOnRemoteConsumer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCurrentTransaction", (Object)new Object[]{msg, isInDoubtOnRemoteConsumer});
        }
        if (this.itemStream == null) {
            this.subscriptionItemStream.setCurrentTransaction(msg, isInDoubtOnRemoteConsumer);
        } else {
            this.itemStream.setCurrentTransaction(msg, isInDoubtOnRemoteConsumer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCurrentTransaction");
        }
    }

    private class BlockedRetryHandler
    implements AlarmListener {
        public BlockedRetryHandler() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"BlockedRetryHandler");
            }
            if (ConsumerDispatcher.this.itemStream != null) {
                ConsumerDispatcher.this.itemStream.setBlocked(true);
            } else if (ConsumerDispatcher.this.subscriptionItemStream != null) {
                ConsumerDispatcher.this.subscriptionItemStream.setBlocked(true);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"BlockedRetryHandler", (Object)this);
            }
        }

        public void alarm(Object thandle) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"BlockedRetryHandler.alarm", (Object)thandle);
            }
            if (ConsumerDispatcher.this.itemStream != null) {
                ConsumerDispatcher.this.itemStream.setBlocked(false);
            } else if (ConsumerDispatcher.this.subscriptionItemStream != null) {
                ConsumerDispatcher.this.subscriptionItemStream.setBlocked(false);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"BlockedRetryHandler.alarm");
            }
        }
    }

    private static class BlockedConsumerRetryHandler
    implements AlarmListener {
        private final DispatchableConsumerPoint cp;

        public BlockedConsumerRetryHandler(DispatchableConsumerPoint cp) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"BlockedConsumerRetryHandler", (Object)cp);
            }
            this.cp = cp;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"BlockedConsumerRetryHandler", (Object)this);
            }
        }

        public boolean startSuspend() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"startSuspend");
            }
            boolean suspended = this.cp.suspendConsumer(1);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"startSuspend", (Object)suspended);
            }
            return suspended;
        }

        public void alarm(Object thandle) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)this);
            }
            this.cp.resumeConsumer(1);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm");
            }
        }
    }

    private class ExceptionDestinationRetryHandler
    implements AlarmListener {
        private final SIMPMessage msg;
        private final ConsumerDispatcher cd;
        private int wait_time = 1000;

        public ExceptionDestinationRetryHandler(SIMPMessage msg, ConsumerDispatcher cd) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"ExceptionDestinationRetryHandler", (Object)new Object[]{msg, cd});
            }
            this.msg = msg;
            this.cd = cd;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ExceptionDestinationRetryHandler", (Object)this);
            }
        }

        public void alarm(Object thandle) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)thandle);
            }
            this.msg.deregisterMessageEventListener(5, this.cd);
            this.msg.deregisterMessageEventListener(4, this.cd);
            UndeliverableReturnCode rc = null;
            try {
                rc = ConsumerDispatcher.this._baseDestHandler.handleUndeliverableMessage(this.msg, 35, new String[]{ConsumerDispatcher.this._baseDestHandler.getName(), ConsumerDispatcher.this._messageProcessor.getMessagingEngineName()}, null);
            }
            catch (SIResourceException sIResourceException) {
                // empty catch block
            }
            this.msg.registerMessageEventListener(5, this.cd);
            this.msg.registerMessageEventListener(4, this.cd);
            if (rc == null || rc == UndeliverableReturnCode.ERROR) {
                ConsumerDispatcher.this._messageProcessor.getAlarmManager().create(this.wait_time, this);
                this.wait_time *= 2;
                if (this.wait_time > 30000) {
                    this.wait_time = 30000;
                }
            }
            if (rc == UndeliverableReturnCode.BLOCK) {
                try {
                    if (!this.msg.isPersistentlyLocked()) {
                        this.msg.unlockMsg(this.msg.getLockID(), null, true);
                    }
                }
                catch (MessageStoreException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.ExceptionDestinationRetryHandler.alarm", (String)"1:3523:1.280.5.25", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.ExceptionDestinationRetryHandler", "1:3530:1.280.5.25", e});
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm", (Object)rc);
            }
        }
    }

    private class ReceiveAllowedThread
    implements Runnable {
        private final DestinationHandler _destinationHandler;
        private boolean _rerunRequested = false;

        ReceiveAllowedThread(DestinationHandler dh) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"ReceiveAllowedThread", (Object)new Object[]{dh});
            }
            this._destinationHandler = dh;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ReceiveAllowedThread", (Object)this);
            }
        }

        public boolean isMarkedForUpdate() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"isMarkedForUpdate");
            }
            boolean marked = this._rerunRequested;
            this._rerunRequested = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"isMarkedForUpdate", (Object)marked);
            }
            return marked;
        }

        public void markForUpdate() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"markForUpdate");
            }
            this._rerunRequested = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"markForUpdate");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"run", (Object)this);
            }
            boolean run = true;
            while (run) {
                boolean newReceiveAllowed = ConsumerDispatcher.this.isReceiveAllowed(this._destinationHandler);
                LinkedList<DispatchableKey> linkedList = ConsumerDispatcher.this.consumerPoints;
                synchronized (linkedList) {
                    if (newReceiveAllowed == ConsumerDispatcher.this.currentReceiveAllowed) {
                        ConsumerDispatcher.this.currentReceiveAllowed = !newReceiveAllowed;
                    }
                }
                while (newReceiveAllowed != ConsumerDispatcher.this.currentReceiveAllowed) {
                    Iterator consumerPointIterator = null;
                    LinkedList<DispatchableKey> linkedList2 = ConsumerDispatcher.this.consumerPoints;
                    synchronized (linkedList2) {
                        consumerPointIterator = ((List)ConsumerDispatcher.this.consumerPoints.clone()).iterator();
                    }
                    while (consumerPointIterator.hasNext()) {
                        DispatchableKey consumerKey = (DispatchableKey)consumerPointIterator.next();
                        consumerKey.notifyReceiveAllowed(newReceiveAllowed, this._destinationHandler);
                    }
                    linkedList2 = ConsumerDispatcher.this.consumerPoints;
                    synchronized (linkedList2) {
                        ConsumerDispatcher.this.currentReceiveAllowed = newReceiveAllowed;
                        newReceiveAllowed = ConsumerDispatcher.this.isReceiveAllowed(this._destinationHandler);
                    }
                }
                run = !ConsumerDispatcher.this.deleteReceiveAllowedThread();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"run");
            }
        }
    }
}

