/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.gd.AIRequestedTick;
import com.ibm.ws.sib.processor.gd.AIValueTick;
import com.ibm.ws.sib.processor.gd.ControllableStream;
import com.ibm.ws.sib.processor.gd.StateStream;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.AIStreamKey;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.RemoteQPConsumerKey;
import com.ibm.ws.sib.processor.impl.exceptions.ClosedException;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableResource;
import com.ibm.ws.sib.processor.impl.interfaces.RemoteDispatchableKey;
import com.ibm.ws.sib.processor.impl.store.AsyncUpdate;
import com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.items.AICompletedPrefixItem;
import com.ibm.ws.sib.processor.impl.store.items.AIMessageItem;
import com.ibm.ws.sib.processor.impl.store.items.AIProtocolItem;
import com.ibm.ws.sib.processor.impl.store.items.AOValue;
import com.ibm.ws.sib.processor.impl.store.itemstreams.AIContainerItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.AIProtocolItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPDeliveryReceiverControllable;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.RemoteConsumerReceiver;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.am.AbstractBatchedTimeoutEntry;
import com.ibm.ws.sib.processor.utils.am.BatchedTimeoutEntry;
import com.ibm.ws.sib.processor.utils.am.BatchedTimeoutManager;
import com.ibm.ws.sib.processor.utils.am.BatchedTimeoutProcessor;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class AIStream
extends ControllableStream
implements ControllableResource {
    private static final TraceComponent tc = SibTr.register(AIStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int NUM_OF_BUCKETS = 4;
    private final SIBUuid12 _streamId;
    private AIProtocolItemStream _itemStream;
    private TreeSet<AIProtocolItem> _itemStreamIndex;
    private AnycastInputHandler _parent;
    private AsyncUpdateThread _msUpdateThread;
    private StateStream _targetStream;
    private AICompletedPrefixItem _completedPrefix;
    private boolean _completedPrefixNeedsToBeScheduled;
    private int _countOfOutstandingCPUpdates;
    private long _latestTick;
    private long _latestDMEVersion;
    private BatchedTimeoutManager _eagerGetTOM;
    private TraversableBatchedTimeoutManager _slowedGetTOM;
    private BatchedTimeoutManager _initialAcceptedTOM;
    private BatchedTimeoutManager _acceptedTOM;
    private BatchedTimeoutManager _rejectedTOM;
    private boolean _stopped = false;
    private MessageProcessor _mp;
    private ControlAdapter _controlAdapter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AIStream(SIBUuid12 streamId, AIProtocolItemStream itemStream, AnycastInputHandler parent, AsyncUpdateThread msUpdateThread, long latestTick, AICompletedPrefixItem completedPrefix, boolean existingIS, MessageProcessor mp) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AIStream", (Object)new Object[]{streamId, itemStream, parent, msUpdateThread, latestTick, completedPrefix, existingIS, mp});
        }
        AIStream aIStream = this;
        synchronized (aIStream) {
            this._itemStream = itemStream;
            ProtocolItemComparator piComparator = new ProtocolItemComparator();
            this._itemStreamIndex = new TreeSet(piComparator);
            this._parent = parent;
            this._msUpdateThread = msUpdateThread;
            this._targetStream = new StateStream();
            this._targetStream.init();
            this._latestTick = latestTick;
            this._latestDMEVersion = -1L;
            this._mp = mp;
            CreateTOMs createTOMs = null;
            if (existingIS) {
                this._streamId = itemStream.getStreamId();
                try {
                    createTOMs = this.recoverFromPersistentState(itemStream);
                }
                catch (MessageStoreException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.AIStream.AIStream", (String)"1:214:1.108.2.18", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"AIStream", (Object)((Object)e));
                    }
                    throw e;
                }
            } else {
                this._streamId = streamId;
                this._completedPrefix = completedPrefix;
                long cpTick = completedPrefix.getTick();
                this._targetStream.setCompletedPrefix(cpTick);
                ArrayList<AIRejectedRange> rejectedTicks = null;
                if (cpTick < latestTick) {
                    rejectedTicks = new ArrayList<AIRejectedRange>();
                    AIRejectedRange rr = this.writeRejectedNoTimeout(cpTick + 1L, latestTick, 0L, false);
                    rejectedTicks.add(rr);
                }
                createTOMs = new CreateTOMs(null, rejectedTicks, null);
            }
            this._completedPrefixNeedsToBeScheduled = true;
            this._countOfOutstandingCPUpdates = 0;
            createTOMs.create();
            if (!parent.getBaseDestinationHandler().isPubSub()) {
                ControlAdapter remoteQueuePoint = (ControlAdapter)parent.getBaseDestinationHandler().getRemoteQueuePointControl(parent.getLocalisationUuid(), true);
                remoteQueuePoint.registerControlAdapterAsMBean();
            }
            this.start();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AIStream", (Object)this);
        }
    }

    public AIStreamState getStreamState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamState");
        }
        AIStreamState streamState = AIStreamState.ACTIVE;
        if (this._parent.isStreamBeingFlushed()) {
            streamState = AIStreamState.REMOVING;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamState", (Object)streamState);
        }
        return streamState;
    }

    public SIBUuid12 getStreamId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamId");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamId", (Object)this._streamId);
        }
        return this._streamId;
    }

    public long insertRequest(AIRequestedTick rt, long tick, long timeout) {
        long rejectStart;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"insertRequest", (Object)new Object[]{rt, tick, timeout});
        }
        if ((rejectStart = this._latestTick + 1L) < tick) {
            this.writeRejected(rejectStart, tick - 1L, 0L);
        } else {
            rejectStart = tick;
        }
        TickRange requestRange = new TickRange(1, tick, tick);
        requestRange.value = rt;
        requestRange.valuestamp = tick;
        this._targetStream.writeRange(requestRange);
        if (timeout > 0L || timeout == this._mp.getCustomProperties().get_infinite_timeout()) {
            this._eagerGetTOM.addTimeoutEntry(rt);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"insertRequest", (Object)rejectStart);
        }
        return rejectStart;
    }

    public long countAllMessagesOnStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"countAllMessagesOnStream");
        }
        long count = 0L;
        this._targetStream.setCursor(0L);
        TickRange tr = this._targetStream.getNext();
        while (tr.endstamp < Long.MAX_VALUE) {
            if (tr.type == 3) {
                ++count;
            }
            if (tr.type == 1 && ((AIRequestedTick)tr.value).getRestoringAOValue() != null) {
                ++count;
            }
            tr = this._targetStream.getNext();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"countAllMessagesOnStream", (Object)count);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDeliverAssuredInOrder(long tick, long prevTick, int priority) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"canDeliverAssuredInOrder", (Object)new Object[]{tick, prevTick, priority});
        }
        boolean canDeliverInOrder = false;
        AIStream aIStream = this;
        synchronized (aIStream) {
            if (prevTick == this._mp.getCustomProperties().get_unknown_prev_tick()) {
                canDeliverInOrder = true;
                long start = this._targetStream.getCompletedPrefix() + 1L;
                if (start < tick) {
                    long end = tick - 1L;
                    this._targetStream.setCursor(start);
                    TickRange tr2 = null;
                    TickRange tr1 = this._targetStream.getNext();
                    do {
                        if (tr1.type == 0 || tr1.type == 1) {
                            canDeliverInOrder = false;
                            break;
                        }
                        if (tr1.type == 3) {
                            boolean samePriority;
                            AIValueTick valueTick = (AIValueTick)tr1.value;
                            boolean delivered = valueTick.isDelivered();
                            Reliability currentReliability = valueTick.getMsgReliability();
                            boolean isAssured = currentReliability.compareTo((Object)Reliability.RELIABLE_PERSISTENT) >= 0;
                            boolean bl = samePriority = valueTick.getMsgPriority() == priority;
                            if (isAssured && samePriority && !delivered) {
                                canDeliverInOrder = false;
                                break;
                            }
                        }
                        tr2 = tr1;
                        tr1 = this._targetStream.getNext();
                    } while (tr1.startstamp <= end && tr1 != tr2);
                }
            } else {
                this._targetStream.setCursor(prevTick);
                TickRange prevTickRange = this._targetStream.getNext();
                canDeliverInOrder = prevTickRange.type == 7 || prevTickRange.type == 5 ? true : (prevTickRange.type == 3 ? ((AIValueTick)prevTickRange.value).isDelivered() : false);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"canDeliverAssuredInOrder", (Object)canDeliverInOrder);
        }
        return canDeliverInOrder;
    }

    public AIRequestedTick updateRequestToValue(long tick, AIMessageItem msgItem, boolean valueDelivered, AnycastInputHandler.SendDispatcher sendDispatcher) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateRequestToValue", (Object)new Object[]{tick, msgItem, valueDelivered});
        }
        AIRequestedTick rt = null;
        this._targetStream.setCursor(tick);
        TickRange tickRange = this._targetStream.getNext();
        if (tickRange.type == 1) {
            rt = (AIRequestedTick)tickRange.value;
            RemoteDispatchableKey ck = rt.getRemoteDispatchableKey();
            AIValueTick valueTick = new AIValueTick(tick, msgItem, valueDelivered, ck, rt.getOriginalTimeout(), rt.getIssueTime(), msgItem.getMessage().getRedeliveredCount());
            TickRange valueRange = new TickRange(3, tick, tick);
            valueRange.value = valueTick;
            valueRange.valuestamp = tick;
            this._targetStream.writeRange(valueRange);
            if (rt.getTimeout() > 0L || rt.getTimeout() == this._mp.getCustomProperties().get_infinite_timeout()) {
                if (rt.isSlowed()) {
                    this._slowedGetTOM.removeTimeoutEntry(rt);
                } else {
                    this._eagerGetTOM.removeTimeoutEntry(rt);
                }
            }
        } else if (tickRange.type == 5) {
            sendDispatcher.sendAccept(tick);
        } else if (tickRange.type == 6) {
            AIRejectedRange rr = (AIRejectedRange)tickRange.value;
            sendDispatcher.sendReject(tick, tick, rr.unlockCount, rr.recovery);
        } else if (tickRange.type == 7) {
            sendDispatcher.sendCompleted(tick, tick);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateRequestToValue", (Object)rt);
        }
        return rt;
    }

    public final void incrementUnlockCount(long tick) {
        AIValueTick valueTick;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"incrementUnlockCount", (Object)tick);
        }
        this._targetStream.setCursor(tick);
        TickRange tickRange = this._targetStream.getNext();
        if (tickRange.type == 3 && (valueTick = (AIValueTick)tickRange.value) != null) {
            valueTick.incRMEUnlockCount();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"incrementUnlockCount", (Object)tickRange);
        }
    }

    public List findUndeliveredList(long tick, JsMessage message) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findUndeliveredList", (Object)new Object[]{tick, message});
        }
        int priority = message.getPriority();
        this._targetStream.setCursor(this._latestTick);
        TickRange tr2 = null;
        TickRange tr1 = this._targetStream.getPrev();
        ArrayList<AIValueTick> temp = null;
        boolean startNewList = true;
        do {
            if (tr1.type == 3) {
                AIValueTick valueTick = (AIValueTick)tr1.value;
                boolean delivered = valueTick.isDelivered();
                int currentPriority = valueTick.getMsgPriority();
                if (!delivered && currentPriority == priority) {
                    long prevTick = valueTick.getMsg().getMessage().getGuaranteedRemoteGetPrevTick();
                    if (startNewList) {
                        temp = new ArrayList<AIValueTick>(10);
                        startNewList = false;
                    }
                    temp.add(valueTick);
                    this._targetStream.setCursor(prevTick);
                    tr2 = tr1;
                    tr1 = this._targetStream.getPrev();
                    continue;
                }
            }
            startNewList = true;
            temp = null;
            tr2 = tr1;
            tr1 = this._targetStream.getPrev();
        } while (tr1.endstamp > tick && tr1 != tr2);
        ArrayList undeliveredList = null;
        if (temp != null) {
            undeliveredList = new ArrayList(temp.size());
            for (int i = temp.size() - 1; i >= 0; --i) {
                undeliveredList.add(temp.get(i));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findUndeliveredList", undeliveredList);
        }
        return undeliveredList;
    }

    public void markListDelivered(List list) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"markListDelivered", (Object)list);
        }
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            AIValueTick valueTick = (AIValueTick)list.get(i);
            valueTick.setDelivered(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"markListDelivered");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AIProtocolItem processAccepted(long tick, TransactionCommon transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAccepted", (Object)new Object[]{tick, transaction});
        }
        AIProtocolItem acceptedItem = null;
        boolean isExpress = false;
        Reliability rel = null;
        AIStream aIStream = this;
        synchronized (aIStream) {
            this._targetStream.setCursor(tick);
            TickRange valueRange = this._targetStream.getNext();
            if (valueRange.type != 3) {
                SIErrorException e1 = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:737:1.108.2.18"}, null));
                FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.sib.processor.gd.AIStream.processAccepted", (String)"1:744:1.108.2.18", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e1));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:753:1.108.2.18"});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processAccepted", null);
                }
                throw e1;
            }
            AIValueTick vt = (AIValueTick)valueRange.value;
            rel = vt.getMsgReliability();
            boolean bl = isExpress = rel.compareTo((Object)Reliability.RELIABLE_NONPERSISTENT) <= 0;
            if (transaction == null) {
                if (isExpress) {
                    this.updateToAccepted(tick, null);
                } else {
                    SIErrorException e2 = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:780:1.108.2.18"}, null));
                    FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sib.processor.gd.AIStream.processAccepted", (String)"1:787:1.108.2.18", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e2));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:795:1.108.2.18"});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"processAccepted", null);
                    }
                    throw e2;
                }
            }
        }
        if (!isExpress && transaction != null) {
            SIErrorException e2;
            acceptedItem = new AIProtocolItem(tick, 5, rel, this._parent);
            try {
                Transaction msTran = this._mp.resolveAndEnlistMsgStoreTransaction(transaction);
                this._itemStream.addItem(acceptedItem, msTran);
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.AIStream.processAccepted", (String)"1:827:1.108.2.18", (Object)this);
                acceptedItem = null;
                e2 = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:839:1.108.2.18", e}, null), (Throwable)e);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e2));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:848:1.108.2.18", SIMPUtils.getStackTrace(e)});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processAccepted", (Object)acceptedItem);
                }
                throw e2;
            }
            catch (SIResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.AIStream.processAccepted", (String)"1:862:1.108.2.18", (Object)this);
                acceptedItem = null;
                e2 = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:874:1.108.2.18", e}, null), (Throwable)e);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e2));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:883:1.108.2.18", SIMPUtils.getStackTrace(e)});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processAccepted", (Object)acceptedItem);
                }
                throw e2;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAccepted", acceptedItem);
        }
        return acceptedItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateToAccepted(long tick, AIProtocolItem acceptedItem) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateToAccepted", (Object)new Object[]{tick, acceptedItem});
        }
        this._targetStream.setCursor(tick);
        TickRange tr = this._targetStream.getNext();
        if (tr.type == 1 || tr.type == 3) {
            if (acceptedItem != null) {
                AICompletedPrefixItem aICompletedPrefixItem = this._completedPrefix;
                synchronized (aICompletedPrefixItem) {
                    this._itemStreamIndex.add(acceptedItem);
                }
            }
            this.writeAccepted(tick);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateToAccepted");
        }
    }

    public void updateToRejected(long tick, AnycastInputHandler.SendDispatcher sendDispatcher) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateToRejected", (Object)tick);
        }
        this._targetStream.setCursor(tick);
        TickRange tr = this._targetStream.getNext();
        if (tr.type == 1) {
            this.writeRejected(tick, tick, 0L);
            sendDispatcher.sendReject(tick, tick, 0L, false);
        }
        if (tr.type != 3) {
            SIErrorException e1 = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:972:1.108.2.18"}, null));
            FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.sib.processor.gd.AIStream.updateToRejected", (String)"1:979:1.108.2.18", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e1));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:988:1.108.2.18"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"updateToRejected", null);
            }
            throw e1;
        }
        long unlockCount = ((AIValueTick)tr.value).getRMEUnlockCount();
        this.writeRejected(tick, tick, unlockCount);
        sendDispatcher.sendReject(tick, tick, unlockCount, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateToRejected");
        }
    }

    public void updateAllToRejected(AnycastInputHandler.SendDispatcher sendDispatcher) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateAllToRejected");
        }
        long start = this._targetStream.getCompletedPrefix() + 1L;
        long end = this._latestTick;
        this._targetStream.setCursor(start);
        TickRange tr2 = null;
        TickRange tr1 = this._targetStream.getNext();
        do {
            long rEnd;
            long rStart;
            if (tr1.type == 1) {
                rStart = tr1.startstamp;
                rEnd = tr1.endstamp;
                TickRange rejectedRange = new TickRange(6, rStart, rEnd);
                AIRejectedRange rr = new AIRejectedRange(rStart, rEnd, 0L, false);
                rejectedRange.value = rr;
                this._targetStream.writeRange(rejectedRange);
                this._rejectedTOM.addTimeoutEntry(rr);
                sendDispatcher.sendReject(rStart, rEnd, rr.unlockCount, false);
            } else if (tr1.type == 3) {
                rStart = tr1.startstamp;
                rEnd = tr1.endstamp;
                long unlockCount = ((AIValueTick)tr1.value).getRMEUnlockCount();
                TickRange rejectedRange = new TickRange(6, rStart, rEnd);
                AIRejectedRange rr = new AIRejectedRange(rStart, rEnd, unlockCount, false);
                rejectedRange.value = rr;
                this._targetStream.writeRange(rejectedRange);
                this._rejectedTOM.addTimeoutEntry(rr);
                sendDispatcher.sendReject(rStart, rEnd, rr.unlockCount, false);
            }
            tr2 = tr1;
            tr1 = this._targetStream.getNext();
        } while (tr1.startstamp <= end && tr1 != tr2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateAllToRejected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateToCompleted(long startTick, long endTick) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateToCompleted", (Object)new Object[]{startTick, endTick});
        }
        boolean checkCompletedPrefix = false;
        this._targetStream.setCursor(startTick);
        TickRange tr1 = this._targetStream.getNext();
        TickRange tr2 = null;
        do {
            AIStreamKey tsKey;
            boolean resolve;
            boolean update;
            block25: {
                update = true;
                resolve = false;
                tsKey = null;
                if (tr1.type == 5) {
                    AIAcceptedTick at = (AIAcceptedTick)tr1.value;
                    this._acceptedTOM.removeTimeoutEntry(at);
                    this._initialAcceptedTOM.removeTimeoutEntry(at);
                } else if (tr1.type == 6) {
                    AIRejectedRange rr = (AIRejectedRange)tr1.value;
                    this._rejectedTOM.removeTimeoutEntry(rr);
                } else if (tr1.type == 1) {
                    AIRequestedTick rt = (AIRequestedTick)tr1.value;
                    tsKey = new AIStreamKey(tr1.startstamp, rt.getRemoteDispatchableKey(), rt.getOriginalTimeout(), rt.getIssueTime());
                    resolve = true;
                    if (rt.getTimeout() > 0L || rt.getOriginalTimeout() == -1L) {
                        if (rt.isSlowed()) {
                            this._slowedGetTOM.removeTimeoutEntry(rt);
                        } else {
                            this._eagerGetTOM.removeTimeoutEntry(rt);
                        }
                    }
                } else {
                    if (tr1.type == 3) {
                        AIValueTick vt = (AIValueTick)tr1.value;
                        if (!vt.isDelivered()) {
                            tsKey = new AIStreamKey(tr1.startstamp, vt.getRemoteDispatchableKey(), vt.getOriginalTimeout(), vt.getIssueTime());
                            resolve = true;
                            break block25;
                        } else {
                            SIErrorException e1 = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:1146:1.108.2.18"}, null));
                            FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.sib.processor.gd.AIStream.updateToCompleted", (String)"1:1153:1.108.2.18", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e1));
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:1162:1.108.2.18"});
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"updateToCompleted", null);
                            }
                            throw e1;
                        }
                    }
                    update = false;
                }
            }
            if (update) {
                this.writeCompletedRange(tr1.startstamp, tr1.endstamp);
                checkCompletedPrefix = true;
            }
            if (resolve) {
                this._parent.resolve(tsKey);
            }
            tr2 = tr1;
            tr1 = this._targetStream.getNext();
        } while (tr1.startstamp <= endTick && tr1 != tr2);
        if (checkCompletedPrefix) {
            AICompletedPrefixItem aICompletedPrefixItem = this._completedPrefix;
            synchronized (aICompletedPrefixItem) {
                if (this._targetStream.getCompletedPrefix() > this._completedPrefix.getTick()) {
                    this._completedPrefix.setTick(this._targetStream.getCompletedPrefix());
                    if (this._completedPrefixNeedsToBeScheduled) {
                        CompletedPrefixAsyncUpdate update = new CompletedPrefixAsyncUpdate();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("CompletedPrefixAsyncUpdate " + update + " : " + this._countOfOutstandingCPUpdates));
                        }
                        if (this.doEnqueueWork(update)) {
                            this._completedPrefixNeedsToBeScheduled = false;
                            ++this._countOfOutstandingCPUpdates;
                        }
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateToCompleted");
        }
    }

    public void resendScheduledRejects() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resendScheduledRejects");
        }
        this._rejectedTOM.driveAllActiveEntries();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resendScheduledRejects");
        }
    }

    public void updateAllToCompleted() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateAllToCompleted");
        }
        long start = this._targetStream.getCompletedPrefix() + 1L;
        long end = this._latestTick;
        this.updateToCompleted(start, end);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateAllToCompleted");
        }
    }

    public void processDecisionExpected(long tick, AnycastInputHandler.SendDispatcher sendDispatcher) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processDecisionExpected", (Object)tick);
        }
        this._targetStream.setCursor(tick);
        TickRange tickRange = this._targetStream.getNext();
        if (tickRange.type != 0) {
            if (tickRange.type == 1) {
                AIRequestedTick rt = (AIRequestedTick)tickRange.value;
                sendDispatcher.sendRequest(rt.getTick(), rt.getTick(), rt.getCriterias(), rt.getTimeout());
            } else if (tickRange.type != 3) {
                if (tickRange.type == 5) {
                    sendDispatcher.sendAccept(tick);
                } else if (tickRange.type == 6) {
                    AIRejectedRange rr = (AIRejectedRange)tickRange.value;
                    sendDispatcher.sendReject(rr.startTick, rr.endTick, rr.unlockCount, rr.recovery);
                } else if (tickRange.type == 7) {
                    sendDispatcher.sendCompleted(tickRange.startstamp, tickRange.endstamp);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processDecisionExpected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequestAck(long tick, long dmeVersion) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processRequestAck", (Object)new Object[]{tick, dmeVersion});
        }
        if (dmeVersion >= this._latestDMEVersion) {
            this._targetStream.setCursor(tick);
            TickRange tickRange = this._targetStream.getNext();
            if (tickRange.type == 1) {
                AIRequestedTick airt;
                AIRequestedTick aIRequestedTick = airt = (AIRequestedTick)tickRange.value;
                synchronized (aIRequestedTick) {
                    if (!airt.isSlowed()) {
                        this._eagerGetTOM.removeTimeoutEntry(airt);
                        airt.setSlowed(true);
                        airt.setAckingDMEVersion(dmeVersion);
                        long to = airt.getTimeout();
                        if (to > 0L || to == this._mp.getCustomProperties().get_infinite_timeout()) {
                            this._slowedGetTOM.addTimeoutEntry(airt);
                        }
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processRequestAck");
        }
    }

    public void processResetRequestAck(long dmeVersion, AnycastInputHandler.SendDispatcher sendDispatcher) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processResetRequestAck", (Object)dmeVersion);
        }
        if (dmeVersion >= this._latestDMEVersion) {
            if (dmeVersion > this._latestDMEVersion) {
                this._latestDMEVersion = dmeVersion;
            }
            this._slowedGetTOM.applyToEachEntry(new AddToEagerTOM(this._slowedGetTOM, dmeVersion));
            sendDispatcher.sendResetRequestAckAck(dmeVersion);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processResetRequestAck");
        }
    }

    public synchronized long getLatestTick() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLatestTick");
            SibTr.exit((TraceComponent)tc, (String)"getLatestTick", (Object)this._latestTick);
        }
        return this._latestTick;
    }

    public AnycastInputHandler getAnycastInputHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAnycastInputHandler");
            SibTr.exit((TraceComponent)tc, (String)"getAnycastInputHandler", (Object)this._parent);
        }
        return this._parent;
    }

    public synchronized void setLatestTick(long tick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setLatestTick", (Object)tick);
        }
        this._latestTick = tick;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setLatestTick");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompletedPrefix(TransactionCommon t, long lockID) throws MessageStoreException, InterruptedException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeCompletedPrefix", (Object)new Object[]{t, lockID, this._countOfOutstandingCPUpdates});
        }
        AICompletedPrefixItem aICompletedPrefixItem = this._completedPrefix;
        synchronized (aICompletedPrefixItem) {
            if (this._countOfOutstandingCPUpdates > 0) {
                ((Object)((Object)this._completedPrefix)).wait();
            }
            this._completedPrefix.lockItemIfAvailable(lockID);
            Transaction msTran = this._mp.resolveAndEnlistMsgStoreTransaction(t);
            this._completedPrefix.remove(msTran, lockID);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeCompletedPrefix");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        AIStream aIStream = this;
        synchronized (aIStream) {
            this._stopped = false;
        }
        this._eagerGetTOM.startTimer();
        this._slowedGetTOM.startTimer();
        this._initialAcceptedTOM.startTimer();
        this._acceptedTOM.startTimer();
        this._rejectedTOM.startTimer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        AIStream aIStream = this;
        synchronized (aIStream) {
            this._stopped = true;
        }
        this._eagerGetTOM.stopTimer();
        this._slowedGetTOM.stopTimer();
        this._initialAcceptedTOM.stopTimer();
        this._acceptedTOM.stopTimer();
        this._rejectedTOM.stopTimer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    private void writeAccepted(long tick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeAccepted", (Object)new Object[]{tick});
        }
        AIAcceptedTick at = this.writeAcceptedNoTimeout(tick);
        this._initialAcceptedTOM.addTimeoutEntry(at);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeAccepted");
        }
    }

    private AIAcceptedTick writeAcceptedNoTimeout(long tick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeAcceptedNoTimeout", (Object)new Object[]{tick});
        }
        AIAcceptedTick at = new AIAcceptedTick(tick);
        TickRange acceptedRange = new TickRange(5, tick, tick);
        acceptedRange.value = at;
        this._targetStream.writeRange(acceptedRange);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeAcceptedNoTimeout", (Object)at);
        }
        return at;
    }

    private AIRejectedRange writeRejected(long startTick, long endTick, long unlockCount) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeRejected", (Object)new Object[]{startTick, endTick, unlockCount});
        }
        AIRejectedRange rr = this.writeRejectedNoTimeout(startTick, endTick, unlockCount, false);
        this._rejectedTOM.addTimeoutEntry(rr);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeRejected", (Object)rr);
        }
        return rr;
    }

    private AIRejectedRange writeRejectedNoTimeout(long startTick, long endTick, long unlockCount, boolean recovery) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeRejectedNoTimeout", (Object)new Object[]{startTick, endTick, unlockCount, recovery});
        }
        AIRejectedRange rr = new AIRejectedRange(startTick, endTick, unlockCount, recovery);
        TickRange rejectedRange = new TickRange(6, startTick, endTick);
        rejectedRange.value = rr;
        this._targetStream.writeRange(rejectedRange);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeRejectedNoTimeout", (Object)rr);
        }
        return rr;
    }

    private TickRange writeCompletedRange(long startTick, long endTick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeCompletedRange", (Object)new Object[]{startTick, endTick});
        }
        TickRange completedRange = new TickRange(7, startTick, endTick);
        TickRange combinedRange = null;
        combinedRange = this._targetStream.writeCompletedRange(completedRange);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeCompletedRange", (Object)combinedRange);
        }
        return combinedRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CreateTOMs recoverFromPersistentState(AIProtocolItemStream persStreamState) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"recoverFromPersistentState", (Object)((Object)persStreamState));
        }
        NonLockingCursor cursor = null;
        AbstractItem abitem = null;
        ArrayList<AIAcceptedTick> acceptedTicks = null;
        ArrayList<AIRejectedRange> rejectedTicks = null;
        ArrayList<AIRequestedTick> requestedTicks = null;
        long completedPrefix = 0L;
        try {
            cursor = persStreamState.newNonLockingItemCursor(null);
            cursor.allowUnavailableItems();
            while ((abitem = cursor.next()) != null) {
                if (abitem instanceof AIProtocolItem) {
                    AIProtocolItem protocolItem = (AIProtocolItem)abitem;
                    byte protocolState = protocolItem.getProtocolState();
                    if (protocolState == 5) {
                        if (protocolItem.getTick() > completedPrefix) {
                            protocolItem.setAIHCallbackTarget(this._parent);
                            persStreamState.setCurrentTransaction(protocolItem, false);
                            if (protocolItem.isAvailable()) {
                                AIAcceptedTick at = null;
                                try {
                                    at = this.writeAcceptedNoTimeout(protocolItem.getTick());
                                }
                                catch (SIErrorException e) {
                                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.AIStream.recoverFromPersistentState", (String)"1:1636:1.108.2.18", (Object[])new Object[]{this.getCompletedPrefix(), protocolItem.getTick(), protocolItem, persStreamState, this._targetStream, this});
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                        SibTr.exit((TraceComponent)tc, (String)"recoverFromPersistentState", (Object)((Object)e));
                                    }
                                    throw e;
                                }
                                if (acceptedTicks == null) {
                                    acceptedTicks = new ArrayList<AIAcceptedTick>();
                                }
                                acceptedTicks.add(at);
                                AICompletedPrefixItem e = this._completedPrefix;
                                synchronized (e) {
                                    this._itemStreamIndex.add(protocolItem);
                                    continue;
                                }
                            }
                            long tick = protocolItem.getTick();
                            AIValueTick valueTick = new AIValueTick(tick, Reliability.ASSURED_PERSISTENT);
                            TickRange valueRange = new TickRange(3, tick, tick);
                            valueRange.value = valueTick;
                            valueRange.valuestamp = tick;
                            this._targetStream.writeRange(valueRange);
                            protocolItem.setUnavailableAfterRecovery(true);
                            continue;
                        }
                        SIMPTransactionManager txMan = this._mp.getTXManager();
                        LocalTransaction mpTxn = txMan.createLocalTransaction(false);
                        try {
                            Transaction msTxn = txMan.resolveAndEnlistMsgStoreTransaction((TransactionCommon)mpTxn);
                            protocolItem.remove(msTxn, -2L);
                            mpTxn.commit();
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.AIStream.recoverFromPersistentState", (String)"1:1693:1.108.2.18", (Object)this);
                        }
                        continue;
                    }
                    SIErrorException e = new SIErrorException();
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.AIStream.recoverFromPersistentState", (String)"1:1706:1.108.2.18", (Object)this);
                    continue;
                }
                if (!(abitem instanceof AICompletedPrefixItem)) continue;
                this._completedPrefix = (AICompletedPrefixItem)abitem;
                long startTick = 0L;
                completedPrefix = this._completedPrefix.getTick();
                this.writeCompletedRange(startTick, completedPrefix);
                this._targetStream.setCompletedPrefix(completedPrefix);
            }
        }
        finally {
            if (cursor != null) {
                cursor.finished();
            }
        }
        ArrayList<AOValue> values = ((AIContainerItemStream)this._itemStream.getItemStream()).getAOLinks();
        if (values != null) {
            for (AOValue val : values) {
                long tick = val.getAIRequestTick();
                TickRange requestRange = new TickRange(1, tick, tick);
                AIRequestedTick rt = new AIRequestedTick(tick, val, -1L);
                requestRange.value = rt;
                requestRange.valuestamp = tick;
                this._targetStream.writeRange(requestRange);
                if (requestedTicks == null) {
                    requestedTicks = new ArrayList<AIRequestedTick>();
                }
                requestedTicks.add(rt);
            }
        }
        long start = this._targetStream.getCompletedPrefix() + 1L;
        long end = this._latestTick;
        this._targetStream.setCursor(start);
        TickRange tr2 = null;
        TickRange tr1 = this._targetStream.getNext();
        while (tr1.startstamp <= end && tr1 != tr2) {
            if (tr1.type == 0) {
                long rangeStart = tr1.startstamp;
                long rangeEnd = tr1.endstamp > end ? end : tr1.endstamp;
                AIRejectedRange rr = this.writeRejectedNoTimeout(rangeStart, rangeEnd, 0L, true);
                if (rejectedTicks == null) {
                    rejectedTicks = new ArrayList<AIRejectedRange>();
                }
                rejectedTicks.add(rr);
            } else if (tr1.type == 3 || tr1.type == 5 || tr1.type == 1) {
                // empty if block
            }
            tr2 = tr1;
            tr1 = this._targetStream.getNext();
        }
        CreateTOMs ct = new CreateTOMs(acceptedTicks, rejectedTicks, requestedTicks);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"recoverFromPersistentState", (Object)ct);
        }
        return ct;
    }

    private boolean doEnqueueWork(AsyncUpdate au) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"doEnqueueWork", (Object)au);
        }
        try {
            this._msUpdateThread.enqueueWork(au);
        }
        catch (ClosedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.AIStream.doEnqueueWork", (String)"1:1812:1.108.2.18", (Object)this);
            SIErrorException e2 = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:1820:1.108.2.18", e}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e2));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:1828:1.108.2.18", SIMPUtils.getStackTrace(e)});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"doEnqueueWork", (Object)false);
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"doEnqueueWork", (Object)true);
        }
        return true;
    }

    private void sendRequest(long rejectStartTick, long tick, SelectionCriteria[] criterias, long timeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendRequest", (Object)new Object[]{rejectStartTick, tick, criterias, timeout});
        }
        long[] rst = new long[]{rejectStartTick};
        long[] ticks = new long[]{tick};
        long[] tos = new long[]{timeout};
        this._parent.sendRequest(rst, ticks, criterias, tos, 12);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendRequest");
        }
    }

    public AIProtocolItemStream getAIProtocolItemStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAIProtocolItemStream");
            SibTr.exit((TraceComponent)tc, (String)"getAIProtocolItemStream", (Object)((Object)this._itemStream));
        }
        return this._itemStream;
    }

    @Override
    public long getCompletedPrefix() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCompletedPrefix");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getCompletedPrefix", (Object)this._targetStream.getCompletedPrefix());
        }
        return this._targetStream.getCompletedPrefix();
    }

    @Override
    public String getID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getID");
        }
        String id = this._streamId.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getID", (Object)id);
        }
        return id;
    }

    @Override
    protected int getPriority() {
        return 0;
    }

    @Override
    protected Reliability getReliability() {
        return null;
    }

    @Override
    public StateStream getStateStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStateStream");
            SibTr.exit((TraceComponent)tc, (String)"getStateStream", (Object)this._targetStream);
        }
        return this._targetStream;
    }

    @Override
    public void writeSilenceForced(long tick) {
    }

    @Override
    public void createControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        this._controlAdapter = new RemoteConsumerReceiver(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    @Override
    public void dereferenceControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControlAdapter");
        }
        this._controlAdapter = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControlAdapter");
        }
    }

    @Override
    public ControlAdapter getControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlAdapter");
        }
        if (this._controlAdapter == null) {
            this.createControlAdapter();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter");
        }
        return this._controlAdapter;
    }

    @Override
    public void registerControlAdapterAsMBean() {
    }

    @Override
    public void deregisterControlAdapterMBean() {
    }

    public String toString() {
        String text = super.toString() + "[";
        text = text + "StreamId:" + this._streamId + "]";
        return text;
    }

    class ProtocolItemComparator
    implements Comparator {
        ProtocolItemComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"compare", (Object)new Object[]{o1, o2});
            }
            if (o1 instanceof AIProtocolItem && o2 instanceof AIProtocolItem) {
                AIProtocolItem pi1 = (AIProtocolItem)o1;
                AIProtocolItem pi2 = (AIProtocolItem)o2;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("o1.tick:" + pi1.getTick() + " o2.tick:" + pi2.getTick()));
                }
                int result = pi1.getTick() < pi2.getTick() ? -1 : (pi1.getTick() > pi2.getTick() ? 1 : 0);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"compare", (Object)result);
                }
                return result;
            }
            ClassCastException e = new ClassCastException();
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.AIStream.ProtocolItemComparator.compare", (String)"1:2634:1.108.2.18", (Object[])new Object[]{this, o1, o2});
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"compare", (Object)0);
            }
            throw e;
        }
    }

    class CompletedPrefixAsyncUpdate
    extends AsyncUpdate {
        CompletedPrefixAsyncUpdate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(TransactionCommon transactionCommon) throws Throwable {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"execute", (Object)new Object[]{this, transactionCommon});
            }
            Transaction t = AIStream.this._mp.resolveAndEnlistMsgStoreTransaction(transactionCommon);
            AICompletedPrefixItem aICompletedPrefixItem = AIStream.this._completedPrefix;
            synchronized (aICompletedPrefixItem) {
                try {
                    if (!AIStream.this._completedPrefix.isUpdating()) {
                        AIStream.this._completedPrefix.requestUpdate(t);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("_completedPrefix tick: " + AIStream.this._completedPrefix.getTick()));
                    }
                    Iterator items = AIStream.this._itemStreamIndex.iterator();
                    AIProtocolItem nextItem = null;
                    if (items.hasNext()) {
                        nextItem = (AIProtocolItem)items.next();
                    }
                    while (nextItem != null && nextItem.getTick() <= AIStream.this._completedPrefix.getTick()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("processing tick: " + nextItem.getTick()));
                        }
                        long lockID = AIStream.this._parent.getUniqueLockID(1);
                        nextItem.lockItemIfAvailable(lockID);
                        nextItem.remove(t, lockID);
                        items.remove();
                        if (items.hasNext()) {
                            nextItem = (AIProtocolItem)items.next();
                            continue;
                        }
                        nextItem = null;
                    }
                    if (nextItem != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Didn't process tick: " + nextItem.getTick()));
                    }
                    AIStream.this._completedPrefixNeedsToBeScheduled = true;
                }
                catch (Throwable e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.AIStream.CompletedPrefixAsyncUpdate.execute", (String)"1:2544:1.108.2.18", (Object[])new Object[]{this, AIStream.this._itemStreamIndex, AIStream.this._completedPrefix.getTick()});
                    SibTr.exception((TraceComponent)tc, (Throwable)e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"execute", (Object)e);
                    }
                    throw e;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"execute");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void committed() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"committed");
            }
            AICompletedPrefixItem aICompletedPrefixItem = AIStream.this._completedPrefix;
            synchronized (aICompletedPrefixItem) {
                AIStream.this._countOfOutstandingCPUpdates--;
                if (AIStream.this._countOfOutstandingCPUpdates == 0) {
                    ((Object)((Object)AIStream.this._completedPrefix)).notify();
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"committed", (Object)AIStream.this._countOfOutstandingCPUpdates);
            }
        }

        @Override
        public void rolledback(Throwable t) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rolledback", (Object)t);
            }
            AIStream.this.doEnqueueWork(this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rolledback");
            }
        }
    }

    class CreateTOMs {
        private List acceptedTicks;
        private List rejectedTicks;
        private List requestedTicks;

        public CreateTOMs() {
            this.acceptedTicks = null;
            this.rejectedTicks = null;
            this.requestedTicks = null;
        }

        public CreateTOMs(List acceptedTicks, List rejectedTicks, List requestedTicks) {
            this.acceptedTicks = acceptedTicks;
            this.rejectedTicks = rejectedTicks;
            this.requestedTicks = requestedTicks;
        }

        public void create() {
            AIStream.this._eagerGetTOM = new BatchedTimeoutManager(4, AIStream.this._mp.getCustomProperties().get_eager_get_request_interval(), this.requestedTicks, new EagerGetTimeoutProcessor(), AIStream.this._mp);
            AIStream.this._slowedGetTOM = new TraversableBatchedTimeoutManager(4, AIStream.this._mp.getCustomProperties().get_slowed_get_request_interval(), null, new SlowedGetTimeoutProcessor(), AIStream.this._mp);
            AIStream.this._initialAcceptedTOM = new BatchedTimeoutManager(4, AIStream.this._mp.getCustomProperties().get_accept_initial_threshold(), this.acceptedTicks, new InitialAcceptedTimeoutProcessor(), AIStream.this._mp);
            AIStream.this._acceptedTOM = new BatchedTimeoutManager(4, AIStream.this._mp.getCustomProperties().get_accept_repetition_interval(), this.acceptedTicks, new AcceptedTimeoutProcessor(), AIStream.this._mp);
            AIStream.this._rejectedTOM = new BatchedTimeoutManager(4, AIStream.this._mp.getCustomProperties().get_reject_repetition_interval(), this.rejectedTicks, new RejectedTimeoutProcessor(), AIStream.this._mp);
        }
    }

    public static class AIStreamState
    implements SIMPDeliveryReceiverControllable.StreamState {
        public static final AIStreamState ACTIVE = new AIStreamState("Active", 1);
        public static final AIStreamState REMOVING = new AIStreamState("Removing", 2);
        private String name;
        private int id;

        private AIStreamState(String _name, int _id) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AIStreamState", (Object)new Object[]{_name, _id});
            }
            this.name = _name;
            this.id = _id;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AIStreamState", (Object)this);
            }
        }

        public String toString() {
            return this.name;
        }

        public int getValue() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getValue");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getValue", (Object)this.id);
            }
            return this.id;
        }
    }

    class RejectedTimeoutProcessor
    implements BatchedTimeoutProcessor {
        RejectedTimeoutProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processTimedoutEntries(List entries) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"processTimedoutEntries", (Object)new Object[]{"RejectedTimeoutProcessor", AIStream.this, entries});
            }
            AIStream aIStream = AIStream.this;
            synchronized (aIStream) {
                if (AIStream.this._stopped) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"processTimedoutEntries", (Object)this);
                    }
                    return;
                }
            }
            int len = entries.size();
            AnycastInputHandler.SendDispatcher sendDispatcher = new AnycastInputHandler.SendDispatcher(AIStream.this._parent);
            for (int i = 0; i < len; ++i) {
                AIRejectedRange rr = (AIRejectedRange)entries.get(i);
                sendDispatcher.sendReject(rr.startTick, rr.endTick, rr.unlockCount, rr.recovery);
            }
            sendDispatcher.dispatch();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processTimedoutEntries", (Object)this);
            }
        }
    }

    class AcceptedTimeoutProcessor
    implements BatchedTimeoutProcessor {
        protected boolean initialSend = false;

        AcceptedTimeoutProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processTimedoutEntries(List entries) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"processTimedoutEntries", (Object)new Object[]{"AcceptedTimeoutProcessor", AIStream.this, entries, this.initialSend, this});
            }
            AIStream aIStream = AIStream.this;
            synchronized (aIStream) {
                if (AIStream.this._stopped) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"processTimedoutEntries");
                    }
                    return;
                }
            }
            int len = entries.size();
            long[] ticks = new long[len];
            for (int i = 0; i < len; ++i) {
                AIAcceptedTick at = (AIAcceptedTick)entries.get(i);
                ticks[i] = at.tick;
                if (!this.initialSend) continue;
                AIStream.this._initialAcceptedTOM.removeTimeoutEntry(at);
                AIStream.this._acceptedTOM.addTimeoutEntry(at);
            }
            AIStream.this._parent.sendAccept(ticks);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processTimedoutEntries", (Object)this);
            }
        }
    }

    class InitialAcceptedTimeoutProcessor
    extends AcceptedTimeoutProcessor {
        public InitialAcceptedTimeoutProcessor() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"InitialAcceptedTimeoutProcessor");
            }
            this.initialSend = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"InitialAcceptedTimeoutProcessor", (Object)this);
            }
        }
    }

    class AIRejectedRange
    extends AbstractBatchedTimeoutEntry {
        public long startTick;
        public long endTick;
        public boolean recovery;
        public long unlockCount;

        public AIRejectedRange(long startTick, long endTick, long unlockCount, boolean recovery) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AIRejectedRange", (Object)new Object[]{startTick, endTick, unlockCount, recovery});
            }
            this.startTick = startTick;
            this.endTick = endTick;
            this.unlockCount = unlockCount;
            this.recovery = recovery;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AIRejectedRange", (Object)this);
            }
        }
    }

    class AIAcceptedTick
    extends AbstractBatchedTimeoutEntry {
        public long tick;

        public AIAcceptedTick(long tick) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AIAcceptedTick", (Object)new Object[]{tick});
            }
            this.tick = tick;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AIAcceptedTick", (Object)this);
            }
        }
    }

    class AddToEagerTOM
    implements EntryAction {
        private TraversableBatchedTimeoutManager timeoutManager;
        private long dmeVersion;

        public AddToEagerTOM(TraversableBatchedTimeoutManager timeoutManager, long dmeVersion) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AddToEagerTOM", (Object)new Object[]{timeoutManager, dmeVersion});
            }
            this.timeoutManager = timeoutManager;
            this.dmeVersion = dmeVersion;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AddToEagerTOM", (Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void theAction(BatchedTimeoutEntry entry) {
            AIRequestedTick airt;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"theAction", (Object)entry);
            }
            if ((airt = (AIRequestedTick)entry).getAckingDMEVersion() < this.dmeVersion) {
                this.timeoutManager.removeTimeoutEntry(airt);
                AIRequestedTick aIRequestedTick = airt;
                synchronized (aIRequestedTick) {
                    long to = airt.getTimeout();
                    if (to != AIStream.this._mp.getCustomProperties().get_infinite_timeout()) {
                        to -= AIStream.this._mp.getCustomProperties().get_slowed_get_request_interval();
                    }
                    if (to > 0L || to == AIStream.this._mp.getCustomProperties().get_infinite_timeout()) {
                        AIStream.this._eagerGetTOM.addTimeoutEntry(airt);
                        airt.setSlowed(false);
                        long rejectStart = airt.getTick();
                        AIStream.this.sendRequest(rejectStart, airt.getTick(), airt.getCriterias(), to);
                    } else {
                        try {
                            AnycastInputHandler.SendDispatcher rejectedDispatcher = new AnycastInputHandler.SendDispatcher(AIStream.this._parent);
                            AIStream.this.updateToRejected(airt.getTick(), rejectedDispatcher);
                            rejectedDispatcher.dispatch();
                        }
                        catch (SIErrorException sIErrorException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"theAction");
            }
        }
    }

    static interface EntryAction {
        public void theAction(BatchedTimeoutEntry var1);
    }

    class TraversableBatchedTimeoutManager
    extends BatchedTimeoutManager {
        public TraversableBatchedTimeoutManager(int numOfBuckets, long timeoutInterval, List timeoutEntries, BatchedTimeoutProcessor handler, MessageProcessor mp) {
            super(numOfBuckets, timeoutInterval, timeoutEntries, handler, mp);
        }

        public synchronized void applyToEachEntry(EntryAction action) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"applyToEachEntry", (Object)action);
            }
            for (BatchedTimeoutManager.LinkedListEntry entry = (BatchedTimeoutManager.LinkedListEntry)this.activeEntries.getFirst(); entry != null && this.activeEntries.contains(entry); entry = (BatchedTimeoutManager.LinkedListEntry)entry.getNext()) {
                action.theAction(entry.bte);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"applyToEachEntry");
            }
        }
    }

    class SlowedGetTimeoutProcessor
    implements BatchedTimeoutProcessor {
        SlowedGetTimeoutProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processTimedoutEntries(List entries) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"processTimedoutEntries", (Object)new Object[]{"SlowedGetTimeoutProcessor", AIStream.this, entries});
            }
            AIStream aIStream = AIStream.this;
            synchronized (aIStream) {
                if (AIStream.this._stopped) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"processTimedoutEntries", (Object)this);
                    }
                    return;
                }
            }
            int len = entries.size();
            for (int i = 0; i < len; ++i) {
                AIRequestedTick airt = (AIRequestedTick)entries.get(i);
                boolean rejectRequest = false;
                AIRequestedTick aIRequestedTick = airt;
                synchronized (aIRequestedTick) {
                    long to = airt.getTimeout();
                    if (to != AIStream.this._mp.getCustomProperties().get_infinite_timeout()) {
                        airt.resetTimeout(to -= AIStream.this._mp.getCustomProperties().get_slowed_get_request_interval());
                    }
                    if (to > 0L || to == AIStream.this._mp.getCustomProperties().get_infinite_timeout()) {
                        AIStream.this._slowedGetTOM.removeTimeoutEntry(airt);
                        airt.setSlowed(false);
                        AIStream.this._eagerGetTOM.addTimeoutEntry(airt);
                        long rejectStart = airt.getTick();
                        AIStream.this.sendRequest(rejectStart, airt.getTick(), airt.getCriterias(), to);
                    } else {
                        AIStream.this._slowedGetTOM.removeTimeoutEntry(airt);
                        rejectRequest = true;
                    }
                }
                if (!rejectRequest) continue;
                AIStream.this._parent.reject(airt.getTick());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processTimedoutEntries", (Object)entries);
            }
        }
    }

    class EagerGetTimeoutProcessor
    implements BatchedTimeoutProcessor {
        EagerGetTimeoutProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processTimedoutEntries(List entries) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"processTimedoutEntries", (Object)new Object[]{"EagerGetTimeoutProcessor", AIStream.this, entries});
            }
            AIStream aIStream = AIStream.this;
            synchronized (aIStream) {
                if (AIStream.this._stopped) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"processTimedoutEntries", (Object)this);
                    }
                    return;
                }
            }
            int len = entries.size();
            for (int i = 0; i < len; ++i) {
                AIRequestedTick airt = (AIRequestedTick)entries.get(i);
                boolean rejectRequest = false;
                AIRequestedTick aIRequestedTick = airt;
                synchronized (aIRequestedTick) {
                    long to = airt.getTimeout();
                    if (to != AIStream.this._mp.getCustomProperties().get_infinite_timeout()) {
                        airt.resetTimeout(to -= AIStream.this._mp.getCustomProperties().get_eager_get_request_interval());
                    }
                    if (to > 0L || to == AIStream.this._mp.getCustomProperties().get_infinite_timeout()) {
                        long rejectStart = airt.getTick();
                        AIStream.this.sendRequest(rejectStart, airt.getTick(), airt.getCriterias(), to);
                    } else {
                        AIStream.this._eagerGetTOM.removeTimeoutEntry(airt);
                        rejectRequest = true;
                    }
                }
                if (!rejectRequest) continue;
                AIStream.this._parent.reject(airt.getTick());
                RemoteDispatchableKey rdk = airt.getRemoteDispatchableKey();
                if (!(rdk instanceof RemoteQPConsumerKey)) continue;
                ((RemoteQPConsumerKey)rdk).checkAndResetRefillState(airt.getTick());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processTimedoutEntries");
            }
        }
    }
}

