/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.filemonitor.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.filemonitor.internal.CoreService;
import com.ibm.ws.kernel.filemonitor.internal.UpdateMonitor;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class MonitorHolder
implements Runnable {
    static final int TIME_TO_WAIT_FOR_COPY_TO_COMPLETE = 100;
    static final int NUMBER_OF_EXCEPTIONS_BEFORE_DISABLING_MONITOR = 3;
    static final TraceComponent tc = Tr.register(MonitorHolder.class);
    private static final Pattern INTERVAL_STRING = Pattern.compile("(\\d+)(\\w+)");
    Set<File> unnotifiedFileCreates = new HashSet<File>();
    Set<File> unnotifiedFileDeletes = new HashSet<File>();
    Set<File> unnotifiedFileModifies = new HashSet<File>();
    private final AtomicInteger monitorState = new AtomicInteger(MonitorState.UNKNOWN.ordinal());
    private final Lock scanLock = new ReentrantLock();
    private final AtomicBoolean scanInProgress = new AtomicBoolean(false);
    private final CoreService coreService;
    private final ServiceReference<FileMonitor> monitorRef;
    private final Map<UpdateMonitor, UpdateMonitor> updateMonitors;
    private boolean monitorRecurse;
    private boolean monitorSelf;
    protected String monitorFilter;
    private long monitorInterval;
    private TimeUnit monitorTimeUnit;
    private FileMonitor monitor;
    private boolean needsBaseline;
    private ScheduledFuture<?> scheduledFuture = null;
    private int exceptionCount = 0;
    static final long serialVersionUID = -3202331216039649411L;

    public MonitorHolder(CoreService coreService, ServiceReference<FileMonitor> monitorRef) {
        if (coreService == null) {
            throw new NullPointerException("CoreService must be non-null");
        }
        if (monitorRef == null) {
            throw new NullPointerException("FileMonitor reference must be non-null");
        }
        this.coreService = coreService;
        this.monitorRef = monitorRef;
        this.updateMonitors = new HashMap<UpdateMonitor, UpdateMonitor>();
        this.needsBaseline = true;
        this.initProperties(monitorRef);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initProperties(ServiceReference<FileMonitor> monitorRef) {
        Object value = monitorRef.getProperty("monitor.filter");
        if (value != null && !(value instanceof String)) {
            Tr.warning((TraceComponent)tc, (String)"badFilter", (Object[])new Object[]{value});
            throw new IllegalArgumentException("Invalid monitor filter: value=" + value);
        }
        this.needsBaseline = this.monitorFilter == null ? (this.needsBaseline |= value != null) : (this.needsBaseline |= !this.monitorFilter.equals(value));
        this.monitorFilter = (String)value;
        value = monitorRef.getProperty("monitor.recurse");
        boolean b = MetatypeUtils.parseBoolean((Object)monitorRef.getProperty("service.pid"), (String)"monitor.recurse", (Object)value, (boolean)false);
        this.needsBaseline |= this.monitorRecurse != b;
        this.monitorRecurse = b;
        value = monitorRef.getProperty("monitor.includeself");
        b = MetatypeUtils.parseBoolean((Object)monitorRef.getProperty("service.pid"), (String)"monitor.includeself", (Object)value, (boolean)false);
        this.needsBaseline |= this.monitorSelf != b;
        this.monitorSelf = b;
        long interval = 10L;
        TimeUnit unit = TimeUnit.MILLISECONDS;
        value = monitorRef.getProperty("monitor.interval");
        if (value == null) {
            interval = 0L;
        } else if (value.getClass().isAssignableFrom(Long.class)) {
            interval = (Long)value;
        } else {
            if (!(value instanceof String)) {
                Tr.warning((TraceComponent)tc, (String)"badInterval", (Object[])new Object[]{value});
                throw new IllegalArgumentException("Invalid monitor interval: value=" + value);
            }
            String intervalString = (String)value;
            Matcher m = INTERVAL_STRING.matcher(intervalString);
            if (!m.matches()) {
                Tr.warning((TraceComponent)tc, (String)"badInterval", (Object[])new Object[]{value});
                throw new IllegalArgumentException("Invalid monitor interval: value=" + value);
            }
            interval = MonitorHolder.parseInterval(m.group(1), intervalString);
            unit = MonitorHolder.parseTimeUnit(m.group(2), intervalString);
        }
        this.monitorInterval = interval;
        this.monitorTimeUnit = unit;
        this.monitorState.set(MonitorState.INIT.ordinal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void init() {
        if (this.monitorState.compareAndSet(MonitorState.INIT.ordinal(), MonitorState.INITIALIZING.ordinal())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Monitor holder init, initializing", (Object[])new Object[0]);
            }
            HashSet<File> baseline = new HashSet<File>();
            HashMap<UpdateMonitor, UpdateMonitor> oldMap = null;
            Object value = this.monitorRef.getProperty("monitor.files");
            Collection<Object> collection = Collections.emptyList();
            Object servicePid = this.monitorRef.getProperty("service.pid");
            boolean performBaseline = false;
            try {
                this.scanLock.lock();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Monitor holder init, scan lock obtained", (Object[])new Object[0]);
                }
                if (!this.updateMonitors.isEmpty()) {
                    oldMap = new HashMap<UpdateMonitor, UpdateMonitor>(this.updateMonitors);
                    this.updateMonitors.clear();
                }
                LinkedList<UpdateMonitor> newUpdateMonitors = new LinkedList<UpdateMonitor>();
                collection = MetatypeUtils.parseStringCollection((Object)servicePid, (String)"monitor.files", (Object)value, collection);
                for (String string : collection) {
                    try {
                        UpdateMonitor prevMonitor;
                        File file2 = new File(this.coreService.getLocationService().resolveString(string));
                        UpdateMonitor um = this.createUpdateMonitor(file2, UpdateMonitor.MonitorType.FILE, this.monitorFilter);
                        UpdateMonitor updateMonitor = prevMonitor = oldMap == null ? null : (UpdateMonitor)oldMap.remove(um);
                        if (prevMonitor != null) {
                            this.updateMonitors.put(prevMonitor, prevMonitor);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Monitor holder init, updating existing u monitor " + um), (Object[])new Object[0]);
                            }
                            um.destroy();
                            continue;
                        }
                        newUpdateMonitors.add(um);
                        this.needsBaseline = true;
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Monitor holder init, adding new u monitor " + um), (Object[])new Object[0]);
                    }
                    catch (RuntimeException file2) {
                        void e;
                        FFDCFilter.processException((Throwable)file2, (String)"com.ibm.ws.kernel.filemonitor.internal.MonitorHolder", (String)"311", (Object)this, (Object[])new Object[0]);
                        Tr.warning((TraceComponent)tc, (String)"createMonitorException", (Object[])new Object[]{string, e.getLocalizedMessage()});
                    }
                }
                value = this.monitorRef.getProperty("monitor.directories");
                collection = Collections.emptyList();
                collection = MetatypeUtils.parseStringCollection((Object)servicePid, (String)"monitor.directories", (Object)value, collection);
                this.monitor = this.coreService.getReferencedMonitor(this.monitorRef);
                if (this.monitor != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Monitor holder init, monitor not null", (Object[])new Object[0]);
                    }
                    for (String string : collection) {
                        try {
                            UpdateMonitor prevMonitor;
                            File file3 = new File(this.coreService.getLocationService().resolveString(string));
                            UpdateMonitor.MonitorType type = null;
                            type = this.monitorRecurse ? (this.monitorSelf ? UpdateMonitor.MonitorType.DIRECTORY_RECURSE_SELF : UpdateMonitor.MonitorType.DIRECTORY_RECURSE) : (this.monitorSelf ? UpdateMonitor.MonitorType.DIRECTORY_SELF : UpdateMonitor.MonitorType.DIRECTORY);
                            UpdateMonitor um = this.createUpdateMonitor(file3, type, this.monitorFilter);
                            UpdateMonitor updateMonitor = prevMonitor = oldMap == null ? null : (UpdateMonitor)oldMap.remove(um);
                            if (prevMonitor != null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Monitor holder init, found existing dir update monitor " + um), (Object[])new Object[0]);
                                }
                                this.updateMonitors.put(prevMonitor, prevMonitor);
                                um.destroy();
                                continue;
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Monitor holder init, adding new dir update monitor " + um), (Object[])new Object[0]);
                            }
                            newUpdateMonitors.add(um);
                            this.needsBaseline = true;
                        }
                        catch (RuntimeException file3) {
                            void e;
                            FFDCFilter.processException((Throwable)file3, (String)"com.ibm.ws.kernel.filemonitor.internal.MonitorHolder", (String)"368", (Object)this, (Object[])new Object[0]);
                            Tr.warning((TraceComponent)tc, (String)"createMonitorException", (Object[])new Object[]{string, e.getLocalizedMessage()});
                        }
                    }
                    if (this.needsBaseline || !oldMap.isEmpty()) {
                        for (UpdateMonitor updateMonitor : this.updateMonitors.keySet()) {
                            updateMonitor.init(baseline);
                        }
                        for (UpdateMonitor updateMonitor : newUpdateMonitors) {
                            updateMonitor.init(baseline);
                            this.updateMonitors.put(updateMonitor, updateMonitor);
                        }
                        this.needsBaseline = true;
                    }
                    this.monitorState.set(MonitorState.ACTIVE.ordinal());
                }
                performBaseline = this.needsBaseline;
                this.needsBaseline = false;
            }
            finally {
                this.scanLock.unlock();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Monitor holder init, scan lock released", (Object[])new Object[0]);
                }
            }
            if (this.monitor != null && FrameworkState.isValid()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Monitor holder init, calling initComplete", (Object[])new Object[0]);
                }
                if (performBaseline) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Baseline: " + baseline), (Object[])new Object[0]);
                    }
                    this.monitor.onBaseline(baseline);
                }
                this.start();
                if (oldMap != null && !oldMap.isEmpty()) {
                    for (UpdateMonitor um : oldMap.keySet()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Monitor holder init, destroying old monitor " + um), (Object[])new Object[0]);
                        }
                        um.destroy();
                    }
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Monitor holder init, monitor missing", (Object[])new Object[0]);
                }
                this.monitorState.set(MonitorState.DESTROY.ordinal());
                this.stop();
                this.doDestroy();
            }
        }
    }

    protected abstract UpdateMonitor createUpdateMonitor(File var1, UpdateMonitor.MonitorType var2, String var3);

    public synchronized void refresh(File cacheRoot) {
        this.monitorState.set(MonitorState.INIT.ordinal());
        this.stop();
        this.initProperties(this.monitorRef);
        this.init();
    }

    private synchronized void start() {
        if (this.scheduledFuture == null && this.monitorState.get() == MonitorState.ACTIVE.ordinal() && !this.updateMonitors.isEmpty() && this.monitorInterval != 0L && FrameworkState.isValid()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Scan task scheduled", (Object[])new Object[0]);
            }
            this.scheduledFuture = this.coreService.getScheduler().scheduleWithFixedDelay(this, this.monitorInterval, this.monitorInterval, this.monitorTimeUnit);
        }
    }

    public synchronized void reschedule() {
        this.stop();
        this.start();
    }

    public synchronized void stop() {
        if (this.scheduledFuture != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Scan task cancelled", (Object[])new Object[0]);
            }
            this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
    }

    public void destroy() {
        this.monitorState.compareAndSet(MonitorState.INIT.ordinal(), MonitorState.DESTROY.ordinal());
        if (this.monitorState.compareAndSet(MonitorState.ACTIVE.ordinal(), MonitorState.DESTROY.ordinal())) {
            this.stop();
            this.doDestroy();
        }
    }

    private boolean doDestroy() {
        if (this.scanLock.tryLock()) {
            try {
                if (this.monitorState.compareAndSet(MonitorState.DESTROY.ordinal(), MonitorState.DESTROYED.ordinal())) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)"Destroy file monitor", (Object[])new Object[0]);
                    }
                    for (UpdateMonitor m : this.updateMonitors.keySet()) {
                        m.destroy();
                    }
                    this.updateMonitors.clear();
                    this.unnotifiedFileCreates.clear();
                    this.unnotifiedFileDeletes.clear();
                    this.unnotifiedFileModifies.clear();
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.scanLock.unlock();
            }
        }
        return this.monitorState.get() == MonitorState.DESTROYED.ordinal();
    }

    @Override
    public void run() {
        this.scheduledScan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Trivial
    @FFDCIgnore(value={InterruptedException.class})
    void scheduledScan() {
        block37: {
            if ("external".equals(this.monitorRef.getProperty("monitor.type"))) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"scheduledScan - RETURN early - external monitor", (Object[])new Object[0]);
                }
                return;
            }
            if (FrameworkState.isStopping()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"scheduledScan - RETURN early - framework stopping", (Object[])new Object[0]);
                }
                return;
            }
            if (!this.scanInProgress.compareAndSet(false, true)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"scheduledScan - RETURN early - already scan in progress?", (Object[])new Object[0]);
                }
                return;
            }
            try {
                HashSet<File> modified;
                HashSet<File> deleted;
                HashSet<File> created;
                block38: {
                    created = new HashSet<File>();
                    deleted = new HashSet<File>();
                    modified = new HashSet<File>();
                    if (!this.scanLock.tryLock()) break block37;
                    try {
                        if (this.doDestroy() || this.monitorState.get() != MonitorState.ACTIVE.ordinal()) break block38;
                        if (this.coreService.isDetailedScanTraceEnabled() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"File monitor scan: begin", (Object[])new Object[]{this.updateMonitors});
                        }
                        this.scanForUpdates(created, deleted, modified);
                        if (created.isEmpty() && modified.isEmpty() && deleted.isEmpty()) break block38;
                        boolean oneClean = false;
                        boolean twoClean = false;
                        ArrayList<File> createdCheck = new ArrayList<File>();
                        ArrayList<File> deletedCheck = new ArrayList<File>();
                        ArrayList<File> modifiedCheck = new ArrayList<File>();
                        do {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            createdCheck.clear();
                            deletedCheck.clear();
                            modifiedCheck.clear();
                            this.scanForUpdates(createdCheck, deletedCheck, modifiedCheck);
                            this.resolveChangesForScheduledScan(created, deleted, modified, createdCheck, deletedCheck, modifiedCheck);
                            if (createdCheck.isEmpty() && modifiedCheck.isEmpty() && deletedCheck.isEmpty()) {
                                if (oneClean) {
                                    twoClean = true;
                                    continue;
                                }
                                oneClean = true;
                                continue;
                            }
                            oneClean = false;
                        } while (!twoClean && FrameworkState.isValid());
                    }
                    catch (RuntimeException oneClean) {
                        FFDCFilter.processException((Throwable)oneClean, (String)"com.ibm.ws.kernel.filemonitor.internal.MonitorHolder", (String)"667", (Object)this, (Object[])new Object[0]);
                    }
                    finally {
                        try {
                            this.doDestroy();
                        }
                        finally {
                            this.scanLock.unlock();
                        }
                    }
                }
                if (!(created.isEmpty() && modified.isEmpty() && deleted.isEmpty())) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"File monitor scan: end; resources changed", (Object[])new Object[]{created.size() + " created", modified.size() + " modified", deleted.size() + " deleted", "running=" + FrameworkState.isValid()});
                    }
                    if (FrameworkState.isValid()) {
                        try {
                            this.monitor.onChange(created, modified, deleted);
                            this.exceptionCount = 0;
                        }
                        catch (RuntimeException oneClean) {
                            void e;
                            FFDCFilter.processException((Throwable)oneClean, (String)"com.ibm.ws.kernel.filemonitor.internal.MonitorHolder", (String)"696", (Object)this, (Object[])new Object[0]);
                            ++this.exceptionCount;
                            Tr.warning((TraceComponent)tc, (String)"fileMonitorException", (Object[])new Object[]{created, modified, deleted, this.monitor.getClass(), e.getLocalizedMessage()});
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)("scheduledScan - exceptionCount=" + this.exceptionCount), (Object[])new Object[0]);
                            }
                            if (this.exceptionCount >= 3) {
                                Tr.warning((TraceComponent)tc, (String)"fileMonitorDisabled", (Object[])new Object[]{3, this.monitor.getClass()});
                                this.exceptionCount = 0;
                                this.destroy();
                            }
                        }
                    } else {
                        this.stop();
                    }
                } else if (this.coreService.isDetailedScanTraceEnabled() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"File monitor scan: end; no changes", (Object[])new Object[0]);
                }
            }
            finally {
                this.scanInProgress.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void externalScan(Set<File> notifiedCreated, Set<File> notifiedDeleted, Set<File> notifiedModified) {
        if (!"external".equals(this.monitorRef.getProperty("monitor.type"))) {
            return;
        }
        Thread.yield();
        this.scanLock.lock();
        try {
            if (!this.doDestroy() && this.monitorState.get() == MonitorState.ACTIVE.ordinal()) {
                if (this.coreService.isDetailedScanTraceEnabled() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"File monitor scan: begin", (Object[])new Object[]{this.updateMonitors});
                }
                ArrayList<File> actualCreated = new ArrayList<File>();
                ArrayList<File> actualDeleted = new ArrayList<File>();
                ArrayList<File> actualModified = new ArrayList<File>();
                this.scanForUpdates(actualCreated, actualDeleted, actualModified);
                HashSet<File> created = PathUtils.fixPathFiles(actualCreated);
                HashSet<File> deleted = PathUtils.fixPathFiles(actualDeleted);
                HashSet<File> modified = PathUtils.fixPathFiles(actualModified);
                if (created == Collections.EMPTY_SET) {
                    created = new HashSet<File>();
                }
                if (deleted == Collections.EMPTY_SET) {
                    deleted = new HashSet<File>();
                }
                if (modified == Collections.EMPTY_SET) {
                    modified = new HashSet<File>();
                }
                this.resolveChangesForExternalScan(this.unnotifiedFileCreates, this.unnotifiedFileDeletes, this.unnotifiedFileModifies, created, deleted, modified);
                created.addAll(this.unnotifiedFileCreates);
                deleted.addAll(this.unnotifiedFileDeletes);
                modified.addAll(this.unnotifiedFileModifies);
                this.unnotifiedFileCreates.clear();
                this.unnotifiedFileDeletes.clear();
                this.unnotifiedFileModifies.clear();
                this.filterSets(created, notifiedCreated, this.unnotifiedFileCreates);
                this.filterSets(deleted, notifiedDeleted, this.unnotifiedFileDeletes);
                this.filterSets(modified, notifiedModified, this.unnotifiedFileModifies);
                if (!(created.isEmpty() && modified.isEmpty() && deleted.isEmpty())) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"File monitor scan: end; resources changed", (Object[])new Object[]{created.size() + " created", modified.size() + " modified", deleted.size() + " deleted"});
                    }
                    if (this.monitor != null) {
                        try {
                            this.monitor.onChange(created, modified, deleted);
                        }
                        catch (RuntimeException runtimeException) {
                            void e;
                            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.kernel.filemonitor.internal.MonitorHolder", (String)"831", (Object)this, (Object[])new Object[]{notifiedCreated, notifiedDeleted, notifiedModified});
                            Tr.warning((TraceComponent)tc, (String)"fileMonitorException", (Object[])new Object[]{created, modified, deleted, this.monitor.getClass(), e.getLocalizedMessage()});
                        }
                    }
                } else if (this.coreService.isDetailedScanTraceEnabled() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"File monitor scan: end; no changes", (Object[])new Object[0]);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.kernel.filemonitor.internal.MonitorHolder", (String)"843", (Object)this, (Object[])new Object[]{notifiedCreated, notifiedDeleted, notifiedModified});
        }
        finally {
            try {
                this.doDestroy();
            }
            finally {
                this.scanLock.unlock();
            }
        }
    }

    private void resolveChangesForScheduledScan(Set<File> created, Set<File> deleted, Set<File> modified, List<File> createdCheck, List<File> deletedCheck, List<File> modifiedCheck) {
        for (File f : deletedCheck) {
            if (created.remove(f)) continue;
            modified.remove(f);
            deleted.add(f);
        }
        for (File f : createdCheck) {
            if (deleted.remove(f)) {
                modified.add(f);
                continue;
            }
            created.add(f);
        }
        for (File f : modifiedCheck) {
            if (created.contains(f) || modified.contains(f)) continue;
            modified.add(f);
        }
    }

    private void resolveChangesForExternalScan(Set<File> unnotifiedFileCreates, Set<File> unnotifiedFileDeletes, Set<File> unnotifiedFileModifies, Set<File> created, Set<File> deleted, Set<File> modified) {
        File file;
        Iterator<File> i = unnotifiedFileCreates.iterator();
        while (i.hasNext()) {
            file = i.next();
            if (deleted.contains(file)) {
                deleted.remove(file);
                i.remove();
            }
            if (!modified.contains(file)) continue;
            modified.remove(file);
        }
        i = unnotifiedFileModifies.iterator();
        while (i.hasNext()) {
            file = i.next();
            if (!deleted.contains(file)) continue;
            deleted.remove(file);
            i.remove();
            unnotifiedFileDeletes.add(file);
        }
        i = unnotifiedFileDeletes.iterator();
        while (i.hasNext()) {
            file = i.next();
            if (!created.contains(file)) continue;
            created.remove(file);
            i.remove();
            unnotifiedFileModifies.add(file);
        }
    }

    private void filterSets(Set<File> availableChanges, Set<File> notifiedChanges, Set<File> unnotifiedChanges) {
        Iterator<File> i = availableChanges.iterator();
        while (i.hasNext()) {
            File fileChange = i.next();
            if (notifiedChanges.contains(fileChange) || this.isParentFile(notifiedChanges, fileChange)) continue;
            i.remove();
            unnotifiedChanges.add(fileChange);
        }
    }

    private boolean isParentFile(Set<File> notifiedChanges, File fileChange) {
        for (File thisUpdate : notifiedChanges) {
            try {
                if (!fileChange.isDirectory() && fileChange.exists()) continue;
                String testFilePath = fileChange.getCanonicalPath();
                if (!testFilePath.endsWith(File.separator)) {
                    testFilePath = testFilePath + File.separator;
                }
                if (!thisUpdate.getCanonicalPath().startsWith(testFilePath)) continue;
                return true;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.filemonitor.internal.MonitorHolder", (String)"1047", (Object)this, (Object[])new Object[]{notifiedChanges, fileChange});
            }
        }
        return false;
    }

    private void scanForUpdates(Collection<File> created, Collection<File> deleted, Collection<File> modified) {
        for (UpdateMonitor m : this.updateMonitors.keySet()) {
            try {
                m.scanForUpdates(created, modified, deleted);
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.kernel.filemonitor.internal.MonitorHolder", (String)"1068", (Object)this, (Object[])new Object[]{created, deleted, modified});
            }
        }
    }

    @Trivial
    protected static TimeUnit parseTimeUnit(String unitString, String fullValue) {
        if ("ms".equalsIgnoreCase(unitString)) {
            return TimeUnit.MILLISECONDS;
        }
        if ("s".equalsIgnoreCase(unitString)) {
            return TimeUnit.SECONDS;
        }
        if ("m".equalsIgnoreCase(unitString)) {
            return TimeUnit.MINUTES;
        }
        if ("h".equalsIgnoreCase(unitString)) {
            return TimeUnit.HOURS;
        }
        Tr.warning((TraceComponent)tc, (String)"badInterval", (Object[])new Object[]{"monitor.interval", fullValue});
        throw new IllegalArgumentException("Invalid time unit (" + unitString + ") from " + fullValue);
    }

    @Trivial
    protected static long parseInterval(String intervalString, String fullValue) {
        try {
            return Long.parseLong(intervalString);
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.kernel.filemonitor.internal.MonitorHolder", (String)"1102", null, (Object[])new Object[]{intervalString, fullValue});
            Tr.warning((TraceComponent)tc, (String)"badInterval", (Object[])new Object[]{"monitor.interval", fullValue});
            throw new IllegalArgumentException("Invalid interval (" + intervalString + ") from " + fullValue);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class MonitorState
    extends Enum<MonitorState> {
        public static final /* enum */ MonitorState UNKNOWN;
        public static final /* enum */ MonitorState INIT;
        public static final /* enum */ MonitorState INITIALIZING;
        public static final /* enum */ MonitorState ACTIVE;
        public static final /* enum */ MonitorState DESTROY;
        public static final /* enum */ MonitorState DESTROYED;
        private static final /* synthetic */ MonitorState[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static MonitorState[] values() {
            return (MonitorState[])$VALUES.clone();
        }

        public static MonitorState valueOf(String name) {
            return Enum.valueOf(MonitorState.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(MonitorState.class);
            UNKNOWN = new MonitorState();
            INIT = new MonitorState();
            INITIALIZING = new MonitorState();
            ACTIVE = new MonitorState();
            DESTROY = new MonitorState();
            DESTROYED = new MonitorState();
            $VALUES = new MonitorState[]{UNKNOWN, INIT, INITIALIZING, ACTIVE, DESTROY, DESTROYED};
        }
    }
}

