/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OCI.IIOP;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.orb.OB.HexConverter;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.ProtocolPolicy;
import org.apache.yoko.orb.OB.ProtocolPolicyHelper;
import org.apache.yoko.orb.OCI.ConnectCB;
import org.apache.yoko.orb.OCI.Connector;
import org.apache.yoko.orb.OCI.ConnectorInfo;
import org.apache.yoko.orb.OCI.IIOP.ConnectionHelper;
import org.apache.yoko.orb.OCI.IIOP.ConnectorInfo_impl;
import org.apache.yoko.orb.OCI.IIOP.Exceptions;
import org.apache.yoko.orb.OCI.IIOP.ExtendedConnectionHelper;
import org.apache.yoko.orb.OCI.IIOP.InternalError;
import org.apache.yoko.orb.OCI.IIOP.ListenerMap;
import org.apache.yoko.orb.OCI.IIOP.Transport_impl;
import org.apache.yoko.orb.OCI.IIOP.Util;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.orb.OCI.ProfileInfoHolder;
import org.apache.yoko.orb.OCI.ProfileInfoSeqHolder;
import org.apache.yoko.orb.OCI.Transport;
import org.apache.yoko.orb.OCI.TransportInfo;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.IOP.Codec;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;

final class Connector_impl
extends LocalObject
implements Connector {
    static final Logger logger = Logger.getLogger(Connector.class.getName());
    private final IOR ior_;
    private final Policy[] policies_;
    private boolean keepAlive_;
    private final ConnectorInfo_impl info_;
    private Socket socket_;
    private ListenerMap listenMap_;
    private final ConnectionHelper connectionHelper_;
    private byte[] transportInfo;
    private final ExtendedConnectionHelper extendedConnectionHelper_;
    private final Codec codec_;

    private void close() {
        logger.fine("Closing connection to host=" + this.info_.getHost() + ", port=" + this.info_.getPort());
        try {
            this.socket_.close();
            this.socket_ = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String id() {
        return "iiop";
    }

    @Override
    public int tag() {
        return 0;
    }

    @Override
    public Transport connect() {
        if (this.socket_ != null) {
            this.close();
        }
        try {
            logger.fine("Connecting to host=" + this.info_.getHost() + ", port=" + this.info_.getPort());
            if (this.connectionHelper_ != null) {
                InetAddress address = InetAddress.getByName(this.info_.getHost());
                this.socket_ = this.connectionHelper_.createSocket(this.ior_, this.policies_, address, this.info_.getPort());
            } else {
                this.socket_ = this.extendedConnectionHelper_.createSocket(this.info_.getHost(), this.info_.getPort());
            }
            logger.fine("Connection created with socket " + this.socket_);
        }
        catch (ConnectException ex) {
            logger.log(Level.FINE, "Error connecting to host=" + this.info_.getHost() + ", port=" + this.info_.getPort(), ex);
            throw (TRANSIENT)new TRANSIENT(MinorCodes.describeTransient(1095974913) + "Error connecting to host=" + this.info_.getHost() + ", port=" + this.info_.getPort() + ": " + ex.getMessage(), 1330446338, CompletionStatus.COMPLETED_NO).initCause((Throwable)ex);
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "Error connecting to host=" + this.info_.getHost() + ", port=" + this.info_.getPort(), ex);
            throw (COMM_FAILURE)new COMM_FAILURE(MinorCodes.describeCommFailure(1095974917) + "Error connecting to host=" + this.info_.getHost() + ", port=" + this.info_.getPort() + ": " + ex.getMessage(), 1095974917, CompletionStatus.COMPLETED_NO).initCause((Throwable)ex);
        }
        try {
            this.socket_.setTcpNoDelay(true);
            if (this.keepAlive_) {
                this.socket_.setKeepAlive(true);
            }
        }
        catch (SocketException ex) {
            logger.log(Level.FINE, "Socket setup error", ex);
            try {
                this.socket_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw Exceptions.asCommFailure(ex);
        }
        Transport_impl tr = null;
        try {
            tr = new Transport_impl(this.socket_, this.listenMap_);
            this.socket_ = null;
        }
        catch (SystemException ex) {
            logger.log(Level.FINE, "Transport creation error", ex);
            try {
                this.socket_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
        TransportInfo trInfo = tr.get_info();
        try {
            this.info_._OB_callConnectCB(trInfo);
        }
        catch (SystemException ex) {
            logger.log(Level.FINE, "Connection callback error", ex);
            tr.close();
            throw ex;
        }
        return tr;
    }

    @Override
    public Transport connect_timeout(int t) {
        if (this.socket_ != null) {
            this.close();
        }
        InetAddress address = null;
        try {
            address = InetAddress.getByName(this.info_.getHost());
        }
        catch (UnknownHostException ex) {
            logger.log(Level.FINE, "Host resolution error", ex);
            throw Exceptions.asCommFailure(ex);
        }
        try {
            ConnectTimeout connectTimeout = new ConnectTimeout(address);
            connectTimeout.start();
            this.socket_ = connectTimeout.waitForConnect(t);
            if (this.socket_ == null) {
                return null;
            }
        }
        catch (ConnectException ex) {
            logger.log(Level.FINE, "Socket connection error", ex);
            throw new TRANSIENT(MinorCodes.describeTransient(1095974913) + ": " + ex.getMessage(), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "Socket I/O error", ex);
            throw (COMM_FAILURE)new COMM_FAILURE(MinorCodes.describeCommFailure(1095974917) + ": " + ex.getMessage(), 1095974917, CompletionStatus.COMPLETED_NO).initCause((Throwable)ex);
        }
        try {
            this.socket_.setTcpNoDelay(true);
            if (this.keepAlive_) {
                this.socket_.setKeepAlive(true);
            }
        }
        catch (SocketException ex) {
            logger.log(Level.FINE, "Socket setup error", ex);
            try {
                this.socket_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw Exceptions.asCommFailure(ex);
        }
        Transport_impl tr = null;
        try {
            tr = new Transport_impl(this.socket_, this.listenMap_);
            this.socket_ = null;
        }
        catch (SystemException ex) {
            logger.log(Level.FINE, "Transport setup error", ex);
            try {
                this.socket_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
        TransportInfo trInfo = tr.get_info();
        try {
            this.info_._OB_callConnectCB(trInfo);
        }
        catch (SystemException ex) {
            logger.log(Level.FINE, "Callback setup error", ex);
            tr.close();
            throw ex;
        }
        return tr;
    }

    @Override
    public ProfileInfo[] get_usable_profiles(IOR ior, Policy[] policies) {
        for (Policy policy : policies) {
            ProtocolPolicy protocolPolicy;
            if (policy.policy_type() != 1330577410 || (protocolPolicy = ProtocolPolicyHelper.narrow((Object)policy)).contains("iiop")) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Protocol policy exists but does not allow expected transport. policy = " + Arrays.toString(protocolPolicy.value()) + "\t expected transport = " + "iiop");
            }
            return new ProfileInfo[0];
        }
        ProfileInfoSeqHolder profileInfoSeq = new ProfileInfoSeqHolder();
        profileInfoSeq.value = new ProfileInfo[0];
        String host = this.info_.getHost();
        if (Util.isEncodedHost(host)) {
            host = Util.decodeHost(host);
        }
        Util.extractAllProfileInfos(ior, profileInfoSeq, true, host, this.info_.getPort(), false, this.codec_);
        for (ProfileInfo profileInfo : profileInfoSeq.value) {
            byte[] otherTransportInfo = new byte[]{};
            for (TaggedComponent component : profileInfo.components) {
                if (component.tag != 33) continue;
                otherTransportInfo = component.component_data;
                if (!logger.isLoggable(Level.FINE)) break;
                logger.fine("Found CSI_SEC_MECH_LIST: " + otherTransportInfo == null ? null : HexConverter.octetsToAscii(otherTransportInfo, otherTransportInfo.length));
                break;
            }
            if (Arrays.equals(this.transportInfo, otherTransportInfo)) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Transport info does not match CSI_SEC_MECH_LIST: " + otherTransportInfo == null ? null : HexConverter.octetsToAscii(otherTransportInfo, otherTransportInfo.length));
            }
            return new ProfileInfo[0];
        }
        return profileInfoSeq.value;
    }

    @Override
    public boolean equal(Connector con) {
        Connector_impl impl = null;
        try {
            impl = (Connector_impl)con;
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (this.info_.getPort() != impl.info_.getPort()) {
            return false;
        }
        if (!this.info_.getHost().equals(impl.info_.getHost())) {
            try {
                InetAddress addr1 = InetAddress.getByName(this.info_.getHost());
                InetAddress addr2 = InetAddress.getByName(impl.info_.getHost());
                if (!addr1.equals(addr2)) {
                    return false;
                }
            }
            catch (UnknownHostException ex) {
                return false;
            }
        }
        return Arrays.equals(this.transportInfo, impl.transportInfo);
    }

    private byte[] extractTransportInfo(IOR ior) {
        ProfileInfoHolder holder = new ProfileInfoHolder();
        if (Util.extractProfileInfo(ior, holder)) {
            ProfileInfo profileInfo = holder.value;
            for (TaggedComponent component : profileInfo.components) {
                if (component.tag != 33) continue;
                return component.component_data;
            }
        }
        return new byte[0];
    }

    @Override
    public ConnectorInfo get_info() {
        return this.info_;
    }

    private Connector_impl(IOR ior, Policy[] policies, String host, int port, boolean keepAlive, ConnectCB[] cb, ListenerMap lm, ConnectionHelper helper, ExtendedConnectionHelper xhelper, Codec codec) {
        if (null == helper && null == xhelper) {
            throw new IllegalArgumentException("Both connection helpers must not be null");
        }
        this.ior_ = ior;
        this.policies_ = policies;
        this.keepAlive_ = keepAlive;
        this.info_ = new ConnectorInfo_impl(host, port, cb);
        this.listenMap_ = lm;
        this.connectionHelper_ = helper;
        this.extendedConnectionHelper_ = xhelper;
        this.codec_ = codec;
        this.transportInfo = this.extractTransportInfo(ior);
    }

    Connector_impl(IOR ior, Policy[] policies, String host, int port, boolean keepAlive, ConnectCB[] cb, ListenerMap lm, ConnectionHelper helper, Codec codec) {
        this(ior, policies, host, port, keepAlive, cb, lm, helper, null, codec);
    }

    Connector_impl(IOR ior, Policy[] policies, String host, int port, boolean keepAlive, ConnectCB[] cb, ListenerMap lm, ExtendedConnectionHelper xhelper, Codec codec) {
        this(ior, policies, host, port, keepAlive, cb, lm, null, xhelper, codec);
    }

    public void finalize() throws Throwable {
        if (this.socket_ != null) {
            this.close();
        }
        super.finalize();
    }

    public String toString() {
        return "-> " + this.info_;
    }

    private class ConnectTimeout
    extends Thread {
        private InetAddress address_ = null;
        private Socket so_ = null;
        private IOException ex_ = null;
        private boolean finished_ = false;
        private boolean timeout_ = false;

        ConnectTimeout(InetAddress address) {
            this.address_ = address;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.so_ = Connector_impl.this.connectionHelper_ != null ? Connector_impl.this.connectionHelper_.createSocket(Connector_impl.this.ior_, Connector_impl.this.policies_, this.address_, Connector_impl.this.info_.getPort()) : Connector_impl.this.extendedConnectionHelper_.createSocket(Connector_impl.this.info_.getHost(), Connector_impl.this.info_.getPort());
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "Socket creation error", ex);
                this.ex_ = ex;
            }
            ConnectTimeout connectTimeout = this;
            synchronized (connectTimeout) {
                if (this.timeout_) {
                    if (this.so_ != null) {
                        try {
                            this.so_.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.so_ = null;
                    }
                } else {
                    this.finished_ = true;
                    this.notify();
                }
            }
        }

        synchronized Socket waitForConnect(int t) throws IOException {
            while (!this.finished_) {
                try {
                    this.wait(t);
                }
                catch (InterruptedException ex) {
                    continue;
                }
                if (this.finished_) continue;
                this.timeout_ = true;
                return null;
            }
            if (this.so_ != null) {
                return this.so_;
            }
            if (this.ex_ != null) {
                throw this.ex_;
            }
            throw new InternalError();
        }
    }
}

